/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.sponsor.term.SponsorTerm;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardSponsorTermRuleEvent;
import org.kuali.kra.award.AwardSponsorTermRuleImpl;
import org.kuali.kra.award.home.AwardSponsorTerm;
import org.kuali.kra.award.web.struts.action.SponsorTermFormHelper;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SponsorTermActionHelper
implements Serializable {
    private static final long serialVersionUID = -7294863297504587355L;
    private static final String SPONSOR_TERM_CODE = "sponsorTermCode";
    private static final String SPONSOR_TERM_TYPE_CODE = "sponsorTermTypeCode";
    private static final String PERIOD = ".";
    private static final String NEW_AWARD_SPONSOR_TERM = "newAwardSponsorTerm";
    private transient BusinessObjectService businessObjectService;

    public AwardSponsorTerm addSponsorTerm(SponsorTermFormHelper formHelper, HttpServletRequest request) {
        return this.addSponsorTermFromDatabase(formHelper, request);
    }

    public AwardSponsorTerm addSponsorTermFromMutiValueLookup(SponsorTermFormHelper formHelper, SponsorTerm sponsorTerm, HttpServletRequest request) {
        AwardSponsorTerm newAwardSponsorTerm = new AwardSponsorTerm(sponsorTerm.getSponsorTermId(), sponsorTerm);
        if (this.applyRulesToAwardSponsorTermFromMultiValueLookup(newAwardSponsorTerm, formHelper, request, sponsorTerm)) {
            return newAwardSponsorTerm;
        }
        return null;
    }

    protected AwardSponsorTerm addSponsorTermFromDatabase(SponsorTermFormHelper formHelper, HttpServletRequest request) {
        Long sponsorTermId;
        SponsorTerm matchingSponsorTerm;
        String sponsorTermCode = formHelper.getNewSponsorTerms().get(this.getSponsorTermTypeIndex(request)).getSponsorTermCode();
        if (StringUtils.isBlank((CharSequence)sponsorTermCode)) {
            return null;
        }
        String sponsorTermTypeCode = formHelper.getSponsorTermTypes().get(this.getSponsorTermTypeIndex(request)).getKey();
        Collection<SponsorTerm> matchingSponsorTerms = this.getMatchingSponsorTermFromDatabase(formHelper, sponsorTermCode, sponsorTermTypeCode);
        if (matchingSponsorTerms.isEmpty()) {
            matchingSponsorTerm = null;
            sponsorTermId = null;
        } else {
            matchingSponsorTerm = matchingSponsorTerms.iterator().next();
            sponsorTermId = matchingSponsorTerm.getSponsorTermId();
        }
        AwardSponsorTerm newAwardSponsorTerm = new AwardSponsorTerm(sponsorTermId, matchingSponsorTerm);
        if (this.applyRulesToAwardSponsorTerm(newAwardSponsorTerm, formHelper, request)) {
            return newAwardSponsorTerm;
        }
        return null;
    }

    protected boolean applyRulesToAwardSponsorTerm(AwardSponsorTerm newAwardSponsorTerm, SponsorTermFormHelper formHelper, HttpServletRequest request) {
        String sponsorTermCode = formHelper.getNewSponsorTerms().get(this.getSponsorTermTypeIndex(request)).getSponsorTermCode();
        String sponsorTermTypeCode = formHelper.getSponsorTermTypes().get(this.getSponsorTermTypeIndex(request)).getKey();
        AwardSponsorTermRuleEvent event = new AwardSponsorTermRuleEvent(NEW_AWARD_SPONSOR_TERM, formHelper.getAwardDocument(), newAwardSponsorTerm, sponsorTermCode, sponsorTermTypeCode);
        boolean success = new AwardSponsorTermRuleImpl().processAddSponsorTermBusinessRules(event);
        if (success) {
            this.addAwardSponsorTerm(newAwardSponsorTerm, formHelper, request);
        }
        return success;
    }

    protected boolean applyRulesToAwardSponsorTermFromMultiValueLookup(AwardSponsorTerm newAwardSponsorTerm, SponsorTermFormHelper formHelper, HttpServletRequest request, SponsorTerm sponsorTerm) {
        AwardSponsorTermRuleEvent event = new AwardSponsorTermRuleEvent(NEW_AWARD_SPONSOR_TERM, formHelper.getAwardDocument(), newAwardSponsorTerm, newAwardSponsorTerm.getSponsorTermCode(), newAwardSponsorTerm.getSponsorTermTypeCode());
        boolean success = this.validateAwardSponsorTermNotDuplicate(newAwardSponsorTerm, formHelper.getAwardDocument().getAward().getAwardSponsorTerms());
        if (success &= new AwardSponsorTermRuleImpl().processAddSponsorTermFromMultiValueLookupRules(event)) {
            this.addAwardSponsorTermFromMultiValueLookup(newAwardSponsorTerm, formHelper, request);
        }
        return success;
    }

    boolean validateAwardSponsorTermNotDuplicate(AwardSponsorTerm awardSponsorTerm, List<AwardSponsorTerm> awardSponsorTerms) {
        boolean valid = true;
        for (AwardSponsorTerm tempAwardSponsorTerm : awardSponsorTerms) {
            if (!awardSponsorTerm.getSponsorTermId().equals(tempAwardSponsorTerm.getSponsorTermId())) continue;
            valid = false;
            break;
        }
        return valid;
    }

    protected void addAwardSponsorTermFromMultiValueLookup(AwardSponsorTerm newAwardSponsorTerm, SponsorTermFormHelper formHelper, HttpServletRequest request) {
        formHelper.getAwardDocument().getAward().add(newAwardSponsorTerm);
    }

    protected void addAwardSponsorTerm(AwardSponsorTerm newAwardSponsorTerm, SponsorTermFormHelper formHelper, HttpServletRequest request) {
        formHelper.getAwardDocument().getAward().add(newAwardSponsorTerm);
        formHelper.getNewSponsorTerms().set(this.getSponsorTermTypeIndex(request), new SponsorTerm());
    }

    protected Collection<SponsorTerm> getMatchingSponsorTermFromDatabase(SponsorTermFormHelper formHelper, String sponsorTermCode, String sponsorTermTypeCode) {
        HashMap<String, String> matchingSponsorTerm = new HashMap<String, String>();
        matchingSponsorTerm.put(SPONSOR_TERM_CODE, sponsorTermCode);
        matchingSponsorTerm.put(SPONSOR_TERM_TYPE_CODE, sponsorTermTypeCode);
        return this.getKraBusinessObjectService().findMatching(SponsorTerm.class, matchingSponsorTerm);
    }

    protected int getSponsorTermTypeIndex(HttpServletRequest request) {
        int sponsorTermTypeIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String sponsorTermTypeIndexString = StringUtils.substringBetween((String)parameterName, (String)".sponsorTermTypeIndex", (String)PERIOD);
            sponsorTermTypeIndex = Integer.parseInt(sponsorTermTypeIndexString);
        }
        return sponsorTermTypeIndex;
    }

    void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    BusinessObjectService getKraBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }
}

