/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.util.UrlFactory;

public abstract class KraLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final String COLUMN = ":";
    private static final String VIEW = "view";
    protected static final String MEDUSA = "medusa";

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        this.addEditHtmlData(htmlDataList, businessObject);
        return htmlDataList;
    }

    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
        htmlDataList.add((HtmlData)this.getEditLink(businessObject));
    }

    protected HtmlData.AnchorHtmlData getEditLink(BusinessObject businessObject) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "initiate");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put(this.getKeyFieldName(), ObjectUtils.getPropertyValue((Object)businessObject, (String)this.getKeyFieldName()).toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        return new HtmlData.AnchorHtmlData(href, "docHandler", "edit");
    }

    protected HtmlData.AnchorHtmlData getViewLink(String documentNumber) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(VIEW);
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", "true");
        parameters.put("docId", documentNumber);
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getMedusaLink(String documentNumber, Boolean readOnly) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText(MEDUSA);
        Properties parameters = new Properties();
        parameters.put("methodToCall", MEDUSA);
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", readOnly.toString());
        parameters.put("docId", documentNumber);
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        if (!lookupForm.isHideReturnLink()) {
            lookupForm.setSuppressActions(true);
        } else {
            lookupForm.setShowMaintenanceLinks(true);
        }
        return super.performLookup(lookupForm, resultTable, bounded);
    }

    protected void setBackLocationDocFormKey(Map<String, String> fieldValues) {
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            if (entry.getKey().equals("backLocation")) {
                this.setBackLocation(entry.getValue());
                continue;
            }
            if (!entry.getKey().equals("docFormKey")) continue;
            this.setDocFormKey(entry.getValue());
        }
    }

    protected void updateLookupField(Field field, String keyName, String className) {
        if (StringUtils.isNotBlank((CharSequence)keyName) && StringUtils.isNotBlank((CharSequence)className)) {
            field.setFieldConversions(keyName + COLUMN + field.getPropertyName());
            field.setLookupParameters(field.getPropertyName() + COLUMN + keyName);
            field.setInquiryParameters(field.getPropertyName() + COLUMN + keyName);
            field.setQuickFinderClassNameImpl(className);
        }
    }

    protected abstract String getHtmlAction();

    protected abstract String getDocumentTypeName();

    protected abstract String getKeyFieldName();
}

