/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.sys.framework.auth.AuthServicePushService;
import org.kuali.coeus.sys.framework.auth.AuthUser;
import org.kuali.coeus.sys.impl.auth.AbstractCoreUserPushService;
import org.kuali.coeus.sys.impl.auth.KimPersonLite;
import org.kuali.coeus.sys.impl.auth.KimPersonLiteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="authServicePushService")
public class AuthServicePushServiceImpl
extends AbstractCoreUserPushService<KimPersonLite>
implements AuthServicePushService {
    private static final String USER_ROLE = "user";
    @Autowired
    @Qualifier(value="kimPersonLiteService")
    private KimPersonLiteService kimPersonLiteService;
    @Value(value="#{{'kc', 'kr', 'guest', 'kualiadmin'}}")
    List<String> ignoredUsers = new ArrayList<String>();

    @Override
    protected AuthUser generateAuthUserFromPerson(KimPersonLite person, Map<String, String> groupIdsByUnitNumber) {
        AuthUser kimAuthUser = new AuthUser();
        kimAuthUser.setUsername(person.getPrincipalName());
        kimAuthUser.setSchoolId(person.getPrincipalId());
        kimAuthUser.setEmail(person.getEmailAddress());
        kimAuthUser.setName(person.getName());
        kimAuthUser.setFirstName(person.getFirstName());
        kimAuthUser.setLastName(person.getLastName());
        kimAuthUser.setPhone(person.getPhoneNumber());
        kimAuthUser.setActive(person.isActive());
        kimAuthUser.setRole(USER_ROLE);
        kimAuthUser.setGroupId(groupIdsByUnitNumber.get(person.getPrimaryDepartmentCode()));
        kimAuthUser.setActive(person.isActive());
        return kimAuthUser;
    }

    @Override
    protected List<KimPersonLite> getAllPeople() {
        return this.kimPersonLiteService.getAllPeople();
    }

    public KimPersonLiteService getKimPersonLiteService() {
        return this.kimPersonLiteService;
    }

    public void setKimPersonLiteService(KimPersonLiteService kimPersonLiteService) {
        this.kimPersonLiteService = kimPersonLiteService;
    }

    public List<String> getIgnoredUsers() {
        return this.ignoredUsers;
    }

    public void setIgnoredUsers(List<String> ignoredUsers) {
        this.ignoredUsers = ignoredUsers;
    }

    @Override
    protected boolean validUserToPush(KimPersonLite person) {
        return !this.ignoredUsers.contains(person.getPrincipalName());
    }
}

