/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.rolodex.nonorg;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.common.impl.rolodex.RolodexDao;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.BeanPropertyComparator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Component(value="nonOrganizationalRolodexHelperService")
@Scope(value="prototype")
public class NonOrganizationalRolodexLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = -3536764919498823536L;
    @Autowired
    @Qualifier(value="rolodexDao")
    private transient RolodexDao rolodexDao;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        boolean usePrimaryKeys = this.getLookupService().allPrimaryKeyValuesPresentAndNotWildcard(Rolodex.class, fieldValues);
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        List<? extends BusinessObject> searchResults = this.getRolodexDao().getNonOrganizationalRolodexResults(fieldValues, usePrimaryKeys);
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(this.getDefaultSortColumns(), true));
        }
        return searchResults;
    }

    public RolodexDao getRolodexDao() {
        return this.rolodexDao;
    }

    public void setRolodexDao(RolodexDao rolodexDao) {
        this.rolodexDao = rolodexDao;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        Collection results = super.performLookup(lookupForm, resultTable, bounded);
        if (resultTable != null) {
            for (Object row : resultTable) {
                ResultRow resultRow;
                String returnUrl;
                if (!(row instanceof ResultRow) || (returnUrl = (resultRow = (ResultRow)row).getReturnUrl()) == null || returnUrl.isEmpty()) continue;
                resultRow.setReturnUrl(this.escapeJavaScriptInReturnUrl(returnUrl));
            }
        }
        return results;
    }

    private String escapeJavaScriptInReturnUrl(String returnUrl) {
        Pattern pattern = Pattern.compile("'([^']*)'");
        Matcher matcher = pattern.matcher(returnUrl);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String value = matcher.group(1);
            String escapedValue = StringEscapeUtils.escapeEcmaScript((String)value);
            matcher.appendReplacement(result, "'" + Matcher.quoteReplacement(escapedValue) + "'");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

