/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.external.budget.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryType;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.query.QueryList;
import org.kuali.coeus.common.budget.framework.query.operator.Equals;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.external.budget.BudgetAdjustmentServiceHelper;
import org.kuali.kra.external.budget.RateClassRateType;
import org.kuali.rice.krad.data.DataObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="budgetAdjustmentServiceHelper")
public class BudgetAdjustmentServiceHelperImpl
implements BudgetAdjustmentServiceHelper {
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    private static final Logger LOG = LogManager.getLogger(BudgetAdjustmentServiceHelperImpl.class);

    @Override
    public HashMap<String, ScaleTwoDecimal> getNonPersonnelCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        int period = currentBudget.getBudgetPeriods().size() - 1;
        List<BudgetLineItem> currentLineItems = currentBudget.getBudgetPeriods().get(period).getBudgetLineItems();
        HashMap<String, ScaleTwoDecimal> currentLineItemCosts = new HashMap<String, ScaleTwoDecimal>();
        for (BudgetLineItem currentLineItem : currentLineItems) {
            if (StringUtils.equalsIgnoreCase((CharSequence)currentLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)"P")) continue;
            currentLineItemCosts.put(currentLineItem.getCostElement(), currentLineItem.getLineItemCost());
        }
        return currentLineItemCosts;
    }

    @Override
    public SortedMap<RateType, ScaleTwoDecimal> getNonPersonnelCalculatedDirectCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        SortedMap<RateType, List<ScaleTwoDecimal>> currentNonPersonnelCalcDirectCost = currentBudget.getNonPersonnelCalculatedExpenseTotals();
        TreeMap<RateType, ScaleTwoDecimal> netNonPersonnelCalculatedDirectCost = new TreeMap<RateType, ScaleTwoDecimal>();
        int period = currentBudget.getBudgetPeriods().size() - 1;
        for (RateType rateType : currentNonPersonnelCalcDirectCost.keySet()) {
            List currentExpenses = (List)currentNonPersonnelCalcDirectCost.get(rateType);
            netNonPersonnelCalculatedDirectCost.put(rateType, (ScaleTwoDecimal)currentExpenses.get(period));
        }
        return netNonPersonnelCalculatedDirectCost;
    }

    @Override
    public Map<RateClassRateType, ScaleTwoDecimal> getIndirectCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        int period = currentBudget.getBudgetPeriods().size() - 1;
        List<BudgetLineItem> currentLineItems = currentBudget.getBudgetPeriods().get(period).getBudgetLineItems();
        HashMap<RateClassRateType, ScaleTwoDecimal> currentIndirectTotals = new HashMap<RateClassRateType, ScaleTwoDecimal>();
        for (BudgetLineItem lineItem : currentLineItems) {
            for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                lineItemCalculatedAmount.refreshReferenceObject("rateClass");
                if (!lineItemCalculatedAmount.getRateClass().getRateClassTypeCode().equalsIgnoreCase("O")) continue;
                RateClassRateType currentKey = new RateClassRateType(lineItemCalculatedAmount.getRateClassCode(), lineItemCalculatedAmount.getRateTypeCode());
                if (currentIndirectTotals.containsKey(currentKey)) {
                    currentIndirectTotals.put(currentKey, (ScaleTwoDecimal)((ScaleTwoDecimal)currentIndirectTotals.get(currentKey)).add((AbstractDecimal)lineItemCalculatedAmount.getCalculatedCost()));
                    continue;
                }
                currentIndirectTotals.put(currentKey, lineItemCalculatedAmount.getCalculatedCost());
            }
        }
        HashMap<RateClassRateType, ScaleTwoDecimal> netIndirectTotals = new HashMap<RateClassRateType, ScaleTwoDecimal>();
        for (RateClassRateType rate : currentIndirectTotals.keySet()) {
            netIndirectTotals.put(rate, (ScaleTwoDecimal)currentIndirectTotals.get(rate));
        }
        return netIndirectTotals;
    }

    @Override
    public Map<RateClassRateType, ScaleTwoDecimal> getPersonnelCalculatedDirectCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        SortedMap<RateType, List<ScaleTwoDecimal>> currentTotals = currentBudget.getPersonnelCalculatedExpenseTotals();
        int period = currentBudget.getBudgetPeriods().size() - 1;
        HashMap<RateClassRateType, ScaleTwoDecimal> currentCost = new HashMap<RateClassRateType, ScaleTwoDecimal>();
        HashMap<RateClassRateType, ScaleTwoDecimal> netCost = new HashMap<RateClassRateType, ScaleTwoDecimal>();
        for (RateType rateType : currentTotals.keySet()) {
            if (StringUtils.equalsIgnoreCase((CharSequence)rateType.getRateClass().getRateClassTypeCode(), (CharSequence)"O")) continue;
            LOG.info("Rate Class: " + rateType.getRateClassCode() + "RateType: " + rateType.getRateTypeCode());
            currentCost.put(new RateClassRateType(rateType.getRateClassCode(), rateType.getRateTypeCode()), (ScaleTwoDecimal)((List)currentTotals.get(rateType)).get(period));
        }
        for (RateClassRateType rateClassRateType : currentCost.keySet()) {
            netCost.put(rateClassRateType, (ScaleTwoDecimal)currentCost.get(rateClassRateType));
        }
        return netCost;
    }

    @Override
    public Map<RateClassRateType, ScaleTwoDecimal> getPersonnelFringeCost(Budget currentBudget, AwardBudgetExt previousBudget) {
        BudgetCategoryType personnelCategory = this.getPersonnelCategoryType();
        List currentPersonnelObjectCodes = (List)currentBudget.getObjectCodeListByBudgetCategoryType().get(personnelCategory);
        Map<RateClassRateType, ScaleTwoDecimal> currentFringeTotals = this.getFringeTotals(currentPersonnelObjectCodes, currentBudget);
        HashMap<RateClassRateType, ScaleTwoDecimal> netFringeTotals = new HashMap<RateClassRateType, ScaleTwoDecimal>();
        for (RateClassRateType rate : currentFringeTotals.keySet()) {
            netFringeTotals.put(rate, currentFringeTotals.get(rate));
        }
        return netFringeTotals;
    }

    protected Map<RateClassRateType, ScaleTwoDecimal> getFringeTotals(List<CostElement> currentPersonnelObjectCodes, Budget budget) {
        HashMap<RateClassRateType, ScaleTwoDecimal> fringeTotals = new HashMap<RateClassRateType, ScaleTwoDecimal>();
        if (CollectionUtils.isNotEmpty(currentPersonnelObjectCodes)) {
            for (CostElement personnelCostElement : currentPersonnelObjectCodes) {
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    List<BudgetLineItem> filteredLineItems = this.getPersonnelLineItems(budgetPeriod, personnelCostElement);
                    for (BudgetLineItem lineItem : filteredLineItems) {
                        for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                            lineItemCalculatedAmount.refreshReferenceObject("rateClass");
                            if (!lineItemCalculatedAmount.getRateClass().getRateClassTypeCode().equalsIgnoreCase("E")) continue;
                            RateClassRateType currentKey = new RateClassRateType(lineItemCalculatedAmount.getRateClassCode(), lineItemCalculatedAmount.getRateTypeCode());
                            if (fringeTotals.containsKey(currentKey)) {
                                fringeTotals.put(currentKey, (ScaleTwoDecimal)((ScaleTwoDecimal)fringeTotals.get(currentKey)).add((AbstractDecimal)lineItemCalculatedAmount.getCalculatedCost()));
                                continue;
                            }
                            fringeTotals.put(currentKey, lineItemCalculatedAmount.getCalculatedCost());
                        }
                    }
                }
            }
        }
        return fringeTotals;
    }

    protected List<BudgetLineItem> getPersonnelLineItems(BudgetPeriod budgetPeriod, CostElement personnelCostElement) {
        QueryList<BudgetLineItem> lineItemQueryList = new QueryList<BudgetLineItem>();
        lineItemQueryList.addAll(budgetPeriod.getBudgetLineItems());
        Equals objectCodeEquals = new Equals("costElement", (Comparable)((Object)personnelCostElement.getCostElement()));
        QueryList<BudgetLineItem> filteredLineItems = lineItemQueryList.filter(objectCodeEquals);
        return filteredLineItems;
    }

    protected BudgetCategoryType getPersonnelCategoryType() {
        return (BudgetCategoryType)this.getDataObjectService().find(BudgetCategoryType.class, (Object)"P");
    }

    @Override
    public SortedMap<String, ScaleTwoDecimal> getPersonnelSalaryCost(Budget currentBudget, AwardBudgetExt previousBudget) throws Exception {
        SortedMap<String, List<ScaleTwoDecimal>> currentSalaryTotals = currentBudget.getObjectCodePersonnelSalaryTotals();
        TreeMap<String, ScaleTwoDecimal> netSalary = new TreeMap<String, ScaleTwoDecimal>();
        int period = currentBudget.getBudgetPeriods().size() - 1;
        Iterator<String> iterator = currentSalaryTotals.keySet().iterator();
        while (iterator.hasNext()) {
            String person;
            String key = person = iterator.next();
            if (person.contains(",")) {
                String[] objectCode = this.getElements(key);
                key = objectCode[0];
            }
            ScaleTwoDecimal currentSalary = (ScaleTwoDecimal)((List)currentSalaryTotals.get(person)).get(period);
            netSalary.put(key, currentSalary);
        }
        return netSalary;
    }

    protected String[] getElements(String person) throws Exception {
        if (person.contains(",")) {
            String[] personElements = person.split(",");
            return personElements;
        }
        LOG.error("The string is not in the format objectCode,personId  . Unable to retrieve object code.");
        throw new Exception("The string " + person + "is not in the format objectCode,personId  . Unable to retrieve object code.");
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

