/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.rolodex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.sys.framework.lookup.KcKualiLookupableHelperServiceImpl;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.struts.form.LookupForm;
import org.kuali.rice.kns.web.ui.ResultRow;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="rolodexLookupableHelperService")
@Scope(value="prototype")
public class RolodexLookupableHelperServiceImpl
extends KcKualiLookupableHelperServiceImpl {
    @Autowired
    @Qualifier(value="permissionService")
    private PermissionService permissionService;

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List<Object> htmlDataList = new ArrayList<HtmlData>();
        if (businessObject instanceof Rolodex) {
            Rolodex rolodex = (Rolodex)businessObject;
            if (rolodex.getSponsorAddressFlag()) {
                if (this.allowsMaintenanceNewOrCopyAction()) {
                    htmlDataList.add((HtmlData)this.getUrlData(businessObject, "copy", pkNames));
                }
            } else {
                htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
            }
        }
        return htmlDataList;
    }

    protected boolean allowsMaintenanceDeleteAction(BusinessObject businessObject) {
        boolean allowsRecordDeletion = this.getMaintenanceDocumentDictionaryService().getAllowsRecordDeletion(this.businessObjectClass);
        boolean hasPermission = this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-UNT", "Delete Address Book");
        return allowsRecordDeletion && hasPermission;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        Collection results = super.performLookup(lookupForm, resultTable, bounded);
        if (resultTable != null) {
            for (Object row : resultTable) {
                ResultRow resultRow;
                String returnUrl;
                if (!(row instanceof ResultRow) || (returnUrl = (resultRow = (ResultRow)row).getReturnUrl()) == null || returnUrl.isEmpty()) continue;
                resultRow.setReturnUrl(this.escapeJavaScriptInReturnUrl(returnUrl));
            }
        }
        return results;
    }

    private String escapeJavaScriptInReturnUrl(String returnUrl) {
        Pattern pattern = Pattern.compile("'([^']*)'");
        Matcher matcher = pattern.matcher(returnUrl);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String value = matcher.group(1);
            String escapedValue = StringEscapeUtils.escapeEcmaScript((String)value);
            matcher.appendReplacement(result, "'" + Matcher.quoteReplacement(escapedValue) + "'");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

