/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.distribution;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.budget.api.distribution.BudgetUnrecoveredFandAContract;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="EPS_PROP_IDC_RATE")
@IdClass(value=BudgetUnrecoveredFandAId.class)
public class BudgetUnrecoveredFandA
extends KcPersistableBusinessObjectBase
implements HierarchyMaintainable,
BudgetUnrecoveredFandAContract {
    private static final long serialVersionUID = 6614520585838685080L;
    public static final String DOCUMENT_COMPONENT_ID_KEY = "BUDGET_UNRECOVERED_F_AND_A_KEY";
    public static final String OFF_CAMPUS_RATE_FLAG = "N";
    public static final String ON_CAMPUS_RATE_FLAG = "Y";
    @Id
    @Column(name="UNRECOVERED_FNA_ID")
    private Integer documentComponentId;
    @Id
    @Column(name="BUDGET_ID", insertable=false, updatable=false)
    private Long budgetId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    private Budget budget;
    @Column(name="UNDERRECOVERY_OF_IDC")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal amount;
    @Column(name="APPLICABLE_IDC_RATE")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal applicableRate;
    @Column(name="ON_CAMPUS_FLAG")
    private String onCampusFlag;
    @Column(name="FISCAL_YEAR")
    private Integer fiscalYear;
    @Column(name="SOURCE_ACCOUNT")
    private String sourceAccount;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;

    public BudgetUnrecoveredFandA() {
    }

    public BudgetUnrecoveredFandA(Integer fiscalYear, ScaleTwoDecimal amount, ScaleTwoDecimal applicableRate, String campus, String sourceAccount) {
        this.fiscalYear = fiscalYear;
        this.amount = amount;
        this.applicableRate = applicableRate;
        this.onCampusFlag = campus;
        this.sourceAccount = sourceAccount;
    }

    public Integer getDocumentComponentId() {
        return this.documentComponentId;
    }

    public void setDocumentComponentId(Integer costShareId) {
        this.documentComponentId = costShareId;
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetUnrecoveredFandA)) {
            return false;
        }
        BudgetUnrecoveredFandA other = (BudgetUnrecoveredFandA)obj;
        if (this.amount == null ? other.amount != null : !this.amount.equals((Object)other.amount)) {
            return false;
        }
        if (this.applicableRate == null ? other.applicableRate != null : !this.applicableRate.equals((Object)other.applicableRate)) {
            return false;
        }
        if (this.onCampusFlag == null ? other.onCampusFlag != null : !this.onCampusFlag.equals(other.onCampusFlag)) {
            return false;
        }
        if (this.fiscalYear == null ? other.fiscalYear != null : !this.fiscalYear.equals(other.fiscalYear)) {
            return false;
        }
        return !(this.sourceAccount == null ? other.sourceAccount != null : !this.sourceAccount.equals(other.sourceAccount));
    }

    public ScaleTwoDecimal getAmount() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.amount);
    }

    public ScaleTwoDecimal getApplicableRate() {
        return this.applicableRate;
    }

    public String getOnCampusFlag() {
        return this.onCampusFlag;
    }

    public Integer getFiscalYear() {
        return this.fiscalYear;
    }

    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        result = 31 * result + (this.applicableRate == null ? 0 : this.applicableRate.hashCode());
        result = 31 * result + (this.onCampusFlag == null ? 0 : this.onCampusFlag.hashCode());
        result = 31 * result + (this.fiscalYear == null ? 0 : this.fiscalYear.hashCode());
        result = 31 * result + (this.sourceAccount == null ? 0 : this.sourceAccount.hashCode());
        return result;
    }

    public void setAmount(ScaleTwoDecimal amount) {
        this.amount = amount;
    }

    public void setApplicableRate(ScaleTwoDecimal applicableRate) {
        this.applicableRate = applicableRate;
    }

    public void setOnCampusFlag(String campus) {
        this.onCampusFlag = campus;
    }

    public void setFiscalYear(Integer fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public String getDocumentComponentIdKey() {
        return DOCUMENT_COMPONENT_ID_KEY;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
        this.budgetId = budget != null ? budget.getBudgetId() : null;
    }

    public static final class BudgetUnrecoveredFandAId
    implements Serializable,
    Comparable<BudgetUnrecoveredFandAId> {
        private Integer documentComponentId;
        private Long budgetId;

        public Integer getDocumentComponentId() {
            return this.documentComponentId;
        }

        public void setDocumentComponentId(Integer documentComponentId) {
            this.documentComponentId = documentComponentId;
        }

        public Long getBudgetId() {
            return this.budgetId;
        }

        public void setBudgetId(Long budgetId) {
            this.budgetId = budgetId;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("budgetId", (Object)this.budgetId).append("documentComponentId", (Object)this.documentComponentId).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            BudgetUnrecoveredFandAId rhs = (BudgetUnrecoveredFandAId)other;
            return new EqualsBuilder().append((Object)this.budgetId, (Object)rhs.budgetId).append((Object)this.documentComponentId, (Object)rhs.documentComponentId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.budgetId).append((Object)this.documentComponentId).toHashCode();
        }

        @Override
        public int compareTo(BudgetUnrecoveredFandAId other) {
            return new CompareToBuilder().append((Object)this.budgetId, (Object)other.budgetId).append((Object)this.documentComponentId, (Object)other.documentComponentId).toComparison();
        }
    }
}

