/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.budget.core;

import java.beans.PropertyEditor;
import java.text.DecimalFormat;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.calculator.BudgetCalculationService;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.BudgetSaveEvent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationService;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetJustificationWrapper;
import org.kuali.coeus.common.budget.framework.rate.BudgetRatesService;
import org.kuali.coeus.common.budget.framework.summary.BudgetSummaryService;
import org.kuali.coeus.common.budget.impl.nonpersonnel.BudgetExpensesRuleEvent;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.kuali.coeus.propdev.impl.budget.ProposalBudgetService;
import org.kuali.coeus.propdev.impl.budget.ProposalDevelopmentBudgetExt;
import org.kuali.coeus.propdev.impl.budget.auth.ProposalBudgetAuthorizer;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetForm;
import org.kuali.coeus.propdev.impl.budget.core.ProposalBudgetViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.budget.modular.BudgetModularService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.controller.KcCommonControllerService;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.model.ScaleTwoDecimalEditor;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.CollectionControllerService;
import org.kuali.rice.krad.web.service.ModelAndViewService;
import org.kuali.rice.krad.web.service.NavigationControllerService;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.servlet.ModelAndView;

public abstract class ProposalBudgetControllerBase {
    public static final int JUSTIFICATION_TEXT_MAX_LENGTH = 4000;
    @Autowired
    @Qualifier(value="kcCommonControllerService")
    private KcCommonControllerService kcCommonControllerService;
    @Autowired
    @Qualifier(value="collectionControllerService")
    private CollectionControllerService collectionControllerService;
    @Autowired
    @Qualifier(value="modelAndViewService")
    private ModelAndViewService modelAndViewService;
    @Autowired
    @Qualifier(value="navigationControllerService")
    private NavigationControllerService navigationControllerService;
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private ProposalBudgetService budgetService;
    @Autowired
    @Qualifier(value="budgetCalculationService")
    private BudgetCalculationService budgetCalculationService;
    @Autowired
    @Qualifier(value="kcBusinessRulesEngine")
    private KcBusinessRulesEngine kcBusinessRulesEngine;
    @Autowired
    @Qualifier(value="budgetJustificationService")
    private BudgetJustificationService budgetJustificationService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="proposalBudgetAuthorizer")
    private ProposalBudgetAuthorizer proposalBudgetAuthorizer;
    @Autowired
    @Qualifier(value="budgetModularService")
    private BudgetModularService budgetModularService;
    @Autowired
    @Qualifier(value="budgetSummaryService")
    private BudgetSummaryService budgetSummaryService;
    @Autowired
    @Qualifier(value="budgetRatesService")
    private BudgetRatesService budgetRatesService;
    @Autowired
    @Qualifier(value="proposalBudgetService")
    private ProposalBudgetService proposalBudgetService;

    protected UifFormBase createInitialForm(HttpServletRequest request) {
        return new ProposalBudgetForm();
    }

    @ModelAttribute(value="KualiForm")
    public UifFormBase initForm(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getKcCommonControllerService().initForm(this.createInitialForm(request), request, response);
    }

    protected ProposalDevelopmentBudgetExt loadBudget(Long budgetId) {
        ProposalDevelopmentBudgetExt budget = (ProposalDevelopmentBudgetExt)this.getDataObjectService().findUnique(ProposalDevelopmentBudgetExt.class, QueryByCriteria.Builder.andAttributes(Collections.singletonMap("budgetId", budgetId)).build());
        budget.setStartDate(budget.getDevelopmentProposal().getRequestedStartDateInitial());
        budget.setEndDate(budget.getDevelopmentProposal().getRequestedEndDateInitial());
        this.getBudgetSummaryService().setupOldStartEndDate(budget, false);
        if (!this.proposalBudgetAuthorizer.isAuthorizedToViewBudget(budget, this.globalVariableService.getUserSession().getPerson())) {
            throw new AuthorizationException(this.globalVariableService.getUserSession().getPrincipalName(), "open", "Proposal Budget");
        }
        return budget;
    }

    public ModelAndView save(ProposalBudgetForm form) {
        if (form.isCanEditView().booleanValue()) {
            this.saveBudget(form);
        } else {
            this.getBudgetSummaryService().setupOldStartEndDate(form.getBudget(), false);
            form.setBudgetModularSummary(this.budgetModularService.processModularSummary(form.getBudget(), true));
            this.validateBudgetExpenses(form);
        }
        this.checkAudit(form);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    protected void checkAudit(ProposalBudgetForm form) {
        if (form.isAuditActivated()) {
            this.getGlobalVariableService().getAuditErrorMap().clear();
            ((ProposalBudgetViewHelperServiceImpl)form.getViewHelperService()).applyBudgetAuditRules(form);
        }
    }

    protected void saveBudget(ProposalBudgetForm form) {
        boolean valid = this.getKcBusinessRulesEngine().applyRules(new BudgetSaveEvent(form.getBudget()));
        if (valid &= this.validateBudgetJustificationText(form.getBudgetJustificationWrapper())) {
            this.conditionallyClearBudgetParticipants(form.getBudget());
            this.budgetService.calculateBudgetOnSave(form.getBudget());
            form.setBudget((ProposalDevelopmentBudgetExt)this.getDataObjectService().save((Object)form.getBudget(), new PersistenceOption[0]));
            this.getBudgetJustificationService().preSave(form.getBudget(), form.getBudgetJustificationWrapper());
            this.getBudgetSummaryService().setupOldStartEndDate(form.getBudget(), false);
            form.setBudgetModularSummary(this.budgetModularService.processModularSummary(form.getBudget(), true));
            this.validateBudgetExpenses(form);
        }
    }

    private boolean validateBudgetJustificationText(BudgetJustificationWrapper wrapper) {
        String text = wrapper.toString();
        if (text != null && text.length() > 4000) {
            this.getGlobalVariableService().getMessageMap().putError("budgetJustificationWrapper.justificationText", "error.proposalDevelopment.budget.justification.text.length", new String[]{String.valueOf(text.length())});
            return false;
        }
        return true;
    }

    private void conditionallyClearBudgetParticipants(Budget budget) {
        budget.getBudgetPeriods().stream().filter(budgetPeriod -> !budgetPeriod.hasParticipantSupportItems()).forEach(budgetPeriod -> budgetPeriod.setNumberOfParticipants(0));
    }

    protected void validateBudgetExpenses(ProposalBudgetForm form) {
        String errorPath = null;
        if (form.getPageId().equalsIgnoreCase(BudgetConstants.BudgetAuditRules.NON_PERSONNEL_COSTS.getPageId())) {
            errorPath = BudgetConstants.BudgetAuditRules.NON_PERSONNEL_COSTS.getPageId();
        } else if (form.getPageId().equalsIgnoreCase(BudgetConstants.BudgetAuditRules.PERSONNEL_COSTS.getPageId())) {
            errorPath = BudgetConstants.BudgetAuditRules.PERSONNEL_COSTS.getPageId();
        }
        if (errorPath != null) {
            this.getKcBusinessRulesEngine().applyRules(new BudgetExpensesRuleEvent(form.getBudget(), errorPath));
        }
    }

    public ModelAndView saveLine(ProposalBudgetForm form) {
        String selectedCollectionPath = form.getActionParamaterValue("selectedCollectionPath");
        String selectedLine = form.getActionParamaterValue("selectedLineIndex");
        if (form.getEditableBudgetLineItems() != null && selectedCollectionPath != null && form.getEditableBudgetLineItems().containsKey(selectedCollectionPath)) {
            form.getEditableBudgetLineItems().get(selectedCollectionPath).remove(selectedLine);
        }
        return this.getCollectionControllerService().saveLine((UifFormBase)form);
    }

    protected ModelAndView navigate(ProposalBudgetForm form) throws Exception {
        ModelAndView modelAndView = this.save(form);
        String pageId = form.getActionParamaterValue("navigateToPageId");
        if (this.getGlobalVariableService().getMessageMap().hasNoErrors() && StringUtils.isNotEmpty((CharSequence)pageId)) {
            form.setDirtyForm(false);
            form.setPageId(pageId);
        }
        if (pageId.equalsIgnoreCase("PropBudget-CostSharingPage")) {
            this.proposalBudgetService.validateCostShare(form.getBudget());
        }
        return modelAndView;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(ScaleTwoDecimal.class, (PropertyEditor)new ScaleTwoDecimalEditor(new DecimalFormat("##0.00"), true));
    }

    protected Budget getOriginalBudget(ProposalBudgetForm form) {
        return (Budget)this.getDataObjectService().find(Budget.class, (Object)form.getBudget().getBudgetId());
    }

    protected boolean isRateTypeChanged(Budget originalBudget, Budget currentBudget) {
        return !StringUtils.equalsIgnoreCase((CharSequence)originalBudget.getOhRateClassCode(), (CharSequence)currentBudget.getOhRateClassCode()) || !StringUtils.equalsIgnoreCase((CharSequence)originalBudget.getUrRateClassCode(), (CharSequence)currentBudget.getUrRateClassCode());
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public KcCommonControllerService getKcCommonControllerService() {
        return this.kcCommonControllerService;
    }

    public void setKcCommonControllerService(KcCommonControllerService kcCommonControllerService) {
        this.kcCommonControllerService = kcCommonControllerService;
    }

    public CollectionControllerService getCollectionControllerService() {
        return this.collectionControllerService;
    }

    public void setCollectionControllerService(CollectionControllerService collectionControllerService) {
        this.collectionControllerService = collectionControllerService;
    }

    public ModelAndViewService getModelAndViewService() {
        return this.modelAndViewService;
    }

    public void setModelAndViewService(ModelAndViewService modelAndViewService) {
        this.modelAndViewService = modelAndViewService;
    }

    public NavigationControllerService getNavigationControllerService() {
        return this.navigationControllerService;
    }

    public void setNavigationControllerService(NavigationControllerService navigationControllerService) {
        this.navigationControllerService = navigationControllerService;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public ProposalBudgetService getBudgetService() {
        return this.budgetService;
    }

    public void setBudgetService(ProposalBudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public BudgetCalculationService getBudgetCalculationService() {
        return this.budgetCalculationService;
    }

    public void setBudgetCalculationService(BudgetCalculationService budgetCalculationService) {
        this.budgetCalculationService = budgetCalculationService;
    }

    public KcBusinessRulesEngine getKcBusinessRulesEngine() {
        return this.kcBusinessRulesEngine;
    }

    public void setKcBusinessRulesEngine(KcBusinessRulesEngine kcBusinessRulesEngine) {
        this.kcBusinessRulesEngine = kcBusinessRulesEngine;
    }

    public BudgetJustificationService getBudgetJustificationService() {
        return this.budgetJustificationService;
    }

    public void setBudgetJustificationService(BudgetJustificationService budgetJustificationService) {
        this.budgetJustificationService = budgetJustificationService;
    }

    protected GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    protected ProposalBudgetAuthorizer getProposalBudgetAuthorizer() {
        return this.proposalBudgetAuthorizer;
    }

    public void setProposalBudgetAuthorizer(ProposalBudgetAuthorizer proposalBudgetAuthorizer) {
        this.proposalBudgetAuthorizer = proposalBudgetAuthorizer;
    }

    public BudgetModularService getBudgetModularService() {
        return this.budgetModularService;
    }

    public void setBudgetModularService(BudgetModularService budgetModularService) {
        this.budgetModularService = budgetModularService;
    }

    public BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }

    public BudgetRatesService getBudgetRatesService() {
        return this.budgetRatesService;
    }

    public void setBudgetRatesService(BudgetRatesService budgetRatesService) {
        this.budgetRatesService = budgetRatesService;
    }
}

