/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.dataovveride;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.elasticsearch.ElasticsearchIndexService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.dataovveride.common.CommonDataOverrideService;
import org.kuali.coeus.propdev.impl.editable.ProposalChangedData;
import org.kuali.coeus.propdev.impl.editable.ProposalColumnsToAlter;
import org.kuali.coeus.propdev.impl.editable.ProposalDataOverrideEvent;
import org.kuali.coeus.propdev.impl.notification.NotificationControllerService;
import org.kuali.coeus.propdev.impl.notification.ProposalDevelopmentNotificationContext;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KewDocHeaderDao;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentDataOverrideController
extends ProposalDevelopmentControllerBase {
    private static final String SUBCONTRACT_FLAG = "SUBCONTRACT_FLAG";
    private static final String YES = "Y";
    private static final String NO = "N";
    private static final String ON = "on";
    private static final String PROP_DATA_OVERRIDE_DIALOG = "PropDev-DataOverride-Dialog";
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="notificationControllerService")
    private NotificationControllerService notificationControllerService;
    @Autowired
    @Qualifier(value="commonDataOverrideService")
    private CommonDataOverrideService commonDataOverrideService;
    @Autowired
    @Qualifier(value="kualiConfigurationService")
    private ConfigurationService configurationService;
    @Autowired
    @Qualifier(value="kewDocHeaderDao")
    private KewDocHeaderDao kewDocHeaderDao;
    private ElasticsearchIndexService elasticsearchIndexService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=prepareDataOverride"})
    public ModelAndView prepareDataOverride(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        String columnName = form.getNewProposalChangedData().getColumnName();
        if (StringUtils.isNotEmpty((CharSequence)columnName)) {
            form.getNewProposalChangedData().setEditableColumn((ProposalColumnsToAlter)this.getDataObjectService().find(ProposalColumnsToAlter.class, (Object)columnName));
            String propertyValue = this.getCommonDataOverrideService().getChangedValue(form.getDevelopmentProposal(), form.getNewProposalChangedData().getAttributeName());
            form.getNewProposalChangedData().setDisplayValue(propertyValue);
            form.getNewProposalChangedData().setOldDisplayValue(propertyValue);
        } else {
            form.setNewProposalChangedData(new ProposalChangedData());
        }
        form.setUpdateComponentId(PROP_DATA_OVERRIDE_DIALOG);
        form.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=createOverride"})
    public ModelAndView createOverride(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        ProposalDevelopmentDocument pdDocument = form.getProposalDevelopmentDocument();
        ProposalChangedData newProposalChangedData = form.getNewProposalChangedData();
        int changeNumber = pdDocument.getDocumentNextValue("proposalDevelopment.proposalChangedDataList.changeNumber");
        if (SUBCONTRACT_FLAG.equals(newProposalChangedData.getColumnName())) {
            newProposalChangedData.setChangedValue(newProposalChangedData.getChangedValue() != null && newProposalChangedData.getChangedValue().equalsIgnoreCase(ON) ? YES : NO);
        }
        newProposalChangedData.setProposalNumber(pdDocument.getDevelopmentProposal().getProposalNumber());
        newProposalChangedData.setChangeNumber(changeNumber);
        newProposalChangedData.setDisplayValue(newProposalChangedData.getChangedValue());
        if (this.getKualiRuleService().applyRules((DocumentEvent)new ProposalDataOverrideEvent(pdDocument, newProposalChangedData))) {
            this.getCommonDataOverrideService().setChangedValue(pdDocument.getDevelopmentProposal(), newProposalChangedData.getAttributeName(), newProposalChangedData.getChangedValue());
            this.growProposalChangedHistory(pdDocument, newProposalChangedData);
            ArrayList<ProposalChangedData> proposalChangedDataList = new ArrayList<ProposalChangedData>();
            proposalChangedDataList.add(newProposalChangedData);
            proposalChangedDataList.addAll(form.getDevelopmentProposal().getProposalChangedDataList());
            form.getDevelopmentProposal().setProposalChangedDataList(proposalChangedDataList);
            super.save(form);
            this.indexDocument(pdDocument);
            String value = this.getCommonDataOverrideService().getDisplayReferenceValue(form.getDevelopmentProposal(), newProposalChangedData.getAttributeName(), DevelopmentProposal.class);
            if (value != null) {
                newProposalChangedData.setDisplayValue(value);
            }
            form.setNewProposalChangedData(new ProposalChangedData());
            ProposalDevelopmentNotificationContext context = new ProposalDevelopmentNotificationContext(pdDocument.getDevelopmentProposal(), "103", "Proposal Data Override");
            context.getRenderer().setProposalChangedData(newProposalChangedData);
            context.getRenderer().setDevelopmentProposal(pdDocument.getDevelopmentProposal());
            this.getNotificationControllerService().sendNotificationIfNoErrors(form, context);
        }
        return this.getRefreshControllerService().refresh((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=sendOverrideNotification"})
    public ModelAndView sendOverrideNotification(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return this.getNotificationControllerService().sendNotification(form);
    }

    private void growProposalChangedHistory(ProposalDevelopmentDocument pdDocument, ProposalChangedData newProposalChangedData) {
        Map<String, List<ProposalChangedData>> changeHistory = pdDocument.getDevelopmentProposal().getProposalChangeHistory();
        changeHistory.computeIfAbsent(newProposalChangedData.getEditableColumn().getColumnLabel(), k -> new ArrayList());
        changeHistory.get(newProposalChangedData.getEditableColumn().getColumnLabel()).add(0, newProposalChangedData);
    }

    private void indexDocument(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        if (this.getConfigurationService().getPropertyValueAsBoolean("elasticsearch.enabled") && proposalDevelopmentDocument.getDocumentHeader() != null && !proposalDevelopmentDocument.getDocumentHeader().getWorkflowDocument().isInitiated()) {
            this.getElasticsearchIndexService().index(proposalDevelopmentDocument, this.kewDocHeaderDao.getAllNonActiveDocumentIds(proposalDevelopmentDocument.getDocumentNumber()));
        }
    }

    public NotificationControllerService getNotificationControllerService() {
        return this.notificationControllerService;
    }

    public void setNotificationControllerService(NotificationControllerService notificationControllerService) {
        this.notificationControllerService = notificationControllerService;
    }

    public CommonDataOverrideService getCommonDataOverrideService() {
        return this.commonDataOverrideService;
    }

    public void setCommonDataOverrideService(CommonDataOverrideService commonDataOverrideService) {
        this.commonDataOverrideService = commonDataOverrideService;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ElasticsearchIndexService getElasticsearchIndexService() {
        if (this.elasticsearchIndexService == null) {
            this.elasticsearchIndexService = KcServiceLocator.getService(ElasticsearchIndexService.class);
        }
        return this.elasticsearchIndexService;
    }

    public void setElasticsearchIndexService(ElasticsearchIndexService elasticsearchIndexService) {
        this.elasticsearchIndexService = elasticsearchIndexService;
    }
}

