/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.controller.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

public class KcUifHandlerExceptionResolver
implements HandlerExceptionResolver,
Ordered {
    private static final Logger LOG = LogManager.getLogger(KcUifHandlerExceptionResolver.class);
    HandlerExceptionResolver innerHandler;

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        UserSession requestSession = (UserSession)request.getSession().getAttribute("UserSession");
        if (System.identityHashCode(GlobalVariables.getUserSession()) != System.identityHashCode(requestSession)) {
            LOG.error("User Session Difference Detected. GlobalVariables session = " + String.valueOf(GlobalVariables.getUserSession()) + ", request session = " + String.valueOf(requestSession));
        }
        GlobalVariables.setUserSession((UserSession)requestSession);
        if (handler == null) {
            return this.innerHandler.resolveException(request, response, (Object)NullHandler.INSTANCE, ex);
        }
        return this.innerHandler.resolveException(request, response, handler, ex);
    }

    public void setInnerHandler(HandlerExceptionResolver innerHandler) {
        this.innerHandler = innerHandler;
    }

    private static final class NullHandler {
        private static final NullHandler INSTANCE = new NullHandler();

        private NullHandler() {
        }
    }
}

