/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.notification.impl.bo;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.notification.impl.bo.NotificationType;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class NotificationTypeMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = 5816092888763754328L;
    private static final String NOTIFICATION_TYPE_ID_SEQUENCE_NAME = "SEQ_NOTIFICATION_TYPE_ID";
    private static final String NOTIFICATION_TYPE_SECTION_ID = "Edit Notification Types";
    private static final String NOTIFICATION_TYPE_ID_NAME = "notificationTypeId";
    private transient SequenceAccessorService sequenceAccessorService;

    public void setGenerateDefaultValues(String docTypeName) {
        super.setGenerateDefaultValues(docTypeName);
        NotificationType notificationType = (NotificationType)this.getBusinessObject();
        Long nextNotificationTypeId = this.getSequenceAccessorService().getNextAvailableSequenceNumber(NOTIFICATION_TYPE_ID_SEQUENCE_NAME, NotificationType.class);
        notificationType.setNotificationTypeId(nextNotificationTypeId);
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        for (Section section : sections) {
            if (!StringUtils.equals((CharSequence)section.getSectionId(), (CharSequence)NOTIFICATION_TYPE_SECTION_ID)) continue;
            for (Row row : section.getRows()) {
                for (Field field : row.getFields()) {
                    if (!StringUtils.equals((CharSequence)field.getPropertyName(), (CharSequence)NOTIFICATION_TYPE_ID_NAME)) continue;
                    field.setReadOnly(true);
                }
            }
        }
        return sections;
    }

    public SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KcServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

