/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.persistence;

import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.commons.lang3.StringUtils;

@Converter(autoApply=true)
public class MonthDayConverter
implements AttributeConverter<MonthDay, String> {
    private static final DateTimeFormatter dbFormatter = DateTimeFormatter.ofPattern("MM/dd");

    public String convertToDatabaseColumn(MonthDay monthDay) {
        return monthDay == null ? null : monthDay.format(dbFormatter);
    }

    public MonthDay convertToEntityAttribute(String monthDayString) {
        try {
            return StringUtils.isEmpty((CharSequence)monthDayString) ? null : MonthDay.parse(monthDayString, dbFormatter);
        }
        catch (DateTimeParseException e) {
            return null;
        }
    }
}

