/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.person.PropAwardPersonRole;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContact;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalContactsBean;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitAddRuleImpl;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitRuleAddEvent;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalProjectPersonAddRuleImpl;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalProjectPersonRuleAddEvent;
import org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm;

public class InstitutionalProposalProjectPersonnelBean
extends InstitutionalProposalContactsBean {
    private static final long serialVersionUID = 6251507517307475952L;
    private static final Logger LOG = LogManager.getLogger(InstitutionalProposalProjectPersonnelBean.class);
    private InstitutionalProposalPersonUnit[] newInstitutionalProposalPersonUnits;
    private transient String selectedLeadUnit;

    public InstitutionalProposalProjectPersonnelBean(InstitutionalProposalForm institutionalProposalForm) {
        super(institutionalProposalForm);
    }

    public void addNewProjectPersonUnit(int projectPersonIndex) {
        InstitutionalProposalPerson person = this.getInstitutionalProposal().getProjectPersons().get(projectPersonIndex);
        InstitutionalProposalPersonUnitRuleAddEvent event = this.generateAddPersonUnitEvent(person, projectPersonIndex);
        boolean success = new InstitutionalProposalPersonUnitAddRuleImpl().processAddInstitutionalProposalPersonUnitBusinessRules(event);
        if (success) {
            person.add(this.newInstitutionalProposalPersonUnits[projectPersonIndex]);
            if (this.newInstitutionalProposalPersonUnits[projectPersonIndex].isLeadUnit()) {
                this.getInstitutionalProposal().setLeadUnit(this.newInstitutionalProposalPersonUnits[projectPersonIndex].getUnit());
                this.setSelectedLeadUnit(this.newInstitutionalProposalPersonUnits[projectPersonIndex].getUnitNumber());
            }
            this.initNewInstitutionalProposalPersonUnits();
        }
    }

    public void addProjectPerson() {
        InstitutionalProposalProjectPersonRuleAddEvent event = this.generateAddProjectPersonEvent();
        boolean success = new InstitutionalProposalProjectPersonAddRuleImpl().processAddInstitutionalProposalProjectPersonBusinessRules(event);
        if (success) {
            InstitutionalProposalPerson institutionalProposalPerson;
            institutionalProposalPerson.setFaculty((institutionalProposalPerson = this.getNewProjectPerson()).getPerson() != null ? institutionalProposalPerson.getPerson().getFacultyFlag() : Boolean.FALSE);
            this.getInstitutionalProposal().add(institutionalProposalPerson);
            this.init();
            if (institutionalProposalPerson.isPrincipalInvestigator()) {
                institutionalProposalPerson.getUnits().add(new InstitutionalProposalPersonUnit(institutionalProposalPerson, this.getInstitutionalProposal().getLeadUnit(), true));
            } else if (institutionalProposalPerson.isEmployee() && !institutionalProposalPerson.isKeyPerson()) {
                institutionalProposalPerson.getUnits().add(new InstitutionalProposalPersonUnit(institutionalProposalPerson, institutionalProposalPerson.getPerson().getUnit(), false));
            }
        }
    }

    public void deleteProjectPerson(int lineToDelete) {
        List<InstitutionalProposalPerson> projectPersons = this.getProjectPersonnel();
        if (projectPersons.size() > lineToDelete) {
            projectPersons.remove(lineToDelete);
        }
    }

    public void deleteProjectPersonUnit(int projectPersonIndex, int unitIndex) {
        this.getInstitutionalProposal().getProjectPersons().get(projectPersonIndex).getUnits().remove(unitIndex);
    }

    public InstitutionalProposalPersonUnit getNewInstitutionalProposalPersonUnit(int projectPersonIndex) {
        if (this.newInstitutionalProposalPersonUnits == null | this.newInstitutionalProposalPersonUnits.length == 0) {
            this.initNewInstitutionalProposalPersonUnits();
        }
        return this.newInstitutionalProposalPersonUnits[projectPersonIndex];
    }

    public InstitutionalProposalPersonUnit[] getNewInstitutionalProposalPersonUnits() {
        for (InstitutionalProposalPersonUnit apu : this.newInstitutionalProposalPersonUnits) {
            this.lazyLoadUnit(apu);
        }
        return this.newInstitutionalProposalPersonUnits;
    }

    public InstitutionalProposalPerson getNewProjectPerson() {
        return (InstitutionalProposalPerson)this.newInstitutionalProposalContact;
    }

    public String getNewUnitNumber(int projectPersonIndex) {
        return this.newInstitutionalProposalPersonUnits[projectPersonIndex].getUnit() != null ? this.newInstitutionalProposalPersonUnits[projectPersonIndex].getUnit().getUnitNumber() : null;
    }

    public List<InstitutionalProposalPerson> getProjectPersonnel() {
        return this.getInstitutionalProposal().getProjectPersons();
    }

    public int getProjectPersonnelCount() {
        return this.getProjectPersonnel().size();
    }

    public String getSelectedLeadUnit() {
        this.selectedLeadUnit = "";
        for (InstitutionalProposalPerson p : this.getProjectPersonnel()) {
            if (!p.isPrincipalInvestigator()) continue;
            for (InstitutionalProposalPersonUnit apu : p.getUnits()) {
                if (!apu.isLeadUnit()) continue;
                this.selectedLeadUnit = apu.getUnitNumber();
            }
        }
        return this.selectedLeadUnit;
    }

    public String getUnitName(int projectPersonIndex) {
        return this.newInstitutionalProposalPersonUnits[projectPersonIndex].getUnit() != null ? this.newInstitutionalProposalPersonUnits[projectPersonIndex].getUnit().getUnitName() : null;
    }

    public String getUnitNumber(int projectPersonIndex) {
        return this.getNewUnitNumber(projectPersonIndex);
    }

    public void setSelectedLeadUnit(String unitNumber) {
        this.selectedLeadUnit = unitNumber;
        this.setLeadUnitSelectionStates(unitNumber);
    }

    public InstitutionalProposalPerson getPrincipalInvestigator() {
        return this.findPrincipalInvestigator();
    }

    @Override
    protected InstitutionalProposalContact createNewContact() {
        return new InstitutionalProposalPerson();
    }

    @Override
    protected Class<? extends ContactRole> getContactRoleType() {
        return PropAwardPersonRole.class;
    }

    @Override
    protected void init() {
        super.init();
        this.initNewInstitutionalProposalPersonUnits();
    }

    private InstitutionalProposalPerson findPrincipalInvestigator() {
        InstitutionalProposalPerson institutionalProposalPerson = null;
        for (InstitutionalProposalContact institutionalProposalContact : this.getInstitutionalProposal().getProjectPersons()) {
            if (!"PI".equals(institutionalProposalContact.getContactRole().getRoleCode())) continue;
            institutionalProposalPerson = (InstitutionalProposalPerson)institutionalProposalContact;
            break;
        }
        return institutionalProposalPerson;
    }

    private InstitutionalProposalPersonUnitRuleAddEvent generateAddPersonUnitEvent(InstitutionalProposalPerson projectPerson, int addUnitPersonIndex) {
        return new InstitutionalProposalPersonUnitRuleAddEvent("InstitutionalProposalPersonUnitRuleAddEvent", "projectPersonnelBean.newInstitutionalProposalPersonUnit", this.getDocument(), projectPerson, this.newInstitutionalProposalPersonUnits[addUnitPersonIndex]);
    }

    private InstitutionalProposalProjectPersonRuleAddEvent generateAddProjectPersonEvent() {
        return new InstitutionalProposalProjectPersonRuleAddEvent("AddInstitutionalProposalProjectPersonRuleEvent", "projectPersonnelBean.newInstitutionalProposalContact", this.getDocument(), (InstitutionalProposalPerson)this.newInstitutionalProposalContact);
    }

    private void initNewInstitutionalProposalPersonUnits() {
        this.newInstitutionalProposalPersonUnits = new InstitutionalProposalPersonUnit[this.getInstitutionalProposal().getProjectPersons().size()];
        int personIndex = 0;
        for (InstitutionalProposalPerson p : this.getInstitutionalProposal().getProjectPersons()) {
            this.newInstitutionalProposalPersonUnits[personIndex++] = new InstitutionalProposalPersonUnit(p);
        }
    }

    private void lazyLoadUnit(InstitutionalProposalPersonUnit institutionalProposalPersonUnit) {
        if (institutionalProposalPersonUnit.getUnitNumber() != null && institutionalProposalPersonUnit.getUnit() == null) {
            HashMap<String, String> identifiers = new HashMap<String, String>();
            identifiers.put("unitNumber", institutionalProposalPersonUnit.getUnitNumber());
            Unit newUnit = (Unit)this.getBusinessObjectService().findByPrimaryKey(Unit.class, identifiers);
            institutionalProposalPersonUnit.setUnit(newUnit);
        }
    }

    private void setLeadUnitSelectionStates(String unitNumber) {
        InstitutionalProposalPerson institutionalProposalPerson = this.findPrincipalInvestigator();
        if (institutionalProposalPerson != null) {
            for (InstitutionalProposalPersonUnit associatedUnit : institutionalProposalPerson.getUnits()) {
                associatedUnit.setLeadUnit(associatedUnit.getUnit().getUnitNumber().equals(unitNumber));
            }
        } else {
            IllegalStateException e = new IllegalStateException("institutionalProposalPerson == null");
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

