/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.personnel;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.api.personnel.BudgetPersonnelDetailsContract;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetConstants;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategory;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetFormulatedCostDetail;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemBase;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriodType;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonSalaryDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelRateAndBase;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.persistence.BooleanNFConverter;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.util.ObjectUtils;

@Entity
@Table(name="BUDGET_PERSONNEL_DETAILS")
public class BudgetPersonnelDetails
extends BudgetLineItemBase
implements BudgetPersonnelDetailsContract {
    @PortableSequenceGenerator(name="SEQ_BUDGET_PER_DET_ID")
    @GeneratedValue(generator="SEQ_BUDGET_PER_DET_ID")
    @Id
    @Column(name="BUDGET_PERSONNEL_DETAILS_ID")
    private Long budgetPersonnelLineItemId;
    @Column(name="BUDGET_DETAILS_ID", insertable=false, updatable=false)
    private Long budgetLineItemId;
    @Column(name="LINE_ITEM_NUMBER")
    private Integer lineItemNumber;
    @Column(name="BUDGET_ID", insertable=false, updatable=false)
    private Long budgetId;
    @Column(name="BUDGET_PERIOD")
    private Integer budgetPeriod;
    @Column(name="ON_OFF_CAMPUS_FLAG")
    @Convert(converter=BooleanNFConverter.class)
    private Boolean onOffCampusFlag;
    @Column(name="END_DATE")
    private Date endDate;
    @Column(name="START_DATE")
    private Date startDate;
    @Column(name="BUDGET_JUSTIFICATION")
    @Lob
    private String budgetJustification;
    @Column(name="COST_SHARING_AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
    @Column(name="LINE_ITEM_DESCRIPTION")
    private String lineItemDescription;
    @Column(name="APPLY_IN_RATE_FLAG")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean applyInRateFlag;
    @Column(name="PERSON_NUMBER")
    private Integer personNumber;
    @Column(name="COST_SHARING_PERCENT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal costSharingPercent = ScaleTwoDecimal.ZERO;
    @Column(name="JOB_CODE")
    private String jobCode;
    @Column(name="PERCENT_CHARGED")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal percentCharged = ScaleTwoDecimal.ZERO;
    @Column(name="PERCENT_EFFORT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal percentEffort = ScaleTwoDecimal.ZERO;
    @Column(name="PERIOD_TYPE")
    private String periodTypeCode;
    @Column(name="PERSON_ID")
    private String personId;
    @Column(name="SALARY_REQUESTED")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal salaryRequested = ScaleTwoDecimal.ZERO;
    @Column(name="SEQUENCE_NUMBER")
    private Integer sequenceNumber;
    @Column(name="BUDGET_PERIOD_NUMBER")
    private Long budgetPeriodId;
    @Column(name="PERSON_SEQUENCE_NUMBER", insertable=false, updatable=false)
    private Integer personSequenceNumber;
    @Column(name="UNDERRECOVERY_AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal underrecoveryAmount = ScaleTwoDecimal.ZERO;
    @Column(name="SUBMIT_COST_SHARING")
    @Convert(converter=BooleanYNConverter.class)
    private Boolean submitCostSharingFlag = Boolean.TRUE;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumns(value={@JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID"), @JoinColumn(name="PERSON_SEQUENCE_NUMBER", referencedColumnName="PERSON_SEQUENCE_NUMBER")})
    private BudgetPerson budgetPerson;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID", insertable=false, updatable=false)
    private Budget budget;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_DETAILS_ID")
    private BudgetLineItem budgetLineItem;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PERIOD_TYPE", referencedColumnName="BUDGET_PERIOD_TYPE_CODE", insertable=false, updatable=false)
    private BudgetPeriodType budgetPeriodType;
    @Transient
    private String costElement;
    @Transient
    private ScaleTwoDecimal lineItemCost = ScaleTwoDecimal.ZERO;
    @Transient
    private String budgetCategoryCode;
    @Transient
    private Integer basedOnLineItem;
    @Transient
    private Integer quantity;
    @Transient
    private BudgetCategory budgetCategory;
    @Transient
    private Integer lineItemSequence;
    @Deprecated
    @Transient
    private CostElement costElementBO;
    @Transient
    private ScaleTwoDecimal totalCostSharingAmount;
    @Transient
    private String groupName;
    @Transient
    private Boolean formulatedCostElementFlag;
    @Transient
    private List<BudgetFormulatedCostDetail> budgetFormulatedCosts;
    @Transient
    private BudgetPeriod budgetPeriodBO;
    @OneToMany(mappedBy="budgetPersonnelLineItem", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetPersonnelCalculatedAmount> budgetPersonnelCalculatedAmounts;
    @OneToMany(mappedBy="budgetPersonnelLineItem", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BudgetPersonnelRateAndBase> budgetPersonnelRateAndBaseList;
    @Transient
    private List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails;
    @Transient
    private transient DataObjectService dataObjectService;
    @Transient
    private ScaleTwoDecimal calculatedBaseSalary = ScaleTwoDecimal.ZERO;

    public BudgetPersonnelDetails() {
        this.initializeBudgetPersonnelDetails();
    }

    public BudgetPersonnelDetails(BudgetLineItem personnelBudgetSummaryLineItem) {
        this.initializeBudgetPersonnelDetails();
        this.budgetLineItem = personnelBudgetSummaryLineItem;
        this.startDate = personnelBudgetSummaryLineItem.getStartDate();
        this.endDate = personnelBudgetSummaryLineItem.getEndDate();
        this.budgetPeriod = personnelBudgetSummaryLineItem.getBudgetPeriod();
        this.budgetId = personnelBudgetSummaryLineItem.getBudgetId();
        this.salaryRequested = personnelBudgetSummaryLineItem.getLineItemCost();
        this.personSequenceNumber = BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonSequenceNumber();
        this.personId = BudgetConstants.BudgetPerson.SUMMARYPERSON.getPersonId();
    }

    private void initializeBudgetPersonnelDetails() {
        this.budgetPersonnelCalculatedAmounts = new ArrayList<BudgetPersonnelCalculatedAmount>();
        this.budgetPersonnelRateAndBaseList = new ArrayList<BudgetPersonnelRateAndBase>();
        this.budgetPersonSalaryDetails = new ArrayList<BudgetPersonSalaryDetails>();
        this.budgetFormulatedCosts = new ArrayList<BudgetFormulatedCostDetail>();
    }

    @Override
    public Long getBudgetId() {
        return this.budgetId;
    }

    @Override
    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public Integer getPersonNumber() {
        return this.personNumber;
    }

    public void setPersonNumber(Integer personNumber) {
        this.personNumber = personNumber;
    }

    public ScaleTwoDecimal getCostSharingPercent() {
        return this.costSharingPercent;
    }

    public void setCostSharingPercent(ScaleTwoDecimal costSharingPercent) {
        this.costSharingPercent = costSharingPercent;
    }

    public String getJobCode() {
        return this.jobCode;
    }

    public void setJobCode(String jobCode) {
        this.jobCode = jobCode;
    }

    public ScaleTwoDecimal getPercentCharged() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.percentCharged);
    }

    public void setPercentCharged(ScaleTwoDecimal percentCharged) {
        this.percentCharged = percentCharged;
    }

    public ScaleTwoDecimal getPercentEffort() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.percentEffort);
    }

    public void setPercentEffort(ScaleTwoDecimal percentEffort) {
        this.percentEffort = percentEffort;
    }

    public String getPeriodTypeCode() {
        return this.periodTypeCode;
    }

    public void setPeriodTypeCode(String periodTypeCode) {
        this.periodTypeCode = periodTypeCode;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public ScaleTwoDecimal getSalaryRequested() {
        return this.salaryRequested;
    }

    public void setSalaryRequested(ScaleTwoDecimal salaryRequested) {
        this.salaryRequested = salaryRequested;
    }

    public ScaleTwoDecimal getCalculatedBaseSalary() {
        return this.calculatedBaseSalary;
    }

    public void setCalculatedBaseSalary(ScaleTwoDecimal calculatedBaseSalary) {
        this.calculatedBaseSalary = calculatedBaseSalary;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public Boolean getNonEmployeeFlag() {
        return this.getBudgetPerson() == null ? false : this.getBudgetPerson().getNonEmployeeFlag();
    }

    public Integer getPersonSequenceNumber() {
        return this.personSequenceNumber;
    }

    public void setPersonSequenceNumber(Integer personSequenceNumber) {
        this.personSequenceNumber = personSequenceNumber;
    }

    public BudgetPerson getBudgetPerson() {
        return this.budgetPerson;
    }

    public void setBudgetPerson(BudgetPerson budgetPerson) {
        this.budgetPerson = budgetPerson;
        if (budgetPerson != null) {
            this.setPersonId(budgetPerson.getPersonRolodexTbnId());
            this.setJobCode(budgetPerson.getJobCode());
        }
    }

    public List<BudgetPersonnelCalculatedAmount> getBudgetPersonnelCalculatedAmounts() {
        return this.budgetPersonnelCalculatedAmounts;
    }

    @Override
    public List<BudgetPersonnelCalculatedAmount> getBudgetCalculatedAmounts() {
        return this.getBudgetPersonnelCalculatedAmounts();
    }

    public List<BudgetPersonnelRateAndBase> getBudgetPersonnelRateAndBaseList() {
        return this.budgetPersonnelRateAndBaseList;
    }

    public List<BudgetPersonSalaryDetails> getBudgetPersonSalaryDetails() {
        return this.budgetPersonSalaryDetails;
    }

    public void setBudgetPersonSalaryDetails(List<BudgetPersonSalaryDetails> budgetPersonSalaryDetails) {
        this.budgetPersonSalaryDetails = budgetPersonSalaryDetails;
    }

    public String getEffdtAfterStartdtMsg() {
        if (this.isPersonSalaryEffectiveDateAfterStartDate()) {
            return "Earning Period Start Date is before " + this.budgetPerson.getPersonName() + "'s Salary Effective Date. Salary is calculated based on Effective Date.";
        }
        return "";
    }

    public boolean isPersonSalaryEffectiveDateAfterStartDate() {
        return this.getStartDate() != null && this.budgetPerson != null && this.budgetPerson.getEffectiveDate() != null && this.budgetPerson.getEffectiveDate().after(this.getStartDate());
    }

    public boolean isPersonBaseSalaryZero() {
        return this.getBudgetPerson() == null ? false : this.getBudgetPerson().getCalculationBase().equals((Object)ScaleTwoDecimal.ZERO);
    }

    public ScaleTwoDecimal getPersonMonths() {
        ScaleTwoDecimal result = null;
        if (this.getStartDate() != null && this.getEndDate() != null) {
            Calendar startDateCalendar = Calendar.getInstance();
            startDateCalendar.setTime(this.getStartDate());
            int startMonth = startDateCalendar.get(2);
            Calendar endDateCalendar = Calendar.getInstance();
            endDateCalendar.setTime(this.getEndDate());
            double personMonths = 0.0;
            while (startDateCalendar.compareTo(endDateCalendar) <= 0) {
                double noOfDaysInMonth = startDateCalendar.getActualMaximum(5);
                double noOfActualDays = 0.0;
                noOfActualDays = startDateCalendar.get(2) == endDateCalendar.get(2) && startDateCalendar.get(1) == endDateCalendar.get(1) ? (double)(endDateCalendar.get(5) - startDateCalendar.get(5) + 1) : (startDateCalendar.get(2) == startMonth ? noOfDaysInMonth - (double)startDateCalendar.get(5) + 1.0 : noOfDaysInMonth);
                startDateCalendar.add(2, 1);
                startDateCalendar.set(5, 1);
                personMonths += noOfActualDays / noOfDaysInMonth;
            }
            result = new ScaleTwoDecimal(new BigDecimal(personMonths).setScale(2, RoundingMode.HALF_UP).multiply(this.getPercentEffort().bigDecimalValue()).divide(new ScaleTwoDecimal(100).bigDecimalValue(), RoundingMode.HALF_UP));
        }
        return result;
    }

    public Long getBudgetPersonnelLineItemId() {
        return this.budgetPersonnelLineItemId;
    }

    public void setBudgetPersonnelLineItemId(Long budgetPersonnelLineItemId) {
        this.budgetPersonnelLineItemId = budgetPersonnelLineItemId;
    }

    @Override
    public Integer getLineItemNumber() {
        return this.lineItemNumber;
    }

    @Override
    public void setLineItemNumber(Integer lineItemNumber) {
        this.lineItemNumber = lineItemNumber;
    }

    @Override
    public Integer getBudgetPeriod() {
        return this.budgetPeriod;
    }

    @Override
    public void setBudgetPeriod(Integer budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }

    @Override
    public Boolean getOnOffCampusFlag() {
        return this.onOffCampusFlag;
    }

    @Override
    public void setOnOffCampusFlag(Boolean onOffCampusFlag) {
        this.onOffCampusFlag = onOffCampusFlag;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @Override
    public String getBudgetJustification() {
        return this.budgetJustification;
    }

    @Override
    public void setBudgetJustification(String budgetJustification) {
        this.budgetJustification = budgetJustification;
    }

    @Override
    public String getLineItemDescription() {
        return this.lineItemDescription;
    }

    @Override
    public void setLineItemDescription(String lineItemDescription) {
        this.lineItemDescription = lineItemDescription;
    }

    @Override
    public Boolean getApplyInRateFlag() {
        return this.applyInRateFlag;
    }

    @Override
    public void setApplyInRateFlag(Boolean applyInRateFlag) {
        this.applyInRateFlag = applyInRateFlag;
    }

    public AbstractBudgetCalculatedAmount getNewBudgetPersonnelCalculatedAmount() {
        return new BudgetPersonnelCalculatedAmount();
    }

    @Override
    public ScaleTwoDecimal getCostSharingAmount() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.costSharingAmount);
    }

    @Override
    public void setCostSharingAmount(ScaleTwoDecimal costSharingAmount) {
        this.costSharingAmount = costSharingAmount;
    }

    @Override
    public ScaleTwoDecimal getLineItemCost() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.lineItemCost);
    }

    @Override
    public void setLineItemCost(ScaleTwoDecimal lineItemCost) {
        this.lineItemCost = lineItemCost;
    }

    @Override
    public ScaleTwoDecimal getUnderrecoveryAmount() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.underrecoveryAmount);
    }

    @Override
    public void setUnderrecoveryAmount(ScaleTwoDecimal underrecoveryAmount) {
        this.underrecoveryAmount = underrecoveryAmount;
    }

    @Override
    public ScaleTwoDecimal getTotalCostSharingAmount() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.totalCostSharingAmount);
    }

    @Override
    public void setTotalCostSharingAmount(ScaleTwoDecimal totalCostSharingAmount) {
        this.totalCostSharingAmount = totalCostSharingAmount;
    }

    @Override
    public void setSubmitCostSharingFlag(Boolean submitCostSharingFlag) {
        this.submitCostSharingFlag = submitCostSharingFlag;
    }

    @Override
    public Boolean getSubmitCostSharingFlag() {
        if (this.getBudget() != null) {
            return this.getBudget().getSubmitCostSharingFlag() != false ? this.submitCostSharingFlag : false;
        }
        return this.getBudgetPeriodBO() != null && this.getBudgetPeriodBO().getBudget().getSubmitCostSharingFlag() != false ? this.submitCostSharingFlag : false;
    }

    @Override
    public Boolean getFormulatedCostElementFlag() {
        return this.formulatedCostElementFlag == null ? Boolean.FALSE : this.formulatedCostElementFlag;
    }

    @Override
    public void setFormulatedCostElementFlag(Boolean formulatedCostElementFlag) {
        this.formulatedCostElementFlag = formulatedCostElementFlag;
    }

    @Override
    public String getCostElement() {
        return this.costElement;
    }

    @Override
    public void setCostElement(String costElement) {
        this.costElement = costElement;
    }

    @Override
    public String getBudgetCategoryCode() {
        return this.budgetCategoryCode;
    }

    @Override
    public void setBudgetCategoryCode(String budgetCategoryCode) {
        this.budgetCategoryCode = budgetCategoryCode;
    }

    @Override
    public Integer getBasedOnLineItem() {
        return this.basedOnLineItem;
    }

    @Override
    public void setBasedOnLineItem(Integer basedOnLineItem) {
        this.basedOnLineItem = basedOnLineItem;
    }

    @Override
    public Integer getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    @Override
    public BudgetCategory getBudgetCategory() {
        return this.budgetCategory;
    }

    @Override
    public void setBudgetCategory(BudgetCategory budgetCategory) {
        this.budgetCategory = budgetCategory;
    }

    @Override
    public Integer getLineItemSequence() {
        return this.lineItemSequence;
    }

    @Override
    public void setLineItemSequence(Integer lineItemSequence) {
        this.lineItemSequence = lineItemSequence;
    }

    @Override
    @Deprecated
    public CostElement getCostElementBO() {
        if (this.getBudgetLineItem() != null) {
            return this.getBudgetLineItem().getCostElementBO();
        }
        return this.costElementBO;
    }

    @Override
    @Deprecated
    public void setCostElementBO(CostElement costElementBO) {
        this.costElementBO = costElementBO;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    @Override
    public List<BudgetFormulatedCostDetail> getBudgetFormulatedCosts() {
        return this.budgetFormulatedCosts;
    }

    @Override
    public void setBudgetFormulatedCosts(List<BudgetFormulatedCostDetail> budgetFormulatedCosts) {
        this.budgetFormulatedCosts = budgetFormulatedCosts;
    }

    @Override
    public BudgetPeriod getBudgetPeriodBO() {
        if (this.budgetPeriodId != null && ObjectUtils.isNull((Object)this.budgetPeriodBO)) {
            this.budgetPeriodBO = (BudgetPeriod)this.getDataObjectService().find(BudgetPeriod.class, (Object)this.budgetPeriodId);
        }
        return this.budgetPeriodBO;
    }

    @Override
    public void setBudgetPeriodBO(BudgetPeriod budgetPeriodBO) {
        this.budgetPeriodBO = budgetPeriodBO;
    }

    public void setBudgetPersonnelCalculatedAmounts(List<BudgetPersonnelCalculatedAmount> budgetPersonnelCalculatedAmounts) {
        this.budgetPersonnelCalculatedAmounts = budgetPersonnelCalculatedAmounts;
    }

    public void setBudgetPersonnelRateAndBaseList(List<BudgetPersonnelRateAndBase> budgetPersonnelRateAndBaseList) {
        this.budgetPersonnelRateAndBaseList = budgetPersonnelRateAndBaseList;
    }

    @Override
    public Long getBudgetPeriodId() {
        return this.budgetPeriodId;
    }

    @Override
    public void setBudgetPeriodId(Long budgetPeriodId) {
        this.budgetPeriodId = budgetPeriodId;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
        this.budgetId = budget != null ? budget.getBudgetId() : null;
    }

    public BudgetLineItem getBudgetLineItem() {
        return this.budgetLineItem;
    }

    public void setBudgetLineItem(BudgetLineItem budgetLineItem) {
        this.budgetLineItem = budgetLineItem;
    }

    public Long getBudgetLineItemId() {
        return this.budgetLineItemId;
    }

    public BudgetPeriodType getBudgetPeriodType() {
        return this.budgetPeriodType;
    }

    public void setBudgetPeriodType(BudgetPeriodType budgetPeriodType) {
        this.budgetPeriodType = budgetPeriodType;
    }

    public String getPersonDetailGroup() {
        StringBuffer personDetailGroup = new StringBuffer();
        personDetailGroup.append(this.getBudgetLineItem().getCostElementBO().getDescription());
        if (StringUtils.isNotEmpty((CharSequence)this.getBudgetLineItem().getGroupName())) {
            personDetailGroup.append(" (");
            personDetailGroup.append(this.getBudgetLineItem().getGroupName());
            personDetailGroup.append(")");
        }
        return personDetailGroup.toString();
    }

    public ScaleTwoDecimal getCalculatedFringe() {
        if (!this.getBudgetPersonnelCalculatedAmounts().isEmpty()) {
            return this.getPersonnelCalculatedFringe();
        }
        return this.getSummaryCalculatedFringe();
    }

    private ScaleTwoDecimal getPersonnelCalculatedFringe() {
        ScaleTwoDecimal calculatedFringe = ScaleTwoDecimal.ZERO;
        for (BudgetPersonnelCalculatedAmount budgetPersonnelCalculatedAmount : this.getBudgetPersonnelCalculatedAmounts()) {
            if (!budgetPersonnelCalculatedAmount.getAddToFringeRate()) continue;
            calculatedFringe = (ScaleTwoDecimal)calculatedFringe.add((AbstractDecimal)budgetPersonnelCalculatedAmount.getCalculatedCost());
        }
        return calculatedFringe;
    }

    private ScaleTwoDecimal getSummaryCalculatedFringe() {
        ScaleTwoDecimal calculatedFringe = ScaleTwoDecimal.ZERO;
        for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : this.getBudgetLineItem().getBudgetLineItemCalculatedAmounts()) {
            if (!budgetLineItemCalculatedAmount.getAddToFringeRate()) continue;
            calculatedFringe = (ScaleTwoDecimal)calculatedFringe.add((AbstractDecimal)budgetLineItemCalculatedAmount.getCalculatedCost());
        }
        return calculatedFringe;
    }

    public void setBudgetLineItemId(Long budgetLineItemId) {
        this.budgetLineItemId = budgetLineItemId;
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

