/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.medusa;

import java.util.Comparator;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.medusa.MedusaNode;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.subaward.bo.SubAward;

public class MedusaNodeComparator
implements Comparator<MedusaNode> {
    @Override
    public int compare(MedusaNode m1, MedusaNode m2) {
        return this.getNodeValue(m1).compareTo(this.getNodeValue(m2));
    }

    private String getNodeValue(MedusaNode m) {
        String nodeType = m.getType();
        Object mBo = m.getBo();
        if (!StringUtils.isNotBlank((CharSequence)nodeType) || mBo == null) {
            return "medusa: unknown medusa node type";
        }
        if (StringUtils.equals((CharSequence)nodeType, (CharSequence)"award")) {
            return nodeType + ((Award)mBo).getAwardNumber();
        }
        if (StringUtils.equals((CharSequence)nodeType, (CharSequence)"IP")) {
            return nodeType + ((InstitutionalProposal)mBo).getProposalNumber();
        }
        if (StringUtils.equals((CharSequence)nodeType, (CharSequence)"DP")) {
            return nodeType + ((DevelopmentProposal)mBo).getProposalNumber();
        }
        if (StringUtils.equals((CharSequence)nodeType, (CharSequence)"neg")) {
            return nodeType + ((Negotiation)mBo).getNegotiationId();
        }
        if (StringUtils.equals((CharSequence)nodeType, (CharSequence)"subaward")) {
            return nodeType + ((SubAward)mBo).getSubAwardId();
        }
        return "medusa: unsupported medusa node type";
    }
}

