/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.rate;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kuali.coeus.common.budget.framework.rate.RateClass;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.uif.control.UifKeyValuesFinderBase;

public class RateClassBaseInclusionValuesFinder
extends UifKeyValuesFinderBase {
    public static final String DESCRIPTION = "description";
    public static final String BASE_COST = "Base Cost";
    public static final String BASE_COST_CODE = "0";
    private transient DataObjectService dataObjectService;

    public List<KeyValue> getKeyValues() {
        List<KeyValue> keyValues = this.getRateClasses().stream().map(rateClass -> new ConcreteKeyValue(rateClass.getCode(), rateClass.getDescription())).collect(Collectors.toList());
        keyValues.add(0, (KeyValue)new ConcreteKeyValue(BASE_COST_CODE, BASE_COST));
        return keyValues;
    }

    private List<RateClass> getRateClasses() {
        ArrayList<OrderByField> orderByFields = new ArrayList<OrderByField>();
        orderByFields.add(OrderByField.Builder.create((String)DESCRIPTION, (OrderDirection)OrderDirection.ASCENDING).build());
        return this.getDataObjectService().findMatching(RateClass.class, QueryByCriteria.Builder.create().setOrderByFields(orderByFields).build()).getResults();
    }

    public DataObjectService getDataObjectService() {
        if (this.dataObjectService == null) {
            this.dataObjectService = KcServiceLocator.getService(DataObjectService.class);
        }
        return this.dataObjectService;
    }
}

