/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.print;

import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.kuali.coeus.common.budget.api.rate.RateClassType;
import org.kuali.coeus.common.budget.framework.calculator.ValidCalcType;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.BudgetParent;
import org.kuali.coeus.common.budget.framework.nonpersonnel.AbstractBudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItem;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemBase;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.coeus.common.budget.framework.nonpersonnel.BudgetRateAndBase;
import org.kuali.coeus.common.budget.framework.period.BudgetPeriod;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPerson;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelDetails;
import org.kuali.coeus.common.budget.framework.personnel.BudgetPersonnelRateAndBase;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.common.budget.impl.print.ReportTypeVO;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.printing.schema.GroupsType;
import org.kuali.kra.printing.schema.ReportHeaderType;
import org.kuali.kra.printing.schema.ReportPageType;
import org.kuali.kra.printing.schema.ReportType;
import org.kuali.kra.printing.schema.SubReportType;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BudgetBaseStream<T extends XmlObject>
implements XmlStream<T> {
    private static final Logger LOG = LogManager.getLogger(BudgetBaseStream.class);
    public static final String RATE_CLASS_TYPE = "rateClassType";
    private static final String DEPENDENT_RATE_CLASS_TYPE = "dependentRateClassType";
    private static final String RATE_CLASS_CODE = "rateClassCode";
    private static final String GET_METHOD_PREFIX = "get";
    private static final String RATE_TYPE_CODE = "rateTypeCode";
    private static final String CLOSE_BRACES = ")";
    private static final String OPEN_BRACES = "(";
    private static final String PERSONNEL_SUMMARY_LINE_ITEM_NAME = "Summary";
    protected static final String TOTAL_EMPLOYEE_BENEFITS = "Total Employee Benefits";
    protected static final String ALLOCATED_LAB_EXPENSE = "Allocated Lab Expense";
    protected static final String EMPLOYEE_BENEFITS_ON_ALLOCATED_ADMINISTRATIVE_SUPPORT = "Employee Benefits on Allocated Administrative Support";
    protected static final String EMPLOYEE_BENEFITS_ON_PERSONNEL = "Employee Benefits on ";
    protected static final String ALLOCATED_ADMINISTRATIVE_SUPPORT = "Allocated Administrative Support";
    protected static final String OTHER_DIRECT_COSTS = "Other Direct Costs";
    protected static final String ALLOCATED_ADMIN_SUPPORT = "Allocated Admin Support";
    protected static final String PERCENTAGE = "%";
    protected static final String LAB_ALLOCATION = "Lab Allocation";
    protected static final String CATEGORY_CODE_LA_SALARY = "99";
    protected static final String DEFAULT_RATE_TYPE_CODE_FOR_LI = "3";
    private static final String RATE_CLASS = "rateClass";
    private static final String STRING_SEPRATOR = "-";
    private static final String EMPTY_STRING = "";
    protected static final String DATE_FORMAT = "dd MMM yyyy";
    protected static final String DATE_FORMAT_MMDDYY = "MM/dd/yy";
    protected static final String BUDGET_PERIOD = "Period";
    protected static final String BUDGET_CATEGORY_PERSONNEL = "P";
    public static final String COST_ELEMENT_BO = "costElementBO";
    public static final String BUDGET_CATEGORY = "budgetCategory";
    protected Budget budget;
    protected String[] category = new String[]{"budgetCategoryDescription"};
    protected String[] rateType = new String[]{"rateTypeDesc"};
    protected String[] rateClassRateType = new String[]{"rateClassDesc", "rateTypeDesc"};
    protected BudgetPeriod budgetPeriod;
    @Autowired
    @Qualifier(value="businessObjectService")
    protected BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dateTimeService")
    protected DateTimeService dateTimeService;
    @Autowired
    @Qualifier(value="dataObjectService")
    protected DataObjectService dataObjectService;

    protected ReportHeaderType getReportHeaderTypeForCumulativeReport(BudgetParent budgetParent) {
        String principleInvestigatorName;
        ReportHeaderType reportHeaderType = (ReportHeaderType)ReportHeaderType.Factory.newInstance();
        if (budgetParent != null) {
            reportHeaderType.setParentTypeName(budgetParent.getParentTypeName());
            reportHeaderType.setProposalNumber(budgetParent.getParentNumber());
        }
        if (budgetParent != null && budgetParent.getParentTitle() != null) {
            reportHeaderType.setProposalTitle(budgetParent.getParentTitle());
        }
        if ((principleInvestigatorName = budgetParent.getParentPIName()) != null) {
            reportHeaderType.setPIName(principleInvestigatorName);
        }
        if (this.budgetPeriod.getVersionNumber() != null) {
            reportHeaderType.setBudgetVersion(this.budget.getBudgetVersionNumber());
        }
        if (this.budgetPeriod.getStartDate() != null) {
            reportHeaderType.setPeriodStartDate(DateFormatUtils.format((java.util.Date)this.budgetPeriod.getStartDate(), (String)DATE_FORMAT));
        }
        if (this.budgetPeriod.getEndDate() != null) {
            reportHeaderType.setPeriodEndDate(DateFormatUtils.format((java.util.Date)this.budgetPeriod.getEndDate(), (String)DATE_FORMAT));
        }
        if (this.budgetPeriod.getBudgetPeriod() != null) {
            reportHeaderType.setPeriod(this.budgetPeriod.getBudgetPeriod());
        }
        reportHeaderType.setCreateDate(this.dateTimeService.getCurrentDate().toString());
        if (this.budget.getComments() != null && this.budget.getPrintBudgetCommentFlag() != null && this.budget.getPrintBudgetCommentFlag().equals("true")) {
            reportHeaderType.setComments(this.budget.getComments());
        }
        this.budget.setPrintBudgetCommentFlag(null);
        return reportHeaderType;
    }

    protected ReportType getReportTypeForNonPersonnel(String categoryDesc, String costElementDesc, ScaleTwoDecimal calculatedCost, ScaleTwoDecimal costSharingAmount) {
        ReportType reportType = this.getReportType();
        if (categoryDesc != null) {
            reportType.setBudgetCategoryDescription(categoryDesc);
        }
        if (costElementDesc != null) {
            reportType.setCostElementDescription(costElementDesc);
        }
        if (calculatedCost != null) {
            reportType.setCalculatedCost(calculatedCost.doubleValue());
        } else {
            reportType.setCalculatedCost(0.0);
        }
        if (costSharingAmount != null) {
            reportType.setCostSharingAmount(costSharingAmount.doubleValue());
        } else {
            reportType.setCostSharingAmount(0.0);
        }
        return reportType;
    }

    protected ReportType getReportTypeForBudgetIndirectCostsForReport(Boolean onOffCampus, ScaleTwoDecimal calculatedCost, ScaleTwoDecimal costSharingAmount) {
        ReportType reportType = this.getReportType();
        if (onOffCampus != null) {
            reportType.setOnOffCampus(onOffCampus);
        }
        if (costSharingAmount != null) {
            reportType.setCostSharingAmount(costSharingAmount.doubleValue());
        } else {
            reportType.setCostSharingAmount(0.0);
        }
        if (calculatedCost != null) {
            reportType.setCalculatedCost(calculatedCost.doubleValue());
        } else {
            reportType.setCalculatedCost(0.0);
        }
        return reportType;
    }

    protected ReportType getReportTypeForExclusions(int sortId, String categoryDesc, ScaleTwoDecimal calculatedCost) {
        ReportType reportType = this.getReportType();
        reportType.setSortId(sortId);
        reportType.setCostElementDescription(categoryDesc);
        if (calculatedCost != null) {
            reportType.setCalculatedCost(calculatedCost.doubleValue());
        } else {
            reportType.setCalculatedCost(0.0);
        }
        return reportType;
    }

    protected ScaleTwoDecimal getTotalCalculatedCostByRateClassTypeFromLineItem(String rateClassType, BudgetLineItem budgetLineItem) {
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItemCalculatedAmount lineItemCalAmt : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            lineItemCalAmt.refreshReferenceObject(RATE_CLASS);
            if (!lineItemCalAmt.getRateClass().getRateClassTypeCode().equals(rateClassType) || lineItemCalAmt.getCalculatedCost() == null) continue;
            calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)lineItemCalAmt.getCalculatedCost());
        }
        return calculatedCost;
    }

    protected ScaleTwoDecimal getTotalCostSharingAmountByRateClassTypeFromLineItem(BudgetLineItem budgetLineItem, String rateClassType) {
        ScaleTwoDecimal costSharingAmount = ScaleTwoDecimal.ZERO;
        for (BudgetLineItemCalculatedAmount lineItemCalAmt : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            lineItemCalAmt.refreshReferenceObject(RATE_CLASS);
            if (!lineItemCalAmt.getRateClass().getRateClassTypeCode().equals(rateClassType) || lineItemCalAmt.getCalculatedCostSharing() == null) continue;
            costSharingAmount = (ScaleTwoDecimal)costSharingAmount.add((AbstractDecimal)lineItemCalAmt.getCalculatedCostSharing());
        }
        return costSharingAmount;
    }

    protected ScaleTwoDecimal getCalculatedCostForBudgetExclusionsSortId1() {
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (budgetRateAndBase.getCalculatedCost() == null || !this.isRateAndBaseOfRateClassTypeLAwithEBVA(budgetRateAndBase)) continue;
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)budgetRateAndBase.getCalculatedCost());
            }
        }
        return calculatedCost;
    }

    protected ScaleTwoDecimal getCalculatedCostForBudgetLAExclusionsSortId2() {
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (budgetRateAndBase.getCalculatedCost() == null) continue;
                budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
                if (!this.isRateAndBaseOfRateClassTypeEB(budgetRateAndBase) && !this.isRateAndBaseOfRateClassTypeVacation(budgetRateAndBase)) continue;
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)budgetRateAndBase.getCalculatedCost());
            }
        }
        return calculatedCost;
    }

    protected ScaleTwoDecimal getCalculatedCostForBudgetOHExclusionsSortId2() {
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (budgetRateAndBase.getCalculatedCost() == null) continue;
                budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
                if (!this.isRateAndBaseEBonLA(budgetRateAndBase) && !this.isRateAndBaseVAonLA(budgetRateAndBase)) continue;
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)budgetRateAndBase.getCalculatedCost());
            }
        }
        return calculatedCost;
    }

    protected ScaleTwoDecimal getCalculatedCostForBudgetExclusionsSortId4() {
        ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
                if (budgetLineItemCalcAmount.getCalculatedCost() == null) continue;
                budgetLineItemCalcAmount.refreshReferenceObject(RATE_CLASS);
                if (!this.isLineItemCalAmountOfRateClassTypeLabAllocation(budgetLineItemCalcAmount)) continue;
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)budgetLineItemCalcAmount.getCalculatedCost());
            }
        }
        return calculatedCost;
    }

    protected void setReportTypeBudgetLASalary(List<ReportType> reportTypeList, List<ReportTypeVO> reportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : reportTypeVOList) {
            String budgetLASalaryKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(budgetLASalaryKey)) continue;
            Date startDate = reportTypeVO.getStartDate();
            Date endDate = reportTypeVO.getEndDate();
            ScaleTwoDecimal fringe = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal calculatedCostSharing = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal salary = ScaleTwoDecimal.ZERO;
            HashSet<CallSite> lineItemFringe = new HashSet<CallSite>();
            for (ReportTypeVO tempReportTypeVO : reportTypeVOList) {
                String budgetLASalaryTempKey = tempReportTypeVO.getCostElementDesc();
                if (!budgetLASalaryTempKey.equals(budgetLASalaryKey)) continue;
                if (startDate.after(tempReportTypeVO.getStartDate())) {
                    startDate = tempReportTypeVO.getStartDate();
                }
                if (endDate.before(tempReportTypeVO.getEndDate())) {
                    endDate = tempReportTypeVO.getEndDate();
                }
                if (tempReportTypeVO.getBudgetLineItemId() == null || !lineItemFringe.contains(tempReportTypeVO.getBudgetLineItemId().toString() + STRING_SEPRATOR + String.valueOf(startDate) + STRING_SEPRATOR + String.valueOf(endDate))) {
                    fringe = (ScaleTwoDecimal)fringe.add((AbstractDecimal)tempReportTypeVO.getFringe());
                }
                lineItemFringe.add((CallSite)((Object)(tempReportTypeVO.getBudgetLineItemId().toString() + STRING_SEPRATOR + String.valueOf(startDate) + STRING_SEPRATOR + String.valueOf(endDate))));
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)tempReportTypeVO.getCalculatedCost());
                calculatedCostSharing = (ScaleTwoDecimal)calculatedCostSharing.add((AbstractDecimal)tempReportTypeVO.getCostSharingAmount());
                salary = (ScaleTwoDecimal)salary.add((AbstractDecimal)tempReportTypeVO.getSalaryRequested());
            }
            this.addReportType(reportTypeList, reportTypeVO, startDate, endDate, fringe, calculatedCost, calculatedCostSharing, salary);
            reportTypeMap.put(budgetLASalaryKey, reportTypeVO);
        }
    }

    protected void addReportType(List<ReportType> reportTypeList, ReportTypeVO reportTypeVO, Date startDate, Date endDate, ScaleTwoDecimal fringe, ScaleTwoDecimal calculatedCost, ScaleTwoDecimal calculatedCostSharing, ScaleTwoDecimal salary) {
        ReportType reportType = this.getReportTypeForLASalary(fringe, salary, calculatedCost, calculatedCostSharing, reportTypeVO, startDate, endDate);
        reportTypeList.add(reportType);
    }

    private ReportType getReportTypeForLASalary(ScaleTwoDecimal fringe, ScaleTwoDecimal salary, ScaleTwoDecimal calculatedCost, ScaleTwoDecimal calculatedCostSharing, ReportTypeVO reportTypeVO, Date startDate, Date endDate) {
        ReportType reportType = this.getReportType();
        reportType.setBudgetCategoryDescription(LAB_ALLOCATION);
        reportType.setPersonName(ALLOCATED_ADMIN_SUPPORT);
        reportType.setPercentEffort(100.0);
        reportType.setPercentCharged(100.0);
        reportType.setBudgetCategoryCode(99);
        reportType.setInvestigatorFlag(3);
        reportType.setStartDate(DateFormatUtils.format((java.util.Date)startDate, (String)DATE_FORMAT_MMDDYY));
        reportType.setEndDate(DateFormatUtils.format((java.util.Date)endDate, (String)DATE_FORMAT_MMDDYY));
        reportType.setCostSharingAmount(calculatedCostSharing.doubleValue());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        reportType.setFringe(fringe.doubleValue());
        reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
        reportType.setSalaryRequested(salary.doubleValue());
        return reportType;
    }

    protected void setBudgetLASalaryForBudgetRateAndBase(List<ReportType> reportTypeList, List<ReportTypeVO> reportTypeVOList) {
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
                if (!this.isRateAndBaseOfRateClassTypeLAwithEBVA(budgetRateAndBase)) continue;
                ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetLASalaryForRateBase(budgetLineItem, budgetRateAndBase);
                reportTypeVOList.add(reportTypeVO);
            }
        }
        reportTypeVOList.sort(Comparator.comparing(ReportTypeVO::getBudgetCategoryCode));
        this.setReportTypeBudgetLASalary(reportTypeList, reportTypeVOList);
    }

    protected ReportTypeVO getReportTypeVOForBudgetLASalaryForRateBase(BudgetLineItem budgetLineItem, BudgetRateAndBase budgetRateAndBase) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setCostElementDesc(budgetLineItem.getCostElementBO().getDescription());
        Date startDate = budgetRateAndBase.getStartDate();
        Date endDate = budgetRateAndBase.getEndDate();
        reportTypeVO.setStartDate(startDate);
        reportTypeVO.setEndDate(endDate);
        reportTypeVO.setBudgetCategoryDesc(this.getBudgetCategoryDescForSalarySummary(budgetLineItem, budgetLineItem, budgetRateAndBase));
        reportTypeVO.setBudgetCategoryCode(this.getBudgetCategoryCodeFroBudgetSalarySummary(budgetRateAndBase, budgetLineItem));
        reportTypeVO.setSalaryRequested(budgetRateAndBase.getCalculatedCost());
        reportTypeVO.setFringe(this.getFringeForLASalaryForRateAndBase(budgetLineItem, startDate, endDate));
        reportTypeVO.setCostSharingAmount(budgetRateAndBase.getCalculatedCostSharing());
        reportTypeVO.setCalculatedCost(this.getFringeCostSharingLASalaryRateAndBase(budgetLineItem, startDate, endDate));
        reportTypeVO.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
        return reportTypeVO;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected String getLiVacOnLaRateTypeCode() {
        String liVacOnLaRateTypeCode = DEFAULT_RATE_TYPE_CODE_FOR_LI;
        HashMap<String, String> liVacOnLaRateTypeCodeMap = new HashMap<String, String>();
        liVacOnLaRateTypeCodeMap.put(RATE_CLASS_TYPE, RateClassType.EMPLOYEE_BENEFITS.getRateClassType());
        liVacOnLaRateTypeCodeMap.put(DEPENDENT_RATE_CLASS_TYPE, RateClassType.LA_SALARIES.getRateClassType());
        ValidCalcType validCalcType = (ValidCalcType)this.businessObjectService.findByPrimaryKey(ValidCalcType.class, liVacOnLaRateTypeCodeMap);
        if (validCalcType != null) {
            liVacOnLaRateTypeCode = validCalcType.getRateTypeCode();
        }
        return liVacOnLaRateTypeCode;
    }

    private String getLiEbOnLaRateTypeCode() {
        String liEbOnLaRateTypeCode = DEFAULT_RATE_TYPE_CODE_FOR_LI;
        HashMap<String, String> liVacOnLaRateTypeCodeMap = new HashMap<String, String>();
        liVacOnLaRateTypeCodeMap.put(RATE_CLASS_TYPE, RateClassType.VACATION.getRateClassType());
        liVacOnLaRateTypeCodeMap.put(DEPENDENT_RATE_CLASS_TYPE, RateClassType.LA_SALARIES.getRateClassType());
        ValidCalcType validCalcType = (ValidCalcType)this.businessObjectService.findByPrimaryKey(ValidCalcType.class, liVacOnLaRateTypeCodeMap);
        if (validCalcType != null) {
            liEbOnLaRateTypeCode = validCalcType.getRateTypeCode();
        }
        return liEbOnLaRateTypeCode;
    }

    protected String getRateTypeDesc(String rateClassCode, String rateTypeCode) {
        HashMap<String, String> rateTypeCodeMap = new HashMap<String, String>();
        rateTypeCodeMap.put(RATE_TYPE_CODE, rateTypeCode);
        rateTypeCodeMap.put(RATE_CLASS_CODE, rateClassCode);
        RateType rateType = (RateType)this.businessObjectService.findByPrimaryKey(RateType.class, rateTypeCodeMap);
        return rateType.getDescription();
    }

    private void addReportTypeToGroupType(GroupsType groupsType, ReportType reportType) {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        reportTypeList.add(reportType);
        groupsType.setDetailsArray(reportTypeList.toArray(new ReportType[0]));
    }

    protected GroupsType[] getGroupsType(List<ReportType> reportTypeList) {
        ArrayList<GroupsType> groupTypeList = new ArrayList<GroupsType>();
        for (ReportType reportType : reportTypeList) {
            GroupsType groupsType = (GroupsType)GroupsType.Factory.newInstance();
            this.addReportTypeToGroupType(groupsType, reportType);
            groupTypeList.add(groupsType);
        }
        return groupTypeList.toArray(new GroupsType[0]);
    }

    protected GroupsType[] getGroupsType(List<ReportType> reportTypeList, String[] groupBy) {
        GroupsType groupsType = null;
        Object lastGroup = EMPTY_STRING;
        ArrayList<ReportType> reportTypeListForGroup = null;
        ArrayList<GroupsType> groupTypeList = new ArrayList<GroupsType>();
        for (ReportType reportType : reportTypeList) {
            Object presentGroup = EMPTY_STRING;
            for (String s : groupBy) {
                presentGroup = (String)presentGroup + String.valueOf(this.getFieldValue(s, reportType));
            }
            if (!((String)presentGroup).equals(lastGroup)) {
                groupsType = (GroupsType)GroupsType.Factory.newInstance();
                reportTypeListForGroup = new ArrayList<ReportType>();
                Object fieldValue = this.getFieldValue(groupBy[0], reportType);
                if (fieldValue != null) {
                    groupsType.setDescription(this.getFieldValue(groupBy[0], reportType).toString());
                }
                groupTypeList.add(groupsType);
                lastGroup = presentGroup;
            }
            reportTypeListForGroup.add(reportType);
            groupsType.setDetailsArray(reportTypeListForGroup.toArray(new ReportType[0]));
        }
        return groupTypeList.toArray(new GroupsType[0]);
    }

    private Object getFieldValue(String fieldName, ReportType baseBean) {
        Class<?> dataClass = baseBean.getClass();
        Object value = null;
        try {
            StringBuilder methodName = new StringBuilder(GET_METHOD_PREFIX);
            methodName.append(String.valueOf(fieldName.charAt(0)).toUpperCase()).append(fieldName.substring(1));
            Method method = dataClass.getMethod(methodName.toString(), null);
            value = method.invoke((Object)baseBean, (Object[])null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOG.error("Method not Found " + String.valueOf(noSuchMethodException));
        }
        catch (InvocationTargetException invocationTargetException) {
            LOG.error("Error while Invoking the Method " + String.valueOf(invocationTargetException));
        }
        catch (IllegalAccessException illegalAccessException) {
            LOG.error("Illegal Access Exception" + String.valueOf(illegalAccessException));
        }
        return value;
    }

    protected SubReportType getBudgetIndirectCostsForReport() {
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        ScaleTwoDecimal calculatedCostForOn = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal calculatedCostForOff = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal costSharingAmountForOn = ScaleTwoDecimal.ZERO;
        ScaleTwoDecimal costSharingAmountForOff = ScaleTwoDecimal.ZERO;
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            ScaleTwoDecimal totalCostSharingAmount = this.getTotalCostSharingAmountByRateClassTypeFromLineItem(budgetLineItem, RateClassType.OVERHEAD.getRateClassType());
            ScaleTwoDecimal totalCalculatedCost = this.getTotalCalculatedCostByRateClassTypeFromLineItem(RateClassType.OVERHEAD.getRateClassType(), budgetLineItem);
            if (budgetLineItem.getOnOffCampusFlag().booleanValue()) {
                calculatedCostForOn = (ScaleTwoDecimal)calculatedCostForOn.add((AbstractDecimal)totalCalculatedCost);
                costSharingAmountForOn = (ScaleTwoDecimal)costSharingAmountForOn.add((AbstractDecimal)totalCostSharingAmount);
                continue;
            }
            calculatedCostForOff = (ScaleTwoDecimal)calculatedCostForOff.add((AbstractDecimal)totalCalculatedCost);
            costSharingAmountForOff = (ScaleTwoDecimal)costSharingAmountForOff.add((AbstractDecimal)totalCostSharingAmount);
        }
        if (!calculatedCostForOn.equals((Object)ScaleTwoDecimal.ZERO) || !costSharingAmountForOn.equals((Object)ScaleTwoDecimal.ZERO)) {
            ReportType reportTypeForOn = this.getReportTypeForBudgetIndirectCostsForReport(Boolean.TRUE, calculatedCostForOn, costSharingAmountForOn);
            reportTypeList.add(reportTypeForOn);
        }
        if (!calculatedCostForOff.equals((Object)ScaleTwoDecimal.ZERO) || !costSharingAmountForOff.equals((Object)ScaleTwoDecimal.ZERO)) {
            ReportType reportTypeForOff = this.getReportTypeForBudgetIndirectCostsForReport(Boolean.FALSE, calculatedCostForOff, costSharingAmountForOff);
            reportTypeList.add(reportTypeForOff);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    protected ReportPageType.CalculationMethodology getCalculationMethodology() {
        ReportPageType.CalculationMethodology calculationMethodology = (ReportPageType.CalculationMethodology)ReportPageType.CalculationMethodology.Factory.newInstance();
        SubReportType subReportType = this.getBudgetOHExclusions();
        calculationMethodology.setBudgetOHExclusions(subReportType);
        subReportType = this.getBudgetLAExclusions();
        calculationMethodology.setBudgetLAExclusions(subReportType);
        subReportType = this.getBudgetOHRateBaseForPeriod();
        calculationMethodology.setBudgetOHRateBaseForPeriod(subReportType);
        subReportType = this.getBudgetEBRateBaseForPeriod();
        calculationMethodology.setBudgetEBRateBaseForPeriod(subReportType);
        subReportType = this.getBudgetLARateBaseForPeriod();
        calculationMethodology.setBudgetLARateBaseForPeriod(subReportType);
        subReportType = this.getBudgetVacRateBaseForPeriod();
        calculationMethodology.setBudgetVacRateBaseForPeriod(subReportType);
        subReportType = this.getBudgetOtherRateBaseForPeriod();
        calculationMethodology.setBudgetOtherRateBaseForPeriod(subReportType);
        return calculationMethodology;
    }

    protected boolean budgetHasLineItemsWithLaRates() {
        return this.budget.getBudgetPeriods().stream().flatMap(budgetPeriod1 -> budgetPeriod1.getBudgetLineItems().stream()).flatMap(budgetLineItem -> budgetLineItem.getBudgetRateAndBaseList().stream()).anyMatch(budgetRateAndBase -> {
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            return budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.LAB_ALLOCATION.getRateClassType()) || budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.LA_SALARIES.getRateClassType());
        });
    }

    private SubReportType getBudgetOHExclusions() {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        if (this.budgetHasLineItemsWithLaRates()) {
            int sortId = 1;
            String categoryDesc = ALLOCATED_ADMINISTRATIVE_SUPPORT;
            ScaleTwoDecimal calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId1();
            ReportType reportTypeForSortId1 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId1);
            sortId = 2;
            categoryDesc = EMPLOYEE_BENEFITS_ON_ALLOCATED_ADMINISTRATIVE_SUPPORT;
            calculatedCost = this.getCalculatedCostForBudgetOHExclusionsSortId2();
            ReportType reportTypeForSortId2 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId2);
            sortId = 3;
            this.setReportTypeOHExclusionForSortId(reportTypeList, sortId);
            sortId = 4;
            categoryDesc = ALLOCATED_LAB_EXPENSE;
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId4();
            ReportType reportTypeForSortId4 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            if (calculatedCost.doubleValue() > 0.0) {
                reportTypeList.add(reportTypeForSortId4);
            }
        } else {
            int sortId = 1;
            this.setReportTypeOHExclusionForSortId(reportTypeList, sortId);
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private SubReportType getBudgetLAExclusions() {
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>();
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        if (this.budgetHasLineItemsWithLaRates()) {
            int sortId = 1;
            String categoryDesc = ALLOCATED_ADMINISTRATIVE_SUPPORT;
            ScaleTwoDecimal calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId1();
            ReportType reportTypeForSortId1 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId1);
            sortId = 2;
            categoryDesc = TOTAL_EMPLOYEE_BENEFITS;
            calculatedCost = this.getCalculatedCostForBudgetLAExclusionsSortId2();
            ReportType reportTypeForSortId2 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            reportTypeList.add(reportTypeForSortId2);
            this.setReportTypeForBudgetLAExclusionsSortId3(reportTypeList);
            sortId = 4;
            categoryDesc = ALLOCATED_LAB_EXPENSE;
            calculatedCost = this.getCalculatedCostForBudgetExclusionsSortId4();
            ReportType reportTypeForSortId4 = this.getReportTypeForExclusions(sortId, categoryDesc, calculatedCost);
            if (calculatedCost.doubleValue() > 0.0) {
                reportTypeList.add(reportTypeForSortId4);
            }
        }
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    protected void setReportTypeOHExclusionForSortId(List<ReportType> reportTypeList, int sortId) {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        this.setReportTypeVOListForOHExclusionSortId(tempReportTypeVOList);
        this.setReportTypeListOHExclusionForSortId(reportTypeList, sortId, tempReportTypeVOList);
    }

    protected void setReportTypeVOListForOHExclusionSortId(List<ReportTypeVO> tempReportTypeVOList) {
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.isLineItemTypeOverheadWithRateApplied(budgetLineItem)) continue;
            ReportTypeVO reportTypeVO = new ReportTypeVO();
            reportTypeVO.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
            reportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
            reportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
            tempReportTypeVOList.add(reportTypeVO);
            reportTypeVO = new ReportTypeVO();
            BudgetRateAndBase emptyBudgetRateAndBase = new BudgetRateAndBase();
            reportTypeVO.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
            emptyBudgetRateAndBase.setCalculatedCost(ScaleTwoDecimal.ZERO);
            reportTypeVO.setCostElementDesc(EMPLOYEE_BENEFITS_ON_PERSONNEL + this.getCostElementDescription(budgetLineItem));
            BudgetRateAndBase employeeBenefitsRateAndBase = budgetLineItem.getBudgetRateAndBaseList().stream().filter(budgetRateAndBase -> this.isRateAndBaseOfRateClassTypeEB((AbstractBudgetRateAndBase)budgetRateAndBase) && !this.isRateAndBaseEBonLA((AbstractBudgetRateAndBase)budgetRateAndBase)).findFirst().orElse(emptyBudgetRateAndBase);
            BudgetRateAndBase vacationBenefitsRateAndBase = budgetLineItem.getBudgetRateAndBaseList().stream().filter(budgetRateAndBase -> this.isRateAndBaseOfRateClassTypeVacation((AbstractBudgetRateAndBase)budgetRateAndBase) && !this.isRateAndBaseVAonLA((AbstractBudgetRateAndBase)budgetRateAndBase)).findFirst().orElse(emptyBudgetRateAndBase);
            reportTypeVO.setCalculatedCost((ScaleTwoDecimal)employeeBenefitsRateAndBase.getCalculatedCost().add((AbstractDecimal)vacationBenefitsRateAndBase.getCalculatedCost()));
            if (!reportTypeVO.getCalculatedCost().isNonZero()) continue;
            tempReportTypeVOList.add(reportTypeVO);
        }
    }

    protected void setReportTypeListOHExclusionForSortId(List<ReportType> reportTypeList, int sortId, List<ReportTypeVO> tempReportTypeVOList) {
        LinkedHashMap<String, ReportTypeVO> reportTypeMap = new LinkedHashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String budgetOHExclusionKey = reportTypeVO.getCostElementDesc();
            ScaleTwoDecimal calculatedCost = reportTypeVO.getCalculatedCost();
            if (reportTypeMap.containsKey(budgetOHExclusionKey)) {
                ReportTypeVO reportTypeVO1 = (ReportTypeVO)reportTypeMap.get(budgetOHExclusionKey);
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)reportTypeVO1.getCalculatedCost());
                reportTypeVO1.setCalculatedCost(calculatedCost);
                reportTypeMap.put(budgetOHExclusionKey, reportTypeVO1);
                continue;
            }
            reportTypeMap.put(budgetOHExclusionKey, reportTypeVO);
        }
        for (String budgetOHExclusionKey : reportTypeMap.keySet()) {
            ReportTypeVO reportTypeVO1 = (ReportTypeVO)reportTypeMap.get(budgetOHExclusionKey);
            ReportType reportType = this.getReportType();
            reportType.setSortId(sortId);
            reportType.setCostElementDescription(budgetOHExclusionKey);
            reportType.setCalculatedCost(reportTypeVO1.getCalculatedCost().doubleValue());
            reportTypeList.add(reportType);
        }
    }

    protected void setReportTypeForBudgetLAExclusionsSortId3(List<ReportType> reportTypeList) {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        this.setReportTypeVOListForLAExclusionSortId3(tempReportTypeVOList);
        this.setReportTypeList(reportTypeList, tempReportTypeVOList);
    }

    protected void setReportTypeVOListForLAExclusionSortId3(List<ReportTypeVO> tempReportTypeVOList) {
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            if (this.isBudgetCategoryPersonnel(budgetLineItem) || this.checkLineItemNumberAvailableForLAExclusion(budgetLineItem)) continue;
            ReportTypeVO tempReportTypeVO = new ReportTypeVO();
            tempReportTypeVO.setCostElementDesc(this.getCostElementDescription(budgetLineItem));
            tempReportTypeVO.setCalculatedCost(budgetLineItem.getLineItemCost());
            tempReportTypeVO.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
            tempReportTypeVOList.add(tempReportTypeVO);
        }
    }

    protected void setReportTypeList(List<ReportType> reportTypeList, List<ReportTypeVO> tempReportTypeVOList) {
        HashMap<String, ReportTypeVO> reportTypeMap = new HashMap<String, ReportTypeVO>();
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String budgetLAExclusionsKey = reportTypeVO.getCostElementDesc();
            if (reportTypeMap.containsKey(budgetLAExclusionsKey)) continue;
            ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
            for (ReportTypeVO reportTypeVO1 : tempReportTypeVOList) {
                String budgetLAExclusionTempKey = reportTypeVO1.getCostElementDesc();
                if (!budgetLAExclusionTempKey.equals(budgetLAExclusionsKey)) continue;
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)reportTypeVO1.getCalculatedCost());
            }
            reportTypeMap.put(budgetLAExclusionsKey, reportTypeVO);
            ReportType reportType = this.getReportType();
            reportType.setSortId(3);
            reportType.setCostElementDescription(reportTypeVO.getCostElementDesc());
            reportType.setCalculatedCost(calculatedCost.doubleValue());
            reportTypeList.add(reportType);
        }
    }

    private boolean checkLineItemNumberAvailableForLAExclusion(BudgetLineItem budgetLineItem) {
        boolean available = false;
        Integer lineItemNumber = budgetLineItem.getLineItemNumber();
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            budgetLineItemCalcAmount.refreshReferenceObject(RATE_CLASS);
            boolean lineItemCalAmountLabAllocation = this.isLineItemCalAmountOfRateClassTypeLabAllocation(budgetLineItemCalcAmount);
            boolean lineItemCalAmountLAWithEBVA = this.isLineItemCalAmountOfRateClassTypeLAWithEBVA(budgetLineItemCalcAmount);
            if (!budgetLineItemCalcAmount.getApplyRateFlag().booleanValue() || !lineItemCalAmountLabAllocation && !lineItemCalAmountLAWithEBVA || !budgetLineItemCalcAmount.getLineItemNumber().equals(lineItemNumber)) continue;
            available = true;
        }
        return available;
    }

    private boolean isLineItemTypeOverheadWithRateApplied(BudgetLineItem budgetLineItem) {
        Integer lineItemNumber = budgetLineItem.getLineItemNumber();
        for (BudgetLineItemCalculatedAmount budgetLineItemCalcAmount : budgetLineItem.getBudgetLineItemCalculatedAmounts()) {
            budgetLineItemCalcAmount.refreshReferenceObject(RATE_CLASS);
            if (!budgetLineItemCalcAmount.getApplyRateFlag().booleanValue() || !this.isLineItemCalAmountOfRateClassTypeOverhead(budgetLineItemCalcAmount) || !budgetLineItemCalcAmount.getLineItemNumber().equals(lineItemNumber)) continue;
            return true;
        }
        return false;
    }

    protected String getCostElementDescription(BudgetLineItem budgetLineItem) {
        String lineItemDescription = budgetLineItem.getLineItemDescription() == null ? EMPTY_STRING : STRING_SEPRATOR.concat(budgetLineItem.getLineItemDescription());
        return budgetLineItem.getCostElementBO().getDescription().concat(lineItemDescription);
    }

    private SubReportType getBudgetOHRateBaseForPeriod() {
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        List<ReportType> reportTypeList = this.getReportTypeListForBudgetOHRateAndBase();
        subReportType.setGroupArray(this.getGroupsType(reportTypeList));
        return subReportType;
    }

    private SubReportType getBudgetEBRateBaseForPeriod() {
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        List<ReportType> reportTypeList = this.getReportTypeListForBudgetEBRateAndBase();
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateType));
        return subReportType;
    }

    protected List<ReportType> getReportTypeListForBudgetEBRateAndBase() {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetEBRateAndBase(tempReportTypeVOList, budgetLineItem);
            if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetEBRateAndBase(tempReportTypeVOList, budgetLineItem);
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    private SubReportType getBudgetLARateBaseForPeriod() {
        List<ReportType> reportTypeList = this.getReportTypeListForBudgetLARateAndBase();
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateClassRateType));
        return subReportType;
    }

    protected List<ReportType> getReportTypeListForBudgetLARateAndBase() {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetLARateAndBase(tempReportTypeVOList, budgetLineItem);
            if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetLARateAndBase(tempReportTypeVOList, budgetLineItem);
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    private SubReportType getBudgetVacRateBaseForPeriod() {
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        List<ReportType> reportTypeList = this.getReportTypeListForBudgetVACRateAndBase();
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateType));
        return subReportType;
    }

    protected List<ReportType> getReportTypeListForBudgetVACRateAndBase() {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetVacRateAndBase(tempReportTypeVOList, budgetLineItem);
            if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetVacRateAndBase(tempReportTypeVOList, budgetLineItem);
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    protected void setReportTypeMapFromReportTypeVOList(List<ReportTypeVO> tempReportTypeVOList, Map<String, ReportType> reportTypeMap) {
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String reportTypeKey = this.getKeyForRateBase(reportTypeVO);
            if (reportTypeMap.containsKey(reportTypeKey)) continue;
            Date startDate = reportTypeVO.getStartDate();
            Date endDate = reportTypeVO.getEndDate();
            ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal salaryRequested = ScaleTwoDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : tempReportTypeVOList) {
                String reportTypeTempKey = this.getKeyForRateBase(tempReportTypeVO);
                if (!reportTypeTempKey.equals(reportTypeKey)) continue;
                salaryRequested = (ScaleTwoDecimal)salaryRequested.add((AbstractDecimal)tempReportTypeVO.getSalaryRequested());
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)tempReportTypeVO.getCalculatedCost());
                if (startDate.after(tempReportTypeVO.getStartDate())) {
                    startDate = tempReportTypeVO.getStartDate();
                }
                if (!endDate.before(tempReportTypeVO.getEndDate())) continue;
                endDate = tempReportTypeVO.getEndDate();
            }
            ReportType reportType = this.getReportTypeForRateAndBase(startDate, endDate, calculatedCost, salaryRequested, reportTypeVO);
            reportTypeMap.put(reportTypeKey, reportType);
        }
    }

    private ReportType getReportTypeForRateAndBase(Date startDate, Date endDate, ScaleTwoDecimal calculatedCost, ScaleTwoDecimal salaryRequested, ReportTypeVO reportTypeVO) {
        ReportType reportType = this.getReportType();
        reportType.setSalaryRequested(salaryRequested.doubleValue());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        reportType.setStartDate(DateFormatUtils.format((java.util.Date)startDate, (String)DATE_FORMAT));
        reportType.setEndDate(DateFormatUtils.format((java.util.Date)endDate, (String)DATE_FORMAT));
        reportType.setAppliedRate(reportTypeVO.getAppliedRate().doubleValue());
        reportType.setRateClassDesc(reportTypeVO.getRateClassDesc());
        reportType.setRateTypeDesc(reportTypeVO.getRateTypeDesc());
        reportType.setOnOffCampus(reportTypeVO.getOnOffCampusFlag());
        return reportType;
    }

    private SubReportType getBudgetOtherRateBaseForPeriod() {
        SubReportType subReportType = (SubReportType)SubReportType.Factory.newInstance();
        List<ReportType> reportTypeList = this.getReportTypeListForBudgetOtherRateAndBase();
        subReportType.setGroupArray(this.getGroupsType(reportTypeList, this.rateClassRateType));
        return subReportType;
    }

    protected List<ReportType> getReportTypeListForBudgetOtherRateAndBase() {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetOtherRateAndBase(tempReportTypeVOList, budgetLineItem);
            if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetOtherRateAndBase(tempReportTypeVOList, budgetLineItem);
        }
        this.setReportTypeMapFromReportTypeVOList(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    protected List<ReportType> getReportTypeListForBudgetOHRateAndBase() {
        ArrayList<ReportTypeVO> tempReportTypeVOList = new ArrayList<ReportTypeVO>();
        HashMap<String, ReportType> reportTypeMap = new HashMap<String, ReportType>();
        for (BudgetLineItem budgetLineItem : this.budgetPeriod.getBudgetLineItems()) {
            this.setBudgetPersRateAndBaseListForBudgetOHRateAndBase(tempReportTypeVOList, budgetLineItem);
            if (this.isBudgetCategoryPersonnel(budgetLineItem)) continue;
            this.setBudgetRateAndBaseListForBudgetOHRateAndBase(tempReportTypeVOList, budgetLineItem);
        }
        this.setReportTypeMapForBudgetOHRateAndBase(tempReportTypeVOList, reportTypeMap);
        ArrayList<ReportType> reportTypeList = new ArrayList<ReportType>(reportTypeMap.values());
        return reportTypeList;
    }

    protected void setReportTypeMapForBudgetOHRateAndBase(List<ReportTypeVO> tempReportTypeVOList, Map<String, ReportType> reportTypeMap) {
        for (ReportTypeVO reportTypeVO : tempReportTypeVOList) {
            String budgetOHRateBaseKey = this.getKeyForBudgetOHRateBase(reportTypeVO);
            if (reportTypeMap.containsKey(budgetOHRateBaseKey)) continue;
            Date startDate = reportTypeVO.getStartDate();
            Date endDate = reportTypeVO.getEndDate();
            ScaleTwoDecimal calculatedCost = ScaleTwoDecimal.ZERO;
            ScaleTwoDecimal salaryRequested = ScaleTwoDecimal.ZERO;
            for (ReportTypeVO tempReportTypeVO : tempReportTypeVOList) {
                String budgetOHRateBaseTempKey = this.getKeyForBudgetOHRateBase(tempReportTypeVO);
                if (!budgetOHRateBaseTempKey.equals(budgetOHRateBaseKey)) continue;
                salaryRequested = (ScaleTwoDecimal)salaryRequested.add((AbstractDecimal)(tempReportTypeVO.getSalaryRequested() == null ? ScaleTwoDecimal.ZERO : tempReportTypeVO.getSalaryRequested()));
                calculatedCost = (ScaleTwoDecimal)calculatedCost.add((AbstractDecimal)tempReportTypeVO.getCalculatedCost());
                if (startDate.after(tempReportTypeVO.getStartDate())) {
                    startDate = tempReportTypeVO.getStartDate();
                }
                if (!endDate.before(tempReportTypeVO.getEndDate())) continue;
                endDate = tempReportTypeVO.getEndDate();
            }
            ReportType reportType = this.getReportTypeForBudgetOHRateAndBase(startDate, endDate, calculatedCost, salaryRequested, reportTypeVO);
            reportTypeMap.put(budgetOHRateBaseKey, reportType);
        }
    }

    private ReportType getReportTypeForBudgetOHRateAndBase(Date startDate, Date endDate, ScaleTwoDecimal calculatedCost, ScaleTwoDecimal salaryRequested, ReportTypeVO reportTypeVO) {
        ReportType reportType = this.getReportType();
        reportType.setSalaryRequested(salaryRequested.doubleValue());
        reportType.setCalculatedCost(calculatedCost.doubleValue());
        reportType.setStartDate(DateFormatUtils.format((java.util.Date)startDate, (String)DATE_FORMAT));
        reportType.setEndDate(DateFormatUtils.format((java.util.Date)endDate, (String)DATE_FORMAT));
        reportType.setAppliedRate(reportTypeVO.getAppliedRate().doubleValue());
        reportType.setRateClassDesc(reportTypeVO.getRateClassDesc());
        reportType.setOnOffCampus(reportTypeVO.getOnOffCampusFlag());
        return reportType;
    }

    public ReportType getReportType() {
        return (ReportType)ReportType.Factory.newInstance();
    }

    private String getKeyForRateBase(ReportTypeVO reportTypeVO) {
        StringBuilder key = new StringBuilder();
        key.append(reportTypeVO.getRateClassDesc()).append(reportTypeVO.getRateTypeDesc()).append(reportTypeVO.getOnOffCampusFlag().toString()).append(reportTypeVO.getAppliedRate().toString());
        return key.toString();
    }

    private String getKeyForBudgetOHRateBase(ReportTypeVO reportTypeVO) {
        StringBuilder key = new StringBuilder();
        key.append(reportTypeVO.getOnOffCampusFlag().toString()).append(reportTypeVO.getAppliedRate().toString()).append(reportTypeVO.getRateClassDesc());
        return key.toString();
    }

    protected void setBudgetRateAndBaseListForBudgetOtherRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        HashMap<String, BudgetRateAndBase> laRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.OTHER.getRateClassType()) || laRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseList(budgetLineItem, budgetRateAndBase);
            reportTypeVOList.add(reportTypeVO);
            laRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    protected void setBudgetRateAndBaseListForBudgetVacRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        HashMap<String, BudgetRateAndBase> vacBudgetRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.VACATION.getRateClassType()) || budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(this.getLiVacOnLaRateTypeCode()) || vacBudgetRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseList(budgetLineItem, budgetRateAndBase);
            reportTypeVOList.add(reportTypeVO);
            vacBudgetRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    protected void setBudgetRateAndBaseListForBudgetLARateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        HashMap<String, BudgetRateAndBase> laRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.LAB_ALLOCATION.getRateClassType()) && !budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.LA_SALARIES.getRateClassType()) || laRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseList(budgetLineItem, budgetRateAndBase);
            reportTypeVOList.add(reportTypeVO);
            laRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    private String getBudgetRateAndBaseKey(BudgetRateAndBase budgetRateAndBase) {
        return budgetRateAndBase.getStartDate().toString() + budgetRateAndBase.getEndDate().toString() + budgetRateAndBase.getRateTypeCode() + budgetRateAndBase.getRateClassCode();
    }

    protected void setBudgetRateAndBaseListForBudgetEBRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        HashMap<String, BudgetRateAndBase> ebBudgetRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.EMPLOYEE_BENEFITS.getRateClassType()) || budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(this.getLiEbOnLaRateTypeCode()) || ebBudgetRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseList(budgetLineItem, budgetRateAndBase);
            reportTypeVOList.add(reportTypeVO);
            ebBudgetRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    protected void setBudgetRateAndBaseListForBudgetOHRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        HashMap<String, BudgetRateAndBase> ohBudgetRateBaseMap = new HashMap<String, BudgetRateAndBase>();
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            String budgetRateBaseKey;
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.OVERHEAD.getRateClassType()) || ohBudgetRateBaseMap.containsKey(budgetRateBaseKey = this.getBudgetRateAndBaseKey(budgetRateAndBase))) continue;
            ReportTypeVO reportTypeVO = this.getBudgetRateAndBaseListForBudgetOHRateBase(budgetRateAndBase, budgetLineItem);
            reportTypeVOList.add(reportTypeVO);
            ohBudgetRateBaseMap.put(budgetRateBaseKey, budgetRateAndBase);
        }
    }

    private ReportTypeVO getBudgetRateAndBaseList(BudgetLineItem budgetLineItem, BudgetRateAndBase budgetRateAndBase) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setRateClassDesc(budgetRateAndBase.getRateClass().getDescription());
        reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetRateAndBase.getRateClassCode(), budgetRateAndBase.getRateTypeCode()));
        reportTypeVO.setStartDate(budgetRateAndBase.getStartDate());
        reportTypeVO.setEndDate(budgetRateAndBase.getEndDate());
        reportTypeVO.setAppliedRate(budgetRateAndBase.getAppliedRate());
        reportTypeVO.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
        reportTypeVO.setSalaryRequested(ScaleTwoDecimal.ZERO);
        if (this.rateIsApplied(budgetLineItem.getBudgetLineItemCalculatedAmounts(), budgetRateAndBase.getRateClassCode(), budgetRateAndBase.getRateTypeCode())) {
            reportTypeVO.setSalaryRequested(budgetRateAndBase.getBaseCost());
        }
        reportTypeVO.setCalculatedCost(budgetRateAndBase.getCalculatedCost());
        reportTypeVO.setOnOffCampusFlag(budgetRateAndBase.getOnOffCampusFlag());
        return reportTypeVO;
    }

    protected ReportTypeVO getBudgetRateAndBaseListForBudgetOHRateBase(BudgetRateAndBase budgetRateAndBase, BudgetLineItem budgetLineItem) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setRateClassDesc(budgetRateAndBase.getRateClass().getDescription());
        reportTypeVO.setStartDate(budgetRateAndBase.getStartDate());
        reportTypeVO.setEndDate(budgetRateAndBase.getEndDate());
        reportTypeVO.setAppliedRate(budgetRateAndBase.getAppliedRate());
        reportTypeVO.setCalculatedCost(budgetRateAndBase.getCalculatedCost());
        reportTypeVO.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
        reportTypeVO.setSalaryRequested(ScaleTwoDecimal.ZERO);
        if (this.rateIsApplied(budgetLineItem.getBudgetLineItemCalculatedAmounts(), budgetRateAndBase.getRateClassCode(), budgetRateAndBase.getRateTypeCode())) {
            reportTypeVO.setSalaryRequested(budgetRateAndBase.getBaseCost());
        }
        reportTypeVO.setOnOffCampusFlag(budgetRateAndBase.getOnOffCampusFlag());
        return reportTypeVO;
    }

    protected boolean rateIsApplied(List<BudgetLineItemCalculatedAmount> calculatedAmounts, String rateClassCode, String rateTypeCode) {
        BudgetLineItemCalculatedAmount lineItemCalculatedAmount = calculatedAmounts.stream().filter(calculatedAmount -> rateTypeCode.equalsIgnoreCase(calculatedAmount.getRateTypeCode()) && rateClassCode.equalsIgnoreCase(calculatedAmount.getRateClassCode())).findFirst().orElse(null);
        return lineItemCalculatedAmount == null ? Boolean.FALSE : lineItemCalculatedAmount.getApplyRateFlag();
    }

    protected void setBudgetPersRateAndBaseListForBudgetOtherRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        if (!this.isBudgetCategoryPersonnel(budgetLineItem)) {
            return;
        }
        for (AbstractBudgetRateAndBase budgetPersRateAndBase : this.getBudgetLineItemRateAndBaseEntries(budgetLineItem)) {
            budgetPersRateAndBase.refreshNonUpdateableReferences();
            if (budgetPersRateAndBase.getRateClass() == null || !RateClassType.OTHER.getRateClassType().equals(budgetPersRateAndBase.getRateClass().getRateClassTypeCode())) continue;
            ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetLineItem, budgetPersRateAndBase);
            reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetPersRateAndBase.getRateClassCode(), budgetPersRateAndBase.getRateTypeCode()));
            reportTypeVOList.add(reportTypeVO);
        }
    }

    protected void setBudgetPersRateAndBaseListForBudgetVacRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        if (!this.isBudgetCategoryPersonnel(budgetLineItem)) {
            return;
        }
        for (AbstractBudgetRateAndBase budgetPersRateAndBase : this.getBudgetLineItemRateAndBaseEntries(budgetLineItem)) {
            budgetPersRateAndBase.refreshNonUpdateableReferences();
            if (budgetPersRateAndBase.getRateClass() == null || budgetPersRateAndBase.getRateClass().getRateClassTypeCode() == null || !budgetPersRateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.VACATION.getRateClassType())) continue;
            ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetLineItem, budgetPersRateAndBase);
            reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetPersRateAndBase.getRateClassCode(), budgetPersRateAndBase.getRateTypeCode()));
            reportTypeVOList.add(reportTypeVO);
        }
    }

    protected void setBudgetPersRateAndBaseListForBudgetLARateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        if (!this.isBudgetCategoryPersonnel(budgetLineItem)) {
            return;
        }
        String LAB_ALLOCATION_RATE_CLASS = RateClassType.LAB_ALLOCATION.getRateClassType();
        String LA_SALARIES_RATE_CLASS = RateClassType.LA_SALARIES.getRateClassType();
        for (AbstractBudgetRateAndBase budgetPersRateAndBase : this.getBudgetLineItemRateAndBaseEntries(budgetLineItem)) {
            budgetPersRateAndBase.refreshNonUpdateableReferences();
            if (budgetPersRateAndBase.getRateClass() == null || !LAB_ALLOCATION_RATE_CLASS.equals(budgetPersRateAndBase.getRateClass().getRateClassTypeCode()) && !LA_SALARIES_RATE_CLASS.equals(budgetPersRateAndBase.getRateClass().getRateClassTypeCode())) continue;
            ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetLineItem, budgetPersRateAndBase);
            reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetPersRateAndBase.getRateClassCode(), budgetPersRateAndBase.getRateTypeCode()));
            reportTypeVOList.add(reportTypeVO);
        }
    }

    protected void setBudgetPersRateAndBaseListForBudgetEBRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        if (!this.isBudgetCategoryPersonnel(budgetLineItem)) {
            return;
        }
        String EB_RATE_CLASS_TYPE = RateClassType.EMPLOYEE_BENEFITS.getRateClassType();
        for (AbstractBudgetRateAndBase budgetPersRateAndBase : this.getBudgetLineItemRateAndBaseEntries(budgetLineItem)) {
            budgetPersRateAndBase.refreshNonUpdateableReferences();
            if (budgetPersRateAndBase.getRateClass() == null || budgetPersRateAndBase.getRateClass().getRateClassTypeCode() == null || !budgetPersRateAndBase.getRateClass().getRateClassTypeCode().equals(EB_RATE_CLASS_TYPE)) continue;
            ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetLineItem, budgetPersRateAndBase);
            reportTypeVO.setRateTypeDesc(this.getRateTypeDesc(budgetPersRateAndBase.getRateClassCode(), budgetPersRateAndBase.getRateTypeCode()));
            reportTypeVOList.add(reportTypeVO);
        }
    }

    protected void setBudgetPersRateAndBaseListForBudgetOHRateAndBase(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem) {
        if (!this.isBudgetCategoryPersonnel(budgetLineItem)) {
            return;
        }
        String OVERHEAD_RATE_CLASS_TYPE = RateClassType.OVERHEAD.getRateClassType();
        for (AbstractBudgetRateAndBase budgetPersRateAndBase : this.getBudgetLineItemRateAndBaseEntries(budgetLineItem)) {
            budgetPersRateAndBase.refreshNonUpdateableReferences();
            if (budgetPersRateAndBase.getRateClass() == null || budgetPersRateAndBase.getRateClass().getRateClassTypeCode() == null || !budgetPersRateAndBase.getRateClass().getRateClassTypeCode().equals(OVERHEAD_RATE_CLASS_TYPE)) continue;
            ReportTypeVO reportTypeVO = this.getReportTypeVOForBudgetPersonnelRateAndBase(budgetLineItem, budgetPersRateAndBase);
            reportTypeVOList.add(reportTypeVO);
        }
    }

    protected List<? extends AbstractBudgetRateAndBase> getBudgetLineItemRateAndBaseEntries(BudgetLineItem lineItem) {
        if (lineItem.getBudgetPersonnelDetailsList() != null && !lineItem.getBudgetPersonnelDetailsList().isEmpty()) {
            return lineItem.getBudgetPersonnelDetailsList().stream().flatMap(details -> details.getBudgetPersonnelRateAndBaseList().stream()).collect(Collectors.toList());
        }
        return lineItem.getBudgetRateAndBaseList();
    }

    protected ReportTypeVO getReportTypeVOForBudgetPersonnelRateAndBase(BudgetLineItem budgetLineItem, AbstractBudgetRateAndBase budgetPersRateAndBase) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setRateClassDesc(budgetPersRateAndBase.getRateClass().getDescription());
        reportTypeVO.setStartDate(budgetPersRateAndBase.getStartDate());
        reportTypeVO.setEndDate(budgetPersRateAndBase.getEndDate());
        reportTypeVO.setAppliedRate(budgetPersRateAndBase.getAppliedRate());
        reportTypeVO.setCalculatedCost(budgetPersRateAndBase.getCalculatedCost());
        reportTypeVO.setBudgetLineItemId(budgetLineItem.getBudgetLineItemId());
        reportTypeVO.setSalaryRequested(ScaleTwoDecimal.ZERO);
        if (this.rateIsApplied(budgetLineItem.getBudgetLineItemCalculatedAmounts(), budgetPersRateAndBase.getRateClassCode(), budgetPersRateAndBase.getRateTypeCode())) {
            if (budgetPersRateAndBase instanceof BudgetPersonnelRateAndBase) {
                reportTypeVO.setSalaryRequested(((BudgetPersonnelRateAndBase)budgetPersRateAndBase).getSalaryRequested());
            } else {
                reportTypeVO.setSalaryRequested(((BudgetRateAndBase)budgetPersRateAndBase).getBaseCost());
            }
        }
        reportTypeVO.setOnOffCampusFlag(budgetPersRateAndBase.getOnOffCampusFlag());
        return reportTypeVO;
    }

    protected String getBudgetCategoryDescForSalarySummary(BudgetLineItem budgetLineItem, BudgetLineItemBase budgetDetails, AbstractBudgetRateAndBase budgetRateAndBase) {
        budgetLineItem.refreshReferenceObject(COST_ELEMENT_BO);
        budgetLineItem.refreshReferenceObject(BUDGET_CATEGORY);
        String category = null;
        if (budgetRateAndBase != null && this.isRateAndBaseLASalary(budgetRateAndBase)) {
            category = LAB_ALLOCATION;
        } else if (budgetLineItem.getBudgetCategory() != null) {
            category = budgetLineItem.getBudgetCategory().getDescription();
        } else if (budgetDetails.getCostElementBO() != null && budgetDetails.getCostElementBO().getBudgetCategory() != null) {
            category = budgetDetails.getCostElementBO().getBudgetCategory().getDescription();
        }
        return category;
    }

    protected ScaleTwoDecimal getFringeForLASalaryForRateAndBase(BudgetLineItem budgetLineItem, Date startDate, Date endDate) {
        ScaleTwoDecimal fringe = ScaleTwoDecimal.ZERO;
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getStartDate().equals(startDate) || !budgetRateAndBase.getEndDate().equals(endDate) || budgetRateAndBase.getCalculatedCost() == null || !this.isRateAndBaseEBonLA(budgetRateAndBase) && !this.isRateAndBaseVAonLA(budgetRateAndBase)) continue;
            fringe = (ScaleTwoDecimal)fringe.add((AbstractDecimal)budgetRateAndBase.getCalculatedCost());
        }
        return fringe;
    }

    protected ScaleTwoDecimal getFringeCostSharingLASalaryRateAndBase(BudgetLineItem budgetLineItem, Date startDate, Date endDate) {
        ScaleTwoDecimal fringeCostSharing = ScaleTwoDecimal.ZERO;
        for (BudgetRateAndBase budgetRateAndBase : budgetLineItem.getBudgetRateAndBaseList()) {
            budgetRateAndBase.refreshReferenceObject(RATE_CLASS);
            if (!budgetRateAndBase.getStartDate().equals(startDate) || !budgetRateAndBase.getEndDate().equals(endDate) || budgetRateAndBase.getCalculatedCostSharing() == null || !this.isRateAndBaseEBonLA(budgetRateAndBase) && !this.isRateAndBaseVAonLA(budgetRateAndBase)) continue;
            fringeCostSharing = (ScaleTwoDecimal)fringeCostSharing.add((AbstractDecimal)budgetRateAndBase.getCalculatedCostSharing());
        }
        return fringeCostSharing;
    }

    protected Integer getInvestigatorFlag(BudgetPersonnelDetails budgetPersonDetails) {
        Integer flag = 3;
        String personId = budgetPersonDetails.getPersonId();
        flag = this.budget.getBudgetParent().getParentInvestigatorFlag(personId, flag);
        return flag;
    }

    protected String getKeyForBudgetSalarySummary(ReportTypeVO reportTypeVO) {
        StringBuilder key = new StringBuilder();
        key.append(reportTypeVO.getStartDate().toString()).append(reportTypeVO.getEndDate().toString()).append(reportTypeVO.getPersonName()).append(reportTypeVO.getInvestigatorFlag().toString()).append(reportTypeVO.getBudgetCategoryCode()).append(reportTypeVO.getBudgetCategoryDesc()).append(reportTypeVO.getSalaryRequested()).append(reportTypeVO.getBudgetLineItemId());
        return key.toString();
    }

    protected String getPersonNameFromBudgetPersonByRateAndBase(BudgetPerson budgetPerson, BudgetPersonnelRateAndBase budgetPersRateAndBase, Integer quantity) {
        String personName = EMPTY_STRING;
        if (budgetPersRateAndBase != null && this.isRateAndBaseLASalary(budgetPersRateAndBase)) {
            personName = ALLOCATED_ADMIN_SUPPORT;
        } else if (budgetPerson != null) {
            if (budgetPerson.getPersonId() == null && budgetPerson.getRolodexId() == null) {
                StringBuilder pNmae = new StringBuilder();
                personName = pNmae.append(budgetPerson.getPersonName()).append(OPEN_BRACES).append(quantity.toString()).append(CLOSE_BRACES).toString();
            } else {
                personName = budgetPerson.getPersonName();
            }
        }
        return personName;
    }

    protected ScaleTwoDecimal getPercentEffortForBudgetPersonnelRateBase(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersDetails, BudgetPersonnelRateAndBase budgetPersRateAndBase) {
        ScaleTwoDecimal percentEffort = ScaleTwoDecimal.ZERO;
        Integer personNumber = budgetPersDetails.getPersonNumber();
        if (budgetPersRateAndBase != null && this.isRateAndBaseLASalary(budgetPersRateAndBase)) {
            percentEffort = new ScaleTwoDecimal(100);
        } else {
            for (BudgetPersonnelDetails budgetPersDetail : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (!budgetPersDetail.getPersonNumber().equals(personNumber) || budgetPersDetails.getPercentEffort() == null) continue;
                percentEffort = (ScaleTwoDecimal)percentEffort.add((AbstractDecimal)budgetPersDetail.getPercentEffort());
            }
        }
        return percentEffort;
    }

    protected ScaleTwoDecimal getPercentChargedForBudgetPersonnelRateBase(BudgetLineItem budgetLineItem, BudgetPersonnelDetails budgetPersDetails, BudgetPersonnelRateAndBase budgetPersRateAndBase) {
        ScaleTwoDecimal percentCharged = ScaleTwoDecimal.ZERO;
        Integer personNumber = budgetPersDetails.getPersonNumber();
        if (budgetPersRateAndBase != null && this.isRateAndBaseLASalary(budgetPersRateAndBase)) {
            percentCharged = new ScaleTwoDecimal(100);
        } else {
            for (BudgetPersonnelDetails budgetPersDetail : budgetLineItem.getBudgetPersonnelDetailsList()) {
                if (!budgetPersDetail.getPersonNumber().equals(personNumber) || budgetPersDetails.getPercentEffort() == null) continue;
                percentCharged = (ScaleTwoDecimal)percentCharged.add((AbstractDecimal)budgetPersDetail.getPercentCharged());
            }
        }
        return percentCharged;
    }

    protected String getBudgetCategoryCodeFroBudgetSalarySummary(AbstractBudgetRateAndBase budgetPersRateAndBase, BudgetLineItemBase budgetPersonnelDetails) {
        String categoryCode = null;
        if (budgetPersRateAndBase != null && this.isRateAndBaseLASalary(budgetPersRateAndBase)) {
            categoryCode = CATEGORY_CODE_LA_SALARY;
        } else if (budgetPersonnelDetails.getCostElementBO() != null && budgetPersonnelDetails.getCostElementBO().getBudgetCategory() != null) {
            categoryCode = budgetPersonnelDetails.getCostElementBO().getBudgetCategory().getCode();
        }
        return categoryCode;
    }

    protected boolean isBudgetCategoryPersonnel(BudgetLineItemBase budgetDetails) {
        return budgetDetails.getBudgetCategory() != null && BUDGET_CATEGORY_PERSONNEL.equals(budgetDetails.getBudgetCategory().getBudgetCategoryTypeCode());
    }

    protected boolean isRateAndBaseLASalary(AbstractBudgetRateAndBase rateAndBase) {
        rateAndBase.refreshNonUpdateableReferences();
        return rateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.LA_SALARIES.getRateClassType());
    }

    protected boolean isRateAndBaseEBonLA(AbstractBudgetRateAndBase rateAndBase) {
        ValidCalcType ebOnLaValidCalcType = this.getDependentValidRateClassTypeForLA(RateClassType.EMPLOYEE_BENEFITS.getRateClassType());
        return ebOnLaValidCalcType != null && rateAndBase.getRateClassCode().equals(ebOnLaValidCalcType.getRateClassCode()) && rateAndBase.getRateTypeCode().equals(ebOnLaValidCalcType.getRateTypeCode());
    }

    protected ValidCalcType getDependentValidRateClassTypeForLA(String rateClassType) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(RATE_CLASS_TYPE, rateClassType);
        param.put(DEPENDENT_RATE_CLASS_TYPE, RateClassType.LA_SALARIES.getRateClassType());
        List result = this.getBusinessObjectService().findMatching(ValidCalcType.class, param);
        return result.isEmpty() ? null : (ValidCalcType)result.get(0);
    }

    protected boolean isRateAndBaseVAonLA(AbstractBudgetRateAndBase rateAndBase) {
        ValidCalcType vacationOnLaValidCalcType = this.getDependentValidRateClassTypeForLA(RateClassType.VACATION.getRateClassType());
        return vacationOnLaValidCalcType != null && rateAndBase.getRateClassCode().equals(vacationOnLaValidCalcType.getRateClassCode()) && rateAndBase.getRateTypeCode().equals(vacationOnLaValidCalcType.getRateTypeCode());
    }

    protected boolean isLineItemCalAmountOfRateClassTypeLAWithEBVA(BudgetLineItemCalculatedAmount lineItemCalcAmount) {
        return lineItemCalcAmount.getRateClass().getRateClassTypeCode().equals(RateClassType.LA_SALARIES.getRateClassType());
    }

    protected boolean isLineItemCalAmountOfRateClassTypeLabAllocation(BudgetLineItemCalculatedAmount lineItemCalcAmount) {
        return lineItemCalcAmount.getRateClass().getRateClassTypeCode().equals(RateClassType.LAB_ALLOCATION.getRateClassType());
    }

    protected boolean isLineItemCalAmountOfRateClassTypeOverhead(BudgetLineItemCalculatedAmount lineItemCalcAmount) {
        return lineItemCalcAmount.getRateClass().getRateClassTypeCode().equals(RateClassType.OVERHEAD.getRateClassType());
    }

    protected boolean isRateAndBaseOfRateClassTypeLAwithEBVA(AbstractBudgetRateAndBase rateAndBase) {
        boolean status = false;
        rateAndBase.refreshNonUpdateableReferences();
        if (rateAndBase.getRateClass() != null) {
            return rateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.LA_SALARIES.getRateClassType());
        }
        return status;
    }

    protected boolean isRateAndBaseOfRateClassTypeEB(AbstractBudgetRateAndBase rateAndBase) {
        boolean status = false;
        rateAndBase.refreshNonUpdateableReferences();
        if (rateAndBase.getRateClass() != null) {
            return rateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.EMPLOYEE_BENEFITS.getRateClassType());
        }
        return status;
    }

    protected boolean isRateAndBaseOfRateClassTypeVacation(AbstractBudgetRateAndBase rateAndBase) {
        boolean status = false;
        rateAndBase.refreshNonUpdateableReferences();
        if (rateAndBase.getRateClass() != null) {
            return rateAndBase.getRateClass().getRateClassTypeCode().equals(RateClassType.VACATION.getRateClassType());
        }
        return status;
    }

    protected List<ReportTypeVO> getReportTypeVOList(BudgetPeriod budgetPeriod) {
        ArrayList<ReportTypeVO> reportTypeVOList = new ArrayList<ReportTypeVO>();
        for (BudgetLineItem budgetLineItem : budgetPeriod.getBudgetLineItems()) {
            if (!StringUtils.equals((CharSequence)budgetLineItem.getBudgetCategory().getBudgetCategoryTypeCode(), (CharSequence)BUDGET_CATEGORY_PERSONNEL)) continue;
            if (!budgetLineItem.getBudgetPersonnelDetailsList().isEmpty()) {
                for (BudgetPersonnelDetails budgetPersDetails : budgetLineItem.getBudgetPersonnelDetailsList()) {
                    this.addReportTypeVO(reportTypeVOList, budgetLineItem, budgetPersDetails, this.getRatesApplicableToVOList(budgetPersDetails.getBudgetPersonnelRateAndBaseList()));
                }
                continue;
            }
            this.addReportTypeVO(reportTypeVOList, budgetLineItem, budgetLineItem, this.getRatesApplicableToVOList(budgetLineItem.getBudgetRateAndBaseList()));
        }
        return reportTypeVOList;
    }

    protected void addReportTypeVO(List<ReportTypeVO> reportTypeVOList, BudgetLineItem budgetLineItem, BudgetLineItemBase budgetDetails, List<? extends AbstractBudgetRateAndBase> rates) {
        List<AbstractBudgetRateAndBase> fringeRates = this.getVAAndEBRates(rates);
        if (fringeRates != null && !fringeRates.isEmpty()) {
            for (AbstractBudgetRateAndBase rate : fringeRates) {
                ReportTypeVO reportTypeVO = this.getReportTypeVO(budgetLineItem, budgetDetails, rate);
                reportTypeVOList.add(reportTypeVO);
            }
        } else {
            ReportTypeVO reportTypeVO = this.getReportTypeVO(budgetLineItem, budgetDetails);
            reportTypeVOList.add(reportTypeVO);
        }
    }

    protected List<AbstractBudgetRateAndBase> getVAAndEBRates(List<? extends AbstractBudgetRateAndBase> rates) {
        ArrayList<AbstractBudgetRateAndBase> result = new ArrayList<AbstractBudgetRateAndBase>();
        for (AbstractBudgetRateAndBase abstractBudgetRateAndBase : rates) {
            if (this.isRateAndBaseEBonLA(abstractBudgetRateAndBase) || this.isRateAndBaseVAonLA(abstractBudgetRateAndBase) || this.isRateAndBaseLASalary(abstractBudgetRateAndBase) || !this.isRateAndBaseOfRateClassTypeEB(abstractBudgetRateAndBase) && !this.isRateAndBaseOfRateClassTypeVacation(abstractBudgetRateAndBase)) continue;
            result.add(abstractBudgetRateAndBase);
        }
        return result;
    }

    protected List<AbstractBudgetRateAndBase> getRatesApplicableToVOList(List<? extends AbstractBudgetRateAndBase> rates) {
        return this.getVAAndEBRates(rates);
    }

    private ReportTypeVO getReportTypeVO(BudgetLineItem budgetLineItem, BudgetLineItemBase budgetDetails, AbstractBudgetRateAndBase rate) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setStartDate(rate.getStartDate());
        reportTypeVO.setEndDate(rate.getEndDate());
        reportTypeVO.setBudgetCategoryDesc(this.getBudgetCategoryDescForSalarySummary(budgetLineItem, budgetDetails, rate));
        if (budgetDetails instanceof BudgetPersonnelDetails) {
            BudgetPersonnelDetails budgetPersDetails = (BudgetPersonnelDetails)budgetDetails;
            BudgetPersonnelRateAndBase budgetPersRateAndBase = (BudgetPersonnelRateAndBase)rate;
            reportTypeVO.setPersonName(this.getPersonNameFromBudgetPersonByRateAndBase(budgetPersDetails.getBudgetPerson(), budgetPersRateAndBase, budgetLineItem.getQuantity()));
            reportTypeVO.setPercentEffort(this.getPercentEffortForBudgetPersonnelRateBase(budgetLineItem, budgetPersDetails, budgetPersRateAndBase));
            reportTypeVO.setPercentCharged(this.getPercentChargedForBudgetPersonnelRateBase(budgetLineItem, budgetPersDetails, budgetPersRateAndBase));
            reportTypeVO.setInvestigatorFlag(this.getInvestigatorFlag(budgetPersDetails));
            reportTypeVO.setSalaryRequested(budgetPersRateAndBase.getSalaryRequested());
            reportTypeVO.setBudgetLineItemId(budgetPersDetails.getBudgetLineItemId());
        } else {
            BudgetRateAndBase budgetRate = (BudgetRateAndBase)rate;
            reportTypeVO.setPersonName(PERSONNEL_SUMMARY_LINE_ITEM_NAME);
            reportTypeVO.setInvestigatorFlag(3);
            reportTypeVO.setSalaryRequested(budgetRate.getBaseCost());
            reportTypeVO.setBudgetLineItemId(((BudgetLineItem)budgetDetails).getBudgetLineItemId());
        }
        if (this.isRateAndBaseOfRateClassTypeVacation(rate)) {
            reportTypeVO.setVacationRate(rate.getAppliedRate());
        } else {
            reportTypeVO.setVacationRate(ScaleTwoDecimal.ZERO);
        }
        if (this.isRateAndBaseOfRateClassTypeEB(rate)) {
            reportTypeVO.setEmployeeBenefitRate(rate.getAppliedRate());
        } else {
            reportTypeVO.setEmployeeBenefitRate(ScaleTwoDecimal.ZERO);
        }
        reportTypeVO.setCostSharingAmount(rate.getBaseCostSharing());
        reportTypeVO.setCalculatedCost(rate.getCalculatedCostSharing());
        reportTypeVO.setFringe(rate.getCalculatedCost());
        reportTypeVO.setCostElementDesc(budgetDetails.getCostElementBO().getDescription());
        reportTypeVO.setBudgetCategoryCode(this.getBudgetCategoryCodeFroBudgetSalarySummary(rate, budgetDetails));
        return reportTypeVO;
    }

    private ReportTypeVO getReportTypeVO(BudgetLineItem budgetLineItem, BudgetLineItemBase budgetDetails) {
        ReportTypeVO reportTypeVO = new ReportTypeVO();
        reportTypeVO.setStartDate(budgetDetails.getStartDate());
        reportTypeVO.setEndDate(budgetDetails.getEndDate());
        reportTypeVO.setBudgetCategoryDesc(this.getBudgetCategoryDescForSalarySummary(budgetLineItem, budgetDetails, null));
        if (budgetDetails instanceof BudgetPersonnelDetails) {
            BudgetPersonnelDetails budgetPersDetails = (BudgetPersonnelDetails)budgetDetails;
            reportTypeVO.setPersonName(this.getPersonNameFromBudgetPersonByRateAndBase(budgetPersDetails.getBudgetPerson(), null, budgetLineItem.getQuantity()));
            reportTypeVO.setPercentEffort(this.getPercentEffortForBudgetPersonnelRateBase(budgetLineItem, budgetPersDetails, null));
            reportTypeVO.setPercentCharged(this.getPercentChargedForBudgetPersonnelRateBase(budgetLineItem, budgetPersDetails, null));
            reportTypeVO.setInvestigatorFlag(this.getInvestigatorFlag(budgetPersDetails));
            reportTypeVO.setSalaryRequested(budgetPersDetails.getSalaryRequested());
            reportTypeVO.setBudgetLineItemId(budgetPersDetails.getBudgetPersonnelLineItemId());
        } else {
            reportTypeVO.setPersonName(PERSONNEL_SUMMARY_LINE_ITEM_NAME);
            reportTypeVO.setInvestigatorFlag(3);
            reportTypeVO.setSalaryRequested(budgetLineItem.getLineItemCost());
            reportTypeVO.setBudgetLineItemId(((BudgetLineItem)budgetDetails).getBudgetLineItemId());
        }
        reportTypeVO.setVacationRate(ScaleTwoDecimal.ZERO);
        reportTypeVO.setEmployeeBenefitRate(ScaleTwoDecimal.ZERO);
        reportTypeVO.setCostSharingAmount(budgetDetails.getCostSharingAmount());
        reportTypeVO.setCalculatedCost(ScaleTwoDecimal.ZERO);
        reportTypeVO.setFringe(ScaleTwoDecimal.ZERO);
        reportTypeVO.setCostElementDesc(budgetDetails.getCostElementBO().getDescription());
        reportTypeVO.setBudgetCategoryCode(this.getBudgetCategoryCodeFroBudgetSalarySummary(null, budgetDetails));
        return reportTypeVO;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
    }

    public BudgetPeriod getBudgetPeriod() {
        return this.budgetPeriod;
    }

    public void setBudgetPeriod(BudgetPeriod budgetPeriod) {
        this.budgetPeriod = budgetPeriod;
    }
}

