/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.preproposal;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentViewHelperServiceImpl;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalForm;
import org.kuali.coeus.propdev.impl.preproposal.PreproposalFormsService;
import org.kuali.coeus.propdev.impl.preproposal.ProposalDevelopmentPreproposalFormsHelper;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildAppDto;
import org.kuali.coeus.sys.framework.kualibuild.dto.KualiBuildInitializeWorkflowDto;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentPreproposalFormsController
extends ProposalDevelopmentControllerBase {
    private static final Logger LOG = LogManager.getLogger(ProposalDevelopmentPreproposalFormsController.class);
    @Autowired
    @Qualifier(value="preproposalFormsService")
    private PreproposalFormsService preproposalFormsService;

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=navigate", "actionParameters[navigateToPageId]=PropDev-PreproposalFormsPage"})
    public ModelAndView navigateToPreproposal(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = super.navigate(form, result, request, response);
        this.getViewHelper(form).populatePreproposalForms(form);
        this.getPreproposalFormsService().deleteAndSavePreproposalForms(form.getDevelopmentProposal(), form.getPreproposalFormsHelper().getPreproposalForms());
        return modelAndView;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addPreproposalForm"})
    public ModelAndView addPreproposalForm(@RequestParam(value="appId") String appId, @RequestParam(value="timeZone") String timeZone, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        LOG.debug("addPreproposalForm: {}\t{}", (Object)appId, (Object)timeZone);
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        KualiBuildAppDto app = this.findAvailableApp(preproposalFormsHelper, appId);
        KualiBuildInitializeWorkflowDto initResponse = this.preproposalFormsService.createPreproposalForm(app, form.getProposalDevelopmentDocument(), preproposalFormsHelper.getEvaluator(), timeZone);
        LOG.debug("Build document id: {}", (Object)initResponse.getDocumentId());
        Optional<String> url = this.preproposalFormsService.preparePreproposalFormAction(initResponse.getActionId());
        preproposalFormsHelper.setKualiBuildActionUri(url.orElse("#"));
        return this.getModelAndViewService().showDialog("PropDev-PreproposalFormsPage-BuildOpenedDialog", false, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=updatePreproposalForm"})
    public ModelAndView updatePreproposalForm(@RequestParam(value="documentId") String documentId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        LOG.debug("updatePreproposalForm: {}", (Object)documentId);
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        preproposalFormsHelper.setCurrentPreproposalFormByDocumentId(documentId);
        this.preproposalFormsService.updatePreproposalForm(form);
        return this.refresh(form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=confirmResubmitPreproposalForm"})
    public ModelAndView confirmResubmit(@RequestParam(value="appId") String appId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        LOG.debug("confirmResubmit: {}", (Object)appId);
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        KualiBuildAppDto app = this.findAvailableApp(preproposalFormsHelper, appId);
        preproposalFormsHelper.setCurrentApp(app);
        return this.getModelAndViewService().showDialog("PropDev-PreproposalFormsPage-ResubmitDialog", true, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=preproposalFillForm"})
    public ModelAndView fillForm(@RequestParam(value="documentId") String documentId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        LOG.debug("fillForm: {}", (Object)documentId);
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        PreproposalForm preproposalForm = preproposalFormsHelper.setCurrentPreproposalFormByDocumentId(documentId);
        if (this.preproposalFormsService.requiresUpgrade(preproposalForm)) {
            return this.getModelAndViewService().showDialog("PropDev-PreproposalFormsPage-UpgradeDocumentDialog", false, (UifFormBase)form);
        }
        return this.openFillForm(preproposalForm, form);
    }

    private ModelAndView openFillForm(PreproposalForm preproposalForm, ProposalDevelopmentDocumentForm form) {
        Optional<String> url;
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        if (preproposalForm.getActionId().isPresent()) {
            url = this.preproposalFormsService.preparePreproposalFormAction(preproposalForm.getActionId().get());
            if (url.isEmpty()) {
                return this.getModelAndViewService().getModelAndView((UifFormBase)form);
            }
        } else {
            throw new RuntimeException("No Kuali Build action for document id " + preproposalForm.getDocument().getId());
        }
        preproposalFormsHelper.setKualiBuildActionUri(url.get());
        return this.getModelAndViewService().showDialog("PropDev-PreproposalFormsPage-BuildOpenedDialog", false, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=preproposalGoToBuildAction"})
    public ModelAndView goToBuildAction(@RequestParam(value="actionId") String actionId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        LOG.debug("goToBuildAction: {}", (Object)actionId);
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        preproposalFormsHelper.setKualiBuildActionUri(this.preproposalFormsService.getActionUrl(actionId));
        return this.getModelAndViewService().showDialog("PropDev-PreproposalFormsPage-BuildOpenedDialog", false, (UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=setCurrentPreproposalForm"})
    public ModelAndView setCurrentPreproposalForm(@RequestParam(value="documentId") String documentId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        LOG.debug("setCurrentPreproposalForm: {}", (Object)documentId);
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        preproposalFormsHelper.setCurrentPreproposalFormByDocumentId(documentId);
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=preproposalFormsToggleShowAll"})
    public ModelAndView toggleShowAll(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=upgradePreproposalFormDocument"})
    public ModelAndView upgradeDocument(@RequestParam(value="documentId") String documentId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        LOG.debug("upgradeDocument: {}", (Object)documentId);
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        preproposalFormsHelper.setCurrentPreproposalFormByDocumentId(documentId);
        PreproposalForm newPreproposalForm = this.preproposalFormsService.upgradeDocument(form);
        return this.openFillForm(newPreproposalForm, form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=discardPreproposalForm"})
    public ModelAndView discard(@RequestParam(value="documentId") String documentId, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        LOG.debug("discard: {}", (Object)documentId);
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        PreproposalForm preproposalForm = preproposalFormsHelper.setCurrentPreproposalFormByDocumentId(documentId);
        boolean success = this.preproposalFormsService.discardPreproposalForm(preproposalForm);
        if (success) {
            return this.refresh(form);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=withdrawPreproposalForm"})
    public ModelAndView withdraw(@RequestParam(value="documentId") String documentId, @RequestParam(value="timeZone") String timeZone, @ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        LOG.debug("withdraw: {}\t{}", (Object)documentId, (Object)timeZone);
        ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper = form.getPreproposalFormsHelper();
        PreproposalForm preproposalForm = preproposalFormsHelper.setCurrentPreproposalFormByDocumentId(documentId);
        boolean success = this.preproposalFormsService.withdrawPreproposalForm(preproposalForm, timeZone);
        if (success) {
            return this.refresh(form);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=preproposalFormsRefresh"})
    public ModelAndView refresh(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm form) {
        this.getViewHelper(form).populatePreproposalForms(form);
        this.getPreproposalFormsService().deleteAndSavePreproposalForms(form.getDevelopmentProposal(), form.getPreproposalFormsHelper().getPreproposalForms());
        return this.getModelAndViewService().getModelAndView((UifFormBase)form);
    }

    private ProposalDevelopmentViewHelperServiceImpl getViewHelper(ProposalDevelopmentDocumentForm form) {
        return (ProposalDevelopmentViewHelperServiceImpl)form.getViewHelperService();
    }

    private KualiBuildAppDto findAvailableApp(ProposalDevelopmentPreproposalFormsHelper preproposalFormsHelper, String appId) {
        return preproposalFormsHelper.getAvailableApps().stream().filter(a -> a.getId().equals(appId)).findFirst().orElseThrow(() -> new RuntimeException("Application with id " + appId + " not found."));
    }

    public PreproposalFormsService getPreproposalFormsService() {
        return this.preproposalFormsService;
    }

    public void setPreproposalFormsService(PreproposalFormsService preproposalFormsService) {
        this.preproposalFormsService = preproposalFormsService;
    }
}

