/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.reporting.web.struts.action;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.util.PrintingUtils;
import org.kuali.coeus.sys.framework.controller.BackLocationAction;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.subaward.reporting.printing.SubAwardPrintType;
import org.kuali.kra.subaward.reporting.printing.service.SubAwardPrintingService;
import org.kuali.kra.subaward.reporting.web.struts.form.IsrSsrReportGenerationForm;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.KualiForm;

public class IsrSsrReportGenerationAction
extends KualiAction
implements BackLocationAction {
    private static final String SF_295_REPORT = "SF295";
    private static final String AWARD_NO = "awardNo";
    private transient AwardService awardService;
    private transient ErrorReporter errorReporter;
    private transient SubAwardPrintingService subAwardPrintingService;

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.returnToSender(request, mapping, (KualiForm)form);
    }

    public ActionForward printReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IsrSsrReportGenerationForm isrSsrReportGenerationForm = (IsrSsrReportGenerationForm)form;
        if (StringUtils.isNotBlank((CharSequence)isrSsrReportGenerationForm.getAwardNo()) && StringUtils.isNotBlank((CharSequence)isrSsrReportGenerationForm.getReportType()) && StringUtils.isNotBlank((CharSequence)isrSsrReportGenerationForm.getReportName())) {
            List<Award> awards = this.getAwardService().findAwardsForAwardNumber(isrSsrReportGenerationForm.getAwardNo());
            if (CollectionUtils.isNotEmpty(awards)) {
                Award award = awards.get(0);
                HashMap<String, Object> reportParameters = new HashMap<String, Object>();
                reportParameters.put("printType", isrSsrReportGenerationForm.getReportName());
                reportParameters.put("reportType", isrSsrReportGenerationForm.getReportType());
                reportParameters.put("awardNumber", isrSsrReportGenerationForm.getAwardNo());
                AttachmentDataSource dataStream = isrSsrReportGenerationForm.getReportName().equals(SF_295_REPORT) ? this.getSubAwardPrintingService().printSubAwardReport(award, SubAwardPrintType.SUB_AWARD_SF_295_PRINT_TYPE, reportParameters) : this.getSubAwardPrintingService().printSubAwardReport(award, SubAwardPrintType.SUB_AWARD_SF_294_PRINT_TYPE, reportParameters);
                PrintingUtils.streamToResponse(dataStream, response);
            } else {
                this.getErrorReporter().reportError(AWARD_NO, "error.award.notFound", "");
            }
        } else {
            this.getErrorReporter().reportError(AWARD_NO, "error.missing.report.inputparameters", "");
        }
        return mapping.findForward("basic");
    }

    protected AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KcServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }

    protected void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    protected ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        }
        return this.errorReporter;
    }

    protected void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    protected SubAwardPrintingService getSubAwardPrintingService() {
        if (this.subAwardPrintingService == null) {
            this.subAwardPrintingService = KcServiceLocator.getService(SubAwardPrintingService.class);
        }
        return this.subAwardPrintingService;
    }

    protected void setSubAwardPrintingService(SubAwardPrintingService subAwardPrintingService) {
        this.subAwardPrintingService = subAwardPrintingService;
    }
}

