/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.budget.framework.core.CostElement;
import org.kuali.coeus.common.budget.framework.core.category.BudgetCategoryType;
import org.kuali.coeus.common.budget.framework.rate.RateType;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.kra.award.budget.AwardBudgetExt;

public class BudgetLimitSummaryHelper
implements Serializable {
    private static final long serialVersionUID = -3504648775976043270L;
    private AwardBudgetExt currentBudget;
    private AwardBudgetExt previousBudget;

    public Map<BudgetCategoryType, Set<CostElement>> getCombinedObjectCodeListByCategory() {
        TreeMap<BudgetCategoryType, Set<CostElement>> result = new TreeMap<BudgetCategoryType, Set<CostElement>>();
        for (Map.Entry<BudgetCategoryType, List<CostElement>> entry : this.currentBudget.getObjectCodeListByBudgetCategoryType().entrySet()) {
            result.put(entry.getKey(), new TreeSet(entry.getValue()));
        }
        for (Map.Entry<BudgetCategoryType, List<CostElement>> entry : this.previousBudget.getObjectCodeListByBudgetCategoryType().entrySet()) {
            Set<CostElement> curElements = result.get(entry.getKey());
            if (curElements == null) {
                result.put(entry.getKey(), new TreeSet(entry.getValue()));
                continue;
            }
            curElements.addAll((Collection<CostElement>)entry.getValue());
        }
        return result;
    }

    public Set<CostElement> getCombinedPersonnelObjectCodes() {
        for (Map.Entry<BudgetCategoryType, Set<CostElement>> entry : this.getCombinedObjectCodeListByCategory().entrySet()) {
            if (!StringUtils.equals((CharSequence)entry.getKey().getCode(), (CharSequence)"P")) continue;
            return entry.getValue();
        }
        return new TreeSet<CostElement>();
    }

    public Map<CostElement, ScaleTwoDecimal> getCurrentObjectCodeTotals() {
        return this.getCurrentBudget().getObjectCodeBudgetTotals();
    }

    public Map<CostElement, ScaleTwoDecimal> getPreviousObjectCodeTotals() {
        return this.getPreviousBudget().getObjectCodeBudgetTotals();
    }

    public Map<String, ScaleTwoDecimal> getCurrentSummaryTotals() {
        return this.getCurrentBudget().getTotalBudgetSummaryTotals();
    }

    public Map<String, ScaleTwoDecimal> getPreviousSummaryTotals() {
        return this.getPreviousBudget().getTotalBudgetSummaryTotals();
    }

    public Map<String, ScaleTwoDecimal> getCurrentObjectCodePersonnelFringeTotals() {
        return this.getCurrentBudget().getObjectCodePersonnelFringeBudgetTotals();
    }

    public Map<String, ScaleTwoDecimal> getPreviousObjectCodePersonnelFringeTotals() {
        return this.getPreviousBudget().getObjectCodePersonnelFringeBudgetTotals();
    }

    public Set<RateType> getCombinedPersonnelCalculatedExpenseRates() {
        TreeSet<RateType> result = new TreeSet<RateType>();
        for (RateType type : this.getCurrentBudget().getPersonnelCalculatedExpenseTotals().keySet()) {
            if (type.getRateClass().getRateClassTypeCode() == null || StringUtils.equals((CharSequence)type.getRateClass().getRateClassTypeCode(), (CharSequence)"O")) continue;
            result.add(type);
        }
        for (RateType type : this.getPreviousBudget().getPersonnelCalculatedExpenseTotals().keySet()) {
            if (type.getRateClass().getRateClassTypeCode() == null || StringUtils.equals((CharSequence)type.getRateClass().getRateClassTypeCode(), (CharSequence)"O")) continue;
            result.add(type);
        }
        return result;
    }

    public Map<RateType, ScaleTwoDecimal> getCurrentPersonnelCalculatedExpenseTotals() {
        return this.getCurrentBudget().getPersonnelCalculatedExpenseBudgetTotals();
    }

    public Map<RateType, ScaleTwoDecimal> getPreviousPersonnelCalculatedExpenseTotals() {
        return this.getPreviousBudget().getPersonnelCalculatedExpenseBudgetTotals();
    }

    public Set<RateType> getCombinedNonPersonnelCalculatedExpenseRates() {
        TreeSet<RateType> result = new TreeSet<RateType>();
        for (RateType type : this.getCurrentBudget().getNonPersonnelCalculatedExpenseTotals().keySet()) {
            if (type.getRateClass().getRateClassTypeCode() == null || StringUtils.equals((CharSequence)type.getRateClass().getRateClassTypeCode(), (CharSequence)"O")) continue;
            result.add(type);
        }
        for (RateType type : this.getPreviousBudget().getNonPersonnelCalculatedExpenseTotals().keySet()) {
            if (type.getRateClass().getRateClassTypeCode() == null || StringUtils.equals((CharSequence)type.getRateClass().getRateClassTypeCode(), (CharSequence)"O")) continue;
            result.add(type);
        }
        return result;
    }

    public Map<RateType, ScaleTwoDecimal> getCurrentNonPersonnelCalculatedExpenseTotals() {
        return this.getCurrentBudget().getNonPersonnelCalculatedExpenseBudgetTotals();
    }

    public Map<RateType, ScaleTwoDecimal> getPreviousNonPersonnelCalculatedExpenseTotals() {
        return this.getPreviousBudget().getNonPersonnelCalculatedExpenseBudgetTotals();
    }

    public ScaleTwoDecimal getCurrentPersonnelTotal() {
        Map<String, ScaleTwoDecimal> summaryTotals = this.getCurrentSummaryTotals();
        ScaleTwoDecimal total = ScaleTwoDecimal.ZERO;
        total = (ScaleTwoDecimal)total.add((AbstractDecimal)summaryTotals.get("personnelSalaryTotals"));
        total = (ScaleTwoDecimal)total.add((AbstractDecimal)summaryTotals.get("personnelFringeTotals"));
        total = (ScaleTwoDecimal)total.add((AbstractDecimal)summaryTotals.get("personnelCalculatedExpenseSummaryTotals"));
        return total;
    }

    public ScaleTwoDecimal getPreviousPersonnelTotal() {
        Map<String, ScaleTwoDecimal> summaryTotals = this.getPreviousSummaryTotals();
        ScaleTwoDecimal total = ScaleTwoDecimal.ZERO;
        total = (ScaleTwoDecimal)total.add((AbstractDecimal)summaryTotals.get("personnelSalaryTotals"));
        total = (ScaleTwoDecimal)total.add((AbstractDecimal)summaryTotals.get("personnelFringeTotals"));
        total = (ScaleTwoDecimal)total.add((AbstractDecimal)summaryTotals.get("personnelCalculatedExpenseSummaryTotals"));
        return total;
    }

    public AwardBudgetExt getCurrentBudget() {
        return this.currentBudget;
    }

    public void setCurrentBudget(AwardBudgetExt currentBudget) {
        this.currentBudget = currentBudget;
    }

    public AwardBudgetExt getPreviousBudget() {
        return this.previousBudget;
    }

    public void setPreviousBudget(AwardBudgetExt previousBudget) {
        this.previousBudget = previousBudget;
    }
}

