/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.rolodex;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.common.framework.rolodex.Rolodex;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.Maintainable;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.data.platform.MaxValueIncrementerFactory;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.framework.state.StateValuesFinder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="rolodexMaintainableImpl")
@Scope(value="prototype")
public class RolodexMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = -6436670290567992063L;
    public static final String ROLODEX_ID_SEQUENCE_NAME = "SEQ_ROLODEX_ID";
    public static final String SECTION_ID = "Edit Address Book";
    public static final String ROLODEX_ID_NAME = "rolodexId";
    public static final String STATE = "state";
    private static final String SPONSOR_CODE_NAME = "sponsorCode";
    private static final String ORGANIZATION_NAME = "organization";
    private static final String OWNED_BY_UNIT_NAME = "ownedByUnit";
    @Autowired
    @Qualifier(value="kradApplicationDataSource")
    private DataSource kradApplicationDataSource;
    @Autowired
    @Qualifier(value="parameterService")
    private transient ParameterService parameterService;
    @Autowired
    @Qualifier(value="sequenceAccessorService")
    private transient SequenceAccessorService sequenceAccessorService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;
    @Autowired
    @Qualifier(value="kcPersonService")
    private KcPersonService kcPersonService;
    @Autowired
    @Qualifier(value="countryService")
    private transient CountryService countryService;

    public void setGenerateDefaultValues(String docTypeName) {
        super.setGenerateDefaultValues(docTypeName);
        Rolodex rolodex = (Rolodex)this.getBusinessObject();
        if (this.isAutoGenerateCode()) {
            rolodex.setRolodexId(Integer.parseInt(this.getSequenceAccessorService().getNextAvailableSequenceNumber(ROLODEX_ID_SEQUENCE_NAME, Rolodex.class).toString()));
        }
    }

    @Override
    public List<Section> getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        if (this.isAutoGenerateCode()) {
            this.disableRolodexId(sections);
        }
        if (this.isRolodexOrganizationAsSponsor()) {
            this.setupRolodexOrganizationAsSponsor(sections);
        } else {
            this.setupOrganizationAsRequired(sections);
        }
        if (this.isRolodexOwnedByUnit()) {
            this.setupRolodexOwnedByUnit(sections);
        }
        return sections;
    }

    public boolean isRolodexOrganizationAsSponsor() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "ADDRESSBOOK_ORGANIZATION_AS_SPONSOR_NAME");
    }

    private String getRolodexOwnedByUnit() {
        return this.getParameterService().getParameterValueAsString("KC-GEN", "All", "ADDRESSBOOK_OWNED_BY_UNIT");
    }

    public boolean isRolodexOwnedByUnit() {
        return StringUtils.isNotBlank((CharSequence)this.getRolodexOwnedByUnit());
    }

    private Stream<Field> getFieldStream(List<Section> sections) {
        return sections.stream().filter(section -> StringUtils.equals((CharSequence)section.getSectionId(), (CharSequence)SECTION_ID)).flatMap(section -> section.getRows().stream()).flatMap(row -> row.getFields().stream());
    }

    private void setupRolodexOrganizationAsSponsor(List<Section> sections) {
        this.getFieldStream(sections).forEach(field -> {
            if (StringUtils.equals((CharSequence)field.getPropertyName(), (CharSequence)SPONSOR_CODE_NAME)) {
                field.setFieldRequired(true);
            }
            if (StringUtils.equals((CharSequence)field.getPropertyName(), (CharSequence)ORGANIZATION_NAME)) {
                field.setReadOnly(true);
            }
        });
    }

    private void setupOrganizationAsRequired(List<Section> sections) {
        this.getFieldStream(sections).forEach(field -> {
            if (StringUtils.equals((CharSequence)field.getPropertyName(), (CharSequence)ORGANIZATION_NAME)) {
                field.setFieldRequired(true);
            }
        });
    }

    private void setupRolodexOwnedByUnit(List<Section> sections) {
        this.getFieldStream(sections).filter(field -> StringUtils.equals((CharSequence)field.getPropertyName(), (CharSequence)OWNED_BY_UNIT_NAME)).findFirst().ifPresent(field -> {
            String ownedByUnit = this.getRolodexOwnedByUnit();
            Rolodex rolodex = (Rolodex)this.getBusinessObject();
            field.setReadOnly(true);
            field.setPropertyValue(ownedByUnit);
            rolodex.setOwnedByUnit(ownedByUnit);
        });
    }

    protected void disableRolodexId(List<Section> sections) {
        this.getFieldStream(sections).forEach(field -> {
            if (StringUtils.equals((CharSequence)field.getPropertyName(), (CharSequence)ROLODEX_ID_NAME)) {
                field.setReadOnly(true);
            }
            if (StringUtils.equals((CharSequence)field.getPropertyName(), (CharSequence)STATE)) {
                field.setFieldValidValues(this.getFieldValues(((Rolodex)this.businessObject).getCountryCode()));
            }
        });
    }

    protected List<KeyValue> getFieldValues(String alternateCode) {
        StateValuesFinder valuesFinder = new StateValuesFinder();
        if (StringUtils.isNotBlank((CharSequence)alternateCode)) {
            Country country = this.getCountryService().getCountryByAlternateCode(alternateCode);
            valuesFinder.setCountryCode(country.getCode());
        } else {
            valuesFinder.setCountryCode("");
        }
        return valuesFinder.getKeyValues();
    }

    public void processAfterNew(org.kuali.rice.krad.maintenance.MaintenanceDocument document, Map<String, String[]> requestParameters) {
        Rolodex rolodex = (Rolodex)document.getNewMaintainableObject().getDataObject();
        rolodex.setActive(true);
        if (this.isAutoGenerateCode()) {
            rolodex.setRolodexId(Integer.parseInt(Long.valueOf(MaxValueIncrementerFactory.getIncrementer((DataSource)this.getKradApplicationDataSource(), (String)ROLODEX_ID_SEQUENCE_NAME).nextLongValue()).toString()));
        }
        if (this.isRolodexOwnedByUnit()) {
            rolodex.setOwnedByUnit(this.getRolodexOwnedByUnit());
        } else {
            KcPerson person = this.getKcPersonService().getKcPersonByPersonId(this.getGlobalVariableService().getUserSession().getPrincipalId());
            rolodex.setOwnedByUnit(person.getUnit().getUnitNumber());
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        this.setGenerateDefaultValues(document.getDocumentHeader().getWorkflowDocument().getDocumentTypeName());
    }

    public boolean isAutoGenerateCode() {
        return this.getParameterService().getParameterValueAsBoolean("KC-GEN", "All", "AUTO_GENERATE_NON_EMPLOYEE_ID");
    }

    public void saveDataObject() {
        if (this.getBusinessObject() instanceof Rolodex) {
            Rolodex rolodex = (Rolodex)this.getBusinessObject();
            rolodex.setSponsorAddressFlag(false);
        }
        super.saveDataObject();
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected CountryService getCountryService() {
        if (this.countryService == null) {
            this.countryService = KcServiceLocator.getService(CountryService.class);
        }
        return this.countryService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = KcServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public DataSource getKradApplicationDataSource() {
        if (this.kradApplicationDataSource == null) {
            this.kradApplicationDataSource = (DataSource)KcServiceLocator.getService("kradApplicationDataSource");
        }
        return this.kradApplicationDataSource;
    }

    public void setKradApplicationDataSource(DataSource kradApplicationDataSource) {
        this.kradApplicationDataSource = kradApplicationDataSource;
    }

    public KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

