/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.api.sponsor.hierarchy.SponsorHierarchyService;
import org.kuali.coeus.common.framework.auth.UnitAuthorizationService;
import org.kuali.coeus.common.framework.person.PropAwardPersonRoleService;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.contacts.AwardCentralAdminContactsBean;
import org.kuali.kra.award.contacts.AwardCreditSplitBean;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardProjectPersonnelBean;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.contacts.AwardSponsorContactsBean;
import org.kuali.kra.award.contacts.AwardUnitContactsBean;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.infrastructure.AwardPermissionConstants;
import org.kuali.kra.award.web.struts.action.AwardAction;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardContactsAction
extends AwardAction {
    private static final String PROJECT_PERSON_PREFIX = ".personIndex";
    private static final String LINE_SUFFIX = ".line";
    private static final String CONFIRM_SYNC_UNIT_CONTACTS = "confirmSyncUnitContacts";
    private static final String CONFIRM_SYNC_CENTRAL_ADMIN_CONTACTS = "confirmSyncCentralAdminContacts";
    private static final String CONFIRM_TOGGLE_CENTRAL_ADMIN_CONTACTS_AUTO_SYNC = "confirmToggleCentralAdminContactsAutoSync";
    private static final String CONFIRM_SYNC_UNIT_DETAILS = "confirmSyncUnitDetails";
    private static final String ADD_SYNC_UNIT_DETAILS = "addSyncUnitDetails";
    private static final String CONFIRM_SYNC_UNIT_CONTACTS_KEY = "confirmSyncUnitContactsKey";
    private static final String CONFIRM_SYNC_CENTRAL_ADMIN_CONTACTS_KEY = "confirmSyncCentralAdminContactsKey";
    private static final String CONFIRM_TOGGLE_CENTRAL_ADMIN_CONTACTS_AUTO_SYNC_KEY = "confirmToggleCentralAdminContactsAutoSyncKey";
    private transient PropAwardPersonRoleService propAwardPersonRoleService;
    private transient UnitAuthorizationService authService;

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        AwardForm awardForm = (AwardForm)form;
        awardForm.refreshDisclosureProjectStatuses();
        Award award = awardForm.getAwardDocument().getAward();
        if (this.isValidSave(awardForm.getAwardDocument().getAward())) {
            this.setLeadUnitOnAwardFromPILeadUnit(award, awardForm);
            award.getAwardCentralAdminContacts();
            award.removeDuplicateAwardCentralAdminContacts();
            forward = super.save(mapping, form, request, response);
        } else {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward saveContacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        if (awardForm.getEditingMode().containsKey("limitedEditAwardSponsorContacts")) {
            return this.optimisticActionForward(mapping, form, () -> super.save(mapping, form, request, response));
        }
        return mapping.findForward("basic");
    }

    protected boolean isValidSave(Award award) {
        String leadUnitNumber = award.getLeadUnitNumber();
        List<AwardPerson> persons = award.getProjectPersons();
        if (StringUtils.isNotEmpty((CharSequence)leadUnitNumber) && this.checkNoMoreThanOnePI(award) && this.isMultiPiValid(award.getSponsorCode(), persons)) {
            String userId = this.getPrincipalIdFromSession();
            UnitAuthorizationService authService = this.getAuthService();
            if (!authService.hasPermission(userId, leadUnitNumber, "KC-AWARD", AwardPermissionConstants.MODIFY_AWARD.getAwardPermission())) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.award.contacts.no.perm.for.new.unit", new String[0]);
            } else {
                return true;
            }
        }
        return false;
    }

    protected UnitAuthorizationService getAuthService() {
        if (this.authService == null) {
            this.authService = KcServiceLocator.getService(UnitAuthorizationService.class);
        }
        return this.authService;
    }

    public void setAuthService(UnitAuthorizationService authService) {
        this.authService = authService;
    }

    protected String getPrincipalIdFromSession() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected boolean isMultiPiValid(String sponsor, List<AwardPerson> persons) {
        boolean valid = true;
        boolean multiPiAllowed = this.isMultiPiAllowed(sponsor);
        for (int index = 0; index < persons.size(); ++index) {
            boolean multiplePi = persons.get(index).isMultiplePi();
            if (!multiplePi || multiPiAllowed || this.getPropAwardPersonRoleService().getRole("MPI", "DEFAULT") != null) continue;
            valid = false;
            GlobalVariables.getMessageMap().putError("projectPersonnelBean.projectPersonnel[" + index + "].contactRoleCode", "error.awardProjectPerson.pi.exists", new String[0]);
        }
        return valid;
    }

    protected boolean isMultiPiAllowed(String sponsor) {
        PropAwardPersonRoleService awardPersonRoleService = this.getPropAwardPersonRoleService();
        SponsorHierarchyService sponsorHierarchyService = this.getSponsorHierarchyService();
        return awardPersonRoleService.areAllSponsorsMultiPi() != false || sponsorHierarchyService.isSponsorNihMultiplePi(sponsor);
    }

    public PropAwardPersonRoleService getPropAwardPersonRoleService() {
        if (this.propAwardPersonRoleService == null) {
            this.propAwardPersonRoleService = KcServiceLocator.getService(PropAwardPersonRoleService.class);
        }
        return this.propAwardPersonRoleService;
    }

    public void setPropAwardPersonRoleService(PropAwardPersonRoleService propAwardPersonRoleService) {
        this.propAwardPersonRoleService = propAwardPersonRoleService;
    }

    protected boolean checkNoMoreThanOnePI(Award award) {
        int piCount = 0;
        ArrayList<CallSite> fields = new ArrayList<CallSite>();
        for (int i = 0; i < award.getProjectPersons().size(); ++i) {
            if (!award.getProjectPersons().get(i).isPrincipalInvestigator()) continue;
            ++piCount;
            fields.add((CallSite)((Object)("projectPersonnelBean.projectPersonnel[" + i + "].contactRoleCode")));
        }
        if (piCount > 1) {
            fields.stream().forEach(field -> GlobalVariables.getMessageMap().putError(field, "error.awardProjectPerson.pi.exists", new String[0]));
            return false;
        }
        return true;
    }

    @Override
    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        ActionForward forward = super.reload(mapping, form, request, response);
        awardForm.getAwardDocument().getAward().getAwardCentralAdminContacts();
        awardForm.getAwardDocument().getAward().removeDuplicateAwardCentralAdminContacts();
        return forward;
    }

    private void setLeadUnitOnAwardFromPILeadUnit(Award award, AwardForm awardForm) {
        for (AwardPerson person : award.getProjectPersons()) {
            if (!person.isPrincipalInvestigator() || person.getUnits().size() < 1) continue;
            AwardPersonUnit selectedUnit = null;
            for (AwardPersonUnit unit : person.getUnits()) {
                if (!unit.isLeadUnit()) continue;
                selectedUnit = unit;
            }
            if (selectedUnit == null) {
                selectedUnit = person.getUnit(0);
            }
            if (selectedUnit != null) {
                award.setUnitNumber(selectedUnit.getUnitNumber());
                award.setLeadUnit(selectedUnit.getUnit());
                continue;
            }
            award.setUnitNumber(null);
            award.setLeadUnit(null);
        }
    }

    public ActionForward addNewProjectPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Award award = ((AwardForm)form).getAwardDocument().getAward();
        AwardPersonUnit newPersonUnit = this.getProjectPersonnelBean(form).getNewAwardPersonUnit(this.getSelectedLine(request));
        if (newPersonUnit.isLeadUnit() && award.getLeadUnit() != null) {
            return this.confirm(this.buildSyncUnitDetailsConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_UNIT_DETAILS, ADD_SYNC_UNIT_DETAILS);
        }
        AwardPersonUnit unit = this.getProjectPersonnelBean(form).addNewProjectPersonUnit(this.getSelectedLine(request));
        if (unit != null) {
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)unit, "projectPersons", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildSyncUnitDetailsConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_UNIT_CONTACTS_KEY, "document.question.syncUnitContacts.text", new String[0]);
    }

    public ActionForward confirmSyncUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardPersonUnit unit = this.getProjectPersonnelBean(form).addNewProjectPersonUnit(this.getSelectedLine(request));
        if (unit != null) {
            AwardForm awardForm = (AwardForm)form;
            this.getUnitContactsBean((ActionForm)awardForm).syncAwardUnitContactsToLeadUnitContacts();
            this.getAward(form).syncCentralAdminContactsWithUnitAdministrators();
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)unit, "projectPersons", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addSyncUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardPersonUnit unit = this.getProjectPersonnelBean(form).addNewProjectPersonUnit(this.getSelectedLine(request));
        if (unit != null) {
            this.getAward((ActionForm)awardForm).syncCentralAdminContactsWithUnitAdministrators();
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)unit, "projectPersons", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addProjectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardPerson awardPerson = this.getProjectPersonnelBean(form).addProjectPerson();
        if (awardPerson != null) {
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)awardPerson, "projectPersons", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addSponsorContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardSponsorContact contact = this.getSponsorContactsBean(form).addSponsorContact();
        if (contact != null) {
            return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.ADD_SYNC, (PersistableBusinessObject)contact, "sponsorContacts", null, mapping.findForward("basic"));
        }
        return mapping.findForward("basic");
    }

    public ActionForward addUnitContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getUnitContactsBean(form).addUnitContact();
        return mapping.findForward("basic");
    }

    public ActionForward addCentralAdminContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.getCentralAdminContactsBean(form).addCentralAdminContact();
        return mapping.findForward("basic");
    }

    public ActionForward deleteCentralAdminContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.getCentralAdminContactsBean(form).deleteCentralAdminContact(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteProjectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardPerson awardPerson = this.getProjectPersonnelBean(form).getProjectPersonnel().get(this.getLineToDelete(request));
        this.getProjectPersonnelBean(form).deleteProjectPerson(this.getLineToDelete(request));
        return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)awardPerson, "projectPersons", null, mapping.findForward("basic"));
    }

    public ActionForward deleteProjectPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardPersonUnit unit = this.getProjectPersonnelBean(form).getProjectPersonnel().get(this.getProjectPersonIndex(request)).getUnit(this.getLineToDelete(request));
        this.getProjectPersonnelBean(form).deleteProjectPersonUnit(this.getProjectPersonIndex(request), this.getLineToDelete(request));
        return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)unit, "projectPersons", null, mapping.findForward("basic"));
    }

    public ActionForward deleteUnitContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getUnitContactsBean(form).deleteUnitContact(this.getLineToDelete(request));
        return mapping.findForward("basic");
    }

    public ActionForward deleteSponsorContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardSponsorContact contact = this.getSponsorContactsBean(form).getSponsorContacts().get(this.getLineToDelete(request));
        this.getSponsorContactsBean(form).deleteSponsorContact(this.getLineToDelete(request));
        return this.confirmSyncAction(mapping, form, request, response, AwardSyncType.DELETE_SYNC, (PersistableBusinessObject)contact, "sponsorContacts", null, mapping.findForward("basic"));
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, ServletRequest request, ServletResponse response) throws Exception {
        ActionForward actionForward = super.execute(mapping, form, request, response);
        Award award = this.getAward(form);
        return actionForward;
    }

    public ActionForward recalculateCreditSplit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.getAwardCreditSplitBean(form).recalculateCreditSplit();
        return mapping.findForward("basic");
    }

    public ActionForward syncDefaultUnitContactsToLeadUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildSyncUnitContactsConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_UNIT_CONTACTS, "");
    }

    public ActionForward syncDefaultCentralAdminContactsToLeadUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildSyncCentralAdminContactsConfirmationQuestion(mapping, form, request, response), CONFIRM_SYNC_CENTRAL_ADMIN_CONTACTS, "");
    }

    public ActionForward toggleCentralAdminContactsAutoSync(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = this.getAward((ActionForm)awardForm);
        StrutsConfirmation confirmationQuestion = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_TOGGLE_CENTRAL_ADMIN_CONTACTS_AUTO_SYNC_KEY, award.getSyncCentralAdminContacts() ? "document.question.disableSyncCentralAdminContacts.text" : "document.question.enableSyncCentralAdminContacts.text", new String[0]);
        return this.confirm(confirmationQuestion, CONFIRM_TOGGLE_CENTRAL_ADMIN_CONTACTS_AUTO_SYNC, "");
    }

    public ActionForward confirmToggleCentralAdminContactsAutoSync(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Award award;
        AwardForm awardForm = (AwardForm)form;
        award.setSyncCentralAdminContacts(!(award = this.getAward((ActionForm)awardForm)).getSyncCentralAdminContacts());
        if (award.getSyncCentralAdminContacts()) {
            award.syncCentralAdminContactsWithUnitAdministrators();
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildSyncUnitContactsConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_UNIT_CONTACTS_KEY, "document.question.syncUnitContacts.text", new String[0]);
    }

    private StrutsConfirmation buildSyncCentralAdminContactsConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SYNC_CENTRAL_ADMIN_CONTACTS_KEY, "document.question.syncCentralAdminContacts.text", new String[0]);
    }

    public ActionForward confirmSyncUnitContacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        this.getUnitContactsBean((ActionForm)awardForm).syncAwardUnitContactsToLeadUnitContacts();
        this.getAward((ActionForm)awardForm).syncCentralAdminContactsWithUnitAdministrators();
        return mapping.findForward("basic");
    }

    public ActionForward confirmSyncCentralAdminContacts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        this.getAward((ActionForm)awardForm).syncCentralAdminContactsWithUnitAdministrators();
        return mapping.findForward("basic");
    }

    protected BusinessObjectService getBusinessObjectService() {
        return KcServiceLocator.getService(BusinessObjectService.class);
    }

    private int getProjectPersonIndex(HttpServletRequest request) {
        int selectedPersonIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            selectedPersonIndex = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)PROJECT_PERSON_PREFIX, (String)LINE_SUFFIX));
        }
        return selectedPersonIndex;
    }

    private AwardCreditSplitBean getAwardCreditSplitBean(ActionForm form) {
        return ((AwardForm)form).getAwardCreditSplitBean();
    }

    private AwardProjectPersonnelBean getProjectPersonnelBean(ActionForm form) {
        return ((AwardForm)form).getProjectPersonnelBean();
    }

    private AwardSponsorContactsBean getSponsorContactsBean(ActionForm form) {
        return ((AwardForm)form).getSponsorContactsBean();
    }

    private AwardUnitContactsBean getUnitContactsBean(ActionForm form) {
        return ((AwardForm)form).getUnitContactsBean();
    }

    private AwardCentralAdminContactsBean getCentralAdminContactsBean(ActionForm form) {
        return ((AwardForm)form).getCentralAdminContactsBean();
    }

    public ActionForward syncProjectPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardPerson person = award.getProjectPerson(this.getSelectedLine(request));
        awardForm.getAwardSyncBean().addConfirmedPendingChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)person, "projectPersons");
        return mapping.findForward("basic");
    }

    public ActionForward syncProjectPersonUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardPersonUnit unit = award.getProjectPerson(this.getProjectPersonIndex(request)).getUnit(this.getSelectedLine(request));
        awardForm.getAwardSyncBean().addConfirmedPendingChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)unit, "projectPersons");
        return mapping.findForward("basic");
    }

    public ActionForward syncSponsorContact(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        Award award = awardForm.getAwardDocument().getAward();
        AwardSponsorContact contact = award.getSponsorContacts().get(this.getSelectedLine(request));
        awardForm.getAwardSyncBean().addConfirmedPendingChange(AwardSyncType.ADD_SYNC, (PersistableBusinessObject)contact, "sponsorContacts");
        return mapping.findForward("basic");
    }

    public ActionForward addUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardPerson person = awardForm.getProjectPersonnelBean().getProjectPersonnel().get(this.getSelectedLine(request));
        awardForm.getProjectPersonnelBean().addUnitDetails(person);
        return mapping.findForward("basic");
    }

    public ActionForward removeUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AwardForm awardForm = (AwardForm)form;
        AwardPerson person = awardForm.getProjectPersonnelBean().getProjectPersonnel().get(this.getSelectedLine(request));
        awardForm.getProjectPersonnelBean().removeUnitDetails(person);
        return mapping.findForward("basic");
    }
}

