/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.excon.project.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.excon.project.ExconProject;
import org.kuali.kra.excon.project.dao.ExconProjectLookupDao;
import org.kuali.kra.excon.project.document.ExconProjectDocument;
import org.kuali.kra.excon.project.document.authorization.ExconProjectDocumentAuthorizer;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.util.UrlFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ExconProjectLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 6369873655376681944L;
    @Autowired
    @Qualifier(value="exconProjectLookupDao")
    private ExconProjectLookupDao exconProjectLookupDao;
    @Autowired
    @Qualifier(value="exconProjectDocumentAuthorizer")
    private ExconProjectDocumentAuthorizer exconProjectDocumentAuthorizer;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    public boolean getSearchResultsActualSizeKnown() {
        return false;
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        super.setBackLocationDocFormKey(fieldValues);
        super.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        List<ExconProject> unfilteredSearchResults = this.getExconProjectLookupDao().getExconProjectSearchResults(fieldValues);
        CollectionIncomplete searchResults = this.filterForPermissions(unfilteredSearchResults);
        if (unfilteredSearchResults instanceof CollectionIncomplete) {
            searchResults = new CollectionIncomplete(searchResults, ((CollectionIncomplete)unfilteredSearchResults).getActualSizeIfTruncated());
        }
        return searchResults;
    }

    public List<ExconProject> filterForPermissions(List<ExconProject> results) {
        Person user = this.globalVariableService.getUserSession().getPerson();
        return results.stream().filter(p -> p != null && this.exconProjectDocumentAuthorizer.canOpen(p.getExconProjectDocument(true), user)).collect(Collectors.toList());
    }

    @Override
    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List<HtmlData> htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        htmlDataList.add((HtmlData)this.getOpenLink((ExconProject)businessObject, false));
        return htmlDataList;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(ExconProject exconProject, Boolean viewOnly) {
        ExconProjectDocument exconProjectDocument = exconProject.getExconProjectDocument();
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", viewOnly.toString());
        parameters.put("docId", exconProjectDocument.getDocumentNumber());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals("projectStartDate") && !field.getPropertyName().equals("projectEndDate")) continue;
                field.setDatePicker(true);
            }
        }
        return rows;
    }

    @Override
    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
    }

    @Override
    protected String getHtmlAction() {
        return "exconProjectHome.do";
    }

    @Override
    protected String getDocumentTypeName() {
        return "ExconProjectDocument";
    }

    @Override
    protected String getKeyFieldName() {
        return "projectId";
    }

    public ExconProjectLookupDao getExconProjectLookupDao() {
        return this.exconProjectLookupDao;
    }

    public void setExconProjectLookupDao(ExconProjectLookupDao exconProjectLookupDao) {
        this.exconProjectLookupDao = exconProjectLookupDao;
    }
}

