/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.lookup.keyvalue.FrequencyBaseCodeValuesFinder;
import org.kuali.kra.award.lookup.keyvalue.FrequencyCodeValuesFinder;
import org.kuali.kra.award.lookup.keyvalue.ReportCodeValuesFinder;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.AuditCluster;
import org.kuali.rice.krad.util.AuditError;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardReportAuditRule
implements DocumentAuditRule {
    private static final String DOT = ".";
    private static final String REPORTS_AUDIT_ERRORS = "reportsAuditErrors";
    private static final int ZERO = 0;
    private List<AuditError> auditErrors;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean emptyAwardReportTerms;
        boolean valid = true;
        AwardDocument awardDocument = (AwardDocument)document;
        this.auditErrors = new ArrayList<AuditError>();
        boolean bl = emptyAwardReportTerms = awardDocument.getAward().getAwardReportTermItems().size() == 0;
        if (emptyAwardReportTerms) {
            valid = false;
            this.addErrorToAuditErrors("error.empty.report.terms");
        }
        this.reportAndCreateAuditCluster();
        return valid &= this.processAwardReportTermAuditRules(awardDocument);
    }

    public boolean processAwardReportTermAuditRules(Document document) {
        boolean retval = true;
        int i = 0;
        AwardDocument awardDocument = (AwardDocument)document;
        for (AwardReportTerm awardReportTerm : awardDocument.getAward().getAwardReportTermItems()) {
            retval &= this.evaluateAuditRuleForReportCodeField(awardReportTerm, i);
            if (StringUtils.isNotBlank((CharSequence)awardReportTerm.getFrequencyCode())) {
                retval &= this.evaluateAuditRuleForFrequencyCodeField(awardReportTerm, i);
                retval &= this.evaluateAuditRuleForFrequencyBaseCodeField(awardReportTerm, i);
            }
            retval &= this.evaluateAuditRuleForRecipients(awardReportTerm, i);
            ++i;
        }
        return retval;
    }

    protected List<KeyValue> getReportCodes(String reportClassCode) {
        ReportCodeValuesFinder reportCodeValuesFinder = new ReportCodeValuesFinder();
        reportCodeValuesFinder.setReportClassCode(reportClassCode);
        return reportCodeValuesFinder.getKeyValues();
    }

    protected List<KeyValue> getFrequencyCodes(String reportClassCode, String reportCode) {
        FrequencyCodeValuesFinder frequencyCodeValuesFinder = new FrequencyCodeValuesFinder(reportClassCode, reportCode);
        return frequencyCodeValuesFinder.getKeyValues();
    }

    protected List<KeyValue> getFrequencyBaseCodes(String frequencyCode) {
        FrequencyBaseCodeValuesFinder frequencyBaseCodeValuesFinder = new FrequencyBaseCodeValuesFinder();
        frequencyBaseCodeValuesFinder.setFrequencyCode(frequencyCode);
        return frequencyBaseCodeValuesFinder.getKeyValues();
    }

    protected boolean isValidFrequencyBase(AwardReportTerm awardReportTerm, List<KeyValue> frequencyBaseCodes) {
        boolean isValid = false;
        for (KeyValue KeyValue2 : frequencyBaseCodes) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)KeyValue2.getKey().toString(), (CharSequence)awardReportTerm.getFrequencyBaseCode())) continue;
            isValid = true;
        }
        return isValid;
    }

    protected boolean isValidReportCode(AwardReportTerm awardReportTerm, List<KeyValue> reportCodes) {
        boolean isValid = false;
        for (KeyValue KeyValue2 : reportCodes) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)KeyValue2.getKey().toString(), (CharSequence)awardReportTerm.getReportCode())) continue;
            isValid = true;
        }
        return isValid;
    }

    protected boolean evaluateAuditRuleForReportCodeField(AwardReportTerm awardReportTerm, int index) {
        boolean retval = this.isValidReportCode(awardReportTerm, this.getReportCodes(awardReportTerm.getReportClassCode()));
        if (!retval) {
            this.addErrorToAuditErrors("error.invalid.type.for.reportClass");
        }
        return retval;
    }

    protected boolean isValidFrequency(AwardReportTerm awardReportTerm, List<KeyValue> frequencyCodes) {
        boolean isValid = false;
        for (KeyValue KeyValue2 : frequencyCodes) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)KeyValue2.getKey().toString(), (CharSequence)awardReportTerm.getFrequencyCode())) continue;
            isValid = true;
        }
        return isValid;
    }

    protected boolean evaluateAuditRuleForFrequencyCodeField(AwardReportTerm awardReportTerm, int index) {
        boolean retval = this.isValidFrequency(awardReportTerm, this.getFrequencyCodes(awardReportTerm.getReportClassCode(), awardReportTerm.getReportCode()));
        if (!retval) {
            this.addErrorToAuditErrors("error.invalid.frequency.for.reportClass.and.type");
        }
        return retval;
    }

    protected boolean evaluateAuditRuleForFrequencyBaseCodeField(AwardReportTerm awardReportTerm, int index) {
        boolean retval = this.isValidFrequencyBase(awardReportTerm, this.getFrequencyBaseCodes(awardReportTerm.getFrequencyCode()));
        if (!retval) {
            this.addErrorToAuditErrors("error.invalid.frequencyBase.for.frequency");
        }
        return retval;
    }

    protected boolean evaluateAuditRuleForRecipients(AwardReportTerm awardReportTerm, int index) {
        boolean isValid = true;
        List<AwardReportTermRecipient> recipients = awardReportTerm.getAwardReportTermRecipients();
        for (int i = 0; i < recipients.size(); ++i) {
            AwardReportTermRecipient recipient = recipients.get(i);
            if (recipient.getRolodexId() != null) continue;
            this.addErrorToAuditErrors("error.required.organization", new String[]{Integer.valueOf(i + 1).toString()});
            isValid = false;
        }
        return isValid;
    }

    protected void addErrorToAuditErrors(String errorKey, String[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append("paymentReportsAndTerms");
        sb.append(DOT);
        sb.append("Reports");
        if (params != null && params.length > 0) {
            this.auditErrors.add(new AuditError("document.reportTermsAuditRules", errorKey, sb.toString(), params));
        } else {
            this.auditErrors.add(new AuditError("document.reportTermsAuditRules", errorKey, sb.toString()));
        }
    }

    protected void addErrorToAuditErrors(String errorKey) {
        this.addErrorToAuditErrors(errorKey, null);
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            GlobalVariables.getAuditErrorMap().put(REPORTS_AUDIT_ERRORS, new AuditCluster("Reports", this.auditErrors, "Error"));
        }
    }
}

