/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.core;

import java.util.HashSet;
import java.util.Set;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.workflow.KcWorkflowService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.DocumentRequestAuthorizationCache;
import org.kuali.rice.krad.document.TransactionalDocumentViewPresentationControllerBase;
import org.kuali.rice.krad.uif.view.View;
import org.kuali.rice.krad.web.form.DocumentFormBase;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service(value="proposalDevelopmentDocumentViewPresentationController")
@Scope(value="prototype")
public class ProposalDevelopmentDocumentViewPresentationController
extends TransactionalDocumentViewPresentationControllerBase {
    private static final long serialVersionUID = 1L;
    @Autowired
    @Qualifier(value="kcWorkflowService")
    private KcWorkflowService kcWorkflowService;
    @Autowired
    @Qualifier(value="proposalDevelopmentService")
    private ProposalDevelopmentService proposalDevelopmentService;

    public Set<String> getActionFlags(View view, UifFormBase model) {
        Set documentActions = super.getActionFlags(view, model);
        Set set = documentActions = documentActions != null ? documentActions : new HashSet();
        if (this.canDeleteDocument(((DocumentFormBase)model).getDocument())) {
            documentActions.add("deleteDocument");
        }
        if (this.canSubmitToS2S(((DocumentFormBase)model).getDocument())) {
            documentActions.add("submitToS2S");
        }
        if (this.canSubmitToSponsor(((DocumentFormBase)model).getDocument())) {
            documentActions.add("submitToSponsor");
        }
        return documentActions;
    }

    public boolean canDeleteDocument(Document doc) {
        return !this.getKcWorkflowService().isInWorkflow(doc);
    }

    public boolean canSubmitToS2S(Document doc) {
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(doc).getWorkflowDocumentInfo();
        boolean canSubmitToS2s = workflowDocumentInfo.isProcessed() || workflowDocumentInfo.isFinal() || workflowDocumentInfo.isEnroute();
        DevelopmentProposal developmentProposal = ((ProposalDevelopmentDocument)doc).getDevelopmentProposal();
        return canSubmitToS2s &= developmentProposal.hasS2sOpportunity() && (developmentProposal.getS2sAppSubmission() == null || developmentProposal.getS2sAppSubmission().size() == 0);
    }

    public boolean canSubmitToSponsor(Document doc) {
        DocumentRequestAuthorizationCache.WorkflowDocumentInfo workflowDocumentInfo = this.getDocumentRequestAuthorizationCache(doc).getWorkflowDocumentInfo();
        boolean canSubmitToSponsor = workflowDocumentInfo.isProcessed() || workflowDocumentInfo.isFinal() || workflowDocumentInfo.isEnroute();
        canSubmitToSponsor &= this.getProposalDevelopmentService().autogenerateInstitutionalProposal();
        return canSubmitToSponsor &= ((ProposalDevelopmentDocument)doc).getDevelopmentProposal().getSubmitFlag() == false;
    }

    public KcWorkflowService getKcWorkflowService() {
        if (this.kcWorkflowService == null) {
            this.kcWorkflowService = KcServiceLocator.getService(KcWorkflowService.class);
        }
        return this.kcWorkflowService;
    }

    public void setKcWorkflowService(KcWorkflowService kcWorkflowService) {
        this.kcWorkflowService = kcWorkflowService;
    }

    public ProposalDevelopmentService getProposalDevelopmentService() {
        return this.proposalDevelopmentService;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }
}

