/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.kuali.coeus.common.api.pdf.CommonPdfService;
import org.kuali.coeus.common.api.pdf.dto.AcroFormFlattenActionDto;
import org.kuali.coeus.common.api.pdf.dto.AcroFormPutActionDto;
import org.kuali.coeus.common.api.pdf.dto.JobDto;
import org.kuali.coeus.common.api.pdf.dto.LinkDto;
import org.kuali.coeus.common.api.pdf.dto.MapActionDto;
import org.kuali.coeus.common.framework.pdf.forms.PdfForms;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.kra.award.printing.AwardPdfFormBean;
import org.kuali.kra.award.printing.service.AwardPdfPrintingService;
import org.springframework.http.HttpMethod;

public class AwardPdfPrintingServiceImpl
implements AwardPdfPrintingService {
    private CommonPdfService commonPdfService;

    @Override
    public List<AttachmentDataSource> print(AwardPdfFormBean pdfBean) {
        if (pdfBean.getAwardId() == null) {
            throw new PrintingException("Award ID is required");
        }
        return this.getCommonPdfService().submit(pdfBean.getSelectedForms(), (pdfForms, jobDto) -> this.addActions((PdfForms)pdfForms, pdfBean, (JobDto)jobDto));
    }

    private String addActions(PdfForms form, AwardPdfFormBean pdfBean, JobDto job) {
        String finalActionId;
        if (form.getPdfFormFile() == null || form.getMappingFile() == null) {
            throw new PrintingException("Printing " + String.valueOf(form) + " requires a pdf form and mapping file");
        }
        MapActionDto mapAction = new MapActionDto().inputSources(Map.of("award", this.createAwardLink(pdfBean), "topUnit", this.getCommonPdfService().createTopUnit())).mappingSource(this.getCommonPdfService().createMappingsLink(form.getMappingFile())).actionId("map" + form.getId());
        LinkDto fieldActionSource = new LinkDto().url("action://{$jobId}/map" + form.getId() + "/0");
        AcroFormPutActionDto acroFormPutAction = new AcroFormPutActionDto().fieldActions(Collections.emptyMap()).source(this.getCommonPdfService().createPdfFormLink(form.getPdfFormFile())).fieldActionSource(fieldActionSource).actionId("acroFormPut" + form.getId());
        if (pdfBean.isReadOnly()) {
            LinkDto flattenSource = new LinkDto().url("action://{$jobId}/acroFormPut" + form.getId() + "/0");
            AcroFormFlattenActionDto flattenAction = new AcroFormFlattenActionDto().source(flattenSource).actionId("flatten" + form.getId());
            finalActionId = flattenAction.getActionId();
            job.addActionsItem(mapAction).addActionsItem(acroFormPutAction).addActionsItem(flattenAction);
        } else {
            finalActionId = acroFormPutAction.getActionId();
            job.addActionsItem(mapAction).addActionsItem(acroFormPutAction);
        }
        return finalActionId;
    }

    private LinkDto createAwardLink(AwardPdfFormBean pdfBean) {
        return new LinkDto().url(this.getCommonPdfService().getApplicationUrl() + "/award/api/v2/awards/" + pdfBean.getAwardId() + "?includeBudgets=true").method(HttpMethod.GET.name()).addHeader("Authorization", this.getCommonPdfService().getAuthToken()).addHeader("Content-Type", "application/json");
    }

    public CommonPdfService getCommonPdfService() {
        return this.commonPdfService;
    }

    public void setCommonPdfService(CommonPdfService commonPdfService) {
        this.commonPdfService = commonPdfService;
    }
}

