/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.impl.rate;

import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.kuali.coeus.common.budget.impl.rate.UnitFormulatedCost;
import org.kuali.coeus.sys.framework.rule.KcMaintenanceDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.krad.service.BusinessObjectService;

public class UnitFormulatedCostRule
extends KcMaintenanceDocumentRuleBase {
    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        return this.checkForUnitCostExistence(document);
    }

    private boolean checkForUnitCostExistence(MaintenanceDocument maintenanceDocument) {
        UnitFormulatedCost newCost = (UnitFormulatedCost)maintenanceDocument.getNewMaintainableObject().getDataObject();
        BusinessObjectService businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("formulatedTypeCode", newCost.getFormulatedTypeCode());
        values.put("unitNumber", newCost.getUnitNumber());
        List costs = businessObjectService.findMatching(UnitFormulatedCost.class, values);
        for (UnitFormulatedCost cost : costs) {
            if (Objects.equals(newCost.getUnitFormulatedCostId(), cost.getUnitFormulatedCostId())) continue;
            ErrorReporter errorReporter = KcServiceLocator.getService(ErrorReporter.class);
            errorReporter.reportError("document.newMaintainableObject.formulatedTypeCode", "error.invalid.budget.formulated.duplicate", new String[0]);
            return false;
        }
        return true;
    }
}

