/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.budget.framework.distribution;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.kuali.coeus.common.budget.api.distribution.BudgetCostShareContract;
import org.kuali.coeus.common.budget.framework.core.Budget;
import org.kuali.coeus.common.budget.framework.core.CostShare;
import org.kuali.coeus.common.framework.unit.Unit;
import org.kuali.coeus.propdev.impl.hierarchy.HierarchyMaintainable;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.model.KcPersistableBusinessObjectBase;
import org.kuali.coeus.sys.framework.persistence.ScaleTwoDecimalConverter;
import org.kuali.kra.bo.CostShareType;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

@Entity
@Table(name="EPS_PROP_COST_SHARING")
@IdClass(value=BudgetCostShareId.class)
public class BudgetCostShare
extends KcPersistableBusinessObjectBase
implements HierarchyMaintainable,
BudgetCostShareContract,
CostShare {
    private static final long serialVersionUID = 6199797319981907016L;
    public static final String DOCUMENT_COMPONENT_ID_KEY = "BUDGET_COST_SHARE_KEY";
    @Id
    @Column(name="COST_SHARE_ID")
    private Integer documentComponentId;
    @Id
    @Column(name="BUDGET_ID", insertable=false, updatable=false)
    private Long budgetId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BUDGET_ID", referencedColumnName="BUDGET_ID")
    private Budget budget;
    @Column(name="PROJECT_PERIOD")
    private Integer projectPeriod;
    @Column(name="AMOUNT")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal shareAmount;
    @Column(name="COST_SHARING_PERCENTAGE")
    @Convert(converter=ScaleTwoDecimalConverter.class)
    private ScaleTwoDecimal sharePercentage;
    @Column(name="SOURCE_ACCOUNT")
    private String sourceAccount;
    @Column(name="HIERARCHY_PROPOSAL_NUMBER")
    private String hierarchyProposalNumber;
    @Column(name="HIDE_IN_HIERARCHY")
    @Convert(converter=BooleanYNConverter.class)
    private boolean hiddenInHierarchy;
    @Column(name="UNIT_NUMBER")
    private String unitNumber;
    @ManyToOne(targetEntity=Unit.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="UNIT_NUMBER", referencedColumnName="UNIT_NUMBER", insertable=false, updatable=false)
    private Unit unit;
    @Column(name="COST_SHARE_TYPE_CODE")
    private Integer costShareTypeCode;
    @ManyToOne(targetEntity=CostShareType.class, cascade={CascadeType.REFRESH})
    @JoinColumn(name="COST_SHARE_TYPE_CODE", referencedColumnName="COST_SHARE_TYPE_CODE", insertable=false, updatable=false)
    private CostShareType costShareType;

    public BudgetCostShare() {
    }

    public BudgetCostShare(Integer projectPeriod, ScaleTwoDecimal shareAmount, ScaleTwoDecimal sharePercentage, String sourceAccount) {
        this();
        this.projectPeriod = projectPeriod;
        this.sharePercentage = sharePercentage;
        this.shareAmount = shareAmount;
        this.sourceAccount = sourceAccount;
    }

    public Integer getDocumentComponentId() {
        return this.documentComponentId;
    }

    public void setDocumentComponentId(Integer costShareId) {
        this.documentComponentId = costShareId;
    }

    public Long getBudgetId() {
        return this.budgetId;
    }

    public void setBudgetId(Long budgetId) {
        this.budgetId = budgetId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BudgetCostShare)) {
            return false;
        }
        BudgetCostShare other = (BudgetCostShare)obj;
        if (this.projectPeriod == null ? other.projectPeriod != null : !this.projectPeriod.equals(other.projectPeriod)) {
            return false;
        }
        if (this.shareAmount == null ? other.shareAmount != null : !this.shareAmount.equals((Object)other.shareAmount)) {
            return false;
        }
        return !(this.sourceAccount == null ? other.sourceAccount != null : !this.sourceAccount.equals(other.sourceAccount));
    }

    public String getDocumentComponentIdKey() {
        return DOCUMENT_COMPONENT_ID_KEY;
    }

    public Integer getProjectPeriod() {
        return this.projectPeriod;
    }

    public ScaleTwoDecimal getShareAmount() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.shareAmount);
    }

    public ScaleTwoDecimal getSharePercentage() {
        return ScaleTwoDecimal.returnZeroIfNull((ScaleTwoDecimal)this.sharePercentage);
    }

    @Override
    public String getSourceAccount() {
        return this.sourceAccount;
    }

    @Override
    public Integer getCostShareTypeCode() {
        return this.costShareTypeCode;
    }

    @Override
    public CostShareType getCostShareType() {
        return this.costShareType;
    }

    public void setCostShareTypeCode(Integer costShareTypeCode) {
        this.costShareTypeCode = costShareTypeCode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.projectPeriod == null ? 0 : this.projectPeriod.hashCode());
        result = 31 * result + (this.shareAmount == null ? 0 : this.shareAmount.hashCode());
        result = 31 * result + (this.sourceAccount == null ? 0 : this.sourceAccount.hashCode());
        return result;
    }

    public void setProjectPeriod(Integer projectPeriod) {
        this.projectPeriod = projectPeriod;
    }

    public void setShareAmount(ScaleTwoDecimal shareAmount) {
        this.shareAmount = shareAmount;
    }

    public void setSharePercentage(ScaleTwoDecimal sharePercentage) {
        this.sharePercentage = sharePercentage;
    }

    public void setSourceAccount(String sourceAcocunt) {
        this.sourceAccount = sourceAcocunt;
    }

    public String getHierarchyProposalNumber() {
        return this.hierarchyProposalNumber;
    }

    @Override
    public void setHierarchyProposalNumber(String hierarchyProposalNumber) {
        this.hierarchyProposalNumber = hierarchyProposalNumber;
    }

    public boolean isHiddenInHierarchy() {
        return this.hiddenInHierarchy;
    }

    @Override
    public void setHiddenInHierarchy(boolean hiddenInHierarchy) {
        this.hiddenInHierarchy = hiddenInHierarchy;
    }

    public String getUnitNumber() {
        return this.unitNumber;
    }

    public void setUnitNumber(String unitNumber) {
        this.unitNumber = unitNumber;
    }

    public Unit getUnit() {
        if (this.unit == null && StringUtils.isNotBlank((CharSequence)this.getUnitNumber()) || this.unit != null && !this.unit.getUnitNumber().equals(this.getUnitNumber())) {
            this.refreshReferenceObject("unit");
        }
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getUnitName() {
        Unit unit = this.getUnit();
        return unit != null ? unit.getUnitName() : null;
    }

    public void setCostShareType(CostShareType costShareType) {
        this.costShareType = costShareType;
    }

    public Budget getBudget() {
        return this.budget;
    }

    public void setBudget(Budget budget) {
        this.budget = budget;
        this.budgetId = budget != null ? budget.getBudgetId() : null;
    }

    public static final class BudgetCostShareId
    implements Serializable,
    Comparable<BudgetCostShareId> {
        private Integer documentComponentId;
        private Long budgetId;

        public Integer getDocumentComponentId() {
            return this.documentComponentId;
        }

        public void setDocumentComponentId(Integer documentComponentId) {
            this.documentComponentId = documentComponentId;
        }

        public Long getBudgetId() {
            return this.budgetId;
        }

        public void setBudgetId(Long budgetId) {
            this.budgetId = budgetId;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("budgetId", (Object)this.budgetId).append("documentComponentId", (Object)this.documentComponentId).toString();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            BudgetCostShareId rhs = (BudgetCostShareId)other;
            return new EqualsBuilder().append((Object)this.budgetId, (Object)rhs.budgetId).append((Object)this.documentComponentId, (Object)rhs.documentComponentId).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.budgetId).append((Object)this.documentComponentId).toHashCode();
        }

        @Override
        public int compareTo(BudgetCostShareId other) {
            return new CompareToBuilder().append((Object)this.budgetId, (Object)other.budgetId).append((Object)this.documentComponentId, (Object)other.documentComponentId).toComparison();
        }
    }
}

