/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.kuali.coeus.common.framework.print.stream.xml.XmlStream;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.printing.schema.AwardNoticeDocument;
import org.kuali.kra.printing.schema.AwardTransactionType;
import org.kuali.kra.printing.schema.AwardType;
import org.kuali.kra.printing.schema.SchoolInfoType2;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class AwardBudgetBaseStream
implements XmlStream<AwardNoticeDocument> {
    protected BusinessObjectService businessObjectService = null;
    protected DateTimeService dateTimeService = null;
    private static final String SCHOOL_NAME = "SCHOOL_NAME";
    private static final String SCHOOL_ACRONYM = "SCHOOL_ACRONYM";
    protected static final String DOCUMENT_NUMBER = "documentNumber";
    private ParameterService parameterService;

    @Override
    public Class<AwardNoticeDocument> type() {
        return AwardNoticeDocument.class;
    }

    protected AwardType.AwardTransactionInfo getAwardTransactiontInfo(Award award) {
        ArrayList<AwardTransactionType> awardTransactionTypeList = new ArrayList<AwardTransactionType>();
        AwardType.AwardTransactionInfo awardTransactionInfo = (AwardType.AwardTransactionInfo)AwardType.AwardTransactionInfo.Factory.newInstance();
        for (AwardAmountInfo awardAmount : award.getAwardAmountInfos()) {
            AwardAmountTransaction awardAmountTransaction = this.getAwardAmountTransaction(awardAmount.getTimeAndMoneyDocumentNumber());
            if (awardAmountTransaction == null) continue;
            AwardTransactionType awardTransactionType = (AwardTransactionType)AwardTransactionType.Factory.newInstance();
            this.setAwardAmountTransaction(awardTransactionType, awardAmountTransaction);
            awardTransactionTypeList.add(awardTransactionType);
            break;
        }
        awardTransactionInfo.setTransactionInfoArray(awardTransactionTypeList.toArray(new AwardTransactionType[0]));
        return awardTransactionInfo;
    }

    private String getProposalParameterValue(String param) {
        return this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, param);
    }

    private void setAwardAmountTransaction(AwardTransactionType awardTransactionType, AwardAmountTransaction awardAmountTransaction) {
        if (awardAmountTransaction.getAwardNumber() != null) {
            awardTransactionType.setAwardNumber(awardAmountTransaction.getAwardNumber());
        }
        if (awardAmountTransaction.getTransactionTypeCode() != null) {
            awardTransactionType.setTransactionTypeCode(awardAmountTransaction.getTransactionTypeCode());
        }
        if (awardAmountTransaction.getAuthorPersonName() != null) {
            awardTransactionType.setTransactionTypeDesc(awardAmountTransaction.getAwardTransactionType().getDescription());
        }
        if (awardAmountTransaction.getComments() != null) {
            awardTransactionType.setComments(awardAmountTransaction.getComments());
        }
        if (awardAmountTransaction.getNoticeDate() != null) {
            awardTransactionType.setNoticeDate(this.dateTimeService.getCalendar((Date)awardAmountTransaction.getNoticeDate()));
        }
    }

    private AwardAmountTransaction getAwardAmountTransaction(String timeAndMoneyDocNumber) {
        TimeAndMoneyDocument timeAndMoneyDocument;
        List<AwardAmountTransaction> awardAmountTransactionList;
        AwardAmountTransaction awardAmountTransaction = null;
        HashMap<String, String> timeAndMoneyMap = new HashMap<String, String>();
        timeAndMoneyMap.put(DOCUMENT_NUMBER, timeAndMoneyDocNumber);
        List timeAndMoneyDocs = this.businessObjectService.findMatching(TimeAndMoneyDocument.class, timeAndMoneyMap);
        if (timeAndMoneyDocs != null && !timeAndMoneyDocs.isEmpty() && (awardAmountTransactionList = (timeAndMoneyDocument = (TimeAndMoneyDocument)timeAndMoneyDocs.get(0)).getAwardAmountTransactions()) != null && !awardAmountTransactionList.isEmpty()) {
            awardAmountTransaction = awardAmountTransactionList.get(0);
        }
        return awardAmountTransaction;
    }

    protected SchoolInfoType2 getSchoolInfoType() {
        SchoolInfoType2 schoolInfoType = (SchoolInfoType2)SchoolInfoType2.Factory.newInstance();
        String schoolName = this.getAwardParameterValue(SCHOOL_NAME);
        String schoolAcronym = this.getProposalParameterValue(SCHOOL_ACRONYM);
        if (schoolName != null) {
            schoolInfoType.setSchoolName(schoolName);
        }
        if (schoolAcronym != null) {
            schoolInfoType.setAcronym(schoolAcronym);
        }
        return schoolInfoType;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    private String getAwardParameterValue(String param) {
        return this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, param);
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

