/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.ruleengine;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRule;
import org.kuali.coeus.common.framework.ruleengine.KcBusinessRulesEngine;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class KcBusinessRulesHandler
implements ApplicationContextAware,
InitializingBean,
BeanNameAware {
    private static final Logger LOG = LogManager.getLogger(KcBusinessRulesHandler.class);
    private ApplicationContext applicationContext;
    private String beanName;
    @Autowired
    @Qualifier(value="kcBusinessRulesEngine")
    private KcBusinessRulesEngine kcBusinessRulesEngine;

    public void afterPropertiesSet() {
        Map businessRules = this.applicationContext.getBeansWithAnnotation(KcBusinessRule.class);
        for (Map.Entry entry : businessRules.entrySet()) {
            this.kcBusinessRulesEngine.registerBusinessRuleClass((String)entry.getKey(), entry.getValue());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Rule Events Registered for handler: " + this.beanName + " " + this.kcBusinessRulesEngine.getRuleInfo());
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public KcBusinessRulesEngine getKcBusinessRulesEngine() {
        return this.kcBusinessRulesEngine;
    }

    public void setKcBusinessRulesEngine(KcBusinessRulesEngine kcBusinessRulesEngine) {
        this.kcBusinessRulesEngine = kcBusinessRulesEngine;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }
}

