/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.model.KcTransactionalDocumentBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

@ParameterConstants.NAMESPACE(namespace="KC-PROTOCOL")
@ParameterConstants.COMPONENT(component="Document")
public abstract class ProtocolOnlineReviewDocumentBase
extends KcTransactionalDocumentBase
implements Copyable,
SessionDocument {
    private static final String DOCUMENT_TYPE_CODE = "PTRV";
    private static final String OLR_DOC_ID_PARAM = "olrDocId";
    private static final String OLR_EVENT_PARAM = "olrEvent";
    private static final long serialVersionUID = 803158468103165087L;

    @Override
    public void initialize() {
        super.initialize();
    }

    public abstract ProtocolOnlineReviewBase getProtocolOnlineReview();

    public abstract void setProtocolOnlineReview(ProtocolOnlineReviewBase var1);

    @Override
    protected List<RolePersons> getAllRolePersons() {
        return new ArrayList<RolePersons>();
    }

    @Override
    public String getDocumentTypeCode() {
        return DOCUMENT_TYPE_CODE;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        this.executeAsLastActionUser(() -> {
            super.doRouteStatusChange(statusChangeEvent);
            return null;
        });
    }

    public void doActionTaken(ActionTakenEvent event) {
        this.executeAsLastActionUser(() -> {
            super.doActionTaken(event);
            return null;
        });
    }

    public void prepareForSave() {
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
    }

    @Override
    public boolean isProcessComplete() {
        boolean isComplete = true;
        String backLocation = (String)GlobalVariables.getUserSession().retrieveObject("holdingPageReturnLocation");
        String olrDocId = this.getURLParamValue(backLocation, OLR_DOC_ID_PARAM);
        if (olrDocId != null) {
            String olrEvent = this.getURLParamValue(backLocation, OLR_EVENT_PARAM);
            if (StringUtils.equalsIgnoreCase((CharSequence)olrEvent, (CharSequence)"Approve")) {
                isComplete = this.isOnlineReviewApproveComplete(olrDocId);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)olrEvent, (CharSequence)"Return")) {
                isComplete = this.isOnlineReviewRejectComplete(olrDocId);
            }
        }
        return isComplete;
    }

    private WorkflowDocumentService getWorkflowDocumentService() {
        return KRADServiceLocatorWeb.getWorkflowDocumentService();
    }

    private boolean isOnlineReviewApproveComplete(String olrDocId) {
        boolean isComplete = true;
        try {
            ProtocolOnlineReviewDocumentBase onlineReviewDoc = (ProtocolOnlineReviewDocumentBase)this.getDocumentService().getByDocumentHeaderId(olrDocId);
            if (this.getWorkflowDocumentService().getCurrentRouteNodeNames(onlineReviewDoc.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("OnlineReviewer")) {
                isComplete = false;
            }
        }
        catch (Exception e) {
            isComplete = true;
        }
        return isComplete;
    }

    private boolean isOnlineReviewRejectComplete(String olrDocId) {
        boolean isComplete = true;
        try {
            ProtocolOnlineReviewDocumentBase onlineReviewDoc = (ProtocolOnlineReviewDocumentBase)this.getDocumentService().getByDocumentHeaderId(olrDocId);
            if (!this.getWorkflowDocumentService().getCurrentRouteNodeNames(onlineReviewDoc.getDocumentHeader().getWorkflowDocument()).equalsIgnoreCase("OnlineReviewer")) {
                isComplete = false;
            }
        }
        catch (Exception e) {
            isComplete = true;
        }
        return isComplete;
    }

    private DocumentService getDocumentService() {
        return KcServiceLocator.getService(DocumentService.class);
    }

    private String getURLParamValue(String url, String paramName) {
        String paramString;
        String pValue = null;
        if (StringUtils.isNotBlank((CharSequence)url) && url.contains("?") && StringUtils.isNotBlank((CharSequence)(paramString = url.substring(url.indexOf("?") + 1)))) {
            String[] params;
            for (String param : params = paramString.split("&")) {
                String[] temp = param.split("=");
                if (!StringUtils.equals((CharSequence)temp[0], (CharSequence)paramName)) continue;
                pValue = temp[1];
            }
        }
        return pValue;
    }
}

