/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.kuali.coeus.common.framework.person.KcPerson;
import org.kuali.coeus.common.framework.person.KcPersonService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentStatusBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ProtocolAttachmentProtocolBase
extends ProtocolAttachmentBase
implements MutableInactivatable {
    private static final long serialVersionUID = -7115904344245464654L;
    public static final String INCOMPLETE_STATUS_CODE = "2";
    public static final String COMPLETE_STATUS_CODE = "1";
    protected String statusCode;
    protected ProtocolAttachmentStatusBase status;
    protected String contactName;
    protected String contactEmailAddress;
    protected String contactPhoneNumber;
    protected String comments;
    protected String typeCode;
    protected ProtocolAttachmentTypeBase type;
    protected String description;
    protected String documentStatusCode;
    protected Integer attachmentVersion = 1;
    protected Timestamp createTimestamp;
    protected List<ProtocolAttachmentProtocolBase> versions;
    protected boolean active = true;
    protected boolean changed = false;
    private transient KcPersonService kcPersonService;

    protected ProtocolAttachmentProtocolBase() {
    }

    protected ProtocolAttachmentProtocolBase(ProtocolBase protocol) {
        super(protocol);
    }

    public ProtocolAttachmentStatusBase getStatus() {
        return this.status;
    }

    public void setStatus(ProtocolAttachmentStatusBase status) {
        this.status = status;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getContactEmailAddress() {
        return this.contactEmailAddress;
    }

    public void setContactEmailAddress(String contactEmailAddress) {
        this.contactEmailAddress = contactEmailAddress;
    }

    public String getContactPhoneNumber() {
        return this.contactPhoneNumber;
    }

    public void setContactPhoneNumber(String contactPhoneNumber) {
        this.contactPhoneNumber = contactPhoneNumber;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public ProtocolAttachmentTypeBase getType() {
        return this.type;
    }

    @Override
    public void setType(ProtocolAttachmentTypeBase type) {
        this.type = type;
    }

    @Override
    public String getTypeCode() {
        return this.typeCode;
    }

    @Override
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    @Override
    public abstract String getGroupCode();

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public abstract String getAttachmentDescription();

    public List<ProtocolAttachmentProtocolBase> getVersions() {
        if (this.versions == null) {
            this.versions = new ArrayList<ProtocolAttachmentProtocolBase>();
        }
        this.versions.clear();
        for (ProtocolAttachmentProtocolBase attachment : this.getProtocol().getAttachmentProtocols()) {
            if (!attachment.getDocumentId().equals(this.getDocumentId())) continue;
            this.versions.add(attachment);
        }
        if (this.versions.size() == 1) {
            this.versions.clear();
        }
        this.versions.sort((attachment1, attachment2) -> attachment2.getUpdateTimestamp().compareTo(attachment1.getUpdateTimestamp()));
        return this.versions;
    }

    public void setVersions(List<ProtocolAttachmentProtocolBase> versions) {
        this.versions = versions;
    }

    @Override
    public boolean supportsVersioning() {
        return true;
    }

    public abstract boolean isDraft();

    public abstract void setDraft();

    public abstract boolean isFinal();

    public abstract void setFinal();

    public abstract boolean isDeleted();

    public abstract void setDeleted();

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.comments == null ? 0 : this.comments.hashCode());
        result = 31 * result + (this.contactEmailAddress == null ? 0 : this.contactEmailAddress.hashCode());
        result = 31 * result + (this.contactName == null ? 0 : this.contactName.hashCode());
        result = 31 * result + (this.contactPhoneNumber == null ? 0 : this.contactPhoneNumber.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.statusCode == null ? 0 : this.statusCode.hashCode());
        result = 31 * result + (this.typeCode == null ? 0 : this.typeCode.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolAttachmentProtocolBase other = (ProtocolAttachmentProtocolBase)obj;
        if (this.comments == null ? other.comments != null : !this.comments.equals(other.comments)) {
            return false;
        }
        if (this.contactEmailAddress == null ? other.contactEmailAddress != null : !this.contactEmailAddress.equals(other.contactEmailAddress)) {
            return false;
        }
        if (this.contactName == null ? other.contactName != null : !this.contactName.equals(other.contactName)) {
            return false;
        }
        if (this.contactPhoneNumber == null ? other.contactPhoneNumber != null : !this.contactPhoneNumber.equals(other.contactPhoneNumber)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.statusCode == null ? other.statusCode != null : !this.statusCode.equals(other.statusCode)) {
            return false;
        }
        return !(this.typeCode == null ? other.typeCode != null : !this.typeCode.equals(other.typeCode));
    }

    public String getDocumentStatusCode() {
        return this.documentStatusCode;
    }

    public void setDocumentStatusCode(String documentStatusCode) {
        this.documentStatusCode = documentStatusCode;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public void setUpdateTimestamp(Timestamp updateTimestamp) {
        if (this.getDocumentStatusCode() == null || updateTimestamp == null || this.getUpdateTimestamp() == null || this.isAttachmentUpdated()) {
            super.setUpdateTimestamp(updateTimestamp);
            this.setChanged(false);
        }
    }

    @Override
    public void setUpdateUser(String updateUser) {
        if (this.getDocumentStatusCode() == null || updateUser == null || this.getUpdateUser() == null || this.isAttachmentUpdated()) {
            super.setUpdateUser(updateUser);
        }
    }

    private boolean isAttachmentUpdated() {
        return (this.isDraft() || this.isDeleted()) && this.isChanged();
    }

    public Integer getAttachmentVersion() {
        return this.attachmentVersion;
    }

    public void setAttachmentVersion(Integer attachmentVersion) {
        this.attachmentVersion = attachmentVersion;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public Timestamp getCreateTimestamp() {
        return this.createTimestamp;
    }

    public void setCreateTimestamp(Timestamp createTimestamp) {
        if (this.getCreateTimestamp() == null || createTimestamp == null) {
            this.createTimestamp = createTimestamp;
        }
    }

    @Override
    protected void prePersist() {
        super.prePersist();
        if (this.getCreateTimestamp() == null) {
            this.setCreateTimestamp(((DateTimeService)KcServiceLocator.getService("dateTimeService")).getCurrentTimestamp());
        }
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = KcServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public String getAuthorPersonName() {
        KcPerson person = this.getKcPersonService().getKcPersonByUserName(this.getUpdateUser());
        return ObjectUtils.isNull((Object)person) ? "Person not found" : person.getFullName();
    }

    public static enum PropertyName {
        COMMENTS("comments"),
        EMAIL("contactEmailAddress"),
        CONTACT_NAME("contactName"),
        PHONE("contactPhoneNumber"),
        STATUS_CODE("statusCode"),
        DOCUMENT_STATUS_CODE("documentStatusCode"),
        ATTACHMENT_VERSION("attachmentVersion"),
        CREATE_TIMESTAMP("createTimestamp");

        private final String name;

        private PropertyName(String name) {
            this.name = name;
        }

        public String getPropertyName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

