/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.location;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.org.Organization;
import org.kuali.coeus.common.framework.org.OrganizationService;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.protocol.location.AddProtocolLocationEvent;
import org.kuali.kra.protocol.protocol.location.AddProtocolLocationRule;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;

public abstract class ProtocolLocationRuleBase
extends KcTransactionalDocumentRuleBase
implements AddProtocolLocationRule {
    private static final String ERROR_PROPERTY_ORGANIZATION_ID = "protocolHelper.newProtocolLocation.organizationId";
    private static final String ERROR_PROPERTY_ORGANIZATION_TYPE_CODE = "protocolHelper.newProtocolLocation.protocolOrganizationTypeCode";

    @Override
    public boolean processAddProtocolLocationBusinessRules(AddProtocolLocationEvent addProtocolLocationEvent) {
        boolean isValid = true;
        String organizationId = addProtocolLocationEvent.getProtocolLocation().getOrganizationId();
        if (StringUtils.isBlank((CharSequence)organizationId)) {
            isValid = false;
            this.reportError(ERROR_PROPERTY_ORGANIZATION_ID, "error.protocolLocation.organizationId.notFound", new String[0]);
        } else if (this.isInvalidOrganizationId(organizationId)) {
            isValid = false;
            this.reportError(ERROR_PROPERTY_ORGANIZATION_ID, "error.protocolLocation.organizationId.invalid", new String[0]);
        } else if (this.isDuplicate((ProtocolDocumentBase)addProtocolLocationEvent.getDocument(), organizationId)) {
            isValid = false;
            this.reportError(ERROR_PROPERTY_ORGANIZATION_ID, "error.protocolLocation.organizationId.duplicate", new String[0]);
        }
        String organizationTypeCode = addProtocolLocationEvent.getProtocolLocation().getProtocolOrganizationTypeCode();
        if (StringUtils.isBlank((CharSequence)organizationTypeCode)) {
            isValid = false;
            this.reportError(ERROR_PROPERTY_ORGANIZATION_TYPE_CODE, "error.protocolLocation.organizationTypeCode.notFound", new String[0]);
        }
        return isValid;
    }

    private boolean isInvalidOrganizationId(String organizationId) {
        boolean organizationIdInvalid = false;
        OrganizationService organizationService = KcServiceLocator.getService(OrganizationService.class);
        Organization organization = organizationService.getOrganization(organizationId);
        if (organization == null) {
            organizationIdInvalid = true;
        }
        return organizationIdInvalid;
    }

    private boolean isDuplicate(ProtocolDocumentBase document, String organizationId) {
        for (ProtocolLocationBase protocolLocation : document.getProtocol().getProtocolLocations()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)protocolLocation.getOrganizationId(), (CharSequence)organizationId)) continue;
            return true;
        }
        return false;
    }
}

