/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.specialreview;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.common.framework.compliance.core.AddSpecialReviewEvent;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentControllerBase;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocument;
import org.kuali.coeus.propdev.impl.core.ProposalDevelopmentDocumentForm;
import org.kuali.coeus.propdev.impl.person.ProposalPerson;
import org.kuali.coeus.propdev.impl.specialreview.ProposalDevelopmentSpecialReviewService;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewAttachment;
import org.kuali.coeus.sys.framework.controller.ControllerFileUtils;
import org.kuali.kra.iacuc.IacucProtocolFinderDao;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.rice.krad.data.MaterializeOption;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.uif.UifConstants;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.web.bind.UifBeanPropertyBindingResult;
import org.kuali.rice.krad.web.form.UifFormBase;
import org.kuali.rice.krad.web.service.CollectionControllerService;
import org.kuali.rice.krad.web.service.RefreshControllerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ProposalDevelopmentSpecialReviewController
extends ProposalDevelopmentControllerBase {
    private static String NEW_SPECIAL_REVIEW_PATH = "newCollectionLines['document.developmentProposal.propSpecialReviews']";
    @Autowired
    @Qualifier(value="refreshControllerService")
    private RefreshControllerService refreshControllerService;
    @Autowired
    @Qualifier(value="collectionControllerService")
    private CollectionControllerService collectionControllerService;
    @Autowired
    @Qualifier(value="proposalDevelopmentSpecialReviewService")
    private ProposalDevelopmentSpecialReviewService proposalDevelopmentSpecialReviewService;
    @Autowired
    @Qualifier(value="protocolFinderDao")
    private ProtocolFinderDao protocolFinderDao;
    @Autowired
    @Qualifier(value="iacucProtocolFinderDao")
    private IacucProtocolFinderDao iacucProtocolFinderDao;

    @ResponseBody
    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=clearAddCompliance"})
    public void clearAddCompliance(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalSpecialReview proposalSpecialReview = (ProposalSpecialReview)pdForm.getNewCollectionLines().get("document.developmentProposal.propSpecialReviews");
        proposalSpecialReview.setSpecialReviewTypeCode(null);
        proposalSpecialReview.setSpecialReviewType(null);
        proposalSpecialReview.setApprovalTypeCode(null);
        proposalSpecialReview.setApprovalType(null);
        proposalSpecialReview.setProtocolNumber(null);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=refreshAddCompliance"})
    public ModelAndView refreshAddCompliance(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        ProposalSpecialReview proposalSpecialReview = (ProposalSpecialReview)pdForm.getNewCollectionLines().get("document.developmentProposal.propSpecialReviews");
        String protocolNumber = request.getParameter("newCollectionLines['document.developmentProposal.propSpecialReviews'].protocolNumber");
        UifBeanPropertyBindingResult propertyResult = (UifBeanPropertyBindingResult)result;
        this.handleTypeChange(propertyResult.getModifiedPaths(), proposalSpecialReview);
        this.determineProtocolStatus(protocolNumber, proposalSpecialReview);
        return this.getRefreshControllerService().refresh((UifFormBase)pdForm);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=refreshComplianceEntry"})
    public ModelAndView refreshComplianceEntry(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) {
        String updateComponentId = request.getParameter("updateComponentId");
        String suffix = updateComponentId.substring(updateComponentId.indexOf("_line"));
        int index = Integer.valueOf(suffix.replace("_line", ""));
        ProposalSpecialReview proposalSpecialReview = pdForm.getDevelopmentProposal().getPropSpecialReviews().get(index);
        UifBeanPropertyBindingResult propertyResult = (UifBeanPropertyBindingResult)result;
        this.handleTypeChange(propertyResult.getModifiedPaths(), proposalSpecialReview);
        this.determineProtocolStatus(proposalSpecialReview.getProtocolNumber(), proposalSpecialReview);
        return this.getRefreshControllerService().refresh((UifFormBase)pdForm);
    }

    protected void handleTypeChange(Set<String> modifiedPaths, ProposalSpecialReview specialReview) {
        for (String path : modifiedPaths) {
            if (!path.endsWith("specialReviewTypeCode")) continue;
            specialReview.setApprovalTypeCode(null);
            specialReview.setApprovalType(null);
            specialReview.setProtocolNumber(null);
            specialReview.setProtocolStatus(null);
            specialReview.setExpirationDate(null);
            specialReview.setApprovalDate(null);
            specialReview.setApplicationDate(null);
            specialReview.setComments(null);
            specialReview.setExemptionTypeCodes(new ArrayList<String>());
            this.getDataObjectService().wrap((Object)specialReview).materializeReferencedObjects(new MaterializeOption[0]);
        }
    }

    protected void determineProtocolStatus(String protocolNumber, ProposalSpecialReview proposalSpecialReview) {
        ProtocolBase protocol = null;
        if (StringUtils.isNotBlank((CharSequence)protocolNumber) && proposalSpecialReview.getSpecialReviewTypeCode() != null && proposalSpecialReview.getSpecialReviewTypeCode().equals("1") && this.getProposalDevelopmentSpecialReviewService().isIrbLinkingEnabled()) {
            protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
        } else if (StringUtils.isNotBlank((CharSequence)protocolNumber) && proposalSpecialReview.getSpecialReviewTypeCode() != null && proposalSpecialReview.getSpecialReviewTypeCode().equals("2") && this.getProposalDevelopmentSpecialReviewService().isIacucLinkingEnabled()) {
            protocol = this.getIacucProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
        }
        if (protocol != null && protocol.getProtocolStatus() != null) {
            String status = protocol.getProtocolStatus().getDescription();
            proposalSpecialReview.setApprovalTypeCode(protocol.getProtocolStatusCode());
            proposalSpecialReview.setProtocolStatus(status);
            proposalSpecialReview.setExpirationDate(protocol.getExpirationDate());
            proposalSpecialReview.setApprovalDate(protocol.getApprovalDate());
            proposalSpecialReview.setApplicationDate(protocol.getApplicationDate());
        } else {
            proposalSpecialReview.setProtocolStatus(null);
        }
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=addComplianceEntry"})
    public ModelAndView addComplianceEntry(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm) {
        ProposalSpecialReview proposalSpecialReview = (ProposalSpecialReview)pdForm.getNewCollectionLines().get("document.developmentProposal.propSpecialReviews");
        ProposalDevelopmentDocument proposalDevelopmentDocument = (ProposalDevelopmentDocument)pdForm.getDocument();
        if (!this.getKualiRuleService().applyRules(new AddSpecialReviewEvent<ProposalSpecialReview>((Document)pdForm.getProposalDevelopmentDocument(), proposalSpecialReview, pdForm.getDevelopmentProposal().getPropSpecialReviews(), this.protocolNeedsToBeLinked(proposalSpecialReview.getSpecialReviewTypeCode()), NEW_SPECIAL_REVIEW_PATH))) {
            pdForm.setAjaxReturnType(UifConstants.AjaxReturnTypes.UPDATECOMPONENT.getKey());
            pdForm.setUpdateComponentId("PropDev-CompliancePage_AddDialog");
            return this.getModelAndViewService().getModelAndView((UifFormBase)pdForm);
        }
        if (proposalSpecialReview.getSpecialReviewTypeCode().equals("1") || proposalSpecialReview.getSpecialReviewTypeCode().equals("2")) {
            proposalSpecialReview.setDevelopmentProposal(proposalDevelopmentDocument.getDevelopmentProposal());
            pdForm.getSpecialReviewHelper().prepareProtocolLinkViewFields(proposalSpecialReview);
            if (this.protocolNeedsToBeLinked(proposalSpecialReview.getSpecialReviewTypeCode()) && !proposalSpecialReview.isLinkedToProtocol()) {
                proposalSpecialReview.setProtocolStatus(null);
                proposalSpecialReview.setProtocolNumber(null);
            }
        }
        if (proposalSpecialReview.getSpecialReviewNumber() == null) {
            proposalSpecialReview.setSpecialReviewNumber(this.getProposalDevelopmentSpecialReviewService().generateSpecialReviewNumber(proposalDevelopmentDocument));
        }
        this.getCollectionControllerService().addLine((UifFormBase)pdForm);
        super.save(pdForm);
        return this.getModelAndViewService().getModelAndView((UifFormBase)pdForm);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=createProtocol"})
    public ModelAndView createProtocol(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm, BindingResult result, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentDocument document = pdForm.getProposalDevelopmentDocument();
        ProposalSpecialReview proposalSpecialReview = (ProposalSpecialReview)pdForm.getNewCollectionLines().get("document.developmentProposal.propSpecialReviews");
        proposalSpecialReview.setApprovalTypeCode(null);
        ProposalPerson person = pdForm.getDevelopmentProposal().getPrincipalInvestigator();
        if (person == null || StringUtils.isEmpty((CharSequence)person.getPersonId())) {
            this.getGlobalVariableService().getMessageMap().putError(pdForm.getActionParamaterValue("selectedCollectionId"), "error.special.review.protocol.noprincipal", new String[0]);
        } else {
            boolean success = this.getProposalDevelopmentSpecialReviewService().createProtocol(proposalSpecialReview, document);
            if (success) {
                super.save(pdForm);
            } else {
                this.displayErrors(pdForm);
            }
        }
        pdForm.getNewCollectionLines().clear();
        return this.getModelAndViewService().getModelAndView((UifFormBase)pdForm);
    }

    protected void displayErrors(ProposalDevelopmentDocumentForm pdForm) {
        Map messages = this.getGlobalVariableService().getMessageMap().getErrorMessages();
        for (String message : messages.keySet()) {
            List errors = (List)messages.get(message);
            for (ErrorMessage error : errors) {
                this.getGlobalVariableService().getMessageMap().putError(pdForm.getActionParamaterValue("selectedCollectionId"), error.getErrorKey(), new String[0]);
            }
        }
    }

    protected boolean protocolNeedsToBeLinked(String specialReviewTypeCode) {
        if (specialReviewTypeCode.equals("1")) {
            return this.getProposalDevelopmentSpecialReviewService().isIrbLinkingEnabled();
        }
        if (specialReviewTypeCode.equals("2")) {
            return this.getProposalDevelopmentSpecialReviewService().isIacucLinkingEnabled();
        }
        return true;
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=getSpecialReviewAttachmentFromLine"})
    public void getSpecialReviewAttachmentFromLine(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String selectedLine = request.getParameter("selectedLineIndex");
        if (StringUtils.isEmpty((CharSequence)selectedLine)) {
            throw new RuntimeException("Selected line index was not set properly, cannot retrieve special review attachment");
        }
        int selectedIndex = Integer.parseInt(selectedLine);
        ProposalSpecialReviewAttachment attachment = Optional.ofNullable(pdForm.getDevelopmentProposal().getPropSpecialReview(selectedIndex)).map(ProposalSpecialReview::getSpecialReviewAttachment).orElseThrow(() -> new RuntimeException(String.format("No downloadable attachment for special review %d", selectedIndex)));
        ControllerFileUtils.streamToResponse(attachment, response);
    }

    @Transactional
    @RequestMapping(value={"/proposalDevelopment"}, params={"methodToCall=replaceSpecialReviewAttachment"})
    public ModelAndView replaceSpecialReviewAttachment(@ModelAttribute(value="KualiForm") ProposalDevelopmentDocumentForm pdForm) {
        String selectedLine = pdForm.getActionParamaterValue("selectedLineIndex");
        if (StringUtils.isEmpty((CharSequence)selectedLine)) {
            throw new RuntimeException("Selected line index was not set properly, cannot replace special review attachment");
        }
        int selectedIndex = Integer.parseInt(selectedLine);
        ProposalSpecialReview specialReview = pdForm.getDevelopmentProposal().getPropSpecialReview(selectedIndex);
        if (specialReview != null && specialReview.getSpecialReviewAttachment() != null && specialReview.getSpecialReviewAttachment().getMultipartFile() != null) {
            this.prepareSpecialReviewAttachmentForSave(specialReview);
            this.getDataObjectService().save((Object)specialReview, new PersistenceOption[0]);
        }
        return this.getModelAndViewService().getModelAndView((UifFormBase)pdForm);
    }

    public ProposalDevelopmentSpecialReviewService getProposalDevelopmentSpecialReviewService() {
        return this.proposalDevelopmentSpecialReviewService;
    }

    public void setProposalDevelopmentSpecialReviewService(ProposalDevelopmentSpecialReviewService proposalDevelopmentSpecialReviewService) {
        this.proposalDevelopmentSpecialReviewService = proposalDevelopmentSpecialReviewService;
    }

    public ProtocolFinderDao getProtocolFinderDao() {
        return this.protocolFinderDao;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public IacucProtocolFinderDao getIacucProtocolFinderDao() {
        return this.iacucProtocolFinderDao;
    }

    public void setIacucProtocolFinderDao(IacucProtocolFinderDao iacucProtocolFinderDao) {
        this.iacucProtocolFinderDao = iacucProtocolFinderDao;
    }

    public RefreshControllerService getRefreshControllerService() {
        return this.refreshControllerService;
    }

    public void setRefreshControllerService(RefreshControllerService refreshControllerService) {
        this.refreshControllerService = refreshControllerService;
    }

    public CollectionControllerService getCollectionControllerService() {
        return this.collectionControllerService;
    }

    public void setCollectionControllerService(CollectionControllerService collectionControllerService) {
        this.collectionControllerService = collectionControllerService;
    }
}

