/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.api.document.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kuali.coeus.common.api.document.service.DocumentActionListService;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actionrequest.service.ActionRequestService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.node.RouteNodeInstance;
import org.kuali.rice.kew.api.document.node.RouteNodeInstanceState;
import org.kuali.rice.kew.dto.DTOConverter;
import org.kuali.rice.kew.engine.node.Branch;
import org.kuali.rice.kew.engine.node.NodeState;
import org.kuali.rice.kew.engine.node.RouteNode;
import org.kuali.rice.kew.engine.node.service.RouteNodeService;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.util.Utilities;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="documentActionListService")
public class DocumentActionListServiceImpl
implements DocumentActionListService {
    @Autowired
    @Qualifier(value="actionRequestService")
    private ActionRequestService actionRequestService;
    @Autowired
    @Qualifier(value="workflowDocumentActionsService")
    protected WorkflowDocumentActionsService workflowDocumentActionsService;
    @Autowired
    @Qualifier(value="routeNodeService")
    protected RouteNodeService routeNodeService;
    private static Comparator<ActionRequestValue> ROUTE_LOG_ACTION_REQUEST_SORTER = new Utilities.RouteLogActionRequestSorter();

    @Override
    public List<ActionRequestValue> populateRouteLogFormActionRequests(DocumentRouteHeaderValue routeHeader) {
        List<ActionRequestValue> rootRequests = this.actionRequestService.getRootRequests((Collection)routeHeader.getActionRequests());
        Collections.sort(rootRequests, ROUTE_LOG_ACTION_REQUEST_SORTER);
        rootRequests = this.switchActionRequestPositionsIfPrimaryDelegatesPresent((Collection<ActionRequestValue>)rootRequests);
        for (ActionRequestValue actionRequest : rootRequests) {
            if (!actionRequest.isPending()) continue;
            if (ActionRequestStatus.INITIALIZED.getCode().equals(actionRequest.getStatus())) {
                actionRequest.setDisplayStatus("PENDING");
                continue;
            }
            if (!ActionRequestStatus.ACTIVATED.getCode().equals(actionRequest.getStatus())) continue;
            actionRequest.setDisplayStatus("IN ACTION LIST");
        }
        return rootRequests;
    }

    @Override
    public List<ActionRequestValue> switchActionRequestPositionsIfPrimaryDelegatesPresent(Collection<ActionRequestValue> actionRequests) {
        ArrayList<ActionRequestValue> results = new ArrayList<ActionRequestValue>(actionRequests.size());
        for (ActionRequestValue actionRequest : actionRequests) {
            results.add(this.switchActionRequestPositionIfPrimaryDelegatePresent(actionRequest));
        }
        return results;
    }

    @Override
    public ActionRequestValue switchActionRequestPositionIfPrimaryDelegatePresent(ActionRequestValue actionRequest) {
        if (!actionRequest.isRoleRequest()) {
            List primaryDelegateRequests = actionRequest.getPrimaryDelegateRequests();
            if (primaryDelegateRequests.size() != 1) {
                return actionRequest;
            }
            ActionRequestValue primaryDelegateRequest = (ActionRequestValue)primaryDelegateRequests.get(0);
            actionRequest.getChildrenRequests().remove(primaryDelegateRequest);
            primaryDelegateRequest.setChildrenRequests(actionRequest.getChildrenRequests());
            primaryDelegateRequest.setParentActionRequest(actionRequest.getParentActionRequest());
            actionRequest.setChildrenRequests(new ArrayList(0));
            actionRequest.setParentActionRequest(primaryDelegateRequest);
            primaryDelegateRequest.getChildrenRequests().add(0, actionRequest);
            for (ActionRequestValue delegateRequest : primaryDelegateRequest.getChildrenRequests()) {
                delegateRequest.setParentActionRequest(primaryDelegateRequest);
            }
            return primaryDelegateRequest;
        }
        return actionRequest;
    }

    @Override
    public void fixActionRequestsPositions(DocumentRouteHeaderValue routeHeader) {
        for (ActionTakenValue actionTaken : routeHeader.getActionsTaken()) {
            Collections.sort((List)actionTaken.getActionRequests(), ROUTE_LOG_ACTION_REQUEST_SORTER);
            actionTaken.setActionRequests(actionTaken.getActionRequests());
        }
    }

    @Override
    public List<ActionRequestValue> populateRouteLogFutureRequests(DocumentRouteHeaderValue document) {
        RoutingReportCriteria reportCriteria = RoutingReportCriteria.Builder.createByDocumentId((String)document.getDocumentId()).build();
        Set<String> preexistingActionRequestIds = this.getActionRequestIds(document);
        DocumentDetail documentDetail = this.workflowDocumentActionsService.executeSimulation(reportCriteria);
        List<ActionRequestValue> futureActionRequests = this.reconstituteActionRequestValues(documentDetail, preexistingActionRequestIds);
        Collections.sort(futureActionRequests, ROUTE_LOG_ACTION_REQUEST_SORTER);
        futureActionRequests = this.switchActionRequestPositionsIfPrimaryDelegatesPresent(futureActionRequests);
        for (ActionRequestValue actionRequest : futureActionRequests) {
            if (!actionRequest.isPending()) continue;
            if (ActionRequestStatus.INITIALIZED.getCode().equals(actionRequest.getStatus())) {
                actionRequest.setDisplayStatus("PENDING");
                continue;
            }
            if (!ActionRequestStatus.ACTIVATED.getCode().equals(actionRequest.getStatus())) continue;
            actionRequest.setDisplayStatus("IN ACTION LIST");
        }
        return futureActionRequests;
    }

    private Set<String> getActionRequestIds(DocumentRouteHeaderValue document) {
        HashSet<String> actionRequestIds = new HashSet<String>();
        List actionRequests = this.actionRequestService.findAllActionRequestsByDocumentId(document.getDocumentId());
        if (actionRequests != null) {
            for (ActionRequestValue actionRequest : actionRequests) {
                if (actionRequest.getActionRequestId() == null) continue;
                actionRequestIds.add(actionRequest.getActionRequestId());
            }
        }
        return actionRequestIds;
    }

    private List<ActionRequestValue> reconstituteActionRequestValues(DocumentDetail documentDetail, Set<String> preexistingActionRequestIds) {
        RouteNodeInstanceFabricator routeNodeInstanceFabricator = new RouteNodeInstanceFabricator(this.routeNodeService);
        if (documentDetail.getRouteNodeInstances() != null && !documentDetail.getRouteNodeInstances().isEmpty()) {
            for (RouteNodeInstance routeNodeInstanceVO : documentDetail.getRouteNodeInstances()) {
                routeNodeInstanceFabricator.importRouteNodeInstanceDTO(routeNodeInstanceVO);
            }
        }
        List actionRequestVOs = documentDetail.getActionRequests();
        ArrayList<ActionRequestValue> futureActionRequests = new ArrayList<ActionRequestValue>();
        if (actionRequestVOs != null) {
            for (ActionRequest actionRequestVO : actionRequestVOs) {
                if (actionRequestVO == null || preexistingActionRequestIds.contains(actionRequestVO.getId())) continue;
                ActionRequestValue converted = ActionRequestValue.from((ActionRequest)actionRequestVO, (DTOConverter.RouteNodeInstanceLoader)routeNodeInstanceFabricator);
                futureActionRequests.add(converted);
            }
        }
        return futureActionRequests;
    }

    public ActionRequestService getActionRequestService() {
        return this.actionRequestService;
    }

    public void setActionRequestService(ActionRequestService actionRequestService) {
        this.actionRequestService = actionRequestService;
    }

    public WorkflowDocumentActionsService getWorkflowDocumentActionsService() {
        return this.workflowDocumentActionsService;
    }

    public void setWorkflowDocumentActionsService(WorkflowDocumentActionsService workflowDocumentActionsService) {
        this.workflowDocumentActionsService = workflowDocumentActionsService;
    }

    public RouteNodeService getRouteNodeService() {
        return this.routeNodeService;
    }

    public void setRouteNodeService(RouteNodeService routeNodeService) {
        this.routeNodeService = routeNodeService;
    }

    private static class RouteNodeInstanceFabricator
    implements DTOConverter.RouteNodeInstanceLoader {
        private Map<String, Branch> branches = new HashMap<String, Branch>();
        private Map<String, org.kuali.rice.kew.engine.node.RouteNodeInstance> routeNodeInstances = new HashMap<String, org.kuali.rice.kew.engine.node.RouteNodeInstance>();
        private Map<String, RouteNode> routeNodes = new HashMap<String, RouteNode>();
        private Map<String, NodeState> nodeStates = new HashMap<String, NodeState>();
        private RouteNodeService routeNodeService;

        public RouteNodeInstanceFabricator(RouteNodeService routeNodeService) {
            this.routeNodeService = routeNodeService;
        }

        public void importRouteNodeInstanceDTO(RouteNodeInstance nodeInstanceDTO) {
            this._importRouteNodeInstanceDTO(nodeInstanceDTO);
        }

        private org.kuali.rice.kew.engine.node.RouteNodeInstance _importRouteNodeInstanceDTO(RouteNodeInstance nodeInstanceDTO) {
            if (nodeInstanceDTO == null) {
                return null;
            }
            org.kuali.rice.kew.engine.node.RouteNodeInstance nodeInstance = new org.kuali.rice.kew.engine.node.RouteNodeInstance();
            nodeInstance.setActive(nodeInstanceDTO.isActive());
            nodeInstance.setComplete(nodeInstanceDTO.isComplete());
            nodeInstance.setDocumentId(nodeInstanceDTO.getDocumentId());
            nodeInstance.setInitial(nodeInstanceDTO.isInitial());
            Branch branch = this.getBranch(nodeInstanceDTO.getBranchId());
            nodeInstance.setBranch(branch);
            if (nodeInstanceDTO.getRouteNodeId() != null) {
                RouteNode routeNode = this.routeNodeService.findRouteNodeById(nodeInstanceDTO.getRouteNodeId());
                if (routeNode == null) {
                    routeNode = this.getRouteNode(nodeInstanceDTO.getRouteNodeId());
                    routeNode.setNodeType(nodeInstanceDTO.getName());
                }
                nodeInstance.setRouteNode(routeNode);
                if (routeNode.getBranch() != null) {
                    branch.setName(routeNode.getBranch().getName());
                }
            }
            org.kuali.rice.kew.engine.node.RouteNodeInstance process = this.getRouteNodeInstance(nodeInstanceDTO.getProcessId());
            nodeInstance.setProcess(process);
            nodeInstance.setRouteNodeInstanceId(nodeInstanceDTO.getId());
            ArrayList<NodeState> nodeState = new ArrayList<NodeState>();
            if (nodeInstanceDTO.getState() != null) {
                for (RouteNodeInstanceState stateDTO : nodeInstanceDTO.getState()) {
                    NodeState state = this.getNodeState(stateDTO.getId());
                    if (state == null) continue;
                    state.setKey(stateDTO.getKey());
                    state.setValue(stateDTO.getValue());
                    state.setStateId(stateDTO.getId());
                    state.setNodeInstance(nodeInstance);
                    nodeState.add(state);
                }
            }
            nodeInstance.setState(nodeState);
            ArrayList<org.kuali.rice.kew.engine.node.RouteNodeInstance> nextNodeInstances = new ArrayList<org.kuali.rice.kew.engine.node.RouteNodeInstance>();
            for (RouteNodeInstance nextNodeInstanceVO : nodeInstanceDTO.getNextNodeInstances()) {
                nextNodeInstances.add(this._importRouteNodeInstanceDTO(nextNodeInstanceVO));
            }
            nodeInstance.setNextNodeInstances(nextNodeInstances);
            this.routeNodeInstances.put(nodeInstance.getRouteNodeInstanceId(), nodeInstance);
            return nodeInstance;
        }

        public org.kuali.rice.kew.engine.node.RouteNodeInstance load(String routeNodeInstanceID) {
            return this.routeNodeInstances.get(routeNodeInstanceID);
        }

        private Branch getBranch(String branchId) {
            Branch result = null;
            if (branchId != null) {
                if (!this.branches.containsKey(branchId)) {
                    result = new Branch();
                    result.setBranchId(branchId);
                    this.branches.put(branchId, result);
                } else {
                    result = this.branches.get(branchId);
                }
            }
            return result;
        }

        private RouteNode getRouteNode(String routeNodeId) {
            RouteNode result = null;
            if (routeNodeId != null) {
                if (!this.routeNodes.containsKey(routeNodeId)) {
                    result = new RouteNode();
                    result.setRouteNodeId(routeNodeId);
                    this.routeNodes.put(routeNodeId, result);
                } else {
                    result = this.routeNodes.get(routeNodeId);
                }
            }
            return result;
        }

        public org.kuali.rice.kew.engine.node.RouteNodeInstance getRouteNodeInstance(String routeNodeInstanceId) {
            org.kuali.rice.kew.engine.node.RouteNodeInstance result = null;
            if (routeNodeInstanceId != null) {
                if (!this.routeNodeInstances.containsKey(routeNodeInstanceId)) {
                    result = new org.kuali.rice.kew.engine.node.RouteNodeInstance();
                    result.setRouteNodeInstanceId(routeNodeInstanceId);
                    this.routeNodeInstances.put(routeNodeInstanceId, result);
                } else {
                    result = this.routeNodeInstances.get(routeNodeInstanceId);
                }
            }
            return result;
        }

        private NodeState getNodeState(String nodeStateId) {
            NodeState result = null;
            if (nodeStateId != null) {
                if (!this.nodeStates.containsKey(nodeStateId)) {
                    result = new NodeState();
                    result.setNodeStateId(nodeStateId);
                    this.nodeStates.put(nodeStateId, result);
                } else {
                    result = this.nodeStates.get(nodeStateId);
                }
            }
            return result;
        }
    }
}

