/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.questionnaire.impl.answer;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.krms.KrmsRulesContext;
import org.kuali.coeus.common.framework.krms.KrmsRulesExecutionService;
import org.kuali.coeus.common.questionnaire.framework.answer.Answer;
import org.kuali.coeus.common.questionnaire.framework.answer.AnswerHeader;
import org.kuali.coeus.common.questionnaire.framework.answer.ModuleQuestionnaireBean;
import org.kuali.coeus.common.questionnaire.framework.answer.QuestionnaireAnswerService;
import org.kuali.coeus.common.questionnaire.framework.core.Questionnaire;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireQuestion;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireService;
import org.kuali.coeus.common.questionnaire.framework.core.QuestionnaireUsage;
import org.kuali.coeus.common.questionnaire.framework.question.QuestionDTO;
import org.kuali.coeus.common.questionnaire.impl.answer.AnswerComparator;
import org.kuali.coeus.propdev.impl.person.question.ProposalPersonModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.coeus.propdev.impl.s2s.question.ProposalDevelopmentS2sModuleQuestionnaireBean;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.protocol.questionnaire.QuestionnaireHelperBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="questionnaireAnswerService")
public class QuestionnaireAnswerServiceImpl
implements QuestionnaireAnswerService {
    private static final Logger LOG = LogManager.getLogger(QuestionnaireAnswerServiceImpl.class);
    private static final String MODULE_ITEM_CODE = "moduleItemCode";
    private static final String MODULE_SUB_ITEM_CODE = "moduleSubItemCode";
    private static final String MODULE_ITEM_KEY = "moduleItemKey";
    private static final String MODULE_SUB_ITEM_KEY = "moduleSubItemKey";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String QUESTIONNAIRE_AGENDA_TYPE_ID = "KC1004";
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="parameterService")
    private ParameterService parameterService;
    @Autowired
    @Qualifier(value="questionnaireService")
    private QuestionnaireService questionnaireService;
    @Autowired
    @Qualifier(value="krmsRulesExecutionService")
    private KrmsRulesExecutionService krmsRulesExecutionService;
    @Autowired
    @Qualifier(value="globalVariableService")
    private GlobalVariableService globalVariableService;

    @Override
    public List<QuestionnaireUsage> getPublishedQuestionnaire(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, moduleQuestionnaireBean.getModuleItemCode());
        fieldValues.put(MODULE_SUB_ITEM_CODE, moduleQuestionnaireBean.getModuleSubItemCode());
        ArrayList<QuestionnaireUsage> usages = new ArrayList<QuestionnaireUsage>();
        ArrayList<String> questionnaireIds = new ArrayList<String>();
        List questionnaireUsages = (List)this.businessObjectService.findMatching(QuestionnaireUsage.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)questionnaireUsages)) {
            Collections.sort(questionnaireUsages);
        }
        ArrayList<String> ruleIds = new ArrayList<String>();
        for (QuestionnaireUsage questionnaireUsage : questionnaireUsages) {
            if (!StringUtils.isNotBlank((CharSequence)questionnaireUsage.getRuleId())) continue;
            ruleIds.add(questionnaireUsage.getRuleId());
        }
        Map<Object, Object> ruleResults = new HashMap();
        if (!ruleIds.isEmpty()) {
            ruleResults = this.runApplicableRules(ruleIds, moduleQuestionnaireBean);
        }
        for (QuestionnaireUsage questionnaireUsage : questionnaireUsages) {
            if (questionnaireIds.contains(questionnaireUsage.getQuestionnaire().getQuestionnaireSeqId())) continue;
            questionnaireIds.add(questionnaireUsage.getQuestionnaire().getQuestionnaireSeqId());
            if (!moduleQuestionnaireBean.isFinalDoc() && (!this.getQuestionnaireService().isCurrentQuestionnaire(questionnaireUsage.getQuestionnaire()) || !questionnaireUsage.getQuestionnaire().isActive())) continue;
            if (StringUtils.isNotBlank((CharSequence)questionnaireUsage.getRuleId())) {
                if (!ruleResults.containsKey(questionnaireUsage.getRuleId()) || !((Boolean)ruleResults.get(questionnaireUsage.getRuleId())).booleanValue()) continue;
                usages.add(questionnaireUsage);
                continue;
            }
            usages.add(questionnaireUsage);
        }
        return usages;
    }

    protected List<AnswerHeader> initAnswerHeaders(ModuleQuestionnaireBean moduleQuestionnaireBean, Map<String, AnswerHeader> answerHeaderMap) {
        ArrayList<AnswerHeader> answerHeaders = new ArrayList<AnswerHeader>();
        for (QuestionnaireUsage questionnaireUsage : this.getPublishedQuestionnaire(moduleQuestionnaireBean)) {
            String questionnaireId = questionnaireUsage.getQuestionnaire().getQuestionnaireSeqId();
            if (answerHeaderMap.containsKey(questionnaireId)) {
                answerHeaders.add(answerHeaderMap.get(questionnaireId));
                if (!questionnaireUsage.getQuestionnaire().getId().equals(answerHeaderMap.get(questionnaireId).getQuestionnaireId())) {
                    if (questionnaireUsage.getQuestionnaire().isActive()) {
                        answerHeaderMap.get(questionnaireId).setNewerVersionPublished(true);
                        answerHeaderMap.get(questionnaireId).setActiveQuestionnaire(true);
                    } else {
                        answerHeaderMap.get(questionnaireId).setActiveQuestionnaire(false);
                    }
                }
                answerHeaderMap.get(questionnaireId).setLabel(questionnaireUsage.getQuestionnaireLabel());
                continue;
            }
            if (moduleQuestionnaireBean.isFinalDoc() || !this.getQuestionnaireService().isCurrentQuestionnaire(questionnaireUsage.getQuestionnaire()) || !questionnaireUsage.getQuestionnaire().isActive()) continue;
            answerHeaders.add(this.setupAnswerForQuestionnaire(questionnaireUsage, moduleQuestionnaireBean));
        }
        return answerHeaders;
    }

    @Override
    public AnswerHeader getNewVersionAnswerHeader(ModuleQuestionnaireBean moduleQuestionnaireBean, Questionnaire questionnaire) {
        AnswerHeader answerHeader = new AnswerHeader();
        List<QuestionnaireUsage> usages = this.getPublishedQuestionnaire(moduleQuestionnaireBean);
        for (QuestionnaireUsage questionnaireUsage : usages) {
            if (!questionnaireUsage.getQuestionnaire().getQuestionnaireSeqId().equals(questionnaire.getQuestionnaireSeqId()) || questionnaireUsage.getQuestionnaire().getSequenceNumber() < questionnaire.getSequenceNumber()) continue;
            answerHeader = this.setupAnswerForQuestionnaire(questionnaireUsage, moduleQuestionnaireBean);
        }
        return answerHeader;
    }

    @Override
    public List<AnswerHeader> versioningQuestionnaireAnswer(ModuleQuestionnaireBean moduleQuestionnaireBean, Integer newSequenceNumber) {
        ArrayList<AnswerHeader> newAnswerHeaders = new ArrayList<AnswerHeader>();
        List<String> questionnaireIds = this.getAssociateedQuestionnaireIds(moduleQuestionnaireBean);
        for (AnswerHeader answerHeader : this.retrieveAnswerHeaders(moduleQuestionnaireBean)) {
            if (!questionnaireIds.contains(answerHeader.getQuestionnaire().getQuestionnaireSeqId())) continue;
            AnswerHeader copiedAnswerHeader = (AnswerHeader)((Object)ObjectUtils.deepCopy((Serializable)((Object)answerHeader)));
            copiedAnswerHeader.setModuleSubItemKey(newSequenceNumber.toString());
            copiedAnswerHeader.setId(null);
            for (Answer answer : copiedAnswerHeader.getAnswers()) {
                answer.setId(null);
            }
            newAnswerHeaders.add(copiedAnswerHeader);
        }
        return newAnswerHeaders;
    }

    protected List<AnswerHeader> copyAnswerHeadersToNewModuleQB(ModuleQuestionnaireBean srcModuleQuestionnaireBean, ModuleQuestionnaireBean destModuleQuestionnaireBean) {
        ArrayList<AnswerHeader> newAnswerHeaders = new ArrayList<AnswerHeader>();
        List<String> questionnaireIds = this.getAssociateedQuestionnaireIds(destModuleQuestionnaireBean);
        List<AnswerHeader> srcModuleAnswerHeaders = this.retrieveAnswerHeaders(srcModuleQuestionnaireBean);
        for (AnswerHeader answerHeader : srcModuleAnswerHeaders) {
            if (!questionnaireIds.contains(answerHeader.getQuestionnaire().getQuestionnaireSeqId())) continue;
            AnswerHeader copiedAnswerHeader = (AnswerHeader)((Object)ObjectUtils.deepCopy((Serializable)((Object)answerHeader)));
            copiedAnswerHeader.setNewModuleQuestionnaireBeanReferenceData(destModuleQuestionnaireBean);
            copiedAnswerHeader.setId(null);
            copiedAnswerHeader.setModuleItemKey(destModuleQuestionnaireBean.getModuleItemKey());
            for (Answer answer : copiedAnswerHeader.getAnswers()) {
                answer.setId(null);
            }
            newAnswerHeaders.add(copiedAnswerHeader);
        }
        return newAnswerHeaders;
    }

    @Override
    public List<AnswerHeader> getQuestionnaireAnswer(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        HashMap<String, AnswerHeader> answerHeaderMap = new HashMap<String, AnswerHeader>();
        List<AnswerHeader> answers = this.retrieveAnswerHeaders(moduleQuestionnaireBean);
        if (this.globalVariableService.getUserSession() != null) {
            this.globalVariableService.getUserSession().removeObject(moduleQuestionnaireBean.getSessionContextKey() + "-rulereferenced");
        }
        for (AnswerHeader answerHeader : answers) {
            if (answerHeaderMap.containsKey(answerHeader.getQuestionnaire().getQuestionnaireSeqId()) && ((AnswerHeader)answerHeaderMap.get(answerHeader.getQuestionnaire().getQuestionnaireSeqId())).getQuestionnaire().getSequenceNumber() >= answerHeader.getQuestionnaire().getSequenceNumber()) continue;
            this.setupChildAnswerIndicator(answerHeader);
            answerHeaderMap.put(answerHeader.getQuestionnaire().getQuestionnaireSeqId(), answerHeader);
        }
        List<AnswerHeader> answerHeaders = this.initAnswerHeaders(moduleQuestionnaireBean, answerHeaderMap);
        for (AnswerHeader answerHeader : answerHeaders) {
            List<QuestionnaireQuestion> questionsWithoutAnswers = this.findQuestionsWithoutAnswers(answerHeader);
            if (!questionsWithoutAnswers.isEmpty()) {
                answerHeader.getAnswers().addAll(questionsWithoutAnswers.stream().flatMap(q -> this.setupAnswersForQuestion((QuestionnaireQuestion)q).stream()).collect(Collectors.toList()));
                this.setupChildAnswerIndicator(answerHeader);
            }
            answerHeader.getAnswers().sort(new AnswerComparator());
            answerHeader.setCompleted(this.isQuestionnaireAnswerComplete(answerHeader.getAnswers()));
            answerHeader.setHasVisibleQuestion(this.hasVisibleQuestion(answerHeader.getAnswers()));
        }
        return answerHeaders;
    }

    protected List<QuestionnaireQuestion> findQuestionsWithoutAnswers(AnswerHeader answerHeader) {
        return answerHeader.getQuestionnaire().getQuestionnaireQuestions().stream().filter(questionnaireQuestion -> !answerHeader.getAnswers().stream().map(Answer::getQuestionId).collect(Collectors.toSet()).contains(questionnaireQuestion.getQuestionId())).collect(Collectors.toList());
    }

    protected List<AnswerHeader> retrieveAnswerHeaders(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, moduleQuestionnaireBean.getModuleItemCode());
        fieldValues.put(MODULE_SUB_ITEM_CODE, moduleQuestionnaireBean.getModuleSubItemCode());
        fieldValues.put(MODULE_ITEM_KEY, moduleQuestionnaireBean.getModuleItemKey());
        fieldValues.put(MODULE_SUB_ITEM_KEY, moduleQuestionnaireBean.getModuleSubItemKey());
        return (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
    }

    protected List<String> getAssociateedQuestionnaireIds(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        ArrayList<String> questionnaireIds = new ArrayList<String>();
        for (QuestionnaireUsage questionnaireUsage : this.getPublishedQuestionnaire(moduleQuestionnaireBean)) {
            questionnaireIds.add(questionnaireUsage.getQuestionnaire().getQuestionnaireSeqId());
        }
        return questionnaireIds;
    }

    protected Questionnaire getLatestQuestionnaireVersion(Integer questionniareSeqId) {
        Questionnaire latestQnnrInstance = null;
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("questionnaireSeqId", Long.valueOf(questionniareSeqId.intValue()));
        List questionnaires = (List)this.businessObjectService.findMatchingOrderBy(Questionnaire.class, fieldValues, SEQUENCE_NUMBER, false);
        if (!questionnaires.isEmpty()) {
            latestQnnrInstance = (Questionnaire)questionnaires.get(0);
        }
        return latestQnnrInstance;
    }

    @Override
    public boolean checkIfQuestionnaireIsActiveForModule(Integer questionniareSeqId, String moduleItemCode, String moduleSubItemCode) {
        boolean isActive = false;
        Questionnaire latestQnnrInstance = this.getLatestQuestionnaireVersion(questionniareSeqId);
        if (null != latestQnnrInstance && latestQnnrInstance.isActive()) {
            isActive = latestQnnrInstance.hasUsageFor(moduleItemCode, moduleSubItemCode);
        }
        return isActive;
    }

    @Override
    public boolean checkIfQuestionnaireIsMandatoryForModule(Integer questionniareSeqId, String moduleItemCode, String moduleSubItemCode) {
        Questionnaire latestQnnrInstance = this.getLatestQuestionnaireVersion(questionniareSeqId);
        if (null != latestQnnrInstance && latestQnnrInstance.isActive()) {
            for (QuestionnaireUsage usage : latestQnnrInstance.getQuestionnaireUsages()) {
                if (!usage.isMandatory()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void copyAnswerToNewVersion(AnswerHeader oldAnswerHeader, AnswerHeader newAnswerHeader) {
        List<List<Answer>> oldParentAnswers = this.setupParentAnswers(oldAnswerHeader.getAnswers());
        List<List<Answer>> newParentAnswers = this.setupParentAnswers(newAnswerHeader.getAnswers());
        block0: for (Answer oldAnswer : oldAnswerHeader.getAnswers()) {
            if (!StringUtils.isNotBlank((CharSequence)oldAnswer.getAnswer())) continue;
            for (Answer newAnswer : newAnswerHeader.getAnswers()) {
                if (!oldAnswer.getQuestion().getQuestionSeqId().equals(newAnswer.getQuestion().getQuestionSeqId()) || !oldAnswer.getQuestion().getId().equals(newAnswer.getQuestion().getId()) || !oldAnswer.getAnswerNumber().equals(newAnswer.getAnswerNumber()) || (oldAnswer.getQuestionnaireQuestion().getParentQuestionNumber() != 0 || newAnswer.getQuestionnaireQuestion().getParentQuestionNumber() != 0) && (oldAnswer.getQuestionnaireQuestion().getParentQuestionNumber() <= 0 || newAnswer.getQuestionnaireQuestion().getParentQuestionNumber() <= 0 || !"Y".equals(newParentAnswers.get(newAnswer.getQuestionnaireQuestion().getParentQuestionNumber()).get(0).getMatchedChild()) || !this.isSameLevel(oldAnswer, oldParentAnswers, newAnswer, newParentAnswers))) continue;
                newAnswer.setAnswer(oldAnswer.getAnswer());
                newAnswer.setMatchedChild("Y");
                continue block0;
            }
        }
        this.setupChildAnswerIndicator(newAnswerHeader);
        for (Answer answer : newAnswerHeader.getAnswers()) {
            if (!StringUtils.isNotBlank((CharSequence)answer.getAnswer()) || !"N".equals(answer.getMatchedChild())) continue;
            answer.setAnswer("");
        }
        newAnswerHeader.setCompleted(this.isQuestionnaireAnswerComplete(newAnswerHeader.getAnswers()));
    }

    @Override
    public List<AnswerHeader> copyAnswerHeaders(ModuleQuestionnaireBean srcModuleQuestionnaireBean, ModuleQuestionnaireBean destModuleQuestionnaireBean) {
        List<AnswerHeader> answerHeaders = this.copyAnswerHeadersToNewModuleQB(srcModuleQuestionnaireBean, destModuleQuestionnaireBean);
        for (AnswerHeader header : answerHeaders) {
            this.businessObjectService.save((PersistableBusinessObject)header);
        }
        return answerHeaders;
    }

    @Override
    public void preSave(List<AnswerHeader> answerHeaders) {
        for (AnswerHeader answerHeader : answerHeaders) {
            int i = 0;
            for (Answer answer : answerHeader.getAnswers()) {
                if (answer.getQuestion().getMaxAnswers() != null && answer.getQuestion().getMaxAnswers() > 1 && answer.getAnswerNumber() == 1 && !Long.valueOf(100L).equals(answer.getQuestion().getQuestionTypeId())) {
                    this.moveAnswer(answerHeader.getAnswers(), i);
                }
                ++i;
            }
            answerHeader.setCompleted(this.isQuestionnaireAnswerComplete(answerHeader.getAnswers()));
            this.setupChildAnswerIndicator(answerHeader);
        }
    }

    protected void moveAnswer(List<Answer> answers, int index) {
        block0: for (int i = 0; i < answers.get(index).getQuestion().getMaxAnswers() - 1; ++i) {
            if (!StringUtils.isBlank((CharSequence)answers.get(index + i).getAnswer())) continue;
            for (int j = i + 1; j < answers.get(index).getQuestion().getMaxAnswers(); ++j) {
                if (!StringUtils.isNotBlank((CharSequence)answers.get(index + j).getAnswer())) continue;
                answers.get(index + i).setAnswer(answers.get(index + j).getAnswer());
                answers.get(index + j).setAnswer("");
                continue block0;
            }
        }
    }

    protected boolean isSameLevel(Answer oldAnswer, List<List<Answer>> oldParentAnswers, Answer newAnswer, List<List<Answer>> newParentAnswers) {
        boolean questionHierarchyMatched = true;
        Answer oAnswer = oldAnswer;
        Answer nAnswer = newAnswer;
        while (questionHierarchyMatched && oAnswer.getQuestionnaireQuestion().getParentQuestionNumber() > 0 && nAnswer.getQuestionnaireQuestion().getParentQuestionNumber() > 0) {
            if (!oAnswer.getQuestionId().equals(nAnswer.getQuestionId())) {
                questionHierarchyMatched = false;
            }
            oAnswer = oldParentAnswers.get(oAnswer.getQuestionnaireQuestion().getParentQuestionNumber()).get(0);
            nAnswer = newParentAnswers.get(nAnswer.getQuestionnaireQuestion().getParentQuestionNumber()).get(0);
        }
        return questionHierarchyMatched && oAnswer.getQuestionnaireQuestion().getParentQuestionNumber() == 0 && nAnswer.getQuestionnaireQuestion().getParentQuestionNumber() == 0;
    }

    protected List<List<Answer>> setupParentAnswers(List<Answer> answers) {
        List<List<Answer>> parentAnswers = this.initParentAnswers(answers);
        for (Answer answer : answers) {
            parentAnswers.get(answer.getQuestionNumber()).add(answer);
        }
        return parentAnswers;
    }

    protected List<List<Answer>> initParentAnswers(List<Answer> answers) {
        int maxQuestionNumber = 0;
        ArrayList<List<Answer>> parentAnswers = new ArrayList<List<Answer>>();
        for (Answer answer : answers) {
            if (answer.getQuestionNumber() <= maxQuestionNumber) continue;
            while (maxQuestionNumber < answer.getQuestionNumber()) {
                parentAnswers.add(new ArrayList());
                ++maxQuestionNumber;
            }
        }
        parentAnswers.add(new ArrayList());
        return parentAnswers;
    }

    protected AnswerHeader setupAnswerForQuestionnaire(QuestionnaireUsage questionnaireUsage, ModuleQuestionnaireBean moduleQuestionnaireBean) {
        Questionnaire questionnaire = questionnaireUsage.getQuestionnaire();
        AnswerHeader answerHeader = new AnswerHeader(moduleQuestionnaireBean, questionnaire.getQuestionnaireRefIdAsLong());
        answerHeader.setQuestionnaire(questionnaire);
        ArrayList<Answer> answers = new ArrayList<Answer>();
        for (QuestionnaireQuestion question : questionnaire.getQuestionnaireQuestions()) {
            if (question.getParentQuestionNumber() != 0) continue;
            answers.addAll(this.setupAnswersForQuestion(question));
            answers.addAll(this.getChildQuestions(questionnaire, question));
        }
        for (Answer answer : answers) {
            answer.setAnswerHeader(answerHeader);
        }
        answerHeader.setAnswers(answers);
        this.setupChildAnswerIndicator(answerHeader);
        answerHeader.setLabel(questionnaireUsage.getQuestionnaireLabel());
        return answerHeader;
    }

    protected List<Answer> getChildQuestions(Questionnaire questionnaire, QuestionnaireQuestion question) {
        ArrayList<Answer> answers = new ArrayList<Answer>();
        for (QuestionnaireQuestion questionnaireQuestion : questionnaire.getQuestionnaireQuestions()) {
            if (questionnaireQuestion.getParentQuestionNumber() == 0 || !questionnaireQuestion.getParentQuestionNumber().equals(question.getQuestionNumber())) continue;
            answers.addAll(this.setupAnswersForQuestion(questionnaireQuestion));
            answers.addAll(this.getChildQuestions(questionnaire, questionnaireQuestion));
        }
        return answers;
    }

    protected List<Answer> setupAnswersForQuestion(QuestionnaireQuestion questionnaireQuestion) {
        ArrayList<Answer> answers = new ArrayList<Answer>();
        int maxAnswers = 1;
        if (questionnaireQuestion.getQuestion().getMaxAnswers() != null) {
            maxAnswers = questionnaireQuestion.getQuestion().getMaxAnswers();
        }
        if (questionnaireQuestion.getQuestion().getDisplayedAnswers() != null && Long.valueOf(100L).equals(questionnaireQuestion.getQuestion().getQuestionTypeId()) && !questionnaireQuestion.getQuestion().isRadioButton()) {
            maxAnswers = questionnaireQuestion.getQuestion().getDisplayedAnswers();
        }
        for (int i = 0; i < maxAnswers; ++i) {
            Answer answer = new Answer();
            answer.setQuestion(questionnaireQuestion.getQuestion());
            answer.setQuestionNumber(questionnaireQuestion.getQuestionNumber());
            answer.setQuestionId(questionnaireQuestion.getQuestion().getId());
            answer.setQuestionnaireQuestionsId(questionnaireQuestion.getId());
            answer.setQuestionnaireQuestion(questionnaireQuestion);
            answer.setAnswerNumber(i + 1);
            answers.add(answer);
        }
        return answers;
    }

    @Override
    public void setupChildAnswerIndicator(AnswerHeader answerHeader) {
        List<Answer> answers = answerHeader.getAnswers();
        List<List<Answer>> parentAnswers = this.setupParentAnswers(answers);
        ArrayList<String> ruleIds = new ArrayList<String>();
        for (Answer answer : answers) {
            if (answer.getQuestionnaireQuestion() != null && answer.getQuestionnaireQuestion().getParentQuestionNumber() > 0) {
                answer.setParentAnswers(parentAnswers.get(answer.getQuestionnaireQuestion().getParentQuestionNumber()));
            }
            if (StringUtils.isNotBlank((CharSequence)answer.getQuestionnaireQuestion().getRuleId())) {
                ruleIds.add(answer.getQuestionnaireQuestion().getRuleId());
            }
            if (!ConditionType.RULE_EVALUATION.getCondition().equals(answer.getQuestionnaireQuestion().getCondition())) continue;
            ruleIds.add(answer.getQuestionnaireQuestion().getConditionValue());
        }
        answers.sort(new AnswerComparator());
        Map<Object, Object> ruleResults = new HashMap();
        if (!ruleIds.isEmpty()) {
            ruleResults = this.runApplicableRules(ruleIds, this.getModuleSpecificBean(answerHeader));
        }
        for (Answer answer : answers) {
            String ruleId;
            QuestionnaireQuestion questionnaireQuestion = answer.getQuestionnaireQuestion();
            if (questionnaireQuestion.getParentQuestionNumber() == 0) {
                ruleId = questionnaireQuestion.getRuleId();
                if (StringUtils.isNotBlank((CharSequence)ruleId)) {
                    if (ruleResults.containsKey(ruleId) && ((Boolean)ruleResults.get(ruleId)).booleanValue()) {
                        answer.setMatchedChild("Y");
                        answer.setRuleMatched(true);
                        continue;
                    }
                    answer.setMatchedChild("N");
                    answer.setRuleMatched(false);
                    answer.setAnswer(null);
                    continue;
                }
                answer.setMatchedChild("Y");
                continue;
            }
            answer.setParentAnswers(parentAnswers.get(questionnaireQuestion.getParentQuestionNumber()));
            if (StringUtils.isBlank((CharSequence)questionnaireQuestion.getCondition())) {
                if (this.isParentNotDisplayed(parentAnswers.get(questionnaireQuestion.getParentQuestionNumber()))) {
                    answer.setMatchedChild("N");
                    answer.setAnswer(null);
                    continue;
                }
                answer.setMatchedChild("Y");
                continue;
            }
            if (this.isParentNotDisplayed(parentAnswers.get(questionnaireQuestion.getParentQuestionNumber()))) {
                answer.setMatchedChild("N");
                answer.setAnswer(null);
                if (!ConditionType.RULE_EVALUATION.getCondition().equals(questionnaireQuestion.getCondition())) continue;
                ruleId = questionnaireQuestion.getConditionValue();
                if (ruleResults.containsKey(ruleId) && ((Boolean)ruleResults.get(ruleId)).booleanValue()) {
                    answer.setRuleMatched(true);
                    continue;
                }
                answer.setRuleMatched(false);
                continue;
            }
            if (ConditionType.RULE_EVALUATION.getCondition().equals(questionnaireQuestion.getCondition()) && ruleResults.containsKey(questionnaireQuestion.getConditionValue()) && ((Boolean)ruleResults.get(questionnaireQuestion.getConditionValue())).booleanValue() || this.isAnyAnswerMatched(questionnaireQuestion.getCondition(), parentAnswers.get(questionnaireQuestion.getParentQuestionNumber()), questionnaireQuestion.getConditionValue())) {
                answer.setMatchedChild("Y");
                continue;
            }
            answer.setMatchedChild("N");
            answer.setAnswer(null);
        }
        this.prepareQuestionnaireView(answerHeader);
    }

    protected void prepareQuestionnaireView(AnswerHeader answerHeader) {
        answerHeader.setQuestions(new ArrayList<QuestionDTO>());
        for (Answer answer : answerHeader.getAnswers()) {
            QuestionDTO currentQuestion = null;
            for (QuestionDTO question : answerHeader.getQuestions()) {
                if (!question.getQuestionnaireQuestion().getQuestionNumber().equals(answer.getQuestionNumber())) continue;
                currentQuestion = question;
                break;
            }
            if (currentQuestion == null) {
                currentQuestion = new QuestionDTO(answer.getQuestionnaireQuestion());
                answerHeader.getQuestions().add(currentQuestion);
                currentQuestion.setChildMatched(StringUtils.equals((CharSequence)answer.getMatchedChild(), (CharSequence)"Y"));
                currentQuestion.setRuleMatched(answer.isRuleMatched());
                currentQuestion.setParentAnswers(answer.getParentAnswers());
            }
            currentQuestion.getAnswers().add(answer);
        }
    }

    @Override
    public boolean isQuestionnaireAnswerComplete(List<Answer> answers) {
        HashMap<Long, Boolean> questionIdsAnswered = new HashMap<Long, Boolean>();
        boolean isComplete = true;
        for (Answer answer : answers) {
            Boolean questionHasAnswer;
            if (!Long.valueOf(100L).equals(answer.getQuestion().getQuestionTypeId())) {
                if (!"Y".equals(answer.getMatchedChild()) || !StringUtils.isBlank((CharSequence)answer.getAnswer()) || answer.getAnswerNumber() != 1) continue;
                isComplete = false;
                continue;
            }
            if (!"Y".equals(answer.getMatchedChild()) || (questionHasAnswer = (Boolean)questionIdsAnswered.get(answer.getQuestionId())) != null && questionHasAnswer.booleanValue()) continue;
            questionIdsAnswered.put(answer.getQuestionId(), answer.getAnswer() != null);
        }
        Iterator<Answer> iterator = questionIdsAnswered.values().iterator();
        while (iterator.hasNext()) {
            boolean answered = (Boolean)((Object)iterator.next());
            isComplete &= answered;
        }
        return isComplete;
    }

    public boolean hasVisibleQuestion(List<Answer> answers) {
        boolean isVisible = false;
        for (Answer answer : answers) {
            if (!StringUtils.equals((CharSequence)"Y", (CharSequence)answer.getMatchedChild())) continue;
            isVisible = true;
            break;
        }
        return isVisible;
    }

    protected boolean isParentNotDisplayed(List<Answer> parentAnswers) {
        boolean valid = true;
        for (Answer answer : parentAnswers) {
            if ("N".equals(answer.getMatchedChild())) {
                valid = true;
                break;
            }
            if ("Y".equals(answer.getMatchedChild())) {
                valid = false;
                break;
            }
            valid = StringUtils.isBlank((CharSequence)answer.getAnswer());
            if (valid) continue;
            break;
        }
        return valid;
    }

    protected boolean isAnyAnswerMatched(String condition, List<Answer> parentAnswers, String conditionValue) {
        boolean valid = false;
        for (Answer answer : parentAnswers) {
            if (StringUtils.isNotBlank((CharSequence)answer.getAnswer())) {
                valid = this.isAnswerMatched(condition, answer.getAnswer(), conditionValue);
            }
            if (!valid) continue;
            break;
        }
        return valid;
    }

    protected boolean isAnswerMatched(String condition, String parentAnswer, String conditionValue) {
        boolean valid = false;
        if (ConditionType.CONTAINS_TEXT.getCondition().equals(condition)) {
            valid = StringUtils.containsIgnoreCase((CharSequence)parentAnswer, (CharSequence)conditionValue);
        } else if (ConditionType.BEGINS_WITH_TEXT.getCondition().equals(condition)) {
            valid = StringUtils.startsWithIgnoreCase((CharSequence)parentAnswer, (CharSequence)conditionValue);
        } else if (ConditionType.ENDS_WITH_TEXT.getCondition().equals(condition)) {
            valid = StringUtils.endsWithIgnoreCase((CharSequence)parentAnswer, (CharSequence)conditionValue);
        } else if (ConditionType.MATCH_TEXT.getCondition().equals(condition)) {
            valid = parentAnswer.equalsIgnoreCase(conditionValue);
        } else if (Integer.parseInt(condition) >= 5 && Integer.parseInt(condition) <= 10) {
            valid = ConditionType.LESS_THAN_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) < Integer.parseInt(conditionValue) || ConditionType.LESS_THAN_OR_EQUALS_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) <= Integer.parseInt(conditionValue) || ConditionType.EQUALS_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) == Integer.parseInt(conditionValue) || ConditionType.NOT_EQUAL_TO_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) != Integer.parseInt(conditionValue) || ConditionType.GREATER_THAN_OR_EQUALS_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) >= Integer.parseInt(conditionValue) || ConditionType.GREATER_THAN_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) > Integer.parseInt(conditionValue);
        } else if (Integer.parseInt(condition) == 11 || Integer.parseInt(condition) == 12) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            try {
                Date date1 = new Date(dateFormat.parse(parentAnswer).getTime());
                Date date2 = new Date(dateFormat.parse(conditionValue).getTime());
                valid = ConditionType.BEFORE_DATE.getCondition().equals(condition) && date1.before(date2) || ConditionType.AFTER_DATE.getCondition().equals(condition) && date1.after(date2);
            }
            catch (Exception e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        return valid;
    }

    @Override
    public List<AnswerHeader> getPrintAnswerHeadersForProtocol(ModuleQuestionnaireBean moduleQuestionnaireBean, String protocolNumber, QuestionnaireHelperBase questionnaireHelper) {
        boolean isAmendmentOrRenewal = protocolNumber.contains("A") || protocolNumber.contains("R");
        questionnaireHelper.populatePrintAnswers();
        List<AnswerHeader> printAnswerHeaders = questionnaireHelper.getPrintAnswerHeaders();
        if (isAmendmentOrRenewal) {
            String originalProtocolNumber = protocolNumber.substring(0, 10);
            ArrayList<AnswerHeader> headers = new ArrayList<AnswerHeader>();
            for (AnswerHeader printAnswerHeader : printAnswerHeaders) {
                if ("2".equals(printAnswerHeader.getModuleSubItemCode()) && printAnswerHeader.getModuleItemKey().equals(originalProtocolNumber) || !printAnswerHeader.getModuleItemKey().equals(protocolNumber)) continue;
                headers.add(printAnswerHeader);
            }
            return headers;
        }
        return printAnswerHeaders;
    }

    private Map<String, Boolean> runApplicableRules(List<String> ruleIds, ModuleQuestionnaireBean moduleQuestionnaireBean) {
        KrmsRulesContext rulesContext = moduleQuestionnaireBean.getKrmsRulesContextFromBean();
        HashMap<String, Boolean> ruleResults = new HashMap<String, Boolean>();
        if (rulesContext != null) {
            ruleResults.putAll(this.getKrmsRulesExecutionService().runApplicableRules(ruleIds, rulesContext, QUESTIONNAIRE_AGENDA_TYPE_ID));
        }
        if (this.globalVariableService.getUserSession() != null) {
            this.globalVariableService.getUserSession().addObject(moduleQuestionnaireBean.getSessionContextKey() + "-rulereferenced", ruleResults);
        }
        return ruleResults;
    }

    @Override
    public ModuleQuestionnaireBean getModuleSpecificBean(AnswerHeader answerHeader) {
        return this.getModuleSpecificBean(answerHeader.getModuleItemCode(), answerHeader.getModuleItemKey(), answerHeader.getModuleSubItemCode(), answerHeader.getModuleSubItemKey(), true);
    }

    @Override
    public ModuleQuestionnaireBean getModuleSpecificBean(String moduleItemCode, String moduleItemKey, String moduleSubItemCode, String moduleSubItemKey, boolean finalDoc) {
        if ("9".equals(moduleItemCode)) {
            return new IacucProtocolModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
        }
        if ("7".equals(moduleItemCode)) {
            return new ProtocolModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
        }
        if ("3".equals(moduleItemCode)) {
            if (this.isProposalPersonSubModule(moduleSubItemCode)) {
                return new ProposalPersonModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
            }
            if ("2".equals(moduleSubItemCode)) {
                return new ProposalDevelopmentS2sModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
            }
            return new ProposalDevelopmentModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
        }
        throw new IllegalArgumentException("Unrecognized moduleItemCode");
    }

    protected boolean isProposalPersonSubModule(String moduleSubItemCode) {
        return StringUtils.equals((CharSequence)moduleSubItemCode, (CharSequence)"3") || StringUtils.equals((CharSequence)moduleSubItemCode, (CharSequence)this.getParameterService().getParameterValueAsString("KC-GEN", "All", "MODULE_SUB_ITEM_CODE_COI_CERTIFICATION")) || StringUtils.equals((CharSequence)moduleSubItemCode, (CharSequence)this.getParameterService().getParameterValueAsString("KC-GEN", "All", "MODULE_SUB_ITEM_CODE_KP_CERTIFICATION")) || StringUtils.equals((CharSequence)moduleSubItemCode, (CharSequence)this.getParameterService().getParameterValueAsString("KC-GEN", "All", "MODULE_SUB_ITEM_CODE_PI_CERTIFICATION"));
    }

    @Override
    public List<AnswerHeader> getNewVersionOfQuestionnaireAnswer(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        List<AnswerHeader> newAnswerHeaders = this.getQuestionnaireAnswer(moduleQuestionnaireBean);
        for (AnswerHeader answerHeader : newAnswerHeaders) {
            answerHeader.setId(null);
            for (Answer answer : answerHeader.getAnswers()) {
                answer.setId(null);
            }
        }
        return newAnswerHeaders;
    }

    protected QuestionnaireService getQuestionnaireService() {
        return this.questionnaireService;
    }

    public void setQuestionnaireService(QuestionnaireService questionnaireService) {
        this.questionnaireService = questionnaireService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public KrmsRulesExecutionService getKrmsRulesExecutionService() {
        return this.krmsRulesExecutionService;
    }

    public void setKrmsRulesExecutionService(KrmsRulesExecutionService krmsRulesExecutionService) {
        this.krmsRulesExecutionService = krmsRulesExecutionService;
    }

    public GlobalVariableService getGlobalVariableService() {
        return this.globalVariableService;
    }

    public void setGlobalVariableService(GlobalVariableService globalVariableService) {
        this.globalVariableService = globalVariableService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    protected static enum ConditionType {
        CONTAINS_TEXT("1"),
        BEGINS_WITH_TEXT("2"),
        ENDS_WITH_TEXT("3"),
        MATCH_TEXT("4"),
        LESS_THAN_NUMBER("5"),
        LESS_THAN_OR_EQUALS_NUMBER("6"),
        EQUALS_NUMBER("7"),
        NOT_EQUAL_TO_NUMBER("8"),
        GREATER_THAN_OR_EQUALS_NUMBER("9"),
        GREATER_THAN_NUMBER("10"),
        BEFORE_DATE("11"),
        AFTER_DATE("12"),
        RULE_EVALUATION("13");

        String condition;

        private ConditionType(String condition) {
            this.condition = condition;
        }

        public String getCondition() {
            return this.condition;
        }
    }
}

