/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.submit;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.submit.ExecuteProtocolSubmitActionRule;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolSubmitActionRuleBase
extends KcTransactionalDocumentRuleBase
implements ExecuteProtocolSubmitActionRule {
    private static final String MANDATORY = "M";
    private ParameterService parameterService;

    @Override
    public boolean processSubmitAction(ProtocolDocumentBase document, ProtocolSubmitAction submitAction) {
        boolean isValid = this.validateSubmissionType(document, submitAction);
        isValid &= this.validateProtocolReviewType(submitAction);
        if (StringUtils.isNotBlank((CharSequence)submitAction.getSubmissionTypeCode()) && StringUtils.isNotBlank((CharSequence)submitAction.getProtocolReviewTypeCode())) {
            isValid &= this.isValidSubmReviewType(submitAction);
        }
        if (this.isMandatory()) {
            isValid &= this.validateCommittee(submitAction);
            isValid &= this.validateSchedule(submitAction);
        }
        isValid &= this.validateReviewers(submitAction);
        return isValid &= this.checkNoSpoofing(submitAction);
    }

    private boolean validateCommittee(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)submitAction.getNewCommitteeId())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.committeeId", "error.protocol.submission.committee.required", new String[0]);
        }
        return valid;
    }

    private boolean validateSchedule(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isBlank((CharSequence)submitAction.getNewScheduleId())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.scheduleId", "error.protocol.submission.schedule.required", new String[0]);
        }
        return valid;
    }

    private boolean validateSubmissionType(ProtocolDocumentBase document, ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        String submissionTypeCode = submitAction.getSubmissionTypeCode();
        if (StringUtils.isBlank((CharSequence)submissionTypeCode)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.submissionTypeCode", "error.protocol.submissionTypeCode.notFound", new String[0]);
        } else {
            isValid = this.isValidSubmTypeQual(submitAction);
        }
        return isValid;
    }

    private boolean validateProtocolReviewType(ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        String protocolReviewTypeCode = submitAction.getProtocolReviewTypeCode();
        if (StringUtils.isBlank((CharSequence)protocolReviewTypeCode)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.protocolReviewTypeCode", "error.protocol.reviewTypeCode.notFound", new String[0]);
        } else if (this.isReviewTypeInvalid(protocolReviewTypeCode)) {
            isValid = false;
            this.reportError("actionHelper.protocolSubmitAction.protocolReviewTypeCode", "error.protocol.reviewTypeCode.invalid", protocolReviewTypeCode);
        }
        return isValid;
    }

    private boolean validateReviewers(ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        return isValid;
    }

    public boolean checkNoSpoofing(ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        return isValid;
    }

    private boolean isValidSubmReviewType(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (!StringUtils.isNotBlank((CharSequence)submitAction.getSubmissionTypeCode()) || StringUtils.isNotBlank((CharSequence)submitAction.getProtocolReviewTypeCode())) {
            // empty if block
        }
        return valid;
    }

    private boolean isValidSubmTypeQual(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isNotBlank((CharSequence)submitAction.getSubmissionTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionTypeCode", submitAction.getSubmissionTypeCode());
        }
        return valid;
    }

    protected abstract Class<? extends ProtocolSubmissionTypeBase> getProtocolSubmissionTypeClassHook();

    private boolean isReviewTypeInvalid(String reviewTypeCode) {
        return !this.existsUnique(this.getProtocolReviewTypeClassHook(), "reviewTypeCode", reviewTypeCode);
    }

    protected abstract Class<? extends ProtocolReviewTypeBase> getProtocolReviewTypeClassHook();

    private boolean existsUnique(Class<? extends BusinessObject> boType, String propertyName, String keyField) {
        if (keyField != null) {
            BusinessObjectService businessObjectService = KcServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, keyField);
            if (businessObjectService.countMatching(boType, fieldValues) == 1) {
                return true;
            }
        }
        return false;
    }

    private boolean isMandatory() {
        String param = this.getParameterService().getParameterValueAsString(this.getProtocolDocumentClassHook(), "IRB_COMM_SELECTION_DURING_SUBMISSION");
        return StringUtils.equalsIgnoreCase((CharSequence)MANDATORY, (CharSequence)param);
    }

    protected abstract Class<? extends ProtocolDocumentBase> getProtocolDocumentClassHook();

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }
}

