/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.committee.impl.meeting;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.committee.impl.meeting.MeetingControllerService;
import org.kuali.coeus.common.committee.impl.meeting.MeetingHelperBase;
import org.kuali.coeus.sys.framework.gv.GlobalVariableService;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.document.Document;

public abstract class MeetingFormBase
extends KualiForm {
    private static final long serialVersionUID = -7825455832928793712L;
    private static final String ERROR_SCHEDULE_MULTIPLE_TABS = "error.schedule.multipleTabs";
    private static final String SCHEDULE_ID = "meetingHelper.committeeSchedule.id";
    private MeetingHelperBase meetingHelper;
    private String formKey;
    private Document document;
    private boolean readOnly;

    public MeetingFormBase() {
        this.initialize();
    }

    public void initialize() {
        this.setMeetingHelper(this.getNewMeetingHelperInstanceHook(this));
    }

    protected abstract MeetingHelperBase getNewMeetingHelperInstanceHook(MeetingFormBase var1);

    public MeetingHelperBase getMeetingHelper() {
        return this.meetingHelper;
    }

    public void setMeetingHelper(MeetingHelperBase meetingHelper) {
        this.meetingHelper = meetingHelper;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.getMeetingHelper().setAbsenteeList("");
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void populate(HttpServletRequest request) {
        if (this.getMeetingHelper() != null && this.getMeetingHelper().getCommitteeSchedule() != null && this.getMeetingHelper().getCommitteeSchedule().getId() != null) {
            String sessionScheduleId = Long.toString(this.getMeetingHelper().getCommitteeSchedule().getId());
            String requestScheduleId = request.getParameter(SCHEDULE_ID);
            if (requestScheduleId != null && !sessionScheduleId.equals(requestScheduleId)) {
                this.getGlobalVariableService().getMessageMap().putError(SCHEDULE_ID, ERROR_SCHEDULE_MULTIPLE_TABS, new String[]{""});
                this.setReadOnly(true);
            }
        }
        super.populate(request);
        this.populateFalseCheckboxes(request);
    }

    private void populateFalseCheckboxes(HttpServletRequest request) {
        String[] checkboxesToReset;
        Map parameterMap = request.getParameterMap();
        if (parameterMap.get("checkboxToReset") != null && (checkboxesToReset = request.getParameterValues("checkboxToReset")) != null && checkboxesToReset.length > 0) {
            for (int i = 0; i < checkboxesToReset.length; ++i) {
                String propertyName = checkboxesToReset[i];
                if (!StringUtils.isBlank((CharSequence)propertyName) && parameterMap.get(propertyName) == null) {
                    this.populateForProperty(propertyName, "No", parameterMap);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)propertyName) || parameterMap.get(propertyName) == null || ((String[])parameterMap.get(propertyName)).length < 1 || !((String[])parameterMap.get(propertyName))[0].equalsIgnoreCase("on")) continue;
                this.populateForProperty(propertyName, "Yes", parameterMap);
            }
        }
    }

    protected GlobalVariableService getGlobalVariableService() {
        return KcServiceLocator.getService(GlobalVariableService.class);
    }

    protected abstract MeetingControllerService getMeetingControllerService();
}

