/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.ErrorReporter;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.rice.krad.util.AuditError;

public abstract class ProtocolAttachmentProtocolRuleHelperBase {
    protected static final String NOTES_ATTACHMENTS_CLUSTER_LABEL = "Notes & Attachments";
    protected static final String NOTES_AND_ATTACHMENT_AUDIT_ERRORS_KEY = "NoteAndAttachmentAuditErrors";
    protected static final String NOTE_AND_ATTACHMENT_LINK = "noteAndAttachment";
    protected ErrorReporter errorReporter;
    protected String propertyPrefix;

    protected ProtocolAttachmentProtocolRuleHelperBase() {
    }

    protected ProtocolAttachmentProtocolRuleHelperBase(String aPropertyPrefix) {
        this.resetPropertyPrefix(aPropertyPrefix);
    }

    public void resetPropertyPrefix(String aPropertyPrefix) {
        if (aPropertyPrefix == null) {
            throw new IllegalArgumentException("propertyPrefix is null");
        }
        this.propertyPrefix = aPropertyPrefix;
    }

    protected boolean validStatusForSubmission(ProtocolAttachmentProtocolBase attachmentProtocol) {
        if (!StringUtils.equals((CharSequence)attachmentProtocol.getDocumentStatusCode(), (CharSequence)"3") && !"1".equals(attachmentProtocol.getStatusCode())) {
            AuditError error = new AuditError(this.propertyPrefix + "." + ProtocolAttachmentProtocolBase.PropertyName.STATUS_CODE, "error.protocolAttachment.not.complete", NOTE_AND_ATTACHMENT_LINK);
            this.getErrorReporter().reportAuditError(error, NOTES_AND_ATTACHMENT_AUDIT_ERRORS_KEY, NOTES_ATTACHMENTS_CLUSTER_LABEL, "Error");
            return false;
        }
        return true;
    }

    public boolean validStatus(ProtocolAttachmentProtocolBase attachment) {
        if (attachment.getStatus() == null || StringUtils.isBlank((CharSequence)attachment.getStatus().getCode())) {
            return true;
        }
        return true;
    }

    public ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = KcServiceLocator.getService(ErrorReporter.class);
        }
        return this.errorReporter;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }
}

