/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.web.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.sys.framework.controller.BackLocationAction;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.service.ResearchAreaCurrentReferencerHolderBase;
import org.kuali.kra.service.ResearchAreasServiceBase;
import org.kuali.kra.web.struts.form.ResearchAreasFormBase;
import org.kuali.rice.kns.web.struts.action.KualiAction;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ResearchAreasActionBase
extends KualiAction
implements BackLocationAction {
    private static final Logger LOG = LogManager.getLogger(ResearchAreasActionBase.class);

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        return mapping.findForward("basic");
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.returnToSender(request, mapping, (KualiForm)form);
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.returnToSender(request, mapping, (KualiForm)form);
    }

    private void setResearchAreas(ActionForm form) {
        block24: {
            ResearchAreasFormBase researchAreaForm = (ResearchAreasFormBase)form;
            ResearchAreasServiceBase researchAreaService = this.getResearchAreasService();
            if (StringUtils.isNotBlank((CharSequence)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("Y")) {
                if (researchAreaService.isResearchAreaExist(researchAreaForm.getResearchAreaCode(), researchAreaForm.getDeletedRas())) {
                    researchAreaForm.setResearchAreas("<h3>true</h3>");
                } else {
                    researchAreaForm.setResearchAreas("<h3>false</h3>");
                }
            } else if (StringUtils.isNotBlank((CharSequence)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("S")) {
                try {
                    researchAreaService.saveResearchAreas(researchAreaForm.getSqlScripts());
                    String error = (String)GlobalVariables.getUserSession().retrieveObject("raError");
                    if (StringUtils.isNotBlank((CharSequence)error)) {
                        researchAreaForm.setResearchAreas("<h3>" + error + "</h3>");
                        GlobalVariables.getUserSession().addObject("raError", null);
                        break block24;
                    }
                    researchAreaForm.setResearchAreas("<h3>Success</h3>");
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            } else if (StringUtils.isNotBlank((CharSequence)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("A")) {
                researchAreaForm.setResearchAreas(researchAreaService.getSubResearchAreasForTreeView(researchAreaForm.getResearchAreaCode(), true));
            } else if (StringUtils.isNotBlank((CharSequence)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("I")) {
                try {
                    String researchAreaCode = researchAreaForm.getResearchAreaCode();
                    ResearchAreaCurrentReferencerHolderBase referenceHolder = researchAreaService.getAnyCurrentReferencerForResearchAreaOrDescendant(researchAreaCode);
                    if (referenceHolder != ResearchAreaCurrentReferencerHolderBase.NO_REFERENCER) {
                        researchAreaForm.setResearchAreas("<h3>" + referenceHolder.getMessage() + "</h3>");
                        GlobalVariables.getUserSession().addObject("raError", null);
                        break block24;
                    }
                    researchAreaService.deactivateResearchAreaAndDescendants(researchAreaCode);
                    String error = (String)GlobalVariables.getUserSession().retrieveObject("raError");
                    if (StringUtils.isNotBlank((CharSequence)error)) {
                        researchAreaForm.setResearchAreas("<h3>" + error + "</h3>");
                        GlobalVariables.getUserSession().addObject("raError", null);
                        break block24;
                    }
                    researchAreaForm.setResearchAreas("<h3>Success</h3>");
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            } else if (StringUtils.isNotBlank((CharSequence)researchAreaForm.getAddRA()) && researchAreaForm.getAddRA().equals("D")) {
                try {
                    if (researchAreaService.checkResearchAreaAndDescendantsNotReferenced(researchAreaForm.getResearchAreaCode())) {
                        researchAreaService.deleteResearchAreaAndDescendants(researchAreaForm.getResearchAreaCode());
                        String error = (String)GlobalVariables.getUserSession().retrieveObject("raError");
                        if (StringUtils.isNotBlank((CharSequence)error)) {
                            researchAreaForm.setResearchAreas("<h3>" + error + "</h3>");
                            GlobalVariables.getUserSession().addObject("raError", null);
                        } else {
                            researchAreaForm.setResearchAreas("<h3>Success</h3>");
                        }
                        break block24;
                    }
                    researchAreaForm.setResearchAreas("<h3>Research area or descendants are (were) being referenced in a current (past) version of committee, committee member or protocol</h3>");
                    GlobalVariables.getUserSession().addObject("raError", null);
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            } else {
                researchAreaForm.setResearchAreas(researchAreaService.getSubResearchAreasForTreeView(researchAreaForm.getResearchAreaCode(), false));
            }
        }
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ResearchAreasFormBase researchAreaForm = (ResearchAreasFormBase)form;
        ActionForward forward = super.execute(mapping, form, request, response);
        this.setResearchAreas(form);
        this.canMaintainResearchArea(researchAreaForm);
        return forward;
    }

    private void canMaintainResearchArea(ResearchAreasFormBase researchAreaForm) {
        ApplicationTask task = new ApplicationTask(this.getResearchAreasTask());
        researchAreaForm.setAuthorizedToMaintainResearchAreas(this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), task));
    }

    private String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return KcServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected abstract ResearchAreasServiceBase getResearchAreasService();

    protected abstract String getResearchAreasTask();
}

