/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.institutionalproposal.contacts;

import java.util.Collection;
import java.util.HashMap;
import org.kuali.coeus.common.framework.type.InvestigatorCreditType;
import org.kuali.coeus.sys.api.model.AbstractDecimal;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplitRule;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplitRuleEvent;
import org.kuali.kra.institutionalproposal.rules.InstitutionalProposalCreditSplitAuditError;

public class InstitutionalProposalPersonCreditSplitRuleImpl
extends KcTransactionalDocumentRuleBase
implements InstitutionalProposalPersonCreditSplitRule {
    private static final ScaleTwoDecimal MAX_TOTAL_VALUE = new ScaleTwoDecimal(100.0);

    @Override
    public boolean checkInstitutionalProposalPersonCreditSplitTotals(InstitutionalProposalPersonCreditSplitRuleEvent event) {
        boolean retval = true;
        for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
            if (!creditType.addsToHundred().booleanValue()) continue;
            ScaleTwoDecimal value = event.getTotalsByCreditSplitType().get(creditType.getCode());
            if (value == null) break;
            if (((ScaleTwoDecimal)MAX_TOTAL_VALUE.subtract((AbstractDecimal)value)).isZero()) continue;
            InstitutionalProposalCreditSplitAuditError.addAuditError("error.award.person.credit.split.error", creditType.getDescription());
            retval = false;
        }
        return retval;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }
}

