/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.framework.print.watermark;

import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.lang.reflect.Field;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.print.watermark.WatermarkConstants;

public class Font {
    private static final Logger LOG = LogManager.getLogger(Font.class);
    public static String BOLD;
    private String fontName;
    private Color color;
    private int size;

    public Font() {
    }

    public Font(int size) {
        this.size = size;
    }

    public String getFont() {
        return this.fontName;
    }

    public void setFont(String font) {
        this.fontName = font;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(String strColor) {
        if (strColor == null) {
            this.color = WatermarkConstants.DEFAULT_COLOR;
            return;
        }
        try {
            this.color = Color.decode(strColor);
        }
        catch (NumberFormatException nfe) {
            try {
                Field f = Color.class.getField(strColor);
                this.color = (Color)f.get(null);
            }
            catch (Exception exception) {
                this.color = WatermarkConstants.DEFAULT_WATERMARK_COLOR;
                LOG.error("Exception occurred in WatermarkFont.. NumberFormatException: " + exception);
            }
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public BaseFont getBaseFont() {
        try {
            return BaseFont.createFont((String)"Times-Bold", (String)"Cp1252", (boolean)true);
        }
        catch (Exception exception) {
            LOG.error("Exception occurred in Watermark getBaseFont. BaseFontException: " + exception);
            return null;
        }
    }
}

