/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.proposal.impl.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.kuali.coeus.common.framework.print.PendingReportBean;
import org.kuali.coeus.common.framework.version.VersionStatus;
import org.kuali.coeus.common.proposal.impl.report.BaseReportDaoOjb;
import org.kuali.coeus.common.proposal.impl.report.PendingReportDao;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.DocumentBase;
import org.springframework.stereotype.Component;

@Component(value="pendingReportDao")
public class PendingReportDaoOjb
extends BaseReportDaoOjb
implements PendingReportDao {
    private static final String PERSON_ID = "personId";
    private static final String IP_PROPOSAL_SEQUENCE_STATUS = "institutionalProposal.proposalSequenceStatus";
    private static final String IP_PROPOSAL_TYPE_CODE = "institutionalProposal.proposalTypeCode";
    private static final String IP_PROPOSAL_STATUS_CODE = "institutionalProposal.statusCode";

    @Override
    public List<PendingReportBean> queryForPendingSupport(String personId, Collection<String> excludedProposalTypes, Collection<String> excludedProposalStatuses) throws WorkflowException {
        ArrayList<PendingReportBean> data = new ArrayList<PendingReportBean>();
        for (InstitutionalProposalPerson ipPerson : this.executePendingSupportQuery(personId, excludedProposalTypes, excludedProposalStatuses)) {
            PendingReportBean bean = this.buildPendingReportBean(ipPerson);
            if (bean == null) continue;
            data.add(bean);
        }
        return data;
    }

    private PendingReportBean buildPendingReportBean(InstitutionalProposalPerson ipPerson) throws WorkflowException {
        InstitutionalProposal proposal = ipPerson.getInstitutionalProposal();
        PendingReportBean bean = null;
        if (proposal != null && this.shouldDataBeIncluded((DocumentBase)proposal.getInstitutionalProposalDocument())) {
            bean = new PendingReportBean(ipPerson);
        }
        return bean;
    }

    private Collection<InstitutionalProposalPerson> executePendingSupportQuery(String personId, Collection<String> excludedProposalTypes, Collection<String> excludedProposalStatuses) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo(PERSON_ID, (Object)personId);
        criteria.addEqualTo(IP_PROPOSAL_SEQUENCE_STATUS, (Object)VersionStatus.ACTIVE.toString());
        if (!excludedProposalTypes.isEmpty()) {
            criteria.addNotIn(IP_PROPOSAL_TYPE_CODE, excludedProposalTypes);
        }
        if (!excludedProposalStatuses.isEmpty()) {
            criteria.addNotIn(IP_PROPOSAL_STATUS_CODE, excludedProposalStatuses);
        }
        QueryByCriteria queryByCriteria = QueryFactory.newQuery(InstitutionalProposalPerson.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)queryByCriteria);
    }
}

