/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.framework.scheduling.util;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class Time24HrFmt
implements Serializable {
    private static final long serialVersionUID = 2554984023134603437L;
    private String hours;
    private String minutes;

    public Time24HrFmt(String time) {
        this.parseTime(time);
    }

    public String getHours() {
        return this.hours;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    private void parseTime(String time) {
        DateTimeFormatter fmt = ISODateTimeFormat.hourMinute();
        LocalTime localTime = fmt.parseLocalTime(time);
        this.hours = String.valueOf(localTime.getHourOfDay());
        this.minutes = String.valueOf(localTime.getMinuteOfHour());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hours == null ? 0 : this.hours.hashCode());
        result = 31 * result + (this.minutes == null ? 0 : this.minutes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Time24HrFmt other = (Time24HrFmt)obj;
        return StringUtils.equals((CharSequence)this.hours, (CharSequence)other.hours) && StringUtils.equals((CharSequence)this.minutes, (CharSequence)other.minutes);
    }

    public String toString() {
        return this.hours + ":" + this.minutes;
    }
}

