/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.rule.KcTransactionalDocumentRuleBase;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.kra.award.commitments.AwardBenefitsRatesRule;
import org.kuali.kra.award.commitments.AwardBenefitsRatesRuleEvent;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ValidRates;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardBenefitsRatesRuleImpl
extends KcTransactionalDocumentRuleBase
implements AwardBenefitsRatesRule {
    private static final String ON_CAMPUS_RATE = "onCampusRate";
    private static final String OFF_CAMPUS_RATE = "offCampusRate";
    private static final String BENEFITS_RATES = "benefitsRates";
    private ParameterService parameterService;
    BusinessObjectService businessObjectService;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KcServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    @Override
    public boolean processBenefitsRatesBusinessRules(AwardBenefitsRatesRuleEvent event) {
        return this.validateBenefitsRatesInValidRatesTable(event.getAward());
    }

    boolean validateBenefitsRatesInValidRatesTable(Award award) {
        boolean valid = true;
        if (StringUtils.equalsIgnoreCase((CharSequence)this.getParameterService().getParameterValueAsString(AwardDocument.class, "enable.award.FnA.validation"), (CharSequence)"1")) {
            valid = this.checkValidRatesOrNullValues(award);
            if (!valid) {
                this.reportError(BENEFITS_RATES, "error.awardBenefitsRates.invalid.rates", new String[0]);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.getParameterService().getParameterValueAsString(AwardDocument.class, "enable.award.FnA.validation"), (CharSequence)"2") && !(valid = this.checkSingleValidRatesOrNullValues(award))) {
            if (StringUtils.equalsIgnoreCase((CharSequence)this.getParameterService().getParameterValueAsString(AwardDocument.class, "option.warning.error.award.FnA.validation"), (CharSequence)"E")) {
                this.reportError(BENEFITS_RATES, "error.awardBenefitsRates.invalid.rates", new String[0]);
            } else {
                valid = true;
                this.reportWarning(BENEFITS_RATES, "error.awardBenefitsRates.invalid.rates", new String[0]);
            }
        }
        return valid;
    }

    boolean checkValidRatesOrNullValues(Award award) {
        boolean valid = true;
        if (award.getSpecialEbRateOffCampus() != null || award.getSpecialEbRateOnCampus() != null) {
            valid = this.getValidRates(award.getSpecialEbRateOnCampus(), award.getSpecialEbRateOffCampus()).size() > 0;
        }
        return valid;
    }

    boolean checkSingleValidRatesOrNullValues(Award award) {
        boolean valid = true;
        if (award.getSpecialEbRateOffCampus() != null) {
            boolean bl = valid = this.getValidRatesforSingleRate(OFF_CAMPUS_RATE, award.getSpecialEbRateOffCampus()).size() > 0;
        }
        if (award.getSpecialEbRateOnCampus() != null) {
            valid = this.getValidRatesforSingleRate(ON_CAMPUS_RATE, award.getSpecialEbRateOnCampus()).size() > 0;
        }
        return valid;
    }

    Collection<ValidRates> getValidRates(ScaleTwoDecimal specialEbRateOnCampus, ScaleTwoDecimal specialEbRateOffCampus) {
        HashMap<String, ScaleTwoDecimal> rateValues = new HashMap<String, ScaleTwoDecimal>();
        rateValues.put(ON_CAMPUS_RATE, specialEbRateOnCampus);
        rateValues.put(OFF_CAMPUS_RATE, specialEbRateOffCampus);
        return this.getKraBusinessObjectService().findMatching(ValidRates.class, rateValues);
    }

    BusinessObjectService getKraBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KcServiceLocator.getService("businessObjectService");
        }
        return this.businessObjectService;
    }

    Collection<ValidRates> getValidRatesforSingleRate(String rateType, ScaleTwoDecimal benefitRate) {
        HashMap<String, ScaleTwoDecimal> rateValues = new HashMap<String, ScaleTwoDecimal>();
        rateValues.put(rateType, benefitRate);
        return this.getKraBusinessObjectService().findMatching(ValidRates.class, rateValues);
    }
}

