/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.iacuc.actions.submit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.coeus.common.committee.impl.service.CommitteeServiceBase;
import org.kuali.coeus.sys.framework.keyvalue.PrefixValuesFinder;
import org.kuali.kra.iacuc.actions.IacucActionsKeyValuesBase;
import org.kuali.kra.iacuc.actions.submit.IacucProtocolReviewType;
import org.kuali.kra.iacuc.committee.service.IacucCommitteeService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class IacucProtocolReviewTypeValuesFinder
extends IacucActionsKeyValuesBase {
    private static final String PERMISSION_NAME = "View Active Protocol Review Types";
    private PermissionService permissionService;
    private static List<IacucProtocolReviewType> allReviewTypes = null;

    public List<KeyValue> getKeyValues() {
        List<KeyValue> keyValues = this.filterActiveProtocolReviewTypes();
        keyValues.add(0, (KeyValue)new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        return keyValues;
    }

    private List<KeyValue> filterActiveProtocolReviewTypes() {
        ArrayList<KeyValue> filteredKeyValues = new ArrayList<KeyValue>();
        boolean canViewNonGlobalReviewTypes = this.getPermissionService().hasPermission(GlobalVariables.getUserSession().getPrincipalId(), "KC-SYS", PERMISSION_NAME);
        for (IacucProtocolReviewType item : this.getAllReviewTypes()) {
            if (!item.isGlobalFlag() && !canViewNonGlobalReviewTypes) continue;
            filteredKeyValues.add((KeyValue)new ConcreteKeyValue(item.getReviewTypeCode(), item.getDescription()));
        }
        return filteredKeyValues;
    }

    public List<IacucProtocolReviewType> getAllReviewTypes() {
        if (allReviewTypes == null) {
            allReviewTypes = new ArrayList<IacucProtocolReviewType>();
            Collection prTypes = this.getKeyValuesService().findAll(IacucProtocolReviewType.class);
            for (IacucProtocolReviewType protocolReviewType : prTypes) {
                allReviewTypes.add(protocolReviewType);
            }
        }
        return allReviewTypes;
    }

    public PermissionService getPermissionService() {
        if (this.permissionService == null) {
            this.permissionService = KimApiServiceLocator.getPermissionService();
        }
        return this.permissionService;
    }

    @Override
    protected Class<? extends CommitteeServiceBase> getCommitteeServiceClassHook() {
        return IacucCommitteeService.class;
    }
}

