/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.actions;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.kuali.coeus.common.committee.impl.meeting.CommitteeScheduleMinuteBase;
import org.kuali.coeus.common.framework.attachment.AttachmentFile;
import org.kuali.coeus.common.framework.auth.task.ApplicationTask;
import org.kuali.coeus.common.framework.auth.task.TaskAuthorizationService;
import org.kuali.coeus.common.framework.print.AbstractPrint;
import org.kuali.coeus.common.framework.print.AttachmentDataSource;
import org.kuali.coeus.common.framework.print.Printable;
import org.kuali.coeus.common.framework.print.PrintableAttachment;
import org.kuali.coeus.common.framework.print.PrintingException;
import org.kuali.coeus.common.framework.print.util.PrintingUtils;
import org.kuali.coeus.common.framework.print.watermark.WatermarkService;
import org.kuali.coeus.common.notification.impl.NotificationRenderer;
import org.kuali.coeus.common.notification.impl.service.KcNotificationService;
import org.kuali.coeus.sys.framework.controller.StrutsConfirmation;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.coeus.sys.framework.validation.AuditHelper;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolAction;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolForm;
import org.kuali.kra.irb.actions.ActionHelper;
import org.kuali.kra.irb.actions.ProtocolActionBean;
import org.kuali.kra.irb.actions.ProtocolRiskLevelCommentable;
import org.kuali.kra.irb.actions.ProtocolSubmissionBuilder;
import org.kuali.kra.irb.actions.ProtocolSubmissionDoc;
import org.kuali.kra.irb.actions.amendrenew.ModifyAmendmentSectionsEvent;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.irb.actions.assignagenda.ProtocolAssignToAgendaService;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedBean;
import org.kuali.kra.irb.actions.assigncmtsched.ProtocolAssignCmtSchedService;
import org.kuali.kra.irb.actions.copy.ProtocolCopyService;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.irb.actions.correspondence.ProtocolActionsCorrespondence;
import org.kuali.kra.irb.actions.decision.CommitteeDecision;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionAbstainerEvent;
import org.kuali.kra.irb.actions.decision.CommitteeDecisionRecuserEvent;
import org.kuali.kra.irb.actions.decision.CommitteePerson;
import org.kuali.kra.irb.actions.delete.ProtocolDeleteService;
import org.kuali.kra.irb.actions.followup.FollowupActionService;
import org.kuali.kra.irb.actions.genericactions.ProtocolGenericActionBean;
import org.kuali.kra.irb.actions.history.ProtocolHistoryFilterDatesEvent;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionBean;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionEvent;
import org.kuali.kra.irb.actions.modifysubmission.ProtocolModifySubmissionService;
import org.kuali.kra.irb.actions.notification.ProtocolNotificationRequestBean;
import org.kuali.kra.irb.actions.notifyirb.ProtocolNotifyIrbBean;
import org.kuali.kra.irb.actions.print.ProtocolActionPrintEvent;
import org.kuali.kra.irb.actions.print.ProtocolPrintType;
import org.kuali.kra.irb.actions.print.ProtocolPrintingService;
import org.kuali.kra.irb.actions.request.ProtocolRequestBean;
import org.kuali.kra.irb.actions.reviewcomments.ProtocolAddReviewAttachmentEvent;
import org.kuali.kra.irb.actions.reviewcomments.ProtocolAddReviewCommentEvent;
import org.kuali.kra.irb.actions.reviewcomments.ProtocolManageReviewAttachmentEvent;
import org.kuali.kra.irb.actions.reviewcomments.ReviewAttachmentsBean;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsBean;
import org.kuali.kra.irb.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.irb.actions.risklevel.ProtocolAddRiskLevelEvent;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevel;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevelBean;
import org.kuali.kra.irb.actions.risklevel.ProtocolRiskLevelService;
import org.kuali.kra.irb.actions.risklevel.ProtocolUpdateRiskLevelEvent;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionLite;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.irb.actions.submit.ProtocolSubmitActionEvent;
import org.kuali.kra.irb.actions.submit.ValidProtocolActionAction;
import org.kuali.kra.irb.actions.undo.UndoLastActionBean;
import org.kuali.kra.irb.actions.undo.UndoLastActionService;
import org.kuali.kra.irb.auth.ProtocolTask;
import org.kuali.kra.irb.correspondence.ProtocolCorrespondence;
import org.kuali.kra.irb.noteattachment.AddProtocolNotepadEvent;
import org.kuali.kra.irb.noteattachment.AddProtocolNotepadRuleImpl;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentPersonnel;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.irb.noteattachment.ProtocolNotepad;
import org.kuali.kra.irb.notification.IRBNotificationContext;
import org.kuali.kra.irb.notification.IRBNotificationRenderer;
import org.kuali.kra.irb.onlinereview.ProtocolReviewAttachment;
import org.kuali.kra.irb.questionnaire.print.IrbCorrespondencePrintingService;
import org.kuali.kra.irb.summary.ProtocolSummary;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolOnlineReviewCommentable;
import org.kuali.kra.protocol.actions.ProtocolSubmissionDocBase;
import org.kuali.kra.protocol.actions.notify.ProtocolActionAttachment;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryPrintOptions;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.summary.AttachmentSummary;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.action.AuditModeAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.DocumentEvent;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolProtocolActionsAction
extends ProtocolAction
implements AuditModeAction {
    private static final Logger LOG = LogManager.getLogger(ProtocolProtocolActionsAction.class);
    private static final String CONFIRM_NO_ACTION = "";
    private static final String CONFIRM_DELETE_ACTION_ATT = "confirmDeleteActionAttachment";
    private static final String CONFIRM_FOLLOWUP_ACTION = "confirmAddFollowupAction";
    private static final String CONFIRM_SUBMIT_FOR_REVIEW_KEY = "confirmSubmitForReview";
    private static final String CONFIRM_ASSIGN_TO_AGENDA_KEY = "confirmAssignToAgenda";
    private static final String CONFIRM_ASSIGN_CMT_SCHED_KEY = "confirmAssignCmtSched";
    private static final String CONIFRM_REMOVE_REVIEWER_KEY = "confirmRemoveReviewer";
    private static final String PERSON_NOT_FOUND_FORMAT_STRING = "%s (not found)";
    private static final String NOT_FOUND_SELECTION = "The attachment was not found for selection ";
    private static final String CONFIRM_DELETE_PROTOCOL_KEY = "confirmDeleteProtocol";
    private static final String INVALID_ATTACHMENT = "this attachment version is invalid ";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;
    private static final String SUBMISSION_ID = "submissionId";
    private static final String CORRESPONDENCE = "correspondence";
    private static final Map<String, String> PRINTTAG_MAP = new HashMap<String, String>(){
        {
            this.put("summary", "PROTOCOL_SUMMARY_VIEW_REPORT");
            this.put("full", "PROTOCOL_FULL_PROTOCOL_REPORT");
            this.put("history", "PROTOCOL_PROTOCOL_HISTORY_REPORT");
            this.put("comments", "PROTOCOL_REVIEW_COMMENTS_REPORT");
        }
    };

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        String currentTaskName = this.getTaskName(request);
        if (currentTaskName != null) {
            protocolForm.getActionHelper().setCurrentTask(currentTaskName);
        } else {
            protocolForm.getActionHelper().setCurrentTask(CONFIRM_NO_ACTION);
        }
        ActionForward actionForward = super.execute(mapping, form, request, response);
        protocolForm.getActionHelper().prepareView();
        if ("close".equals(protocolForm.getMethodToCall()) || protocolForm.getMethodToCall() == null) {
            return mapping.findForward("portal");
        }
        protocolForm.getActionHelper().initSubmissionDetails();
        return actionForward;
    }

    public ActionForward copyProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ApplicationTask task = new ApplicationTask("createProtocol");
        if (this.isAuthorized(task)) {
            ProtocolDocument copy = (ProtocolDocument)this.getDocumentService().saveDocument((Document)this.getProtocolCopyService().copyProtocol(protocolForm.getProtocolDocument()));
            protocolForm.setDocId(copy.getDocumentNumber());
            protocolForm.setViewOnly(false);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolDocument().setViewOnly(protocolForm.isViewOnly());
            protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
            protocolForm.getProtocolHelper().prepareView();
            protocolForm.getActionHelper().prepareCommentsView();
            return mapping.findForward("protocol");
        }
        return mapping.findForward("basic");
    }

    public ActionForward activate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (ProtocolForm)form, true);
    }

    public ActionForward deactivate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return KcServiceLocator.getService(AuditHelper.class).setAuditMode(mapping, (ProtocolForm)form, false);
    }

    public ActionForward refreshPage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    public ActionForward submitForReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolSubmitAction submitAction;
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
        protocolForm.setAuditActivated(true);
        ProtocolTask task = new ProtocolTask("submitProtocol", protocolDocument.getProtocol());
        if (this.isAuthorized(task) && this.applyRules(protocolForm, (DocumentEvent)new ProtocolSubmitActionEvent(protocolDocument, submitAction = (ProtocolSubmitAction)protocolForm.getActionHelper().getProtocolSubmitAction()))) {
            AuditHelper auditHelper = KcServiceLocator.getService(AuditHelper.class);
            if (auditHelper.auditUnconditionally((Document)protocolDocument)) {
                forward = this.isCommitteeMeetingAssignedMaxProtocols(submitAction.getNewCommitteeId(), submitAction.getNewScheduleId()) ? this.confirm(this.buildSubmitForReviewConfirmationQuestion(mapping, form, request, response), CONFIRM_SUBMIT_FOR_REVIEW_KEY, CONFIRM_NO_ACTION) : this.submitForReviewAndRedirect(mapping, form, request, response);
            } else {
                GlobalVariables.getMessageMap().clearErrorMessages();
                GlobalVariables.getMessageMap().putError("datavalidation", "error.workflow.submission", new String[0]);
            }
        }
        return forward;
    }

    private boolean isCommitteeMeetingAssignedMaxProtocols(String committeeId, String scheduleId) {
        CommitteeSchedule schedule;
        boolean isMax = false;
        Committee committee = (Committee)this.getCommitteeService().getCommitteeById(committeeId);
        if (committee != null && (schedule = (CommitteeSchedule)this.getCommitteeService().getCommitteeSchedule(committee, scheduleId)) != null) {
            int currentSubmissionCount = schedule.getLatestProtocolSubmissions() == null ? 0 : this.activeSubmissonCount(schedule.getLatestProtocolSubmissions());
            int maxSubmissionCount = schedule.getMaxProtocols();
            isMax = currentSubmissionCount >= maxSubmissionCount;
        }
        return isMax;
    }

    private int activeSubmissonCount(List<ProtocolSubmissionLite> submissions) {
        int count = 0;
        for (ProtocolSubmissionLite submission : submissions) {
            if (!submission.isProtocolActive()) continue;
            ++count;
        }
        return count;
    }

    private StrutsConfirmation buildSubmitForReviewConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_SUBMIT_FOR_REVIEW_KEY, "question.protocol.confirmExceedMaxProtocols", new String[0]);
    }

    public ActionForward confirmSubmitForReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        String question = request.getParameter("questionIndex");
        if (CONFIRM_SUBMIT_FOR_REVIEW_KEY.equals(question)) {
            forward = this.submitForReviewAndRedirect(mapping, form, request, response);
        }
        return forward;
    }

    private ActionForward submitForReviewAndRedirect(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        super.route(mapping, (ActionForm)protocolForm, request, response);
        boolean isPromptToNotifyUser = this.getProtocolActionRequestService().submitForReviewAndPromptToNotifyUser(protocolForm, Boolean.TRUE);
        if (isPromptToNotifyUser) {
            return mapping.findForward("protocolNotificationEditor");
        }
        return this.routeProtocolToHoldingPage(mapping, protocolForm);
    }

    private ActionForward routeProtocolToHoldingPage(ActionMapping mapping, ProtocolForm protocolForm) {
        String routeHeaderId = protocolForm.getProtocolDocument().getDocumentNumber();
        String returnLocation = this.buildActionUrl(routeHeaderId, "protocolActions", "ProtocolDocument");
        ActionForward basicForward = mapping.findForward("portal");
        ActionRedirect holdingPageForward = new ActionRedirect((ForwardConfig)mapping.findForward("kraHoldingPage"));
        holdingPageForward.addParameter("holdingPageDocumentId", (Object)routeHeaderId);
        return this.routeToHoldingPage(basicForward, basicForward, holdingPageForward, returnLocation, routeHeaderId);
    }

    public ActionForward withdrawProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isWithdrawProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().withdrawProtocol(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward notifyIrbProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        String forwardTo = this.getProtocolActionRequestService().notifyIrbProtocol(protocolForm);
        forward = mapping.findForward(forwardTo);
        this.loadDocument((KualiDocumentFormBase)protocolForm);
        protocolForm.getProtocolHelper().prepareView();
        return forward;
    }

    public ActionForward addSubmissionDoc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Protocol protocol = ((ProtocolForm)form).getActionHelper().getProtocol();
        int actionIndex = this.getSelectedLine(request);
        if (((ProtocolForm)form).getActionHelper().validFile(protocol.getProtocolActions().get(actionIndex).getNewActionAttachment(), "protocolNotifyIrbBean")) {
            ProtocolSubmissionDoc fyiAttachment = null;
            ProtocolActionAttachment newAttachment = protocol.getProtocolActions().get(actionIndex).getNewActionAttachment();
            Long submissionId = protocol.getProtocolActions().get(actionIndex).getSubmissionIdFk();
            for (ProtocolSubmissionBase fyiSubmission : protocol.getProtocolSubmissions()) {
                if (fyiSubmission.getSubmissionId().longValue() != submissionId.longValue()) continue;
                fyiAttachment = ProtocolSubmissionBuilder.createProtocolSubmissionDoc((ProtocolSubmission)fyiSubmission, newAttachment.getFile().getFileName(), newAttachment.getFile().getContentType(), newAttachment.getFile().getFileData(), newAttachment.getDescription());
                break;
            }
            if (fyiAttachment != null) {
                this.getBusinessObjectService().save(fyiAttachment);
                ((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean().setNewActionAttachment(new ProtocolActionAttachment());
            }
        }
        return mapping.findForward(this.getProtocolHistoryForwardNameHook());
    }

    public ActionForward deleteSubmissionDoc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        ProtocolActionBase protocolAction = ((ProtocolFormBase)protocolForm).getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolSubmissionDocBase attachment = protocolAction.getProtocolSubmissionDocs().get(attachmentIndex);
        if (attachment == null) {
            LOG.info("The attachment was not found for protocolAction: " + actionIndex + ", protocolSubmissionDoc: " + attachmentIndex);
            return mapping.findForward(this.getProtocolHistoryForwardNameHook());
        }
        this.getBusinessObjectService().delete((Object)attachment);
        return mapping.findForward(this.getProtocolHistoryForwardNameHook());
    }

    public ActionForward notifyCommitteeProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        String forwardTo = this.getProtocolActionRequestService().notifyCommitteeProtocol(protocolForm);
        forward = mapping.findForward(forwardTo);
        return forward;
    }

    public ActionForward createAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isCreateAmendmentAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().createAmendment(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward modifyAmendmentSections(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        protocolForm.getActionHelper().setCurrentTask("modifyAmendmentSections");
        ProtocolTask task = new ProtocolTask("modifyAmendmentSections", protocol);
        if (this.isAuthorized(task)) {
            if (!this.applyRules((DocumentEvent)new ModifyAmendmentSectionsEvent((ProtocolDocumentBase)protocolForm.getProtocolDocument(), "actionHelper.protocolModifyAmendment", (ProtocolAmendmentBean)protocolForm.getActionHelper().getProtocolAmendmentBean()))) {
                return mapping.findForward("basic");
            }
            this.getProtocolAmendRenewService().updateAmendmentRenewal(protocolForm.getProtocolDocument(), protocolForm.getActionHelper().getProtocolAmendmentBean());
            return this.save(mapping, (ActionForm)protocolForm, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward createRenewal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionForward forward = mapping.findForward("basic");
        if (this.getProtocolActionRequestService().isCreateRenewalAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().createRenewal(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward createRenewalWithAmendment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionForward forward = mapping.findForward("basic");
        if (this.getProtocolActionRequestService().isCreateRenewalWithAmendmentAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().createRenewalWithAmendment(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward deleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolTask task = new ProtocolTask("protocolAmendRenewDelete", protocolForm.getProtocolDocument().getProtocol());
        if (this.isAuthorized(task)) {
            return this.confirm(this.buildDeleteProtocolConfirmationQuestion(mapping, form, request, response), CONFIRM_DELETE_PROTOCOL_KEY, CONFIRM_NO_ACTION);
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_PROTOCOL_KEY.equals(question)) {
            ProtocolForm protocolForm = (ProtocolForm)form;
            this.getProtocolDeleteService().delete(protocolForm.getProtocolDocument());
            this.recordProtocolActionSuccess("Delete Protocol, Amendment, or Renewal");
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDeleteProtocolConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolDocument doc = ((ProtocolForm)form).getProtocolDocument();
        String protocolNumber = doc.getProtocol().getProtocolNumber();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_PROTOCOL_KEY, "document.question.deleteProtocol.text", protocolNumber);
    }

    public ActionForward viewProtocolAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int selected = this.getSelectedLine(request);
        ProtocolAttachmentProtocol attachment = (ProtocolAttachmentProtocol)protocolForm.getProtocolDocument().getProtocol().getActiveAttachmentProtocolsNoDelete().get(selected);
        return this.printAttachmentProtocol(mapping, response, attachment, protocolForm);
    }

    public ActionForward viewProtocolPersonnelAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int selected = this.getSelectedLine(request);
        ProtocolAttachmentPersonnel personAttach = (ProtocolAttachmentPersonnel)protocolForm.getProtocolDocument().getProtocol().getAttachmentPersonnels().get(selected);
        return this.printPersonnelAttachmentProtocol(mapping, response, personAttach, protocolForm);
    }

    public ActionForward printProtocolDocument(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ActionForward forward = mapping.findForward("basic");
        ActionHelper actionHelper = protocolForm.getActionHelper();
        StringBuffer fileName = new StringBuffer().append("Protocol-");
        if (this.applyRules((DocumentEvent)new ProtocolActionPrintEvent(protocolForm.getProtocolDocument(), actionHelper.getSummaryReport(), actionHelper.getFullReport(), actionHelper.getHistoryReport(), actionHelper.getReviewCommentsReport()))) {
            ProtocolPrintType printType = ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT;
            String reportName = protocol.getProtocolNumber() + "-" + printType.getReportName();
            AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getPrintReportArtifacts((ActionForm)protocolForm, fileName));
            if (dataStream.getData() != null) {
                dataStream.setName(fileName.toString());
                PrintingUtils.streamToResponse(dataStream, response);
                forward = null;
            }
        }
        return forward;
    }

    private Map<Class, Object> getReportOptions(ProtocolForm protocolForm, ProtocolPrintType printType) {
        HashMap<Class, Object> reportParameters = new HashMap<Class, Object>();
        ProtocolSummaryPrintOptions summaryOptions = protocolForm.getActionHelper().getProtocolSummaryPrintOptions();
        if (printType.equals((Object)ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT)) {
            summaryOptions.setActions(true);
            summaryOptions.setAmendmentRenewalHistory(true);
            summaryOptions.setAmmendmentRenewalSummary(true);
            summaryOptions.setAreaOfResearch(true);
            summaryOptions.setAttachments(true);
            summaryOptions.setCorrespondents(true);
            summaryOptions.setDocuments(true);
            summaryOptions.setFundingSource(true);
            summaryOptions.setInvestigator(true);
            summaryOptions.setNotes(true);
            summaryOptions.setOrganizaition(true);
            summaryOptions.setProtocolDetails(true);
            summaryOptions.setReferences(true);
            summaryOptions.setRiskLevel(true);
            summaryOptions.setRoles(true);
            summaryOptions.setSpecialReview(true);
            summaryOptions.setStudyPersonnels(true);
            summaryOptions.setSubjects(true);
        }
        reportParameters.put(ProtocolSummaryPrintOptions.class, summaryOptions);
        return reportParameters;
    }

    public ActionForward printProtocolSelectedItems(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ActionForward forward = mapping.findForward("basic");
        String fileName = "Protocol_Summary_Report.pdf";
        ProtocolPrintType printType = ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT;
        String reportName = protocol.getProtocolNumber() + "-" + printType.getReportName();
        AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getPrintArtifacts((ActionForm)protocolForm));
        if (dataStream.getData() != null) {
            dataStream.setName(fileName.toString());
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward printProtocolQuestionnaires(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ActionForward forward = mapping.findForward("basic");
        String fileName = "Protocol_questionnaire_Report.pdf";
        String reportName = protocol.getProtocolNumber() + "-ProtocolQuestionnaires";
        AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getQuestionnairePrintingService().getQuestionnairePrintable(protocolForm.getProtocolDocument().getProtocol(), protocolForm.getActionHelper().getQuestionnairesToPrints()));
        if (dataStream.getData() != null) {
            dataStream.setName(fileName.toString());
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward printProtocolCorrespondences(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        ActionForward forward = mapping.findForward("basic");
        String fileName = "IRB_Protocol_Ccorrespondence_Report.pdf";
        String reportName = protocol.getProtocolNumber() + "-ProtocolCorrespondences";
        AttachmentDataSource dataStream = this.getProtocolPrintingService().print(reportName, this.getIrbCorrespondencePrintingService().getCorrespondencePrintable(protocol, protocolForm.getActionHelper().getCorrespondencesToPrint()));
        if (dataStream.getData() != null) {
            dataStream.setName(fileName.toString());
            PrintingUtils.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    private IrbCorrespondencePrintingService getIrbCorrespondencePrintingService() {
        return KcServiceLocator.getService(IrbCorrespondencePrintingService.class);
    }

    private List<Printable> getPrintArtifacts(ActionForm form) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        org.kuali.kra.protocol.actions.print.ProtocolPrintType printType = org.kuali.kra.protocol.actions.print.ProtocolPrintType.valueOf(PRINTTAG_MAP.get("full"));
        AbstractPrint printable = (AbstractPrint)this.getProtocolPrintingService().getProtocolPrintable(printType);
        printable.setPrintableBusinessObject(protocolForm.getProtocolDocument().getProtocol());
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        ProtocolSummaryPrintOptions summaryOptions = protocolForm.getActionHelper().getProtocolPrintOption();
        reportParameters.put((String)((Object)ProtocolSummaryPrintOptions.class), summaryOptions);
        printable.setReportParameters(reportParameters);
        printableArtifactList.add(printable);
        if (summaryOptions.isReviewComments()) {
            Map<Class, Object> reportParameters1 = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_REVIEW_COMMENTS_REPORT);
            AbstractPrint printable1 = (AbstractPrint)this.getProtocolPrintingService().getProtocolPrintable(org.kuali.kra.protocol.actions.print.ProtocolPrintType.valueOf(PRINTTAG_MAP.get("comments")));
            printable1.setPrintableBusinessObject(protocolForm.getProtocolDocument().getProtocol());
            printable1.setReportParameters(reportParameters1);
            printableArtifactList.add(printable1);
        }
        return printableArtifactList;
    }

    private List<Printable> getPrintReportArtifacts(ActionForm form, StringBuffer fileName) {
        Map<Class, Object> reportParameters;
        ProtocolForm protocolForm = (ProtocolForm)form;
        Boolean printSummary = protocolForm.getActionHelper().getSummaryReport();
        Boolean printFull = protocolForm.getActionHelper().getFullReport();
        Boolean printHistory = protocolForm.getActionHelper().getHistoryReport();
        Boolean printReviewComments = protocolForm.getActionHelper().getReviewCommentsReport();
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        if (printSummary.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_SUMMARY_VIEW_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocolForm.getProtocolDocument().getProtocol(), "summary", fileName, reportParameters));
            protocolForm.getActionHelper().setSummaryReport(false);
        }
        if (printFull.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocolForm.getProtocolDocument().getProtocol(), "full", fileName, reportParameters));
            protocolForm.getActionHelper().setFullReport(false);
        }
        if (printHistory.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_PROTOCOL_HISTORY_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocolForm.getProtocolDocument().getProtocol(), "history", fileName, reportParameters));
            protocolForm.getActionHelper().setHistoryReport(false);
        }
        if (printReviewComments.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_REVIEW_COMMENTS_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocolForm.getProtocolDocument().getProtocol(), "comments", fileName, reportParameters));
            protocolForm.getActionHelper().setReviewCommentsReport(false);
        }
        fileName.append("report.pdf");
        return printableArtifactList;
    }

    private ActionForward printAttachmentProtocol(ActionMapping mapping, HttpServletResponse response, ProtocolAttachmentProtocol attachment, ProtocolForm form) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        byte[] attachmentFile = null;
        String attachmentFileType = file.getType().replace("\"", CONFIRM_NO_ACTION);
        if ((attachmentFileType = attachmentFileType.replace("\\", CONFIRM_NO_ACTION)).equalsIgnoreCase("application/pdf")) {
            attachmentFile = this.getProtocolAttachmentFile(form, attachment);
            if (attachmentFile != null) {
                this.streamToResponse(attachmentFile, ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
            } else {
                this.streamToResponse(file.getData(), ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
            }
            return RESPONSE_ALREADY_HANDLED;
        }
        this.streamToResponse(file.getData(), ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private ActionForward printPersonnelAttachmentProtocol(ActionMapping mapping, HttpServletResponse response, ProtocolAttachmentBase attachment, ProtocolForm form) throws Exception {
        if (attachment == null) {
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private byte[] getProtocolAttachmentFile(ProtocolForm form, ProtocolAttachmentProtocol attachment) {
        byte[] attachmentFile = null;
        AttachmentFile file = attachment.getFile();
        Printable printableArtifacts = this.getProtocolPrintingService().getProtocolPrintArtifacts(form.getProtocolDocument().getProtocol());
        Protocol protocolCurrent = form.getProtocolDocument().getProtocol();
        int currentProtoSeqNumber = protocolCurrent.getSequenceNumber();
        try {
            if (printableArtifacts.isWatermarkEnabled()) {
                int currentAttachmentSequence = attachment.getSequenceNumber();
                String docStatusCode = attachment.getDocumentStatusCode();
                String statusCode = attachment.getStatusCode();
                if (this.getProtocolAttachmentService().isAttachmentActive(attachment) && currentProtoSeqNumber == currentAttachmentSequence || docStatusCode.equals("1")) {
                    if ("2".equals(statusCode)) {
                        attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getWatermark());
                    }
                } else {
                    attachmentFile = this.getWatermarkService().applyWatermark(file.getData(), printableArtifacts.getWatermarkable().getInvalidWatermark());
                    LOG.info(INVALID_ATTACHMENT + attachment.getDocumentId());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Exception Occurred in ProtocolNoteAndAttachmentAction. : ", (Throwable)e);
        }
        return attachmentFile;
    }

    public ActionForward filterHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Date startDate = protocolForm.getActionHelper().getFilteredHistoryStartDate();
        Date endDate = protocolForm.getActionHelper().getFilteredHistoryEndDate();
        if (this.applyRules((DocumentEvent)new ProtocolHistoryFilterDatesEvent((Document)protocolForm.getProtocolDocument(), startDate, endDate))) {
            protocolForm.getActionHelper().initFilterDatesView();
        }
        return mapping.findForward("basic");
    }

    public ActionForward resetHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.getActionHelper().setFilteredHistoryStartDate(null);
        protocolForm.getActionHelper().setFilteredHistoryEndDate(null);
        protocolForm.getActionHelper().initFilterDatesView();
        return mapping.findForward("basic");
    }

    public ActionForward loadProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        org.kuali.kra.irb.actions.ProtocolAction action = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getSelectedProtocolAction();
        if (action != null) {
            protocolForm.getActionHelper().setCurrentSequenceNumber(action.getSequenceNumber());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewAttachmentProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolSummary protocolSummary = (ProtocolSummary)protocolForm.getActionHelper().getProtocolSummary();
        if (((String)request.getAttribute("methodToCallAttribute")).contains(".prev.")) {
            protocolSummary = (ProtocolSummary)protocolForm.getActionHelper().getPrevProtocolSummary();
        }
        int selectedIndex = this.getSelectedLine(request);
        AttachmentSummary attachmentSummary = protocolSummary.getAttachments().get(selectedIndex);
        if (attachmentSummary.getAttachmentType().startsWith("Protocol: ")) {
            ProtocolAttachmentProtocol attachment = this.getProtocolAttachmentService().getAttachment(ProtocolAttachmentProtocol.class, attachmentSummary.getAttachmentId());
            return this.printAttachmentProtocol(mapping, response, attachment, protocolForm);
        }
        ProtocolAttachmentPersonnel personnelAttachment = this.getProtocolAttachmentService().getAttachment(ProtocolAttachmentPersonnel.class, attachmentSummary.getAttachmentId());
        return this.printPersonnelAttachmentProtocol(mapping, response, personnelAttachment, protocolForm);
    }

    public ActionForward viewPreviousProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        actionHelper.setCurrentSequenceNumber(actionHelper.getCurrentSequenceNumber() - 1);
        ((ProtocolForm)form).getActionHelper().initSummaryDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewNextProtocolSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        actionHelper.setCurrentSequenceNumber(actionHelper.getCurrentSequenceNumber() + 1);
        ((ProtocolForm)form).getActionHelper().initSummaryDetails();
        return mapping.findForward("basic");
    }

    public ActionForward viewPreviousSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        actionHelper.setCurrentSubmissionNumber(actionHelper.getPrevSubmissionNumber());
        actionHelper.setAmendmentDetails();
        actionHelper.initAmendmentBeans(true);
        protocolForm.getActionHelper().initSubmissionDetails();
        return mapping.findForward("protocolHistory");
    }

    public ActionForward viewNextSubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        actionHelper.setCurrentSubmissionNumber(actionHelper.getNextSubmissionNumber());
        actionHelper.setAmendmentDetails();
        actionHelper.initAmendmentBeans(true);
        protocolForm.getActionHelper().initSubmissionDetails();
        return mapping.findForward("protocolHistory");
    }

    public ActionForward start(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SUBMISSION_ID, request.getParameter(SUBMISSION_ID));
        ProtocolSubmission protocolSubmission = (ProtocolSubmission)this.getBusinessObjectService().findByPrimaryKey(ProtocolSubmission.class, fieldValues);
        protocolSubmission.getProtocol().setProtocolSubmission(protocolSubmission);
        ProtocolForm protocolForm = (ProtocolForm)form;
        protocolForm.setDocId(protocolSubmission.getProtocol().getProtocolDocument().getDocumentNumber());
        this.loadDocument((KualiDocumentFormBase)protocolForm);
        protocolForm.initialize();
        return mapping.findForward("basic");
    }

    public ActionForward assignToAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isAssignToAgendaAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().assignToAgenda(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward protocolReviewNotRequired(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isProtocolReviewNotRequiredAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().protocolReviewNotRequired(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward confirmAssignToAgenda(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_ASSIGN_TO_AGENDA_KEY.equals(question)) {
            ProtocolForm protocolForm = (ProtocolForm)form;
            ProtocolAssignToAgendaBean actionBean = (ProtocolAssignToAgendaBean)protocolForm.getActionHelper().getAssignToAgendaBean();
            this.getProtocolAssignToAgendaService().assignToAgenda((ProtocolBase)protocolForm.getProtocolDocument().getProtocol(), actionBean);
        }
        return mapping.findForward("basic");
    }

    public ActionForward assignReviewers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isAssignReviewersAuthorized(protocolForm)) {
            boolean processRequest = true;
            if (GlobalVariables.getMessageMap().hasWarnings()) {
                String callerString = String.format("assignReviewers", new Object[0]);
                String question = request.getParameter("questionIndex");
                if (question == null) {
                    forward = this.performQuestionWithoutInput(mapping, form, request, response, CONIFRM_REMOVE_REVIEWER_KEY, this.getKualiConfigurationService().getPropertyValueAsString("message.protocol.reviewer.removeReview.removeReviewWithComments"), "confirmationQuestion", callerString, CONFIRM_NO_ACTION);
                    processRequest = false;
                } else {
                    String buttonClicked = request.getParameter("buttonClicked");
                    if ("DocDisapprove".equals(question) && "1".equals(buttonClicked)) {
                        processRequest = false;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("User declined to confirm the request, not processing.");
                        }
                    }
                }
            }
            if (processRequest) {
                String forwardTo = this.getProtocolActionRequestService().assignReviewers(protocolForm);
                forward = mapping.findForward(forwardTo);
            }
        }
        return forward;
    }

    public ActionForward grantExemption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isGrantExemptionAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().grantExemption(protocolForm);
            this.confirmFollowupAction(mapping, form, request, response, "basic");
            forward = mapping.findForward(forwardTo);
        }
        if (request.getParameter("questionIndex") != null) {
            this.confirmFollowupAction(mapping, form, request, response, "basic");
        }
        return forward;
    }

    public ActionForward grantFullApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isFullApprovalAuthorized(protocolForm)) {
            forward = super.approve(mapping, (ActionForm)protocolForm, request, response);
            this.getProtocolActionRequestService().grantFullApproval(protocolForm);
            if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
                return mapping.findForward(CORRESPONDENCE);
            }
            forward = this.routeProtocolToHoldingPage(mapping, protocolForm);
        }
        return forward;
    }

    public ActionForward grantExpeditedApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (!this.getProtocolActionRequestService().isExpeditedApprovalAuthorized(protocolForm)) {
            return forward;
        }
        this.getProtocolActionRequestService().grantExpeditedApproval(protocolForm);
        forward = this.confirmFollowupAction(mapping, form, request, response, "protocolActions");
        if (request.getParameter("questionIndex") != null) {
            this.confirmFollowupAction(mapping, form, request, response, "protocolActions");
            protocolForm.getProtocolHelper().prepareView();
        }
        if (protocolForm.getActionHelper().getProtocolCorrespondence() != null) {
            return mapping.findForward(CORRESPONDENCE);
        }
        forward = this.routeProtocolToHoldingPage(mapping, protocolForm);
        return forward;
    }

    public ActionForward grantResponseApproval(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isResponseApprovalAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().grantResponseApproval(protocolForm);
            this.routeProtocolToHoldingPage(mapping, protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward requestAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        String taskName = this.getTaskName(request);
        if (this.getProtocolActionRequestService().isRequestActionAuthorized(protocolForm, taskName)) {
            String forwardTo = this.getProtocolActionRequestService().performRequestAction(protocolForm, taskName);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward withdrawRequestAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        String taskName = this.getTaskName(request);
        if (this.getProtocolActionRequestService().isWithdrawRequestActionAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().withdrawRequestAction(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    private ProtocolRequestBean getProtocolRequestBean(ActionForm form, HttpServletRequest request) {
        ProtocolRequestBean protocolRequestBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolRequestBean) {
            protocolRequestBean = (ProtocolRequestBean)protocolActionBean;
        }
        return protocolRequestBean;
    }

    public ActionForward closeProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isCloseProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().closeProtocol(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward closeEnrollment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isCloseEnrollmentAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().closeEnrollment(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward defer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isDeferProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().deferProtocol(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward disapproveProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isDisapproveProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().disapproveProtocol(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward expire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isExpireProtocolAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().expireProtocol(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward irbAcknowledgement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isIrbAcknowledgementAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().irbAcknowledgement(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward permitDataAnalysis(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isPermitDataAnalysisAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().permitDataAnalysis(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward reopenEnrollment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isReopenEnrollmentAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().reopenEnrollment(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward returnForSMR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isReturnForSMRAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().returnForSMR(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward returnForSRR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isReturnForSRRAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().returnForSRR(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward returnToPI(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isReturnToPIAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().returnToPI(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.loadDocument((KualiDocumentFormBase)protocolForm);
            protocolForm.getProtocolHelper().prepareView();
        }
        return forward;
    }

    public ActionForward suspend(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isSuspendAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().suspend(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward suspendByDsmb(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isSuspendByDsmbAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().suspendByDsmb(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward terminate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isTerminateAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().terminate(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward manageComments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isManageCommentsAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().manageComments(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward openProtocolForAdminCorrection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isOpenProtocolForAdminCorrectionAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().openProtocolForAdminCorrection(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    public ActionForward undoLastAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            ProtocolDocument protocolDocument = protocolForm.getProtocolDocument();
            UndoLastActionBean undoLastActionBean = protocolForm.getActionHelper().getUndoLastActionBean();
            String lastActionType = undoLastActionBean.getLastPerformedAction().getProtocolActionTypeCode();
            UndoLastActionService undoLastActionService = KcServiceLocator.getService(UndoLastActionService.class);
            ProtocolDocument updatedDocument = (ProtocolDocument)undoLastActionService.undoLastAction(protocolDocument, undoLastActionBean);
            this.recordProtocolActionSuccess("Undo Last Action");
            if (!updatedDocument.getDocumentNumber().equals(protocolForm.getDocId())) {
                protocolForm.setDocId(updatedDocument.getDocumentNumber());
                this.loadDocument((KualiDocumentFormBase)protocolForm);
                protocolForm.getProtocolHelper().prepareView();
                return mapping.findForward("protocol");
            }
            if ("203".equals(lastActionType) || "202".equals(lastActionType)) {
                return this.routeProtocolToHoldingPage(mapping, protocolForm);
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward submitCommitteeDecision(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isSubmitCommitteeDecisionAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().submitCommitteeDecision(protocolForm);
            forward = mapping.findForward(forwardTo);
            this.confirmFollowupAction(mapping, form, request, response, "basic");
        }
        return forward;
    }

    public ActionForward addAbstainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        CommitteeDecision decision = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        if (this.applyRules((DocumentEvent)new CommitteeDecisionAbstainerEvent(protocolForm.getProtocolDocument(), decision))) {
            decision.getAbstainers().add(decision.getNewAbstainer());
            decision.setNewAbstainer(new CommitteePerson());
            decision.setAbstainCount(decision.getAbstainCount() + 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteAbstainer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        CommitteeDecision decision = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        CommitteePerson person = decision.getAbstainers().get(this.getLineToDelete(request));
        if (person != null) {
            decision.getAbstainersToDelete().add(person);
            decision.getAbstainers().remove(this.getLineToDelete(request));
            decision.setAbstainCount(decision.getAbstainCount() - 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addRecused(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        CommitteeDecision decision = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        if (this.applyRules((DocumentEvent)new CommitteeDecisionRecuserEvent(protocolForm.getProtocolDocument(), decision))) {
            decision.getRecused().add(decision.getNewRecused());
            decision.setNewRecused(new CommitteePerson());
            decision.setRecusedCount(decision.getRecusedCount() + 1);
        }
        return mapping.findForward("basic");
    }

    public ActionForward modifySubmissionAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        String callerString = "assignCommitteeSchedule";
        ProtocolModifySubmissionBean bean = protocolForm.getActionHelper().getProtocolModifySubmissionBean();
        ProtocolAssignCmtSchedBean actionBean = protocolForm.getActionHelper().getAssignCmtSchedBean();
        if (this.applyRules((DocumentEvent)new ProtocolModifySubmissionEvent(protocolForm.getProtocolDocument(), bean))) {
            ProtocolSubmission protocolSubmission;
            if (!this.hasDocumentStateChanged(protocolForm) && (protocolSubmission = protocolForm.getProtocolDocument().getProtocol().getProtocolSubmission()) != null) {
                boolean performAssignment = false;
                String question = request.getParameter("questionIndex");
                String buttonClicked = request.getParameter("buttonClicked");
                if (this.isCommitteeMeetingAssignedMaxProtocols(actionBean.getNewCommitteeId(), actionBean.getNewScheduleId())) {
                    if (question == null || !CONFIRM_ASSIGN_CMT_SCHED_KEY.equals(question)) {
                        return this.performQuestionWithoutInput(mapping, form, request, response, CONFIRM_ASSIGN_CMT_SCHED_KEY, this.getKualiConfigurationService().getPropertyValueAsString("question.protocol.confirmExceedMaxProtocols"), "confirmationQuestion", "assignCommitteeSchedule", CONFIRM_NO_ACTION);
                    }
                    if ("0".equals(buttonClicked)) {
                        performAssignment = true;
                    } else {
                        actionBean.setScheduleId(protocolSubmission.getScheduleId());
                    }
                } else {
                    performAssignment = true;
                }
                if (performAssignment) {
                    if (StringUtils.equals((CharSequence)protocolSubmission.getSubmissionStatusCode(), (CharSequence)"101")) {
                        this.getProtocolAssignCmtSchedService().assignToCommitteeAndSchedulePostAgendaAssignment(protocolForm.getProtocolDocument().getProtocol(), actionBean);
                    } else {
                        this.getProtocolAssignCmtSchedService().assignToCommitteeAndSchedule(protocolForm.getProtocolDocument().getProtocol(), actionBean);
                    }
                }
            }
            KcServiceLocator.getService(ProtocolModifySubmissionService.class).modifySubmission(protocolForm.getProtocolDocument(), bean);
            this.recordProtocolActionSuccess("Modify Submission Request");
        } else if (GlobalVariables.getMessageMap().getErrorCount() <= 0) {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRecused(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        CommitteeDecision decision = (CommitteeDecision)protocolForm.getActionHelper().getCommitteeDecision();
        CommitteePerson person = decision.getRecused().get(this.getLineToDelete(request));
        if (person != null) {
            decision.getRecusedToDelete().add(person);
            decision.getRecused().remove(this.getLineToDelete(request));
            decision.setRecusedCount(decision.getRecusedCount() - 1);
        }
        return mapping.findForward("basic");
    }

    private Printable getPrintableArtifacts(Protocol protocol, String reportType, StringBuffer fileName, Map reportParameters) {
        org.kuali.kra.protocol.actions.print.ProtocolPrintType printType = org.kuali.kra.protocol.actions.print.ProtocolPrintType.valueOf(PRINTTAG_MAP.get(reportType));
        AbstractPrint printable = (AbstractPrint)this.getProtocolPrintingService().getProtocolPrintable(printType);
        printable.setPrintableBusinessObject(protocol);
        printable.setReportParameters(reportParameters);
        fileName.append(reportType).append("-");
        return printable;
    }

    private ProtocolPrintingService getProtocolPrintingService() {
        return KcServiceLocator.getService(ProtocolPrintingService.class);
    }

    public ActionForward addRiskLevel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolRiskLevelBean protocolRiskLevelBean = this.getProtocolRiskLevelBean(mapping, form, request, response);
        if (protocolRiskLevelBean != null) {
            String errorPropertyName = protocolRiskLevelBean.getErrorPropertyKey();
            ProtocolRiskLevel newProtocolRiskLevel = protocolRiskLevelBean.getNewProtocolRiskLevel();
            Protocol protocol = document.getProtocol();
            if (this.applyRules((DocumentEvent)new ProtocolAddRiskLevelEvent(document, errorPropertyName, newProtocolRiskLevel))) {
                this.getProtocolRiskLevelService().addRiskLevel(newProtocolRiskLevel, protocol);
                protocolRiskLevelBean.setNewProtocolRiskLevel(new ProtocolRiskLevel());
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward updateRiskLevel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolRiskLevelBean protocolRiskLevelBean = this.getProtocolRiskLevelBean(mapping, form, request, response);
        if (protocolRiskLevelBean != null) {
            int lineNumber = this.getSelectedLine(request);
            ProtocolRiskLevel currentProtocolRiskLevel = document.getProtocol().getProtocolRiskLevels().get(lineNumber);
            ProtocolRiskLevel newProtocolRiskLevel = protocolRiskLevelBean.getNewProtocolRiskLevel();
            if (this.applyRules((DocumentEvent)new ProtocolUpdateRiskLevelEvent(document, lineNumber))) {
                this.getProtocolRiskLevelService().updateRiskLevel(currentProtocolRiskLevel, newProtocolRiskLevel);
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteRiskLevel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ProtocolRiskLevelBean protocolRiskLevelBean = this.getProtocolRiskLevelBean(mapping, form, request, response);
        if (protocolRiskLevelBean != null) {
            int lineNumber = this.getSelectedLine(request);
            Protocol protocol = document.getProtocol();
            this.getProtocolRiskLevelService().deleteRiskLevel(lineNumber, protocol);
        }
        return mapping.findForward("basic");
    }

    private ProtocolRiskLevelBean getProtocolRiskLevelBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolRiskLevelBean protocolRiskLevelBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolRiskLevelCommentable) {
            protocolRiskLevelBean = ((ProtocolRiskLevelCommentable)((Object)protocolActionBean)).getProtocolRiskLevelBean();
        }
        return protocolRiskLevelBean;
    }

    public ActionForward addReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            String errorPropertyName = reviewCommentsBean.getErrorPropertyName();
            CommitteeScheduleMinute newReviewComment = (CommitteeScheduleMinute)reviewCommentsBean.getNewReviewComment();
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            Protocol protocol = document.getProtocol();
            if (this.applyRules((DocumentEvent)new ProtocolAddReviewCommentEvent(document, errorPropertyName, newReviewComment))) {
                this.getReviewCommentsService().addReviewComment((CommitteeScheduleMinuteBase)newReviewComment, reviewComments, protocol);
                reviewCommentsBean.setNewReviewComment(new CommitteeScheduleMinute("3"));
            }
            reviewCommentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewCommentsBean.getReviewComments()));
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveUpReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            Protocol protocol = document.getProtocol();
            int lineNumber = this.getSelectedLine(request);
            this.getReviewCommentsService().moveUpReviewComment(reviewComments, protocol, lineNumber);
        }
        return mapping.findForward("basic");
    }

    public ActionForward moveDownReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            Protocol protocol = document.getProtocol();
            int lineNumber = this.getSelectedLine(request);
            this.getReviewCommentsService().moveDownReviewComment(reviewComments, protocol, lineNumber);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteReviewComment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReviewCommentsBean reviewCommentsBean = this.getReviewCommentsBean(mapping, form, request, response);
        if (reviewCommentsBean != null) {
            List<CommitteeScheduleMinuteBase> reviewComments = reviewCommentsBean.getReviewComments();
            int lineNumber = this.getLineToDelete(request);
            List<CommitteeScheduleMinuteBase> deletedReviewComments = reviewCommentsBean.getDeletedReviewComments();
            this.getReviewCommentsService().deleteReviewComment(reviewComments, lineNumber, deletedReviewComments);
            if (reviewComments.isEmpty()) {
                reviewCommentsBean.setHideReviewerName(true);
            } else {
                reviewCommentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewCommentsBean.getReviewComments()));
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward abandon(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (this.getProtocolActionRequestService().isAbandonAuthorized(protocolForm)) {
            String forwardTo = this.getProtocolActionRequestService().abandon(protocolForm);
            forward = mapping.findForward(forwardTo);
        }
        return forward;
    }

    private ReviewCommentsBean getReviewCommentsBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReviewCommentsBean reviewCommentsBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolOnlineReviewCommentable) {
            reviewCommentsBean = (ReviewCommentsBean)((ProtocolOnlineReviewCommentable)((Object)protocolActionBean)).getReviewCommentsBean();
        }
        return reviewCommentsBean;
    }

    private ProtocolActionBean getActionBean(ActionForm form, HttpServletRequest request) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        String taskName = this.getTaskName(request);
        ProtocolActionBean protocolActionBean = null;
        if (StringUtils.isNotBlank((CharSequence)taskName)) {
            protocolActionBean = (ProtocolActionBean)protocolForm.getActionHelper().getActionBean(taskName);
        }
        return protocolActionBean;
    }

    private String getTaskName(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String taskName = CONFIRM_NO_ACTION;
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            taskName = StringUtils.substringBetween((String)parameterName, (String)".taskName", (String)".");
        }
        return taskName;
    }

    private boolean hasPermission(String taskName, Protocol protocol) {
        ProtocolTask task = new ProtocolTask(taskName, protocol);
        return this.getTaskAuthorizationService().isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), task);
    }

    private ProtocolAttachmentService getProtocolAttachmentService() {
        return KcServiceLocator.getService(ProtocolAttachmentService.class);
    }

    private TaskAuthorizationService getTaskAuthorizationService() {
        return KcServiceLocator.getService(TaskAuthorizationService.class);
    }

    public ProtocolCopyService getProtocolCopyService() {
        return KcServiceLocator.getService(ProtocolCopyService.class);
    }

    @Override
    public ProtocolAmendRenewService getProtocolAmendRenewService() {
        return KcServiceLocator.getService(ProtocolAmendRenewService.class);
    }

    private ProtocolDeleteService getProtocolDeleteService() {
        return KcServiceLocator.getService(ProtocolDeleteService.class);
    }

    private ProtocolAssignCmtSchedService getProtocolAssignCmtSchedService() {
        return KcServiceLocator.getService(ProtocolAssignCmtSchedService.class);
    }

    private ProtocolAssignToAgendaService getProtocolAssignToAgendaService() {
        return KcServiceLocator.getService(ProtocolAssignToAgendaService.class);
    }

    private CommitteeService getCommitteeService() {
        return KcServiceLocator.getService(CommitteeService.class);
    }

    private ProtocolRiskLevelService getProtocolRiskLevelService() {
        return KcServiceLocator.getService(ProtocolRiskLevelService.class);
    }

    private ReviewCommentsService getReviewCommentsService() {
        return KcServiceLocator.getService(ReviewCommentsService.class);
    }

    public ActionForward addNotifyIrbAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (((ProtocolForm)form).getActionHelper().validFile(((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean().getNewActionAttachment(), "protocolNotifyIrbBean")) {
            LOG.info("addNotifyIrbAttachment " + ((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean().getNewActionAttachment().getFile().getFileName() + ((ProtocolForm)form).getProtocolDocument().getDocumentNumber());
            ((ProtocolForm)form).getActionHelper().addNotifyIrbAttachment();
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewNotifyIrbAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.viewAttachment(mapping, (ProtocolForm)form, request, response);
    }

    private ActionForward viewAttachment(ActionMapping mapping, ProtocolForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolActionAttachment attachment = form.getActionHelper().getProtocolNotifyIrbBean().getActionAttachments().get(selection);
        if (attachment == null) {
            LOG.info(NOT_FOUND_SELECTION + selection);
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getFile().getFileData(), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFile().getFileName()), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFile().getContentType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteNotifyIrbAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirmDeleteAttachment(mapping, (ProtocolForm)form, request, response, ((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean().getActionAttachments());
    }

    private ActionForward confirmDeleteAttachment(ActionMapping mapping, ProtocolForm form, HttpServletRequest request, HttpServletResponse response, List<ProtocolActionAttachment> attachments) throws Exception {
        int selection = this.getSelectedLine(request);
        ProtocolActionAttachment attachment = attachments.get(selection);
        if (attachment == null) {
            LOG.info(NOT_FOUND_SELECTION + selection);
            return mapping.findForward("basic");
        }
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, (ActionForm)form, request, response, CONFIRM_DELETE_ACTION_ATT, "document.question.deleteAttachment.text", CONFIRM_NO_ACTION, attachment.getFile().getFileName());
        return this.confirm(confirm, CONFIRM_DELETE_ACTION_ATT, CONFIRM_NO_ACTION);
    }

    public ActionForward confirmDeleteActionAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String taskName = this.getTaskName(request);
        int selection = this.getSelectedLine(request);
        if (StringUtils.isBlank((CharSequence)taskName)) {
            ProtocolNotifyIrbBean notifyIrbBean = ((ProtocolForm)form).getActionHelper().getProtocolNotifyIrbBean();
            notifyIrbBean.getActionAttachments().remove(selection);
        } else {
            ProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
            requestBean.getActionAttachments().remove(selection);
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewSubmissionDoc(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        org.kuali.kra.irb.actions.ProtocolAction protocolAction = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolSubmissionDoc attachment = (ProtocolSubmissionDoc)protocolAction.getProtocolSubmissionDocs().get(attachmentIndex);
        if (attachment == null) {
            LOG.info("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolSubmissionDoc: " + attachmentIndex);
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getDocument(), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFileName()), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getContentType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward viewActionCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        org.kuali.kra.irb.actions.ProtocolAction protocolAction = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolCorrespondence attachment = (ProtocolCorrespondence)protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (attachment == null) {
            LOG.info("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex);
            return mapping.findForward("basic");
        }
        this.streamToResponse(attachment.getCorrespondence(), StringUtils.replace((String)attachment.getProtocolCorrespondenceType().getDescription(), (String)" ", (String)CONFIRM_NO_ACTION) + ".pdf", "application/pdf", response);
        return RESPONSE_ALREADY_HANDLED;
    }

    private int getSelectedAttachment(HttpServletRequest request) {
        int selectedAttachment = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((CharSequence)parameterName)) {
            String attachmentNumber = StringUtils.substringBetween((String)parameterName, (String)".attachment", (String)".");
            selectedAttachment = Integer.parseInt(attachmentNumber);
        }
        return selectedAttachment;
    }

    public ActionForward addRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
        if (protocolForm.getActionHelper().validFile(requestBean.getNewActionAttachment(), requestBean.getBeanName())) {
            LOG.info("addRequestAttachment " + requestBean.getProtocolActionTypeCode() + " " + requestBean.getNewActionAttachment().getFile().getFileName() + protocolForm.getProtocolDocument().getDocumentNumber());
            requestBean.getActionAttachments().add(requestBean.getNewActionAttachment());
            requestBean.setNewActionAttachment(new ProtocolActionAttachment());
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
        int selection = this.getSelectedLine(request);
        if (requestBean != null) {
            ProtocolActionAttachment attachment = requestBean.getActionAttachments().get(selection);
            if (attachment == null) {
                LOG.info(NOT_FOUND_SELECTION + selection);
                return mapping.findForward("basic");
            }
            this.streamToResponse(attachment.getFile().getFileData(), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFile().getFileName()), ProtocolProtocolActionsAction.getValidHeaderString(attachment.getFile().getContentType()), response);
        }
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteRequestAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProtocolRequestBean requestBean = this.getProtocolRequestBean(form, request);
        if (requestBean != null) {
            forward = this.confirmDeleteAttachment(mapping, (ProtocolForm)form, request, response, requestBean.getActionAttachments());
        }
        return forward;
    }

    private void recordProtocolActionSuccess(String protocolActionName) {
        KNSGlobalVariables.getMessageList().add("message.protocol.action.successfully.completed", new String[]{protocolActionName});
    }

    public ActionForward addNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (protocolForm.getActionHelper().getCanManageNotes()) {
            protocolForm.getNotesAttachmentsHelper().addNewNote();
            protocolForm.getNotesAttachmentsHelper().setManageNotesOpen(true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward editNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (protocolForm.getActionHelper().getCanManageNotes()) {
            int selection = this.getSelectedLine(request);
            protocolForm.getNotesAttachmentsHelper().modifyNote(selection);
            protocolForm.getNotesAttachmentsHelper().setManageNotesOpen(true);
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteNote(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (protocolForm.getActionHelper().getCanManageNotes() && protocolForm.getActionHelper().getCanManageNotes()) {
            int noteToDelete = this.getLineToDelete(request);
            protocolForm.getNotesAttachmentsHelper().deleteNote(noteToDelete);
            protocolForm.getNotesAttachmentsHelper().setManageNotesOpen(false);
        }
        return mapping.findForward("basic");
    }

    public ActionForward saveNotes(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (protocolForm.getActionHelper().getCanManageNotes()) {
                AddProtocolNotepadRuleImpl rule = new AddProtocolNotepadRuleImpl();
                boolean validNotes = true;
                for (ProtocolNotepadBase note : protocol.getNotepads()) {
                    AddProtocolNotepadEvent event;
                    if (!note.isEditable() || rule.processAddProtocolNotepadRules(event = new AddProtocolNotepadEvent((ProtocolDocument)protocol.getProtocolDocument(), (ProtocolNotepad)note))) continue;
                    validNotes = false;
                }
                if (validNotes) {
                    for (ProtocolNotepadBase note : protocol.getNotepads()) {
                        if (StringUtils.isBlank((CharSequence)note.getUpdateUserFullName())) {
                            note.setUpdateUserFullName(GlobalVariables.getUserSession().getPerson().getName());
                            note.setUpdateTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
                        }
                        if (StringUtils.isNotBlank((CharSequence)note.getCreateUser())) {
                            Person creator = this.getPersonService().getPersonByPrincipalName(note.getCreateUser());
                            note.setCreateUserFullName(creator == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, note.getCreateUser()) : creator.getName());
                        } else {
                            note.setCreateUserFullName(CONFIRM_NO_ACTION);
                        }
                        note.setEditable(false);
                    }
                    this.getBusinessObjectService().save(protocol.getNotepads());
                    this.recordProtocolActionSuccess("Manage Notes");
                }
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private ActionForward confirmFollowupAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String forward) throws Exception {
        List validFollowupActions = this.getFollowupActionService().getFollowupsForProtocol(((ProtocolForm)form).getProtocolDocument().getProtocol());
        if (validFollowupActions.isEmpty()) {
            LOG.info("No followup action");
            return mapping.findForward(forward);
        }
        if (!((ValidProtocolActionAction)validFollowupActions.get(0)).getUserPromptFlag()) {
            this.addFollowupAction(((ProtocolForm)form).getProtocolDocument().getProtocol());
            return mapping.findForward(forward);
        }
        StrutsConfirmation confirm = this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_FOLLOWUP_ACTION, "question.protocol.confirmFollowupAction", ((ValidProtocolActionAction)validFollowupActions.get(0)).getUserPrompt());
        LOG.info("followup action " + ((ValidProtocolActionAction)validFollowupActions.get(0)).getUserPrompt());
        return this.confirm(confirm, CONFIRM_FOLLOWUP_ACTION, CONFIRM_NO_ACTION);
    }

    public ActionForward confirmAddFollowupAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.addFollowupAction(((ProtocolForm)form).getProtocolDocument().getProtocol());
        return mapping.findForward("basic");
    }

    private void addFollowupAction(Protocol protocol) throws Exception {
        List validFollowupActions = this.getFollowupActionService().getFollowupsForProtocol(protocol);
        protocol.getLastProtocolAction().setFollowupActionCode(((ValidProtocolActionAction)validFollowupActions.get(0)).getFollowupActionCode());
        this.getBusinessObjectService().save((PersistableBusinessObject)protocol.getLastProtocolAction());
    }

    private FollowupActionService getFollowupActionService() {
        return KcServiceLocator.getService(FollowupActionService.class);
    }

    private WatermarkService getWatermarkService() {
        return KcServiceLocator.getService(WatermarkService.class);
    }

    public ActionForward viewReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            return this.streamReviewAttachment(mapping, request, response, reviewAttachmentsBean.getReviewAttachments());
        }
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward viewSubmissionReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.streamReviewAttachment(mapping, request, response, ((ProtocolForm)form).getActionHelper().getReviewAttachments());
    }

    private ActionForward streamReviewAttachment(ActionMapping mapping, HttpServletRequest request, HttpServletResponse response, List<ProtocolReviewAttachment> reviewAttachments) throws Exception {
        int lineNumber = this.getLineToDelete(request);
        ProtocolReviewAttachment attachment = reviewAttachments.get(lineNumber);
        if (attachment == null) {
            LOG.info(NOT_FOUND_SELECTION + lineNumber);
            return mapping.findForward("basic");
        }
        AttachmentFile file = attachment.getFile();
        this.streamToResponse(file.getData(), ProtocolProtocolActionsAction.getValidHeaderString(file.getName()), ProtocolProtocolActionsAction.getValidHeaderString(file.getType()), response);
        return RESPONSE_ALREADY_HANDLED;
    }

    public ActionForward deleteReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            int lineNumber = this.getLineToDelete(request);
            List deletedReviewAttachments = reviewAttachmentsBean.getDeletedReviewAttachments();
            this.getReviewCommentsService().deleteReviewAttachment(reviewAttachments, lineNumber, deletedReviewAttachments);
            if (reviewAttachments.isEmpty()) {
                reviewAttachmentsBean.setHideReviewerName(true);
            } else {
                reviewAttachmentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewAttachmentsBean.getReviewAttachments()));
            }
        }
        return mapping.findForward("basic");
    }

    private ReviewAttachmentsBean getReviewAttachmentsBean(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ReviewAttachmentsBean reviewAttachmentsBean = null;
        ProtocolActionBean protocolActionBean = this.getActionBean(form, request);
        if (protocolActionBean != null && protocolActionBean instanceof ProtocolOnlineReviewCommentable) {
            reviewAttachmentsBean = (ReviewAttachmentsBean)((ProtocolOnlineReviewCommentable)((Object)protocolActionBean)).getReviewAttachmentsBean();
        }
        return reviewAttachmentsBean;
    }

    public ActionForward manageAttachments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        if (!this.hasDocumentStateChanged(protocolForm)) {
            if (this.hasPermission("protocolManageReviewComments", protocolForm.getProtocolDocument().getProtocol()) && this.applyRules((DocumentEvent)new ProtocolManageReviewAttachmentEvent(protocolForm.getProtocolDocument(), "actionHelper.protocolManageReviewCommentsBean.reviewAttachmentsBean.", protocolForm.getActionHelper().getProtocolManageReviewCommentsBean().getReviewAttachmentsBean().getReviewAttachments()))) {
                ProtocolGenericActionBean actionBean = (ProtocolGenericActionBean)protocolForm.getActionHelper().getProtocolManageReviewCommentsBean();
                this.saveReviewAttachments(protocolForm, actionBean.getReviewAttachmentsBean());
                this.recordProtocolActionSuccess("Manage Review Attachments");
            }
        } else {
            GlobalVariables.getMessageMap().clearErrorMessages();
            GlobalVariables.getMessageMap().putError("documentstatechanged", "error.protocol.document.state.changed", new String[0]);
        }
        return mapping.findForward("basic");
    }

    private void saveReviewAttachments(ProtocolForm protocolForm, ReviewAttachmentsBean actionBean) throws Exception {
        this.getReviewCommentsService().saveReviewAttachments(actionBean.getReviewAttachments(), actionBean.getDeletedReviewAttachments());
        actionBean.setDeletedReviewAttachments(new ArrayList());
        protocolForm.getActionHelper().prepareCommentsView();
    }

    public ActionForward addReviewAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ProtocolDocument document = protocolForm.getProtocolDocument();
        ReviewAttachmentsBean reviewAttachmentsBean = this.getReviewAttachmentsBean(mapping, form, request, response);
        if (reviewAttachmentsBean != null) {
            String errorPropertyName = reviewAttachmentsBean.getErrorPropertyName();
            ProtocolReviewAttachment newReviewAttachment = (ProtocolReviewAttachment)reviewAttachmentsBean.getNewReviewAttachment();
            List reviewAttachments = reviewAttachmentsBean.getReviewAttachments();
            Protocol protocol = document.getProtocol();
            if (this.applyRules((DocumentEvent)new ProtocolAddReviewAttachmentEvent(document, errorPropertyName, newReviewAttachment))) {
                this.getReviewCommentsService().addReviewAttachment(newReviewAttachment, reviewAttachments, protocol);
                reviewAttachmentsBean.setNewReviewAttachment(new ProtocolReviewAttachment());
            }
            reviewAttachmentsBean.setHideReviewerName(this.getReviewCommentsService().setHideReviewerName(reviewAttachmentsBean.getReviewAttachments()));
        }
        return mapping.findForward("basic");
    }

    private boolean hasDocumentStateChanged(ProtocolForm protocolForm) {
        return this.getProtocolActionRequestService().hasDocumentStateChanged(protocolForm);
    }

    private ActionForward checkToSendNotification(ActionMapping mapping, String forwardName, ProtocolForm protocolForm, ProtocolNotificationRequestBean notificationRequestBean) {
        boolean sendNotification = this.getProtocolActionRequestService().checkToSendNotification(protocolForm, notificationRequestBean, forwardName);
        return sendNotification ? mapping.findForward("protocolNotificationEditor") : mapping.findForward(forwardName);
    }

    public ActionForward sendNotification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        Protocol protocol = protocolForm.getProtocolDocument().getProtocol();
        IRBNotificationRenderer renderer = new IRBNotificationRenderer(protocol);
        IRBNotificationContext context = new IRBNotificationContext(protocol, "999", "Ad-Hoc Notification", (NotificationRenderer)renderer);
        protocolForm.getNotificationHelper().initializeDefaultValues(context);
        return mapping.findForward("protocolNotificationEditor");
    }

    protected PersonService getPersonService() {
        return KcServiceLocator.getService(PersonService.class);
    }

    @Override
    protected KcNotificationService getNotificationService() {
        return KcServiceLocator.getService(KcNotificationService.class);
    }

    public ActionForward viewCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionHelper actionHelper = ((ProtocolForm)form).getActionHelper();
        PrintableAttachment source = new PrintableAttachment();
        ProtocolCorrespondence correspondence = (ProtocolCorrespondence)actionHelper.getProtocolCorrespondence();
        source.setData(correspondence.getCorrespondence());
        source.setType("application/pdf");
        source.setName("Correspondence-" + correspondence.getProtocolCorrespondenceType().getDescription() + ".pdf");
        PrintingUtils.streamToResponse(source, response);
        return null;
    }

    public ActionForward saveCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, true);
    }

    public ActionForward closeCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.correspondenceAction(mapping, form, false);
    }

    private ActionForward correspondenceAction(ActionMapping mapping, ActionForm form, boolean saveAction) {
        ProtocolForm protocolForm = (ProtocolForm)form;
        ActionHelper actionHelper = protocolForm.getActionHelper();
        ProtocolCorrespondence correspondence = (ProtocolCorrespondence)actionHelper.getProtocolCorrespondence();
        if (saveAction) {
            if (correspondence.getFinalFlag()) {
                correspondence.setFinalFlagTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            }
            this.getBusinessObjectService().save((PersistableBusinessObject)correspondence);
        }
        if (GlobalVariables.getUserSession().retrieveObject("approvalComplpondence") != null) {
            GlobalVariables.getUserSession().addObject("METHOD_TO_CALL_KEYS_COMPLETE_OBJECT_KEY", GlobalVariables.getUserSession().retrieveObject("approvalComplCorrespondence"));
            GlobalVariables.getUserSession().removeObject("approvalComplCorrespondence");
        }
        if (correspondence.getNotificationRequestBean() != null) {
            return this.checkToSendNotification(mapping, correspondence.getForwardName(), protocolForm, (ProtocolNotificationRequestBean)correspondence.getNotificationRequestBean());
        }
        if (correspondence.isHoldingPage()) {
            return this.routeProtocolToHoldingPage(mapping, protocolForm);
        }
        return mapping.findForward(correspondence.getForwardName());
    }

    public ActionForward regenerateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        org.kuali.kra.irb.actions.ProtocolAction protocolAction = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        ProtocolCorrespondence protocolCorrespondence = (ProtocolCorrespondence)protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (protocolCorrespondence == null) {
            LOG.info("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex);
            return mapping.findForward("basic");
        }
        Protocol protocol = (Protocol)protocolCorrespondence.getProtocol();
        AttachmentDataSource dataSource = this.generateCorrespondenceDocument(protocol, protocolCorrespondence);
        if (dataSource != null) {
            protocolCorrespondence.setCorrespondence(dataSource.getData());
            protocolCorrespondence.setFinalFlag(false);
            protocolCorrespondence.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
            protocolCorrespondence.setCreateTimestamp(KcServiceLocator.getService(DateTimeService.class).getCurrentTimestamp());
            protocolCorrespondence.setForwardName("protocolActions");
            protocolForm.getActionHelper().setProtocolCorrespondence(protocolCorrespondence);
            this.getBusinessObjectService().save((PersistableBusinessObject)protocolCorrespondence);
            return mapping.findForward(CORRESPONDENCE);
        }
        return mapping.findForward("basic");
    }

    protected AttachmentDataSource generateCorrespondenceDocument(ProtocolBase protocol, ProtocolCorrespondence oldCorrespondence) throws PrintingException {
        ProtocolActionsCorrespondence correspondence = new ProtocolActionsCorrespondence(oldCorrespondence.getProtocolAction().getProtocolActionTypeCode());
        correspondence.setProtocol(protocol);
        return this.getProtocolActionCorrespondenceGenerationService().reGenerateCorrespondenceDocument(correspondence);
    }

    private ProtocolActionCorrespondenceGenerationService getProtocolActionCorrespondenceGenerationService() {
        return KcServiceLocator.getService(ProtocolActionCorrespondenceGenerationService.class);
    }

    public ActionForward updateCorrespondence(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolForm protocolForm = (ProtocolForm)form;
        int actionIndex = this.getSelectedLine(request);
        int attachmentIndex = this.getSelectedAttachment(request);
        org.kuali.kra.irb.actions.ProtocolAction protocolAction = (org.kuali.kra.irb.actions.ProtocolAction)protocolForm.getActionHelper().getProtocol().getProtocolActions().get(actionIndex);
        protocolAction.refreshReferenceObject("protocolCorrespondences");
        ProtocolCorrespondence protocolCorrespondence = (ProtocolCorrespondence)protocolAction.getProtocolCorrespondences().get(attachmentIndex);
        if (protocolCorrespondence == null) {
            LOG.info("The attachment was not found for selection protocolAction: " + actionIndex + ", protocolCorrespondence: " + attachmentIndex);
            return mapping.findForward("basic");
        }
        protocolCorrespondence.setForwardName("protocolActions");
        protocolForm.getActionHelper().setProtocolCorrespondence(protocolCorrespondence);
        return mapping.findForward(CORRESPONDENCE);
    }
}

