/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.coeus.sys.impl.logging.slack;

import co.kuali.coeus.sys.impl.logging.slack.SlackAttachmentDto;
import co.kuali.coeus.sys.impl.logging.slack.SlackPayloadDto;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="Slack", category="Core", elementType="appender", printObject=true)
public class SlackAppender
extends AbstractAppender {
    private final String webhookUrl;
    private final String userName;
    private final String channel;
    private final String iconEmoji;

    public SlackAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String webhookUrl, String userName, String channel, String iconEmoji) {
        super(name, filter, layout, ignoreExceptions);
        this.webhookUrl = webhookUrl;
        this.userName = userName;
        this.channel = channel;
        this.iconEmoji = iconEmoji;
    }

    @PluginBuilderFactory
    public static SlackAppenderBuilder createAppender() {
        return new SlackAppenderBuilder();
    }

    public void append(LogEvent event) {
        if (StringUtils.isNotBlank((CharSequence)this.webhookUrl)) {
            CloseableHttpClient instance = HttpClientBuilder.create().build();
            HttpPost post = new HttpPost(this.webhookUrl);
            post.setHeader("Content-Type", "application/json");
            ObjectMapper objectMapper = new ObjectMapper();
            SlackPayloadDto payloadDto = this.createPayloadDto(event);
            try {
                post.setEntity((HttpEntity)new StringEntity(objectMapper.writeValueAsString((Object)payloadDto)));
                this.logResponse(instance.execute((HttpUriRequest)post), payloadDto);
            }
            catch (IOException e) {
                StatusLogger.getLogger().error("Unable to to send serialized payload " + payloadDto + " to url " + this.webhookUrl);
            }
        } else {
            StatusLogger.getLogger().error(SlackAppender.class.getName() + " is not configured with a url");
        }
    }

    private void logResponse(HttpResponse response, SlackPayloadDto payloadDto) throws IOException {
        int responseStatus = response.getStatusLine().getStatusCode();
        String resposeString = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        String responseMessage = "Response received. Payload " + payloadDto + " url " + this.webhookUrl + " response status " + responseStatus + " response " + resposeString;
        if (responseStatus < 400) {
            StatusLogger.getLogger().debug(responseMessage);
        } else {
            StatusLogger.getLogger().error(responseMessage);
        }
    }

    private SlackPayloadDto createPayloadDto(LogEvent event) {
        SlackPayloadDto payloadDto = new SlackPayloadDto();
        if (StringUtils.isNotBlank((CharSequence)this.userName)) {
            payloadDto.setUserName(this.userName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.channel)) {
            payloadDto.setChannel(this.channel);
        }
        if (StringUtils.isNotBlank((CharSequence)this.iconEmoji)) {
            payloadDto.setIconEmoji(this.iconEmoji);
        }
        SlackAttachmentDto attachmentDto = new SlackAttachmentDto();
        attachmentDto.setColor(Integer.toHexString(this.getColor(event).getRGB()).substring(2));
        attachmentDto.setPretext(SlackAppender.escapeSlackString(event.getMessage().toString()));
        attachmentDto.setTitle(SlackAppender.escapeSlackString(event.getLevel().toString()));
        String fallback = this.createFallback(event);
        attachmentDto.setFallback(SlackAppender.escapeSlackString(fallback));
        String stacktrace = this.createThrowableString(event);
        if (StringUtils.isNotBlank((CharSequence)stacktrace)) {
            attachmentDto.setText(SlackAppender.escapeSlackString(fallback + "\n" + stacktrace));
        } else {
            attachmentDto.setText(SlackAppender.escapeSlackString(fallback));
        }
        payloadDto.setAttachments(Collections.singletonList(attachmentDto));
        return payloadDto;
    }

    private String createFallback(LogEvent event) {
        StringBuilder fallback = new StringBuilder();
        fallback.append(event.getLevel().toString());
        fallback.append(" ");
        fallback.append(event.getMessage().toString());
        return fallback.toString();
    }

    private String createThrowableString(LogEvent event) {
        if (event.getThrownProxy() != null && !this.ignoreExceptions()) {
            return event.getThrownProxy().getExtendedStackTraceAsString();
        }
        return null;
    }

    private Color getColor(LogEvent event) {
        Level level = event.getLevel();
        if (Level.FATAL.equals((Object)level)) {
            return Color.RED;
        }
        if (Level.ERROR.equals((Object)level)) {
            return Color.RED;
        }
        if (Level.WARN.equals((Object)level)) {
            return Color.ORANGE;
        }
        if (Level.INFO.equals((Object)level)) {
            return Color.BLACK;
        }
        if (Level.DEBUG.equals((Object)level)) {
            return Color.BLUE;
        }
        if (Level.TRACE.equals((Object)level)) {
            return Color.GREEN;
        }
        return Color.GRAY;
    }

    private static String escapeSlackString(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static class SlackAppenderBuilder<B extends AbstractAppender.Builder<B>>
    extends AbstractAppender.Builder<B>
    implements Builder<SlackAppender> {
        @PluginBuilderAttribute
        @Required(message="Slack Webhook URL required")
        private String webhookUrl;
        @PluginBuilderAttribute
        @Required(message="Slack channel required")
        private String channel;
        @PluginBuilderAttribute
        @Required(message="Slack username/bot-name required")
        private String username;
        @PluginBuilderAttribute
        private String iconEmoji;

        public SlackAppenderBuilder withWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
            return this;
        }

        public SlackAppenderBuilder withChannel(String channel) {
            this.channel = channel;
            return this;
        }

        public SlackAppenderBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        public SlackAppenderBuilder withIconEmoji(String iconEmoji) {
            this.iconEmoji = iconEmoji;
            return this;
        }

        public SlackAppender build() {
            return new SlackAppender(this.getName(), this.getFilter(), (Layout<? extends Serializable>)this.getLayout(), this.isIgnoreExceptions(), this.webhookUrl, this.channel, this.username, this.iconEmoji);
        }
    }
}

