/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.compliance.core;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.kuali.coeus.common.framework.compliance.core.SpecialReview;
import org.kuali.coeus.common.framework.compliance.core.SpecialReviewService;
import org.kuali.coeus.propdev.impl.core.DevelopmentProposal;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReview;
import org.kuali.coeus.propdev.impl.specialreview.ProposalSpecialReviewExemption;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.specialreview.AwardSpecialReview;
import org.kuali.kra.award.specialreview.AwardSpecialReviewExemption;
import org.kuali.kra.iacuc.IacucProtocolFinderDao;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReview;
import org.kuali.kra.institutionalproposal.specialreview.InstitutionalProposalSpecialReviewExemption;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.krad.data.PersistenceOption;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="specialReviewService")
@Lazy
public class SpecialReviewServiceImpl
implements SpecialReviewService {
    private static final String PROTOCOL_NUMBER = ".protocolNumber";
    @Autowired
    @Qualifier(value="awardService")
    private AwardService awardService;
    @Autowired
    @Qualifier(value="institutionalProposalService")
    private InstitutionalProposalService institutionalProposalService;
    @Autowired
    @Qualifier(value="protocolFinderDao")
    private ProtocolFinderDao protocolFinderDao;
    @Autowired
    @Qualifier(value="iacucProtocolFinderDao")
    private IacucProtocolFinderDao iacucProtocolFinderDao;
    @Autowired
    @Qualifier(value="documentService")
    private DocumentService documentService;
    @Autowired
    @Qualifier(value="businessObjectService")
    private BusinessObjectService businessObjectService;
    @Autowired
    @Qualifier(value="dataObjectService")
    private DataObjectService dataObjectService;

    @Override
    public String getProtocolSaveLocationPrefix(Map<String, String[]> parameters) {
        String prefix = null;
        for (String parameterName : parameters.keySet()) {
            if (!parameterName.endsWith(PROTOCOL_NUMBER)) continue;
            prefix = StringUtils.removeEnd((String)parameterName, (String)PROTOCOL_NUMBER);
            break;
        }
        return prefix;
    }

    @Override
    public int getProtocolIndex(String prefix) {
        String lineNumber;
        int index = -1;
        int lastLeftBracketIndex = StringUtils.lastIndexOf((CharSequence)prefix, (int)91);
        int lastRightBracketIndex = StringUtils.lastIndexOf((CharSequence)prefix, (int)93);
        if (lastLeftBracketIndex != -1 && lastRightBracketIndex != -1 && NumberUtils.isDigits((String)(lineNumber = prefix.substring(lastLeftBracketIndex + 1, lastRightBracketIndex)))) {
            index = Integer.parseInt(lineNumber);
        }
        return index;
    }

    @Override
    public String getViewSpecialReviewProtocolRouteHeaderId(String protocolNumber) throws Exception {
        Protocol protocol;
        String routeHeaderId = null;
        if (StringUtils.isNotBlank((CharSequence)protocolNumber) && (protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber)) != null) {
            Document document = this.getDocumentService().getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
            routeHeaderId = document.getDocumentHeader().getWorkflowDocument().getDocumentId();
        }
        return routeHeaderId;
    }

    @Override
    public String getViewSpecialReviewProtocolRouteHeaderId(String protocolNumber, String specialReviewTypeCode) throws Exception {
        String routeHeaderId = null;
        if (StringUtils.isNotBlank((CharSequence)protocolNumber)) {
            ProtocolBase protocol;
            if ("1".equals(specialReviewTypeCode)) {
                Protocol protocol2 = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
                if (protocol2 != null) {
                    Document document = this.getDocumentService().getByDocumentHeaderId(protocol2.getProtocolDocument().getDocumentNumber());
                    routeHeaderId = document.getDocumentHeader().getWorkflowDocument().getDocumentId();
                }
            } else if ("2".equals(specialReviewTypeCode) && (protocol = this.getIacucProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber)) != null) {
                Document document = this.getDocumentService().getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
                routeHeaderId = document.getDocumentHeader().getWorkflowDocument().getDocumentId();
            }
        }
        return routeHeaderId;
    }

    @Override
    public boolean isLinkedToProtocolFundingSource(String protocolNumber, String fundingSourceNumber, String fundingSourceTypeCode) {
        Protocol protocol;
        boolean isLinkedToProtocolFundingSource = false;
        if (StringUtils.isNotBlank((CharSequence)protocolNumber) && (protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber)) != null) {
            List<ProtocolFundingSourceBase> protocolFundingSources = protocol.getProtocolFundingSources();
            for (ProtocolFundingSource protocolFundingSource : protocolFundingSources) {
                if (!StringUtils.equals((CharSequence)protocolFundingSource.getFundingSourceNumber(), (CharSequence)fundingSourceNumber) || !StringUtils.equals((CharSequence)protocolFundingSource.getFundingSourceTypeCode(), (CharSequence)fundingSourceTypeCode)) continue;
                isLinkedToProtocolFundingSource = true;
                break;
            }
        }
        return isLinkedToProtocolFundingSource;
    }

    @Override
    public boolean isLinkedToSpecialReview(String fundingSourceNumber, String fundingSourceTypeCode, String protocolNumber) {
        DevelopmentProposal developmentProposal;
        boolean isLinkedToSpecialReview = false;
        if (StringUtils.equals((CharSequence)"6", (CharSequence)fundingSourceTypeCode)) {
            Award award = this.getAward(fundingSourceNumber);
            if (award != null) {
                isLinkedToSpecialReview = this.isLinkedToSpecialReviews(award.getSpecialReviews(), protocolNumber);
            }
        } else if (StringUtils.equals((CharSequence)"5", (CharSequence)fundingSourceTypeCode)) {
            InstitutionalProposal institutionalProposal = this.getInstitutionalProposal(fundingSourceNumber);
            if (institutionalProposal != null) {
                institutionalProposal.refreshReferenceObject("specialReviews");
                isLinkedToSpecialReview = this.isLinkedToSpecialReviews(institutionalProposal.getSpecialReviews(), protocolNumber);
            }
        } else if (StringUtils.equals((CharSequence)"4", (CharSequence)fundingSourceTypeCode) && (developmentProposal = this.getDevelopmentProposal(fundingSourceNumber)) != null) {
            isLinkedToSpecialReview = this.isLinkedToSpecialReviews(developmentProposal.getPropSpecialReviews(), protocolNumber);
        }
        return isLinkedToSpecialReview;
    }

    private boolean isLinkedToSpecialReviews(List<? extends SpecialReview<?>> specialReviews, String protocolNumber) {
        boolean isLinkedToSpecialReviews = false;
        for (SpecialReview<?> specialReview : specialReviews) {
            if (!StringUtils.equals((CharSequence)specialReview.getProtocolNumber(), (CharSequence)protocolNumber)) continue;
            isLinkedToSpecialReviews = true;
            break;
        }
        return isLinkedToSpecialReviews;
    }

    @Override
    public void addProtocolFundingSourceForSpecialReview(String protocolNumber, String fundingSourceNumber, String fundingSourceTypeCode, String fundingSourceName, String fundingSourceTitle) {
        Protocol protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
        if (protocol != null && StringUtils.isNotBlank((CharSequence)fundingSourceNumber) && NumberUtils.isNumber((String)fundingSourceTypeCode)) {
            ProtocolFundingSource protocolFundingSource = new ProtocolFundingSource();
            protocolFundingSource.setProtocolNumber(protocolNumber);
            protocolFundingSource.setFundingSourceNumber(fundingSourceNumber);
            protocolFundingSource.setFundingSourceTypeCode(fundingSourceTypeCode);
            protocolFundingSource.setFundingSourceName(fundingSourceName);
            protocolFundingSource.setFundingSourceTitle(fundingSourceTitle);
            protocol.getProtocolFundingSources().add(protocolFundingSource);
            this.getBusinessObjectService().save((PersistableBusinessObject)protocol);
        }
    }

    @Override
    public void deleteProtocolFundingSourceForSpecialReview(String protocolNumber, String fundingSourceNumber, String fundingSourceTypeCode) {
        Protocol protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(protocolNumber);
        if (protocol != null) {
            ArrayList<ProtocolFundingSource> deletedProtocolFundingSources = new ArrayList<ProtocolFundingSource>();
            List<ProtocolFundingSourceBase> protocolFundingSources = protocol.getProtocolFundingSources();
            for (ProtocolFundingSource protocolFundingSource : protocolFundingSources) {
                if (!StringUtils.equals((CharSequence)protocolFundingSource.getFundingSourceNumber(), (CharSequence)fundingSourceNumber) || !StringUtils.equals((CharSequence)protocolFundingSource.getFundingSourceTypeCode(), (CharSequence)fundingSourceTypeCode)) continue;
                deletedProtocolFundingSources.add(protocolFundingSource);
            }
            this.getBusinessObjectService().delete(deletedProtocolFundingSources);
        }
    }

    @Override
    public void addSpecialReviewForProtocolFundingSource(String fundingSourceNumber, String fundingSourceTypeCode, String protocolNumber, Date applicationDate, Date approvalDate, Date expirationDate, String specialReviewType, List<String> exemptionTypeCodes) {
        if (StringUtils.equals((CharSequence)"6", (CharSequence)fundingSourceTypeCode)) {
            Award award = this.getAward(fundingSourceNumber);
            this.addAwardSpecialReview(award, protocolNumber, specialReviewType, applicationDate, approvalDate, expirationDate, exemptionTypeCodes);
        } else if (StringUtils.equals((CharSequence)"5", (CharSequence)fundingSourceTypeCode)) {
            InstitutionalProposal institutionalProposal = this.getInstitutionalProposal(fundingSourceNumber);
            this.addInstitutionalProposalSpecialReview(institutionalProposal, protocolNumber, specialReviewType, applicationDate, approvalDate, expirationDate, exemptionTypeCodes);
        } else if (StringUtils.equals((CharSequence)"4", (CharSequence)fundingSourceTypeCode)) {
            DevelopmentProposal developmentProposal = this.getDevelopmentProposal(fundingSourceNumber);
            this.addDevelopmentProposalSpecialReview(developmentProposal, protocolNumber, specialReviewType, applicationDate, approvalDate, expirationDate, exemptionTypeCodes);
        }
    }

    private void addAwardSpecialReview(Award award, String protocolNumber, String specialReviewType, Date applicationDate, Date approvalDate, Date expirationDate, List<String> exemptionTypeCodes) {
        if (award != null) {
            Integer specialReviewNumber = award.getAwardDocument().getDocumentNextValue("SPECIAL_REVIEW_NUMBER");
            AwardSpecialReview specialReview = new AwardSpecialReview();
            specialReview.setSpecialReviewNumber(specialReviewNumber);
            specialReview.setSpecialReviewTypeCode(specialReviewType);
            specialReview.setApprovalTypeCode(this.getSpecialReviewProtocolLinkType(specialReviewType));
            specialReview.setProtocolNumber(protocolNumber);
            specialReview.setApplicationDate(applicationDate);
            specialReview.setApprovalDate(approvalDate);
            specialReview.setExpirationDate(expirationDate);
            for (String exemptionTypeCode : exemptionTypeCodes) {
                AwardSpecialReviewExemption specialReviewExemption = new AwardSpecialReviewExemption();
                specialReviewExemption.setAwardSpecialReview(specialReview);
                specialReviewExemption.setExemptionTypeCode(exemptionTypeCode);
                specialReview.getSpecialReviewExemptions().add(specialReviewExemption);
            }
            specialReview.setComments("A Special Review has been inserted.");
            award.getSpecialReviews().add(specialReview);
            this.getBusinessObjectService().save((PersistableBusinessObject)award);
        }
    }

    private void addInstitutionalProposalSpecialReview(InstitutionalProposal institutionalProposal, String protocolNumber, String specialReviewType, Date applicationDate, Date approvalDate, Date expirationDate, List<String> exemptionTypeCodes) {
        if (institutionalProposal != null) {
            Integer specialReviewNumber = institutionalProposal.getInstitutionalProposalDocument().getDocumentNextValue("SPECIAL_REVIEW_NUMBER");
            InstitutionalProposalSpecialReview specialReview = new InstitutionalProposalSpecialReview();
            specialReview.setSpecialReviewNumber(specialReviewNumber);
            specialReview.setSpecialReviewTypeCode(specialReviewType);
            specialReview.setApprovalTypeCode(this.getSpecialReviewProtocolLinkType(specialReviewType));
            specialReview.setProtocolNumber(protocolNumber);
            specialReview.setApplicationDate(applicationDate);
            specialReview.setApprovalDate(approvalDate);
            specialReview.setExpirationDate(expirationDate);
            for (String exemptionTypeCode : exemptionTypeCodes) {
                InstitutionalProposalSpecialReviewExemption specialReviewExemption = new InstitutionalProposalSpecialReviewExemption();
                specialReviewExemption.setInstitutionalProposalSpecialReview(specialReview);
                specialReviewExemption.setExemptionTypeCode(exemptionTypeCode);
                specialReview.getSpecialReviewExemptions().add(specialReviewExemption);
            }
            specialReview.setComments("A Special Review has been inserted.");
            institutionalProposal.getSpecialReviews().add(specialReview);
            this.getBusinessObjectService().save((PersistableBusinessObject)institutionalProposal);
        }
    }

    protected void addDevelopmentProposalSpecialReview(DevelopmentProposal developmentProposal, String protocolNumber, String specialReviewType, Date applicationDate, Date approvalDate, Date expirationDate, List<String> exemptionTypeCodes) {
        if (developmentProposal != null) {
            Integer specialReviewNumber = developmentProposal.getProposalDocument().getDocumentNextValue("SPECIAL_REVIEW_NUMBER");
            ProposalSpecialReview specialReview = new ProposalSpecialReview();
            specialReview.setDevelopmentProposal(developmentProposal);
            specialReview.setSpecialReviewNumber(specialReviewNumber);
            specialReview.setSpecialReviewTypeCode(specialReviewType);
            specialReview.setApprovalTypeCode(this.getSpecialReviewProtocolLinkType(specialReviewType));
            specialReview.setProtocolNumber(protocolNumber);
            specialReview.setApplicationDate(applicationDate);
            specialReview.setApprovalDate(approvalDate);
            specialReview.setExpirationDate(expirationDate);
            for (String exemptionTypeCode : exemptionTypeCodes) {
                ProposalSpecialReviewExemption specialReviewExemption = new ProposalSpecialReviewExemption();
                specialReviewExemption.setProposalSpecialReview(specialReview);
                specialReviewExemption.setExemptionTypeCode(exemptionTypeCode);
                specialReview.getSpecialReviewExemptions().add(specialReviewExemption);
            }
            specialReview.setComments("A Special Review has been inserted.");
            developmentProposal.getPropSpecialReviews().add(specialReview);
            this.getDataObjectService().save((Object)developmentProposal, new PersistenceOption[0]);
        }
    }

    @Override
    public void deleteSpecialReviewForProtocolFundingSource(String fundingSourceNumber, String fundingSourceTypeCode, String protocolNumber) {
        if (StringUtils.equals((CharSequence)"6", (CharSequence)fundingSourceTypeCode)) {
            Award award = this.getAward(fundingSourceNumber);
            this.deleteAwardSpecialReview(award, protocolNumber);
        } else if (StringUtils.equals((CharSequence)"5", (CharSequence)fundingSourceTypeCode)) {
            InstitutionalProposal institutionalProposal = this.getInstitutionalProposal(fundingSourceNumber);
            this.deleteInstitutionalProposalSpecialReview(institutionalProposal, protocolNumber);
        } else if (StringUtils.equals((CharSequence)"4", (CharSequence)fundingSourceTypeCode)) {
            DevelopmentProposal developmentProposal = this.getDevelopmentProposal(fundingSourceNumber);
            this.deleteDevelopmentProposalSpecialReview(developmentProposal, protocolNumber);
        }
    }

    private void deleteAwardSpecialReview(Award award, String protocolNumber) {
        if (award != null) {
            ArrayList<AwardSpecialReview> deletedSpecialReviews = new ArrayList<AwardSpecialReview>();
            for (AwardSpecialReview specialReview : award.getSpecialReviews()) {
                if (!StringUtils.equals((CharSequence)specialReview.getProtocolNumber(), (CharSequence)protocolNumber)) continue;
                deletedSpecialReviews.add(specialReview);
            }
            this.getBusinessObjectService().delete(deletedSpecialReviews);
        }
    }

    private void deleteInstitutionalProposalSpecialReview(InstitutionalProposal institutionalProposal, String protocolNumber) {
        if (institutionalProposal != null) {
            ArrayList<InstitutionalProposalSpecialReview> deletedSpecialReviews = new ArrayList<InstitutionalProposalSpecialReview>();
            institutionalProposal.refreshReferenceObject("specialReviews");
            for (InstitutionalProposalSpecialReview specialReview : institutionalProposal.getSpecialReviews()) {
                if (!StringUtils.equals((CharSequence)specialReview.getProtocolNumber(), (CharSequence)protocolNumber)) continue;
                deletedSpecialReviews.add(specialReview);
            }
            this.getBusinessObjectService().delete(deletedSpecialReviews);
        }
    }

    protected void deleteDevelopmentProposalSpecialReview(DevelopmentProposal developmentProposal, String protocolNumber) {
        if (developmentProposal != null) {
            for (ProposalSpecialReview specialReview : developmentProposal.getPropSpecialReviews()) {
                if (!StringUtils.equals((CharSequence)specialReview.getProtocolNumber(), (CharSequence)protocolNumber)) continue;
                this.getDataObjectService().delete((Object)specialReview);
                break;
            }
        }
    }

    private Award getAward(String fundingSourceNumber) {
        Award award = null;
        List<Award> awards = this.getAwardService().findAwardsForAwardNumber(fundingSourceNumber);
        if (!awards.isEmpty()) {
            award = awards.get(awards.size() - 1);
        }
        return award;
    }

    private InstitutionalProposal getInstitutionalProposal(String fundingSourceNumber) {
        InstitutionalProposal institutionalProposal = this.getInstitutionalProposalService().getActiveInstitutionalProposalVersion(fundingSourceNumber);
        if (institutionalProposal == null) {
            institutionalProposal = this.getInstitutionalProposalService().getPendingInstitutionalProposalVersion(fundingSourceNumber);
        }
        return institutionalProposal;
    }

    protected DevelopmentProposal getDevelopmentProposal(String proposalNumber) {
        return (DevelopmentProposal)this.getDataObjectService().find(DevelopmentProposal.class, (Object)proposalNumber);
    }

    protected String getSpecialReviewProtocolLinkType(String specialReviewType) {
        if (specialReviewType.equals("1")) {
            return "5";
        }
        return "6";
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public InstitutionalProposalService getInstitutionalProposalService() {
        return this.institutionalProposalService;
    }

    public void setInstitutionalProposalService(InstitutionalProposalService institutionalProposalService) {
        this.institutionalProposalService = institutionalProposalService;
    }

    public IacucProtocolFinderDao getIacucProtocolFinderDao() {
        return this.iacucProtocolFinderDao;
    }

    public void setIacucProtocolFinderDao(IacucProtocolFinderDao iacucProtocolFinderDao) {
        this.iacucProtocolFinderDao = iacucProtocolFinderDao;
    }

    public ProtocolFinderDao getProtocolFinderDao() {
        return this.protocolFinderDao;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

