/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.sys.impl.mq.rest;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.sys.framework.mq.MessageFactory;
import org.kuali.coeus.sys.framework.mq.Producer;
import org.kuali.coeus.sys.framework.mq.rest.RestRequest;
import org.kuali.coeus.sys.impl.mq.rest.RestDestinationRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jms.core.JmsOperations;
import org.springframework.stereotype.Component;

@Component(value="restMessageProducer")
public class RestMessageProducer
implements Producer<RestRequest> {
    private static Logger LOG = LogManager.getLogger(RestMessageProducer.class);
    @Autowired
    @Qualifier(value="restJmsOperations")
    private JmsOperations restJmsOperations;
    @Autowired
    @Qualifier(value="restDestinationRegistry")
    private RestDestinationRegistry restDestinationRegistry;

    @Override
    public void sendMessage(RestRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getMethod() == null) {
            throw new IllegalArgumentException("request must have a non null method");
        }
        if (StringUtils.isBlank((CharSequence)request.getDestination())) {
            throw new IllegalArgumentException("request must have a non null and non blank destination");
        }
        if (this.restDestinationRegistry.isEnabled(request.getDestination())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Producing Message " + request);
            }
            this.restJmsOperations.convertAndSend((Object)MessageFactory.createObjectMessage(request));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Destination Disabled.  Ignoring Message " + request);
        }
    }

    public JmsOperations getRestJmsOperations() {
        return this.restJmsOperations;
    }

    public void setRestJmsOperations(JmsOperations restJmsOperations) {
        this.restJmsOperations = restJmsOperations;
    }

    public RestDestinationRegistry getRestDestinationRegistry() {
        return this.restDestinationRegistry;
    }

    public void setRestDestinationRegistry(RestDestinationRegistry restDestinationRegistry) {
        this.restDestinationRegistry = restDestinationRegistry;
    }
}

